/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class PotionContents
extends Record
implements ConsumableListener,
TooltipProvider {
    private final Optional<Holder<PotionRegistry>> e;
    private final Optional<Integer> f;
    private final List<MobEffect> g;
    private final Optional<String> h;
    public static final PotionContents a = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final IChatBaseComponent i = IChatBaseComponent.c("effect.none").a(EnumChatFormat.h);
    public static final int b = -13083194;
    private static final Codec<PotionContents> j = RecordCodecBuilder.create(instance -> instance.group((App)PotionRegistry.a.optionalFieldOf("potion").forGetter(PotionContents::e), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::f), (App)MobEffect.d.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::d), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::g)).apply((Applicative)instance, PotionContents::new));
    public static final Codec<PotionContents> c = Codec.withAlternative(j, PotionRegistry.a, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> d = StreamCodec.a(PotionRegistry.b.a(ByteBufCodecs::a), PotionContents::e, ByteBufCodecs.g.a(ByteBufCodecs::a), PotionContents::f, MobEffect.e.a(ByteBufCodecs.a()), PotionContents::d, ByteBufCodecs.p.a(ByteBufCodecs::a), PotionContents::g, PotionContents::new);

    public PotionContents(Holder<PotionRegistry> holder) {
        this(Optional.of(holder), Optional.empty(), List.of(), Optional.empty());
    }

    public PotionContents(Optional<Holder<PotionRegistry>> potion, Optional<Integer> customColor, List<MobEffect> customEffects, Optional<String> customName) {
        this.e = potion;
        this.f = customColor;
        this.g = customEffects;
        this.h = customName;
    }

    public static ItemStack a(Item item, Holder<PotionRegistry> holder) {
        ItemStack itemstack = new ItemStack(item);
        itemstack.b(DataComponents.Y, new PotionContents(holder));
        return itemstack;
    }

    public boolean a(Holder<PotionRegistry> holder) {
        return this.e.isPresent() && this.e.get().a(holder) && this.g.isEmpty();
    }

    public Iterable<MobEffect> a() {
        return this.e.isEmpty() ? this.g : (this.g.isEmpty() ? this.e.get().a().a() : Iterables.concat(this.e.get().a().a(), this.g));
    }

    public void a(Consumer<MobEffect> consumer, float f2) {
        if (this.e.isPresent()) {
            for (MobEffect mobeffect : this.e.get().a().a()) {
                consumer.accept(mobeffect.a(f2));
            }
        }
        for (MobEffect mobeffect1 : this.g) {
            consumer.accept(mobeffect1.a(f2));
        }
    }

    public PotionContents b(Holder<PotionRegistry> holder) {
        return new PotionContents(Optional.of(holder), this.f, this.g, this.h);
    }

    public PotionContents a(MobEffect mobeffect) {
        return new PotionContents(this.e, this.f, SystemUtils.a(this.g, mobeffect), this.h);
    }

    public int b() {
        return this.a(-13083194);
    }

    public int a(int i2) {
        return this.f.isPresent() ? this.f.get().intValue() : PotionContents.a(this.a()).orElse(i2);
    }

    public IChatBaseComponent a(String s2) {
        String s1 = this.h.or(() -> this.e.map(holder -> ((PotionRegistry)holder.a()).b())).orElse("empty");
        return IChatBaseComponent.c(s2 + s1);
    }

    public static OptionalInt a(Iterable<MobEffect> iterable) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (MobEffect mobeffect : iterable) {
            if (!mobeffect.g()) continue;
            int i1 = mobeffect.c().a().i();
            int j1 = mobeffect.e() + 1;
            i2 += j1 * ARGB.c(i1);
            j2 += j1 * ARGB.d(i1);
            k2 += j1 * ARGB.e(i1);
            l2 += j1;
        }
        if (l2 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ARGB.a(i2 / l2, j2 / l2, k2 / l2));
    }

    public boolean c() {
        return !this.g.isEmpty() ? true : this.e.isPresent() && !this.e.get().a().a().isEmpty();
    }

    public List<MobEffect> d() {
        return Lists.transform(this.g, MobEffect::new);
    }

    public void a(EntityLiving entityliving, float f2) {
        World world = entityliving.ao();
        if (world instanceof WorldServer) {
            EntityHuman entityhuman1;
            WorldServer worldserver = (WorldServer)world;
            EntityHuman entityhuman = entityliving instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entityliving) : null;
            EntityHuman entityhuman2 = entityhuman;
            this.a((MobEffect mobeffect) -> {
                if (mobeffect.c().a().a()) {
                    mobeffect.c().a().a(worldserver, entityhuman2, entityhuman2, entityliving, mobeffect.e(), 1.0);
                } else {
                    entityliving.addEffect((MobEffect)mobeffect, EntityPotionEffectEvent.Cause.POTION_DRINK);
                }
            }, f2);
        }
    }

    public static void a(Iterable<MobEffect> iterable, Consumer<IChatBaseComponent> consumer, float f2, float f1) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffect mobeffect : iterable) {
            flag = false;
            Holder<MobEffectList> holder = mobeffect.c();
            int i2 = mobeffect.e();
            holder.a().a(i2, (holder1, attributemodifier) -> list.add(new Pair(holder1, attributemodifier)));
            IChatMutableComponent ichatmutablecomponent = PotionContents.a(holder, i2);
            if (!mobeffect.a(20)) {
                ichatmutablecomponent = IChatBaseComponent.a("potion.withDuration", ichatmutablecomponent, MobEffectUtil.a(mobeffect, f2, f1));
            }
            consumer.accept(ichatmutablecomponent.a(holder.a().h().a()));
        }
        if (flag) {
            consumer.accept(i);
        }
        if (!list.isEmpty()) {
            consumer.accept(CommonComponents.a);
            consumer.accept(IChatBaseComponent.c("potion.whenDrank").a(EnumChatFormat.f));
            for (Pair pair : list) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.b();
                double d1 = attributemodifier2.c() != AttributeModifier.Operation.b && attributemodifier2.c() != AttributeModifier.Operation.c ? attributemodifier2.b() : attributemodifier2.b() * 100.0;
                if (d0 > 0.0) {
                    consumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier2.c().a(), new Object[]{ItemAttributeModifiers.d.format(d1), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.j));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                consumer.accept(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier2.c().a(), new Object[]{ItemAttributeModifiers.d.format(d1 *= -1.0), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.m));
            }
        }
    }

    public static IChatMutableComponent a(Holder<MobEffectList> holder, int i2) {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c(holder.a().f());
        return i2 > 0 ? IChatBaseComponent.a("potion.withAmplifier", ichatmutablecomponent, IChatBaseComponent.c("potion.potency." + i2)) : ichatmutablecomponent;
    }

    @Override
    public void a(World world, EntityLiving entityliving, ItemStack itemstack, Consumable consumable) {
        this.a(entityliving, itemstack.a(DataComponents.Z, Float.valueOf(1.0f)).floatValue());
    }

    @Override
    public void a(Item.b item_b, Consumer<IChatBaseComponent> consumer, TooltipFlag tooltipflag, DataComponentGetter datacomponentgetter) {
        PotionContents.a(this.a(), consumer, datacomponentgetter.a(DataComponents.Z, Float.valueOf(1.0f)).floatValue(), item_b.b());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects;customName", "e", "f", "g", "h"}, this, o2);
    }

    public Optional<Holder<PotionRegistry>> e() {
        return this.e;
    }

    public Optional<Integer> f() {
        return this.f;
    }

    public Optional<String> g() {
        return this.h;
    }
}

