/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class AttackRange
extends Record {
    private final float c;
    private final float d;
    private final float e;
    private final float f;
    private final float g;
    private final float h;
    public static final Codec<AttackRange> a = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("min_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::a), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("max_reach", (Object)Float.valueOf(3.0f)).forGetter(AttackRange::b), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("min_creative_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::c), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("max_creative_reach", (Object)Float.valueOf(5.0f)).forGetter(AttackRange::d), (App)ExtraCodecs.a(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(AttackRange::e), (App)Codec.floatRange((float)0.0f, (float)2.0f).optionalFieldOf("mob_factor", (Object)Float.valueOf(1.0f)).forGetter(AttackRange::f)).apply((Applicative)var0, AttackRange::new));
    public static final StreamCodec<ByteBuf, AttackRange> b = StreamCodec.a(ByteBufCodecs.l, AttackRange::a, ByteBufCodecs.l, AttackRange::b, ByteBufCodecs.l, AttackRange::c, ByteBufCodecs.l, AttackRange::d, ByteBufCodecs.l, AttackRange::e, ByteBufCodecs.l, AttackRange::f, AttackRange::new);

    public AttackRange(float var0, float var1, float var2, float var3, float var4, float var5) {
        this.c = var0;
        this.d = var1;
        this.e = var2;
        this.f = var3;
        this.g = var4;
        this.h = var5;
    }

    public static AttackRange a(EntityLiving var0) {
        return new AttackRange(0.0f, (float)var0.i(GenericAttributes.l), 0.0f, (float)var0.i(GenericAttributes.l), 0.0f, 1.0f);
    }

    public MovingObjectPosition a(Entity var0, float var1, Predicate<Entity> var2) {
        Object var102;
        Either<MovingObjectPositionBlock, Collection<MovingObjectPositionEntity>> var3 = ProjectileHelper.a(var0, this, var2, RayTrace.BlockCollisionOption.b);
        if (var3.left().isPresent()) {
            return (MovingObjectPosition)var3.left().get();
        }
        Collection var4 = (Collection)var3.right().get();
        Object var5 = null;
        Vec3D var6 = var0.n(var1);
        double var7 = Double.MAX_VALUE;
        for (Object var102 : var4) {
            double var11 = var6.g(((MovingObjectPosition)var102).g());
            if (!(var11 < var7)) continue;
            var7 = var11;
            var5 = var102;
        }
        if (var5 != null) {
            return var5;
        }
        Vec3D var9 = var0.ck();
        var102 = var0.n(var1).e(var9);
        return MovingObjectPositionBlock.a((Vec3D)var102, EnumDirection.a(var9), BlockPosition.a((IPosition)var102));
    }

    public float a(Entity var0) {
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (var1.au()) {
                return 0.0f;
            }
            return var1.ha() ? this.e : this.c;
        }
        return this.c * this.h;
    }

    public float b(Entity var0) {
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            return var1.ha() ? this.f : this.d;
        }
        return this.d * this.h;
    }

    public boolean a(EntityLiving var0, Vec3D var1) {
        return this.a(var0, var1::g, 0.0);
    }

    public boolean a(EntityLiving var0, AxisAlignedBB var1, double var2) {
        return this.a(var0, var1::e, var2);
    }

    private boolean a(EntityLiving var0, ToDoubleFunction<Vec3D> var1, double var2) {
        double var4 = Math.sqrt(var1.applyAsDouble(var0.bV()));
        double var6 = (double)(this.a(var0) - this.g) - var2;
        double var8 = (double)(this.b(var0) + this.g) + var2;
        return var4 >= var6 && var4 <= var8;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this, var0);
    }

    public float a() {
        return this.c;
    }

    public float b() {
        return this.d;
    }

    public float c() {
        return this.e;
    }

    public float d() {
        return this.f;
    }

    public float e() {
        return this.g;
    }

    public float f() {
        return this.h;
    }
}

