/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class TeleportRandomlyConsumeEffect
extends Record
implements ConsumeEffect {
    private final float c;
    private static final float f = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.v.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::b)).apply((Applicative)instance, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> b = StreamCodec.a(ByteBufCodecs.l, TeleportRandomlyConsumeEffect::b, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public TeleportRandomlyConsumeEffect(float diameter) {
        this.c = diameter;
    }

    public ConsumeEffect.a<TeleportRandomlyConsumeEffect> a() {
        return ConsumeEffect.a.d;
    }

    @Override
    public boolean a(World world, ItemStack itemstack, EntityLiving entityliving) {
        boolean flag = false;
        for (int i2 = 0; i2 < 16; ++i2) {
            SoundCategory soundcategory;
            SoundEffect soundeffect;
            double d0 = entityliving.dP() + (entityliving.ep().j() - 0.5) * (double)this.c;
            double d1 = MathHelper.a(entityliving.dR() + (entityliving.ep().j() - 0.5) * (double)this.c, (double)world.K_(), (double)(world.K_() + ((WorldServer)world).o() - 1));
            double d2 = entityliving.dV() + (entityliving.ep().j() - 0.5) * (double)this.c;
            if (entityliving.cq()) {
                entityliving.cf();
            }
            Vec3D vec3d = entityliving.dI();
            Optional<Boolean> status = entityliving.randomTeleport(d0, d1, d2, true, PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT);
            if (!status.isPresent()) break;
            if (!status.get().booleanValue()) continue;
            world.a(GameEvent.R, vec3d, GameEvent.a.a(entityliving));
            if (entityliving instanceof EntityFox) {
                soundeffect = SoundEffects.ld;
                soundcategory = SoundCategory.g;
            } else {
                soundeffect = SoundEffects.fI;
                soundcategory = SoundCategory.h;
            }
            world.a((Entity)null, entityliving.dP(), entityliving.dR(), entityliving.dV(), soundeffect, soundcategory);
            entityliving.l();
            flag = true;
            break;
        }
        if (flag && entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            entityhuman.hr();
        }
        return flag;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this, o2);
    }

    public float b() {
        return this.c;
    }
}

