/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataAbstract<RecipeMap>
implements RecipeAccess {
    private static final Logger a = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, c> b = Map.of(RecipePropertySet.d, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.k();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.b, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = Optional.of(smithingrecipe.f());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.c, irecipe -> {
        Optional<Object> optional;
        if (irecipe instanceof SmithingRecipe) {
            SmithingRecipe smithingrecipe = (SmithingRecipe)irecipe;
            optional = smithingrecipe.c();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.e, CraftingManager.b(Recipes.b), RecipePropertySet.f, CraftingManager.b(Recipes.c), RecipePropertySet.g, CraftingManager.b(Recipes.d), RecipePropertySet.h, CraftingManager.b(Recipes.e));
    private static final FileToIdConverter c = FileToIdConverter.a(Registries.bK);
    private final HolderLookup.a d;
    public RecipeMap e = RecipeMap.a;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> f = Map.of();
    private SelectableRecipe.b<RecipeStonecutting> g = SelectableRecipe.b.a();
    private List<d> h = List.of();
    private Map<ResourceKey<IRecipe<?>>, List<d>> i = Map.of();
    private FeatureFlagSet featureflagset;

    public CraftingManager(HolderLookup.a holderlookup_a) {
        this.d = holderlookup_a;
    }

    protected RecipeMap a(IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        TreeMap<MinecraftKey, IRecipe> sortedmap = new TreeMap<MinecraftKey, IRecipe>();
        ResourceDataJson.a(iresourcemanager, c, this.d.a(JsonOps.INSTANCE), IRecipe.a, sortedmap);
        ArrayList list = new ArrayList(sortedmap.size());
        sortedmap.forEach((minecraftkey, irecipe) -> {
            ResourceKey<IRecipe<?>> resourcekey = ResourceKey.a(Registries.bK, minecraftkey);
            RecipeHolder<IRecipe> recipeholder = new RecipeHolder<IRecipe>(resourcekey, (IRecipe)irecipe);
            list.add(recipeholder);
        });
        return RecipeMap.a(list);
    }

    @Override
    protected void a(RecipeMap recipemap, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        this.e = recipemap;
        a.info("Loaded {} recipes", (Object)recipemap.a().size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        this.e.addRecipe(irecipe);
        this.finalizeRecipeLoading();
    }

    public void finalizeRecipeLoading() {
        if (this.featureflagset != null) {
            this.a(this.featureflagset);
            MinecraftServer.getServer().aj().reloadRecipes();
        }
    }

    public void a(FeatureFlagSet featureflagset) {
        this.featureflagset = featureflagset;
        ArrayList list = new ArrayList();
        List<b> list1 = b.entrySet().stream().map(entry -> new b((ResourceKey)entry.getKey(), (c)entry.getValue())).toList();
        this.e.a().forEach(recipeholder -> {
            Object irecipe = recipeholder.b();
            if (!irecipe.ar_() && irecipe.aq_().c()) {
                a.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)recipeholder.a().a());
            } else {
                RecipeStonecutting recipestonecutting;
                list1.forEach(craftingmanager_b -> craftingmanager_b.a((IRecipe<?>)irecipe));
                if (irecipe instanceof RecipeStonecutting && CraftingManager.a(featureflagset, (recipestonecutting = (RecipeStonecutting)irecipe).k()) && recipestonecutting.c().a(featureflagset)) {
                    list.add(new SelectableRecipe.a(recipestonecutting.k(), new SelectableRecipe(recipestonecutting.c(), Optional.of(recipeholder))));
                }
            }
        });
        this.f = list1.stream().collect(Collectors.toUnmodifiableMap(craftingmanager_b -> craftingmanager_b.a, craftingmanager_b -> craftingmanager_b.a(featureflagset)));
        this.g = new SelectableRecipe.b(list);
        this.h = CraftingManager.a(this.e.a(), featureflagset);
        this.i = this.h.stream().collect(Collectors.groupingBy(craftingmanager_d -> craftingmanager_d.b.a(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<RecipeItemStack> a(FeatureFlagSet featureflagset, List<RecipeItemStack> list) {
        list.removeIf(recipeitemstack -> !CraftingManager.a(featureflagset, recipeitemstack));
        return list;
    }

    private static boolean a(FeatureFlagSet featureflagset, RecipeItemStack recipeitemstack) {
        return recipeitemstack.a().allMatch(holder -> ((Item)holder.a()).a(featureflagset));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world, @Nullable ResourceKey<IRecipe<?>> resourcekey) {
        RecipeHolder<T> recipeholder = resourcekey != null ? this.a(recipes, resourcekey) : null;
        return this.a(recipes, i0, world, recipeholder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world, @Nullable RecipeHolder<T> recipeholder) {
        return recipeholder != null && recipeholder.b().a(i0, world) ? Optional.of(recipeholder) : this.a(recipes, i0, world);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world) {
        List<RecipeHolder<T>> list = this.e.a(recipes, i0, world).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public Optional<RecipeHolder<?>> b(ResourceKey<IRecipe<?>> resourcekey) {
        return Optional.ofNullable(this.e.a(resourcekey));
    }

    private <T extends IRecipe<?>> @Nullable RecipeHolder<T> a(Recipes<T> recipes, ResourceKey<IRecipe<?>> resourcekey) {
        RecipeHolder<?> recipeholder = this.e.a(resourcekey);
        return recipeholder != null && recipeholder.b().b().equals(recipes) ? recipeholder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> b() {
        return this.f;
    }

    public SelectableRecipe.b<RecipeStonecutting> c() {
        return this.g;
    }

    @Override
    public RecipePropertySet a(ResourceKey<RecipePropertySet> resourcekey) {
        return this.f.getOrDefault(resourcekey, RecipePropertySet.j);
    }

    @Override
    public SelectableRecipe.b<RecipeStonecutting> a() {
        return this.g;
    }

    public Collection<RecipeHolder<?>> d() {
        return this.e.a();
    }

    public @Nullable d a(RecipeDisplayId recipedisplayid) {
        int i2 = recipedisplayid.a();
        return i2 >= 0 && i2 < this.h.size() ? this.h.get(i2) : null;
    }

    public void a(ResourceKey<IRecipe<?>> resourcekey, Consumer<RecipeDisplayEntry> consumer) {
        List<d> list = this.i.get(resourcekey);
        if (list != null) {
            list.forEach(craftingmanager_d -> consumer.accept(craftingmanager_d.a));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> a(ResourceKey<IRecipe<?>> resourcekey, JsonObject jsonobject, HolderLookup.a holderlookup_a) {
        IRecipe irecipe = (IRecipe)IRecipe.a.parse(holderlookup_a.a(JsonOps.INSTANCE), (Object)jsonobject).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(resourcekey, irecipe);
    }

    public boolean removeRecipe(ResourceKey<IRecipe<?>> mcKey) {
        boolean removed = this.e.removeRecipe(mcKey);
        if (removed) {
            this.finalizeRecipeLoading();
        }
        return removed;
    }

    public void clearRecipes() {
        this.e = RecipeMap.a(Collections.emptyList());
        this.finalizeRecipeLoading();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> a(final Recipes<T> recipes) {
        return new a<I, T>(){
            private @Nullable ResourceKey<IRecipe<?>> b;

            @Override
            public Optional<RecipeHolder<T>> a(I i0, WorldServer worldserver) {
                CraftingManager craftingmanager = worldserver.x();
                Optional optional = craftingmanager.a(recipes, i0, (World)worldserver, this.b);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.b = recipeholder.a();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<d> a(Iterable<RecipeHolder<?>> iterable, FeatureFlagSet featureflagset) {
        ArrayList<d> list = new ArrayList<d>();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeholder : iterable) {
            Object irecipe = recipeholder.b();
            OptionalInt optionalint = irecipe.j().isEmpty() ? OptionalInt.empty() : OptionalInt.of(object2intmap.computeIfAbsent((Object)irecipe.j(), arg_0 -> CraftingManager.lambda$unpackRecipeInfo$13((Object2IntMap)object2intmap, arg_0)));
            Optional<Object> optional = irecipe.ar_() ? Optional.empty() : Optional.of(irecipe.aq_().b());
            for (RecipeDisplay recipedisplay : irecipe.g()) {
                if (!recipedisplay.a(featureflagset)) continue;
                int i2 = list.size();
                RecipeDisplayId recipedisplayid = new RecipeDisplayId(i2);
                RecipeDisplayEntry recipedisplayentry = new RecipeDisplayEntry(recipedisplayid, recipedisplay, optionalint, irecipe.h(), optional);
                list.add(new d(recipedisplayentry, recipeholder));
            }
        }
        return list;
    }

    private static c b(Recipes<? extends RecipeSingleItem> recipes) {
        return irecipe -> {
            Optional<Object> optional;
            if (irecipe.b() == recipes && irecipe instanceof RecipeSingleItem) {
                RecipeSingleItem recipesingleitem = (RecipeSingleItem)irecipe;
                optional = Optional.of(recipesingleitem.k());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap object2intmap, Object object) {
        return object2intmap.size();
    }

    public record d(RecipeDisplayEntry a, RecipeHolder<?> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "display;parent", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface c {
        public Optional<RecipeItemStack> apply(IRecipe<?> var1);
    }

    public static class b
    implements Consumer<IRecipe<?>> {
        final ResourceKey<RecipePropertySet> a;
        private final c b;
        private final List<RecipeItemStack> c = new ArrayList<RecipeItemStack>();

        protected b(ResourceKey<RecipePropertySet> resourcekey, c craftingmanager_c) {
            this.a = resourcekey;
            this.b = craftingmanager_c;
        }

        public void a(IRecipe<?> irecipe) {
            Optional<RecipeItemStack> optional = this.b.apply(irecipe);
            List<RecipeItemStack> list = this.c;
            Objects.requireNonNull(this.c);
            optional.ifPresent(list::add);
        }

        public RecipePropertySet a(FeatureFlagSet featureflagset) {
            return RecipePropertySet.a(CraftingManager.a(featureflagset, this.c));
        }
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> a(I var1, WorldServer var2);
    }
}

