/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.DryFoliageColor;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.jspecify.annotations.Nullable;

public final class BiomeBase {
    public static final Codec<BiomeBase> a = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.a.forGetter(var0 -> var0.i), (App)EnvironmentAttributeMap.d.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.a).forGetter(var0 -> var0.l), (App)BiomeFog.a.fieldOf("effects").forGetter(var0 -> var0.m), (App)BiomeSettingsGeneration.b.forGetter(var0 -> var0.j), (App)BiomeSettingsMobs.c.forGetter(var0 -> var0.k)).apply((Applicative)var02, BiomeBase::new));
    public static final Codec<BiomeBase> b = RecordCodecBuilder.create(var02 -> var02.group((App)ClimateSettings.a.forGetter(var0 -> var0.i), (App)EnvironmentAttributeMap.c.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.a).forGetter(var0 -> var0.l), (App)BiomeFog.a.fieldOf("effects").forGetter(var0 -> var0.m)).apply((Applicative)var02, (var0, var1, var2) -> new BiomeBase((ClimateSettings)var0, (EnvironmentAttributeMap)var1, (BiomeFog)var2, BiomeSettingsGeneration.a, BiomeSettingsMobs.b)));
    public static final Codec<Holder<BiomeBase>> c = RegistryFileCodec.a(Registries.aS, a);
    public static final Codec<HolderSet<BiomeBase>> d = RegistryCodecs.a(Registries.aS, a);
    private static final NoiseGenerator3 f = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 g = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 e = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int h = 1024;
    public final ClimateSettings i;
    private final BiomeSettingsGeneration j;
    private final BiomeSettingsMobs k;
    private final EnvironmentAttributeMap l;
    private final BiomeFog m;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> n = ThreadLocal.withInitial(() -> {
        Long2FloatLinkedOpenHashMap var0 = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int var0) {
            }
        };
        var0.defaultReturnValue(Float.NaN);
        return var0;
    });

    BiomeBase(ClimateSettings var0, EnvironmentAttributeMap var1, BiomeFog var2, BiomeSettingsGeneration var3, BiomeSettingsMobs var4) {
        this.i = var0;
        this.j = var3;
        this.k = var4;
        this.l = var1;
        this.m = var2;
    }

    public BiomeSettingsMobs a() {
        return this.k;
    }

    public boolean b() {
        return this.i.a();
    }

    public Precipitation a(BlockPosition var0, int var1) {
        if (!this.b()) {
            return Precipitation.a;
        }
        return this.b(var0, var1) ? Precipitation.c : Precipitation.b;
    }

    private float e(BlockPosition var0, int var1) {
        float var2 = this.i.d.a(var0, this.f());
        int var3 = var1 + 17;
        if (var0.v() > var3) {
            float var4 = (float)(f.a((float)var0.u() / 8.0f, (float)var0.w() / 8.0f, false) * 8.0);
            return var2 - (var4 + (float)var0.v() - (float)var3) * 0.05f / 40.0f;
        }
        return var2;
    }

    @Deprecated
    public float f(BlockPosition var0, int var1) {
        long var2 = var0.a();
        Long2FloatLinkedOpenHashMap var4 = this.n.get();
        float var5 = var4.get(var2);
        if (!Float.isNaN(var5)) {
            return var5;
        }
        float var6 = this.e(var0, var1);
        if (var4.size() == 1024) {
            var4.removeFirstFloat();
        }
        var4.put(var2, var6);
        return var6;
    }

    public boolean a(IWorldReader var0, BlockPosition var1) {
        return this.a(var0, var1, true);
    }

    public boolean a(IWorldReader var0, BlockPosition var1, boolean var2) {
        if (this.c(var1, var0.V())) {
            return false;
        }
        if (var0.d(var1.v()) && var0.a(EnumSkyBlock.b, var1) < 10) {
            IBlockData var3 = var0.a_(var1);
            Fluid var4 = var0.b_(var1);
            if (var4.a() == FluidTypes.c && var3.b() instanceof BlockFluids) {
                boolean var5;
                if (!var2) {
                    return true;
                }
                boolean bl = var5 = var0.F(var1.h()) && var0.F(var1.i()) && var0.F(var1.f()) && var0.F(var1.g());
                if (!var5) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(BlockPosition var0, int var1) {
        return !this.c(var0, var1);
    }

    public boolean c(BlockPosition var0, int var1) {
        return this.f(var0, var1) >= 0.15f;
    }

    public boolean d(BlockPosition var0, int var1) {
        return this.f(var0, var1) > 0.1f;
    }

    public boolean b(IWorldReader var0, BlockPosition var1) {
        IBlockData var2;
        if (this.a(var1, var0.V()) != Precipitation.c) {
            return false;
        }
        return var0.d(var1.v()) && var0.a(EnumSkyBlock.b, var1) < 10 && ((var2 = var0.a_(var1)).l() || var2.a(Blocks.ep)) && Blocks.ep.m().a(var0, var1);
    }

    public BiomeSettingsGeneration c() {
        return this.j;
    }

    public int a(double var0, double var2) {
        int var4 = this.j();
        return this.m.e().a(var0, var2, var4);
    }

    private int j() {
        Optional<Integer> var0 = this.m.d();
        if (var0.isPresent()) {
            return var0.get();
        }
        return this.k();
    }

    private int k() {
        double var0 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double var2 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return GrassColor.a(var0, var2);
    }

    public int d() {
        return this.m.b().orElseGet(this::l);
    }

    private int l() {
        double var0 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double var2 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return FoliageColor.a(var0, var2);
    }

    public int e() {
        return this.m.c().orElseGet(this::m);
    }

    private int m() {
        double var0 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double var2 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return DryFoliageColor.a(var0, var2);
    }

    public float f() {
        return this.i.c;
    }

    public EnvironmentAttributeMap g() {
        return this.l;
    }

    public BiomeFog h() {
        return this.m;
    }

    public int i() {
        return this.m.a();
    }

    public static final class ClimateSettings
    extends Record {
        private final boolean b;
        final float c;
        final TemperatureModifier d;
        final float e;
        public static final MapCodec<ClimateSettings> a = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(var0 -> var0.b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(var0 -> Float.valueOf(var0.c)), (App)TemperatureModifier.c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.a).forGetter(var0 -> var0.d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(var0 -> Float.valueOf(var0.e))).apply((Applicative)var02, ClimateSettings::new));

        ClimateSettings(boolean var0, float var1, TemperatureModifier var2, float var3) {
            this.b = var0;
            this.c = var1;
            this.d = var2;
            this.e = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this, var0);
        }

        public boolean a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public TemperatureModifier c() {
            return this.d;
        }

        public float d() {
            return this.e;
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements INamable {
        public static final /* enum */ Precipitation a = new Precipitation("none");
        public static final /* enum */ Precipitation b = new Precipitation("rain");
        public static final /* enum */ Precipitation c = new Precipitation("snow");
        public static final Codec<Precipitation> d;
        private final String e;
        private static final /* synthetic */ Precipitation[] f;

        public static Precipitation[] values() {
            return (Precipitation[])f.clone();
        }

        public static Precipitation valueOf(String var0) {
            return Enum.valueOf(Precipitation.class, var0);
        }

        private Precipitation(String var2) {
            this.e = var2;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ Precipitation[] a() {
            return new Precipitation[]{a, b, c};
        }

        static {
            f = Precipitation.a();
            d = INamable.a(Precipitation::values);
        }
    }

    public static abstract sealed class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier a = new TemperatureModifier("none"){

            @Override
            public float a(BlockPosition var0, float var1) {
                return var1;
            }
        };
        public static final /* enum */ TemperatureModifier b = new TemperatureModifier("frozen"){

            @Override
            public float a(BlockPosition var0, float var1) {
                double var8;
                double var4;
                double var2 = g.a((double)var0.u() * 0.05, (double)var0.w() * 0.05, false) * 7.0;
                double var6 = var2 + (var4 = BiomeBase.e.a((double)var0.u() * 0.2, (double)var0.w() * 0.2, false));
                if (var6 < 0.3 && (var8 = BiomeBase.e.a((double)var0.u() * 0.09, (double)var0.w() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return var1;
            }
        };
        private final String d;
        public static final Codec<TemperatureModifier> c;
        private static final /* synthetic */ TemperatureModifier[] e;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])e.clone();
        }

        public static TemperatureModifier valueOf(String var0) {
            return Enum.valueOf(TemperatureModifier.class, var0);
        }

        public abstract float a(BlockPosition var1, float var2);

        TemperatureModifier(String var2) {
            this.d = var2;
        }

        public String a() {
            return this.d;
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{a, b};
        }

        static {
            e = TemperatureModifier.b();
            c = INamable.a(TemperatureModifier::values);
        }
    }

    public static class a {
        private boolean a = true;
        private @Nullable Float b;
        private TemperatureModifier c = TemperatureModifier.a;
        private @Nullable Float d;
        private final EnvironmentAttributeMap.a e = EnvironmentAttributeMap.a();
        private @Nullable BiomeFog f;
        private @Nullable BiomeSettingsMobs g;
        private @Nullable BiomeSettingsGeneration h;

        public a a(boolean var0) {
            this.a = var0;
            return this;
        }

        public a a(float var0) {
            this.b = Float.valueOf(var0);
            return this;
        }

        public a b(float var0) {
            this.d = Float.valueOf(var0);
            return this;
        }

        public a a(EnvironmentAttributeMap var0) {
            this.e.a(var0);
            return this;
        }

        public a a(EnvironmentAttributeMap.a var0) {
            return this.a(var0.a());
        }

        public <Value> a a(EnvironmentAttribute<Value> var0, Value var1) {
            this.e.a(var0, var1);
            return this;
        }

        public <Value, Parameter> a a(EnvironmentAttribute<Value> var0, AttributeModifier<Value, Parameter> var1, Parameter var2) {
            this.e.a(var0, var1, var2);
            return this;
        }

        public a a(BiomeFog var0) {
            this.f = var0;
            return this;
        }

        public a a(BiomeSettingsMobs var0) {
            this.g = var0;
            return this;
        }

        public a a(BiomeSettingsGeneration var0) {
            this.h = var0;
            return this;
        }

        public a a(TemperatureModifier var0) {
            this.c = var0;
            return this;
        }

        public BiomeBase a() {
            if (this.b == null || this.d == null || this.f == null || this.g == null || this.h == null) {
                throw new IllegalStateException("You are missing parameters to build a proper biome\n" + String.valueOf(this));
            }
            return new BiomeBase(new ClimateSettings(this.a, this.b.floatValue(), this.c, this.d.floatValue()), this.e.a(), this.f, this.h, this.g);
        }

        public String toString() {
            return "BiomeBuilder{\nhasPrecipitation=" + this.a + ",\ntemperature=" + this.b + ",\ntemperatureModifier=" + String.valueOf(this.c) + ",\ndownfall=" + this.d + ",\nspecialEffects=" + String.valueOf(this.f) + ",\nmobSpawnSettings=" + String.valueOf(this.g) + ",\ngenerationSettings=" + String.valueOf(this.h) + ",\n}";
        }
    }
}

