/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.Nullable;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> a = BlockEnderPortal.b(BlockEnderPortal::new);
    private static final VoxelShape b = Block.b(16.0, 6.0, 12.0);

    public MapCodec<BlockEnderPortal> a() {
        return a;
    }

    protected BlockEnderPortal(BlockBase.Info blockbase_info) {
        super(blockbase_info);
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityEnderPortal(blockposition, iblockdata);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return b;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        return iblockdata.f(iblockaccess, blockposition);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (entity.o(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)world.getWorld(), (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!world.B_() && world.aq() == World.j && entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (!entityplayer.i) {
                    entityplayer.p();
                    return;
                }
            }
            entity.a(this, blockposition);
        }
    }

    @Override
    public @Nullable TeleportTransition a(WorldServer worldserver, net.minecraft.world.entity.Entity entity, BlockPosition blockposition) {
        CraftPortalEvent event;
        Set<Relative> set;
        float f1;
        float f2;
        WorldData.a worlddata_a = worldserver.C();
        ResourceKey<WorldDimension> resourcekey = worldserver.getTypeKey();
        boolean flag = resourcekey == WorldDimension.d;
        ResourceKey<World> resourcekey1 = flag ? worlddata_a.a() : World.j;
        BlockPosition blockposition1 = flag ? worlddata_a.b() : WorldServer.a;
        WorldServer worldserver1 = worldserver.s().a(resourcekey1);
        if (worldserver1 == null) {
            return new TeleportTransition(PlayerTeleportEvent.TeleportCause.END_PORTAL);
        }
        Vec3D vec3d = blockposition1.c();
        if (!flag) {
            EndPlatformFeature.createEndPlatform(worldserver1, BlockPosition.a(vec3d).e(), true, entity);
            f2 = EnumDirection.e.p();
            f1 = 0.0f;
            set = Relative.a(Relative.l, Set.of(Relative.e));
            if (entity instanceof EntityPlayer) {
                vec3d = vec3d.a(0.0, 1.0, 0.0);
            }
        } else {
            f2 = worlddata_a.d();
            f1 = worlddata_a.e();
            set = Relative.a(Relative.l, Relative.k);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                return entityplayer.findRespawnPositionAndUseSpawnBlock(false, TeleportTransition.a, PlayerRespawnEvent.RespawnReason.END_PORTAL);
            }
            vec3d = entity.a(worldserver1, blockposition1).c();
        }
        if ((event = entity.callPortalEvent(entity, CraftLocation.toBukkit(vec3d, (org.bukkit.World)worldserver1.getWorld(), f2, f1), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0)) == null) {
            return null;
        }
        Location to = event.getTo();
        return new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), entity.dN(), to.getYaw(), to.getPitch(), set, TeleportTransition.b.then(TeleportTransition.c), PlayerTeleportEvent.TeleportCause.END_PORTAL);
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        double d0 = (double)blockposition.u() + randomsource.j();
        double d1 = (double)blockposition.v() + 0.8;
        double d2 = (double)blockposition.w() + randomsource.j();
        world.a(Particles.ai, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    protected ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return ItemStack.l;
    }

    @Override
    protected boolean a(IBlockData iblockdata, FluidType fluidtype) {
        return false;
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.a;
    }
}

