/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class BlockSweetBerryBush
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSweetBerryBush> a = BlockSweetBerryBush.b(BlockSweetBerryBush::new);
    private static final float d = 0.003f;
    public static final int b = 3;
    public static final BlockStateInteger c = BlockProperties.aw;
    private static final VoxelShape e = Block.b(10.0, 0.0, 8.0);
    private static final VoxelShape f = Block.b(14.0, 0.0, 16.0);

    public MapCodec<BlockSweetBerryBush> a() {
        return a;
    }

    public BlockSweetBerryBush(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)this.C.b()).b(c, 0));
    }

    @Override
    protected net.minecraft.world.item.ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return new net.minecraft.world.item.ItemStack(Items.za);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return switch (iblockdata.c(c)) {
            case 0 -> e;
            case 3 -> VoxelShapes.b();
            default -> f;
        };
    }

    @Override
    protected boolean f(IBlockData iblockdata) {
        return iblockdata.c(c) < 3;
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2 = iblockdata.c(c);
        if (i2 < 3 && randomsource.i() < (float)worldserver.spigotConfig.sweetBerryModifier / 500.0f && worldserver.b(blockposition.d(), 0) >= 9) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.b(c, i2 + 1);
            if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata1, 2)) {
                return;
            }
            worldserver.a(GameEvent.c, blockposition, GameEvent.a.a(iblockdata1));
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (entity instanceof EntityLiving && entity.ay() != EntityTypes.ae && entity.ay() != EntityTypes.n) {
            entity.a(iblockdata, new Vec3D(0.8f, 0.75, 0.8f));
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (iblockdata.c(c) != 0) {
                    Vec3D vec3d;
                    Vec3D vec3D = vec3d = entity.aa_() ? entity.ag() : entity.bS().d(entity.dI());
                    if (vec3d.j() > 0.0) {
                        double d0 = Math.abs(vec3d.a());
                        double d1 = Math.abs(vec3d.c());
                        if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                            entity.a(worldserver, world.as().u().directBlock(world, blockposition), 1.0f);
                        }
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        int i2 = iblockdata.c(c);
        boolean flag = i2 == 3;
        return !flag && itemstack.a(Items.tC) ? EnumInteractionResult.e : super.a(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (iblockdata.c(c) > 1) {
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                LinkedList<net.minecraft.world.item.ItemStack> dropped = new LinkedList<net.minecraft.world.item.ItemStack>();
                Block.a(worldserver, LootTables.aM, iblockdata, world.c_(blockposition), null, entityhuman, (worldserver1, itemstack) -> dropped.add((net.minecraft.world.item.ItemStack)itemstack));
                PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, blockposition, entityhuman, EnumHand.a, dropped);
                if (event.isCancelled()) {
                    return EnumInteractionResult.a;
                }
                for (ItemStack itemStack : event.getItemsHarvested()) {
                    BlockSweetBerryBush.a(world, blockposition, CraftItemStack.asNMSCopy(itemStack));
                }
                worldserver.a((Entity)null, blockposition, SoundEffects.CK, SoundCategory.e, 1.0f, 0.8f + worldserver.y.i() * 0.4f);
                IBlockData iblockdata1 = (IBlockData)iblockdata.b(c, 1);
                worldserver.a(blockposition, iblockdata1, 2);
                worldserver.a(GameEvent.c, blockposition, GameEvent.a.a(entityhuman, iblockdata1));
            }
            return EnumInteractionResult.a;
        }
        return super.a(iblockdata, world, blockposition, entityhuman, movingobjectpositionblock);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{c});
    }

    @Override
    public boolean a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return iblockdata.c(c) < 3;
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = Math.min(3, iblockdata.c(c) + 1);
        worldserver.a(blockposition, (IBlockData)iblockdata.b(c, i2), 2);
    }
}

