/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeBase.Precipitation.d.fieldOf("precipitation").forGetter(layeredcauldronblock -> layeredcauldronblock.R), (App)CauldronInteraction.b.fieldOf("interactions").forGetter(layeredcauldronblock -> layeredcauldronblock.c), LayeredCauldronBlock.x()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int e = 1;
    public static final int f = 3;
    public static final BlockStateInteger g = BlockProperties.aO;
    private static final int h = 6;
    private static final double i = 3.0;
    private static final VoxelShape[] D = SystemUtils.a(() -> Block.a(2, (int i2) -> VoxelShapes.a(AbstractCauldronBlock.b, Block.b(12.0, 4.0, LayeredCauldronBlock.b(i2 + 1)))));
    private final BiomeBase.Precipitation R;

    public MapCodec<LayeredCauldronBlock> a() {
        return d;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation biomebase_precipitation, CauldronInteraction.a cauldroninteraction_a, BlockBase.Info blockbase_info) {
        super(blockbase_info, cauldroninteraction_a);
        this.R = biomebase_precipitation;
        this.l((IBlockData)((IBlockData)this.C.b()).b(g, 1));
    }

    @Override
    public boolean d(IBlockData iblockdata) {
        return iblockdata.c(g) == 3;
    }

    @Override
    protected boolean a(FluidType fluidtype) {
        return fluidtype == FluidTypes.c && this.R == BiomeBase.Precipitation.b;
    }

    @Override
    protected double b(IBlockData iblockdata) {
        return LayeredCauldronBlock.b(iblockdata.c(g)) / 16.0;
    }

    private static double b(int i2) {
        return 6.0 + (double)i2 * 3.0;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        return D[iblockdata.c(g) - 1];
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            BlockPosition blockposition1 = blockposition.j();
            insideblockeffectapplier.a(InsideBlockEffectType.e, (net.minecraft.world.entity.Entity entity1) -> {
                if (entity1.cp() && entity1.c(worldserver, blockposition1) && this.handleEntityOnFireInside(iblockdata, world, blockposition1, entity)) {
                    insideblockeffectapplier.a(InsideBlockEffectType.e);
                }
            });
        }
    }

    private boolean handleEntityOnFireInside(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (this.R == BiomeBase.Precipitation.c) {
            return LayeredCauldronBlock.lowerFillLevel((IBlockData)Blocks.gj.m().b(g, iblockdata.c(g)), world, blockposition, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
        }
        return LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
    }

    public static void c(IBlockData iblockdata, World world, BlockPosition blockposition) {
        LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = iblockdata.c(g) - 1;
        IBlockData iblockdata1 = i2 == 0 ? Blocks.gi.m() : (IBlockData)iblockdata.b(g, i2);
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, entity, reason);
    }

    public static boolean changeLevel(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData newBlock, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        CraftBlockState newState = CraftBlockStates.getBlockState(world, blockposition);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        newState.update(true);
        world.a(GameEvent.c, blockposition, GameEvent.a.a(newBlock));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, BiomeBase.Precipitation biomebase_precipitation) {
        if (BlockCauldron.a(world, biomebase_precipitation) && iblockdata.c(g) != 3 && biomebase_precipitation == this.R) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.a(g);
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(g);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{g});
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, FluidType fluidtype) {
        if (!this.d(iblockdata)) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.b(g, iblockdata.c(g) + 1);
            if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            world.c(1047, blockposition, 0);
        }
    }
}

