/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ProtoChunk
extends IChunkAccess {
    private static final Logger m = LogUtils.getLogger();
    private volatile @Nullable LevelLightEngine n;
    private volatile ChunkStatus o = ChunkStatus.c;
    private final List<NBTTagCompound> p = Lists.newArrayList();
    private @Nullable CarvingMask q;
    private @Nullable BelowZeroRetrogen r;
    private final ProtoChunkTickList<Block> s;
    private final ProtoChunkTickList<FluidType> t;

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, LevelHeightAccessor var2, PalettedContainerFactory var3, @Nullable BlendingData var4) {
        this(var0, var1, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), var2, var3, var4);
    }

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, ChunkSection @Nullable [] var2, ProtoChunkTickList<Block> var3, ProtoChunkTickList<FluidType> var4, LevelHeightAccessor var5, PalettedContainerFactory var6, @Nullable BlendingData var7) {
        super(var0, var1, var5, var6, 0L, var2, var7);
        this.s = var3;
        this.t = var4;
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.s;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.t;
    }

    @Override
    public IChunkAccess.b a(long var0) {
        return new IChunkAccess.b(this.s.a(var0), this.t.a(var0));
    }

    @Override
    public IBlockData a_(BlockPosition var0) {
        int var1 = var0.v();
        if (this.e(var1)) {
            return Blocks.nY.m();
        }
        ChunkSection var2 = this.b(this.f(var1));
        if (var2.c()) {
            return Blocks.a.m();
        }
        return var2.a(var0.u() & 0xF, var1 & 0xF, var0.w() & 0xF);
    }

    @Override
    public Fluid b_(BlockPosition var0) {
        int var1 = var0.v();
        if (this.e(var1)) {
            return FluidTypes.a.g();
        }
        ChunkSection var2 = this.b(this.f(var1));
        if (var2.c()) {
            return FluidTypes.a.g();
        }
        return var2.b(var0.u() & 0xF, var1 & 0xF, var0.w() & 0xF);
    }

    @Override
    public @Nullable IBlockData a(BlockPosition var0, IBlockData var1, @Block.b int var2) {
        int var3 = var0.u();
        int var4 = var0.v();
        int var5 = var0.w();
        if (this.e(var4)) {
            return Blocks.nY.m();
        }
        int var6 = this.f(var4);
        ChunkSection var7 = this.b(var6);
        boolean var8 = var7.c();
        if (var8 && var1.a(Blocks.a)) {
            return var1;
        }
        int var9 = SectionPosition.b(var3);
        int var10 = SectionPosition.b(var4);
        int var11 = SectionPosition.b(var5);
        IBlockData var12 = var7.a(var9, var10, var11, var1);
        if (this.o.a(ChunkStatus.k)) {
            boolean var13 = var7.c();
            if (var13 != var8) {
                this.n.a(var0, var13);
            }
            if (LightEngine.a(var12, var1)) {
                this.h.a((IBlockAccess)this, var9, var4, var11);
                this.n.a(var0);
            }
        }
        EnumSet<HeightMap.Type> var13 = this.n().e();
        EnumSet<HeightMap.Type> var14 = null;
        for (HeightMap.Type var16 : var13) {
            HeightMap var17 = (HeightMap)this.g.get(var16);
            if (var17 != null) continue;
            if (var14 == null) {
                var14 = EnumSet.noneOf(HeightMap.Type.class);
            }
            var14.add(var16);
        }
        if (var14 != null) {
            HeightMap.a(this, var14);
        }
        for (HeightMap.Type var16 : var13) {
            ((HeightMap)this.g.get(var16)).a(var9, var4, var11, var1);
        }
        return var12;
    }

    @Override
    public void a(TileEntity var0) {
        this.i.remove(var0.aD_());
        this.j.put(var0.aD_(), var0);
    }

    @Override
    public @Nullable TileEntity c_(BlockPosition var0) {
        return (TileEntity)this.j.get(var0);
    }

    public Map<BlockPosition, TileEntity> I() {
        return this.j;
    }

    public void b(NBTTagCompound var0) {
        this.p.add(var0);
    }

    @Override
    public void a(Entity var0) {
        if (var0.cq()) {
            return;
        }
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.es(), m);){
            TagValueOutput var2 = TagValueOutput.a(var1, var0.eo());
            var0.c(var2);
            this.b(var2.b());
        }
    }

    @Override
    public void a(Structure var0, StructureStart var1) {
        BelowZeroRetrogen var2 = this.z();
        if (var2 != null && var1.b()) {
            StructureBoundingBox var3 = var1.a();
            LevelHeightAccessor var4 = this.B();
            if (var3.i() < var4.K_() || var3.l() > var4.aw()) {
                return;
            }
        }
        super.a(var0, var1);
    }

    public List<NBTTagCompound> J() {
        return this.p;
    }

    @Override
    public ChunkStatus n() {
        return this.o;
    }

    public void a(ChunkStatus var0) {
        this.o = var0;
        if (this.r != null && var0.a(this.r.a())) {
            this.a((BelowZeroRetrogen)null);
        }
        this.i();
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        if (this.o().a(ChunkStatus.f)) {
            return super.getNoiseBiome(var0, var1, var2);
        }
        throw new IllegalStateException("Asking for biomes before we have biomes");
    }

    public static short g(BlockPosition var0) {
        int var1 = var0.u();
        int var2 = var0.v();
        int var3 = var0.w();
        int var4 = var1 & 0xF;
        int var5 = var2 & 0xF;
        int var6 = var3 & 0xF;
        return (short)(var4 | var5 << 4 | var6 << 8);
    }

    public static BlockPosition a(short var0, int var1, ChunkCoordIntPair var2) {
        int var3 = SectionPosition.a(var2.h, var0 & 0xF);
        int var4 = SectionPosition.a(var1, var0 >>> 4 & 0xF);
        int var5 = SectionPosition.a(var2.i, var0 >>> 8 & 0xF);
        return new BlockPosition(var3, var4, var5);
    }

    @Override
    public void e(BlockPosition var0) {
        if (!this.y(var0)) {
            IChunkAccess.a(this.b, this.f(var0.v())).add(ProtoChunk.g(var0));
        }
    }

    @Override
    public void a(ShortList var0, int var1) {
        IChunkAccess.a(this.b, var1).addAll(var0);
    }

    public Map<BlockPosition, NBTTagCompound> K() {
        return Collections.unmodifiableMap(this.i);
    }

    @Override
    public @Nullable NBTTagCompound a(BlockPosition var0, HolderLookup.a var1) {
        TileEntity var2 = this.c_(var0);
        if (var2 != null) {
            return var2.b(var1);
        }
        return (NBTTagCompound)this.i.get(var0);
    }

    @Override
    public void c(BlockPosition var0) {
        this.j.remove(var0);
        this.i.remove(var0);
    }

    public @Nullable CarvingMask F() {
        return this.q;
    }

    public CarvingMask G() {
        if (this.q == null) {
            this.q = new CarvingMask(this.L_(), this.K_());
        }
        return this.q;
    }

    public void a(CarvingMask var0) {
        this.q = var0;
    }

    public void a(LevelLightEngine var0) {
        this.n = var0;
    }

    public void a(@Nullable BelowZeroRetrogen var0) {
        this.r = var0;
    }

    @Override
    public @Nullable BelowZeroRetrogen z() {
        return this.r;
    }

    private static <T> LevelChunkTicks<T> a(ProtoChunkTickList<T> var0) {
        return new LevelChunkTicks<T>(var0.b());
    }

    public LevelChunkTicks<Block> L() {
        return ProtoChunk.a(this.s);
    }

    public LevelChunkTicks<FluidType> M() {
        return ProtoChunk.a(this.t);
    }

    @Override
    public LevelHeightAccessor B() {
        if (this.A()) {
            return BelowZeroRetrogen.b;
        }
        return this;
    }
}

