/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Entities";
    private static final String c = "Position";
    public final WorldServer d;
    private final SimpleRegionStorage e;
    private final LongSet f = new LongOpenHashSet();
    public final ConsecutiveExecutor g;

    public EntityStorage(SimpleRegionStorage var0, WorldServer var1, Executor var2) {
        this.e = var0;
        this.d = var1;
        this.g = new ConsecutiveExecutor(var2, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> a(ChunkCoordIntPair var0) {
        if (this.f.contains(var0.b())) {
            return CompletableFuture.completedFuture(EntityStorage.b(var0));
        }
        CompletableFuture<Optional<NBTTagCompound>> var12 = this.e.d(var0);
        this.b(var12, var0);
        return var12.thenApplyAsync(var1 -> {
            Object var2;
            if (var1.isEmpty()) {
                this.f.add(var0.b());
                return EntityStorage.b(var0);
            }
            try {
                var2 = ((NBTTagCompound)var1.get()).a(c, ChunkCoordIntPair.a).orElseThrow();
                if (!Objects.equals(var0, var2)) {
                    a.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{var0, var0, var2});
                    this.d.s().a((ChunkCoordIntPair)var2, var0, this.e.n());
                }
            }
            catch (Exception var22) {
                a.warn("Failed to parse chunk {} position info", (Object)var0, (Object)var22);
                this.d.s().a(var22, this.e.n(), var0);
            }
            var2 = this.e.a((NBTTagCompound)var1.get(), -1);
            try (ProblemReporter.j var3 = new ProblemReporter.j(IChunkAccess.a(var0), a);){
                ValueInput var4 = TagValueInput.a((ProblemReporter)var3, (HolderLookup.a)this.d.J_(), (NBTTagCompound)var2);
                ValueInput.b var5 = var4.d(b);
                List<Entity> var6 = EntityTypes.a(var5, (World)this.d, EntitySpawnReason.r).toList();
                ChunkEntities<Entity> chunkEntities = new ChunkEntities<Entity>(var0, var6);
                return chunkEntities;
            }
        }, this.g::a_);
    }

    private static ChunkEntities<Entity> b(ChunkCoordIntPair var0) {
        return new ChunkEntities<Entity>(var0, List.of());
    }

    @Override
    public void a(ChunkEntities<Entity> var0) {
        ChunkCoordIntPair var1 = var0.a();
        if (var0.c()) {
            if (this.f.add(var1.b())) {
                this.a(this.e.a(var1, IOWorker.a), var1);
            }
            return;
        }
        try (ProblemReporter.j var22 = new ProblemReporter.j(IChunkAccess.a(var1), a);){
            NBTTagList var3 = new NBTTagList();
            var0.b().forEach(var2 -> {
                TagValueOutput var3 = TagValueOutput.a(var22.a(var2.es()), var2.eo());
                if (var2.c(var3)) {
                    NBTTagCompound var4 = var3.b();
                    var3.add(var4);
                }
            });
            NBTTagCompound var4 = GameProfileSerializer.e(new NBTTagCompound());
            var4.a(b, var3);
            var4.a(c, ChunkCoordIntPair.a, var1);
            this.a(this.e.a(var1, var4), var1);
            this.f.remove(var1.b());
        }
    }

    private void a(CompletableFuture<?> var0, ChunkCoordIntPair var12) {
        var0.exceptionally(var1 -> {
            a.error("Failed to store entity chunk {}", (Object)var12, var1);
            this.d.s().b((Throwable)var1, this.e.n(), var12);
            return null;
        });
    }

    private void b(CompletableFuture<?> var0, ChunkCoordIntPair var12) {
        var0.exceptionally(var1 -> {
            a.error("Failed to load entity chunk {}", (Object)var12, var1);
            this.d.s().a((Throwable)var1, this.e.n(), var12);
            return null;
        });
    }

    @Override
    public void a(boolean var0) {
        this.e.b(var0).join();
        this.g.a();
    }

    @Override
    public void close() throws IOException {
        this.e.close();
    }
}

