/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class SimpleRegionStorage
implements AutoCloseable {
    private final IOWorker a;
    private final DataFixer b;
    private final DataFixTypes c;
    private final Supplier<LegacyTagFixer> d;

    public SimpleRegionStorage(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag, DataFixTypes datafixtypes) {
        this(regionstorageinfo, path, datafixer, flag, datafixtypes, LegacyTagFixer.a);
    }

    public SimpleRegionStorage(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag, DataFixTypes datafixtypes, Supplier<LegacyTagFixer> supplier) {
        this.b = datafixer;
        this.c = datafixtypes;
        this.a = new IOWorker(regionstorageinfo, path, flag);
        Objects.requireNonNull(supplier);
        this.d = Suppliers.memoize(supplier::get);
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.a.a(chunkcoordintpair, i2);
    }

    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        return this.a(chunkcoordintpair, () -> nbttagcompound);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkcoordintpair, Supplier<NBTTagCompound> supplier) {
        this.e(chunkcoordintpair);
        return this.a.a(chunkcoordintpair, supplier);
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        NBTTagCompound nbt;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x2, z2);
        if (cps != null && cps.b(x2, z2)) {
            return true;
        }
        try {
            nbt = this.d(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            NBTTagCompound level = nbt.n("Level");
            if (level.b("TerrainPopulated", false)) {
                return true;
            }
            ChunkStatus status = ChunkStatus.a(level.b("Status", ""));
            if (status != null && status.a(ChunkStatus.j)) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound, int i2, @Nullable NBTTagCompound nbttagcompound1) {
        return this.upgradeChunkTag(nbttagcompound, i2, nbttagcompound1, null, null);
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, int i2, @Nullable NBTTagCompound nbttagcompound1, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        int j2 = GameProfileSerializer.b(nbttagcompound, i2);
        if (j2 == SharedConstants.b().a().b()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            NBTTagCompound level;
            if (j2 < 1466 && pos != null && (level = nbttagcompound.n("Level")).b("TerrainPopulated", false) && !level.b("LightPopulated", false)) {
                ChunkProviderServer cps;
                ChunkProviderServer chunkProviderServer = cps = generatoraccess == null ? null : ((WorldServer)generatoraccess).p();
                if (this.check(cps, pos.h - 1, pos.i) && this.check(cps, pos.h - 1, pos.i - 1) && this.check(cps, pos.h, pos.i - 1)) {
                    level.a("LightPopulated", true);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.n("Level").b("Status", ""));
            }
            nbttagcompound = this.d.get().applyFix(nbttagcompound);
            SimpleRegionStorage.a(nbttagcompound, nbttagcompound1);
            nbttagcompound = this.c.a(this.b, nbttagcompound, Math.max(this.d.get().targetDataVersion(), j2));
            if (stopBelowZero) {
                nbttagcompound.a("Status", BuiltInRegistries.m.b(ChunkStatus.m).toString());
            }
            SimpleRegionStorage.a(nbttagcompound);
            GameProfileSerializer.e(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Updated chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Updated chunk details");
            crashreportsystemdetails.a("Data version", j2);
            throw new ReportedException(crashreport);
        }
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound, int i2) {
        return this.a(nbttagcompound, i2, null);
    }

    public Dynamic<NBTBase> a(Dynamic<NBTBase> dynamic, int i2) {
        return new Dynamic(dynamic.getOps(), (Object)this.a((NBTTagCompound)dynamic.getValue(), i2, null));
    }

    public static void a(NBTTagCompound nbttagcompound, @Nullable NBTTagCompound nbttagcompound1) {
        if (nbttagcompound1 != null) {
            nbttagcompound.a("__context", nbttagcompound1);
        }
    }

    private static void a(NBTTagCompound nbttagcompound) {
        nbttagcompound.r("__context");
    }

    protected void e(ChunkCoordIntPair chunkcoordintpair) {
        this.d.get().markChunkDone(chunkcoordintpair);
    }

    public CompletableFuture<Void> b(boolean flag) {
        return this.a.a(flag);
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    public ChunkScanAccess m() {
        return this.a;
    }

    public RegionStorageInfo n() {
        return this.a.a();
    }
}

