/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R7.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R7.util.TransformerGeneratorAccess;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String a = "INVALID";
    public static final StructureStart b = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger c = LogUtils.getLogger();
    private final Structure d;
    private final PiecesContainer e;
    private final ChunkCoordIntPair f;
    private int g;
    private volatile @Nullable StructureBoundingBox h;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure structure, ChunkCoordIntPair chunkcoordintpair, int i2, PiecesContainer piecescontainer) {
        this.d = structure;
        this.f = chunkcoordintpair;
        this.g = i2;
        this.e = piecescontainer;
    }

    public static @Nullable StructureStart a(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound, long i2) {
        String s2 = nbttagcompound.b("id", "");
        if (a.equals(s2)) {
            return b;
        }
        IRegistry<Structure> iregistry = structurepieceserializationcontext.b().f(Registries.bs);
        Structure structure = iregistry.a(MinecraftKey.a(s2));
        if (structure == null) {
            c.error("Unknown stucture id: {}", (Object)s2);
            return null;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound.b("ChunkX", 0), nbttagcompound.b("ChunkZ", 0));
        int j2 = nbttagcompound.b("references", 0);
        NBTTagList nbttaglist = nbttagcompound.p("Children");
        try {
            PiecesContainer piecescontainer = PiecesContainer.a(nbttaglist, structurepieceserializationcontext);
            if (structure instanceof OceanMonumentStructure) {
                piecescontainer = OceanMonumentStructure.a(chunkcoordintpair, i2, piecescontainer);
            }
            return new StructureStart(structure, chunkcoordintpair, j2, piecescontainer);
        }
        catch (Exception exception) {
            c.error("Failed Start with id {}", (Object)s2, (Object)exception);
            return null;
        }
    }

    public StructureBoundingBox a() {
        StructureBoundingBox structureboundingbox = this.h;
        if (structureboundingbox == null) {
            this.h = structureboundingbox = this.d.a(this.e.b());
        }
        return structureboundingbox;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair) {
        List<StructurePiece> list = this.e.c();
        if (!list.isEmpty()) {
            StructureBoundingBox structureboundingbox1 = list.get((int)0).f;
            BlockPosition blockposition = structureboundingbox1.g();
            BlockPosition blockposition1 = new BlockPosition(blockposition.u(), structureboundingbox1.i(), blockposition.w());
            List<StructurePiece> pieces = list.stream().filter(piece -> piece.f().a(structureboundingbox)).toList();
            if (!pieces.isEmpty()) {
                TransformerGeneratorAccess transformerAccess = new TransformerGeneratorAccess();
                transformerAccess.setHandle(generatoraccessseed);
                transformerAccess.setStructureTransformer(new CraftStructureTransformer(this.generationEventCause, generatoraccessseed, structuremanager, this.d, structureboundingbox, chunkcoordintpair));
                for (StructurePiece piece2 : pieces) {
                    piece2.a((GeneratorAccessSeed)transformerAccess, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition1);
                }
                transformerAccess.getStructureTransformer().discard();
            }
            this.d.a(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, this.e);
        }
    }

    public NBTTagCompound a(StructurePieceSerializationContext structurepieceserializationcontext, ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("StructureBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        if (this.b()) {
            nbttagcompound.a("id", structurepieceserializationcontext.b().f(Registries.bs).b(this.d).toString());
            nbttagcompound.a("ChunkX", chunkcoordintpair.h);
            nbttagcompound.a("ChunkZ", chunkcoordintpair.i);
            nbttagcompound.a("references", this.g);
            nbttagcompound.a("Children", this.e.a(structurepieceserializationcontext));
            return nbttagcompound;
        }
        nbttagcompound.a("id", a);
        return nbttagcompound;
    }

    public boolean b() {
        return !this.e.a();
    }

    public ChunkCoordIntPair c() {
        return this.f;
    }

    public boolean d() {
        return this.g < this.g();
    }

    public void e() {
        ++this.g;
    }

    public int f() {
        return this.g;
    }

    protected int g() {
        return 1;
    }

    public Structure h() {
        return this.d;
    }

    public List<StructurePiece> i() {
        return this.e.c();
    }
}

