/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    DAMAGE_DEALT(StatisticList.I),
    DAMAGE_TAKEN(StatisticList.L),
    DEATHS(StatisticList.P),
    MOB_KILLS(StatisticList.Q),
    PLAYER_KILLS(StatisticList.S),
    FISH_CAUGHT(StatisticList.T),
    ANIMALS_BRED(StatisticList.R),
    LEAVE_GAME(StatisticList.j),
    JUMP(StatisticList.G),
    DROP_COUNT(StatisticList.H),
    DROP(MinecraftKey.b("dropped")),
    PICKUP(MinecraftKey.b("picked_up")),
    PLAY_ONE_MINUTE(StatisticList.k),
    TOTAL_WORLD_TIME(StatisticList.l),
    WALK_ONE_CM(StatisticList.p),
    WALK_ON_WATER_ONE_CM(StatisticList.s),
    FALL_ONE_CM(StatisticList.t),
    SNEAK_TIME(StatisticList.o),
    CLIMB_ONE_CM(StatisticList.u),
    FLY_ONE_CM(StatisticList.v),
    WALK_UNDER_WATER_ONE_CM(StatisticList.w),
    MINECART_ONE_CM(StatisticList.x),
    BOAT_ONE_CM(StatisticList.y),
    PIG_ONE_CM(StatisticList.z),
    HAPPY_GHAST_ONE_CM(StatisticList.A),
    HORSE_ONE_CM(StatisticList.B),
    SPRINT_ONE_CM(StatisticList.r),
    CROUCH_ONE_CM(StatisticList.q),
    AVIATE_ONE_CM(StatisticList.C),
    MINE_BLOCK(MinecraftKey.b("mined")),
    USE_ITEM(MinecraftKey.b("used")),
    BREAK_ITEM(MinecraftKey.b("broken")),
    CRAFT_ITEM(MinecraftKey.b("crafted")),
    KILL_ENTITY(MinecraftKey.b("killed")),
    ENTITY_KILLED_BY(MinecraftKey.b("killed_by")),
    TIME_SINCE_DEATH(StatisticList.m),
    TALKED_TO_VILLAGER(StatisticList.U),
    TRADED_WITH_VILLAGER(StatisticList.V),
    CAKE_SLICES_EATEN(StatisticList.W),
    CAULDRON_FILLED(StatisticList.X),
    CAULDRON_USED(StatisticList.Y),
    ARMOR_CLEANED(StatisticList.Z),
    BANNER_CLEANED(StatisticList.aa),
    BREWINGSTAND_INTERACTION(StatisticList.ac),
    BEACON_INTERACTION(StatisticList.ad),
    DROPPER_INSPECTED(StatisticList.ae),
    HOPPER_INSPECTED(StatisticList.af),
    DISPENSER_INSPECTED(StatisticList.ag),
    NOTEBLOCK_PLAYED(StatisticList.ah),
    NOTEBLOCK_TUNED(StatisticList.ai),
    FLOWER_POTTED(StatisticList.aj),
    TRAPPED_CHEST_TRIGGERED(StatisticList.ak),
    ENDERCHEST_OPENED(StatisticList.al),
    ITEM_ENCHANTED(StatisticList.am),
    RECORD_PLAYED(StatisticList.an),
    FURNACE_INTERACTION(StatisticList.ao),
    CRAFTING_TABLE_INTERACTION(StatisticList.ap),
    CHEST_OPENED(StatisticList.aq),
    SLEEP_IN_BED(StatisticList.ar),
    SHULKER_BOX_OPENED(StatisticList.as),
    TIME_SINCE_REST(StatisticList.n),
    SWIM_ONE_CM(StatisticList.D),
    DAMAGE_DEALT_ABSORBED(StatisticList.J),
    DAMAGE_DEALT_RESISTED(StatisticList.K),
    DAMAGE_BLOCKED_BY_SHIELD(StatisticList.M),
    DAMAGE_ABSORBED(StatisticList.N),
    DAMAGE_RESISTED(StatisticList.O),
    CLEAN_SHULKER_BOX(StatisticList.ab),
    OPEN_BARREL(StatisticList.at),
    INTERACT_WITH_BLAST_FURNACE(StatisticList.au),
    INTERACT_WITH_SMOKER(StatisticList.av),
    INTERACT_WITH_LECTERN(StatisticList.aw),
    INTERACT_WITH_CAMPFIRE(StatisticList.ax),
    INTERACT_WITH_CARTOGRAPHY_TABLE(StatisticList.ay),
    INTERACT_WITH_LOOM(StatisticList.az),
    INTERACT_WITH_STONECUTTER(StatisticList.aA),
    BELL_RING(StatisticList.aB),
    RAID_TRIGGER(StatisticList.aC),
    RAID_WIN(StatisticList.aD),
    INTERACT_WITH_ANVIL(StatisticList.aE),
    INTERACT_WITH_GRINDSTONE(StatisticList.aF),
    TARGET_HIT(StatisticList.aG),
    INTERACT_WITH_SMITHING_TABLE(StatisticList.aH),
    STRIDER_ONE_CM(StatisticList.E),
    NAUTILUS_ONE_CM(StatisticList.F);

    private final MinecraftKey minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<MinecraftKey, Statistic> statistics;

    private CraftStatistic(MinecraftKey minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        IRegistry<?> statRegistry = statistic.a().b();
        MinecraftKey nmsKey = BuiltInRegistries.w.b(statistic.a());
        if (statRegistry == BuiltInRegistries.l) {
            nmsKey = (MinecraftKey)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static net.minecraft.stats.Statistic getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        net.minecraft.stats.Statistic<MinecraftKey> nms = StatisticList.i.b((MinecraftKey)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static net.minecraft.stats.Statistic getMaterialStatistic(Statistic stat, Material material) {
        Statistic.Type type = stat.getType();
        switch (type) {
            case BLOCK: {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"statistic type is BLOCK but got non-block Material, %s", (Object)material);
                if (stat != Statistic.MINE_BLOCK) break;
                return StatisticList.a.b(CraftBlockType.bukkitToMinecraft(material));
            }
            case ITEM: {
                Preconditions.checkArgument((boolean)material.isItem(), (String)"statistic type is ITEM but got non-item Material, %s", (Object)material);
                if (stat == Statistic.CRAFT_ITEM) {
                    return StatisticList.b.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.USE_ITEM) {
                    return StatisticList.c.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.BREAK_ITEM) {
                    return StatisticList.d.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.PICKUP) {
                    return StatisticList.e.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat != Statistic.DROP) break;
                return StatisticList.f.b(CraftItemType.bukkitToMinecraft(material));
            }
            default: {
                throw new IllegalArgumentException("statistic type must be either BLOCK or ITEM, given " + String.valueOf(type));
            }
        }
        throw new IllegalArgumentException("Unknwon material statistic " + String.valueOf(stat));
    }

    public static net.minecraft.stats.Statistic getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            EntityTypes<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return StatisticList.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return StatisticList.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(net.minecraft.stats.Statistic<EntityTypes<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof Item) {
            Item statisticItemValue = (Item)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof Block) {
            Block statisticBlockValue = (Block)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

