/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.ban;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.NameAndId;
import org.bukkit.BanEntry;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.craftbukkit.v1_21_R7.ban.CraftProfileBanEntry;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerProfile;
import org.bukkit.profile.PlayerProfile;

public class CraftProfileBanList
implements ProfileBanList {
    private final GameProfileBanList list;

    public CraftProfileBanList(GameProfileBanList list) {
        this.list = list;
    }

    public BanEntry<PlayerProfile> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(((CraftPlayerProfile)target).buildNameAndId());
    }

    public BanEntry<PlayerProfile> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        return this.addBan(CraftProfileBanList.getProfileByName(target), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getUniqueId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(((CraftPlayerProfile)target).buildNameAndId(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (GameProfileBanEntry entry : this.list.e()) {
            NameAndId profile = (NameAndId)entry.h();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public Set<BanEntry<PlayerProfile>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (GameProfileBanEntry entry : this.list.e()) {
            NameAndId profile = (NameAndId)entry.h();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(((CraftPlayerProfile)target).buildNameAndId());
    }

    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(CraftProfileBanList.getProfile(target));
    }

    public void pardon(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(((CraftPlayerProfile)target).buildNameAndId());
    }

    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(NameAndId profile) {
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = (GameProfileBanEntry)this.list.c(profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    public BanEntry<PlayerProfile> addBan(NameAndId profile, String reason, Date expires, String source) {
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = new GameProfileBanEntry(profile, new Date(), source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.list.a(entry);
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    private void pardon(NameAndId profile) {
        this.list.c(profile);
    }

    private boolean isBanned(NameAndId profile) {
        return profile != null && this.list.a(profile);
    }

    static NameAndId getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid != null ? CraftProfileBanList.getProfileByUUID(uuid) : CraftProfileBanList.getProfileByName(target);
    }

    static NameAndId getProfileByUUID(UUID uuid) {
        return MinecraftServer.getServer() != null ? (NameAndId)MinecraftServer.getServer().ar().f().a(uuid).orElse(null) : null;
    }

    static NameAndId getProfileByName(String name) {
        return MinecraftServer.getServer() != null ? (NameAndId)MinecraftServer.getServer().ar().f().a(name).orElse(null) : null;
    }
}

