/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.enchantments;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment
implements Handleable<Enchantment> {
    private final NamespacedKey key;
    private final Holder<Enchantment> handle;

    public static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.minecraftToBukkit(minecraft, Registries.bf, Registry.ENCHANTMENT);
    }

    public static org.bukkit.enchantments.Enchantment minecraftHolderToBukkit(Holder<Enchantment> minecraft) {
        return CraftEnchantment.minecraftToBukkit(minecraft.a());
    }

    public static Enchantment bukkitToMinecraft(org.bukkit.enchantments.Enchantment bukkit) {
        return (Enchantment)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<Enchantment> bukkitToMinecraftHolder(org.bukkit.enchantments.Enchantment bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.bf);
    }

    public static String bukkitToString(org.bukkit.enchantments.Enchantment bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static org.bukkit.enchantments.Enchantment stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEnchantmentName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.get(Registry.ENCHANTMENT, key, ApiVersion.CURRENT);
    }

    public CraftEnchantment(NamespacedKey key, Enchantment handle) {
        this.key = key;
        this.handle = CraftRegistry.getMinecraftRegistry(Registries.bf).e(handle);
    }

    @Override
    public Enchantment getHandle() {
        return this.handle.a();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public int getMaxLevel() {
        return this.getHandle().e();
    }

    public int getStartLevel() {
        return this.getHandle().d();
    }

    public EnchantmentTarget getItemTarget() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public boolean isTreasure() {
        return !this.handle.a(EnchantmentTags.k);
    }

    public boolean isCursed() {
        return this.handle.a(EnchantmentTags.o);
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.getHandle().c(CraftItemStack.asNMSCopy(item));
    }

    public String getName() {
        String keyName;
        if (!this.getKey().getNamespace().equals("minecraft")) {
            return this.getKey().toString();
        }
        return switch (keyName = this.getKey().getKey().toUpperCase(Locale.ROOT)) {
            case "PROTECTION" -> "PROTECTION_ENVIRONMENTAL";
            case "FIRE_PROTECTION" -> "PROTECTION_FIRE";
            case "FEATHER_FALLING" -> "PROTECTION_FALL";
            case "BLAST_PROTECTION" -> "PROTECTION_EXPLOSIONS";
            case "PROJECTILE_PROTECTION" -> "PROTECTION_PROJECTILE";
            case "RESPIRATION" -> "OXYGEN";
            case "AQUA_AFFINITY" -> "WATER_WORKER";
            case "SHARPNESS" -> "DAMAGE_ALL";
            case "SMITE" -> "DAMAGE_UNDEAD";
            case "BANE_OF_ARTHROPODS" -> "DAMAGE_ARTHROPODS";
            case "LOOTING" -> "LOOT_BONUS_MOBS";
            case "EFFICIENCY" -> "DIG_SPEED";
            case "UNBREAKING" -> "DURABILITY";
            case "FORTUNE" -> "LOOT_BONUS_BLOCKS";
            case "POWER" -> "ARROW_DAMAGE";
            case "PUNCH" -> "ARROW_KNOCKBACK";
            case "FLAME" -> "ARROW_FIRE";
            case "INFINITY" -> "ARROW_INFINITE";
            case "LUCK_OF_THE_SEA" -> "LUCK";
            default -> keyName;
        };
    }

    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !Enchantment.a(this.handle, ench.handle);
    }

    public String getTranslationKey() {
        return SystemUtils.a("enchantment", this.handle.e().get().a());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        return this.getKey().equals((Object)((org.bukkit.enchantments.Enchantment)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftEnchantment[" + String.valueOf(this.getKey()) + "]";
    }

    @NotNull
    public NamespacedKey getKeyOrThrow() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot get key of this registry item, because it is not registered. Use #isRegistered() before calling this method.");
        return this.key;
    }

    @Nullable
    public NamespacedKey getKeyOrNull() {
        return this.key;
    }

    public boolean isRegistered() {
        return this.key != null;
    }
}

