/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ay());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ay());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().aZ);
    }

    public boolean isLeashed() {
        return this.getHandle().C() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return this.getHandle().C().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        this.getHandle().r();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        this.getHandle().a_(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.aN || boatType == EntityTypes.aO) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityTypes.o || boatType == EntityTypes.p) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityTypes.c || boatType == EntityTypes.d) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityTypes.z || boatType == EntityTypes.A) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityTypes.ay || boatType == EntityTypes.az) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityTypes.bx || boatType == EntityTypes.by) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityTypes.J || boatType == EntityTypes.K) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityTypes.aF || boatType == EntityTypes.aG) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityTypes.l || boatType == EntityTypes.k) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.EnumStatus.e -> Boat.Status.IN_AIR;
            case AbstractBoat.EnumStatus.d -> Boat.Status.ON_LAND;
            case AbstractBoat.EnumStatus.b -> Boat.Status.UNDER_WATER;
            case AbstractBoat.EnumStatus.c -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.EnumStatus.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.bx || boatType == EntityTypes.by) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityTypes.o || boatType == EntityTypes.p) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityTypes.ay || boatType == EntityTypes.az) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityTypes.c || boatType == EntityTypes.d) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityTypes.J || boatType == EntityTypes.K) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

