/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.entity.Chicken;

public class CraftChicken
extends CraftAnimals
implements Chicken {
    public CraftChicken(CraftServer server, EntityChicken entity) {
        super(server, entity);
    }

    @Override
    public EntityChicken getHandle() {
        return (EntityChicken)this.entity;
    }

    @Override
    public String toString() {
        return "CraftChicken";
    }

    public Chicken.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gP());
    }

    public void setVariant(Chicken.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends CraftRegistryItem<ChickenVariant>
    implements Chicken.Variant {
        public static Chicken.Variant minecraftToBukkit(ChickenVariant minecraft) {
            return (Chicken.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.aV, Registry.CHICKEN_VARIANT);
        }

        public static Chicken.Variant minecraftHolderToBukkit(Holder<ChickenVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static ChickenVariant bukkitToMinecraft(Chicken.Variant bukkit) {
            return (ChickenVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<ChickenVariant> bukkitToMinecraftHolder(Chicken.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.aV);
        }

        public CraftVariant(NamespacedKey key, Holder<ChickenVariant> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

