/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartMobSpawner;
import net.minecraft.world.level.MobSpawnerData;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMinecart;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.SpawnerMinecart;

final class CraftMinecartMobSpawner
extends CraftMinecart
implements SpawnerMinecart {
    CraftMinecartMobSpawner(CraftServer server, EntityMinecartMobSpawner entity) {
        super(server, entity);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = this.getHandle().e().m;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = spawnData.a().a("id", EntityTypes.a);
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getHandle().e().l = WeightedList.a();
            this.getHandle().e().m = new MobSpawnerData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.getHandle().ao().G_();
        this.getHandle().e().a(CraftEntityType.bukkitToMinecraft(entityType), this.getHandle().ao(), rand, this.getHandle().dK());
    }

    public EntitySnapshot getSpawnedEntity() {
        MobSpawnerData spawnData = this.getHandle().e().m;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().e(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().e(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().e(), snapshot, weight, spawnRule, null);
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().e(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(this.getHandle().e(), entries);
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(this.getHandle().e());
    }

    public int getDelay() {
        return this.getHandle().e().k;
    }

    public void setDelay(int delay) {
        this.getHandle().e().k = delay;
    }

    public int getMinSpawnDelay() {
        return this.getHandle().e().p;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        this.getHandle().e().p = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return this.getHandle().e().q;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        this.getHandle().e().q = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return this.getHandle().e().t;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.getHandle().e().t = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return this.getHandle().e().r;
    }

    public void setSpawnCount(int count) {
        this.getHandle().e().r = count;
    }

    public int getRequiredPlayerRange() {
        return this.getHandle().e().u;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.getHandle().e().u = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return this.getHandle().e().v;
    }

    public void setSpawnRange(int spawnRange) {
        this.getHandle().e().v = spawnRange;
    }

    @Override
    public EntityMinecartMobSpawner getHandle() {
        return (EntityMinecartMobSpawner)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMinecartMobSpawner";
    }
}

