/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityShulker;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftGolem;
import org.bukkit.entity.Shulker;

public class CraftShulker
extends CraftGolem
implements Shulker,
CraftEnemy {
    public CraftShulker(CraftServer server, EntityShulker entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftShulker";
    }

    @Override
    public EntityShulker getHandle() {
        return (EntityShulker)this.entity;
    }

    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)this.getHandle().aD().a(EntityShulker.c));
    }

    public void setColor(DyeColor color) {
        this.getHandle().aD().a(EntityShulker.c, color == null ? (byte)16 : (byte)color.getWoolData());
    }

    public float getPeek() {
        return (float)this.getHandle().gX() / 100.0f;
    }

    public void setPeek(float value) {
        Preconditions.checkArgument((value >= 0.0f && value <= 1.0f ? 1 : 0) != 0, (Object)"value needs to be in between or equal to 0 and 1");
        this.getHandle().a((int)(value * 100.0f));
    }

    public BlockFace getAttachedFace() {
        return CraftBlock.notchToBlockFace(this.getHandle().gP());
    }

    public void setAttachedFace(BlockFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"face cannot be null");
        Preconditions.checkArgument((boolean)face.isCartesian(), (String)"%s is not a valid block face to attach a shulker to, a cartesian block face is expected", (Object)face);
        this.getHandle().a(CraftBlock.blockFaceToNotch(face));
    }
}

