/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.entity.Strider;

public class CraftStrider
extends CraftAnimals
implements Strider {
    public CraftStrider(CraftServer server, EntityStrider entity) {
        super(server, entity);
    }

    public boolean isShivering() {
        return this.getHandle().p();
    }

    public void setShivering(boolean shivering) {
        this.getHandle().x(shivering);
    }

    public boolean hasSaddle() {
        return this.getHandle().al();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().a(EnumItemSlot.h, saddled ? new ItemStack(Items.oR) : ItemStack.l);
    }

    public int getBoostTicks() {
        return this.getHandle().cC.e ? this.getHandle().cC.d() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().cC.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().cC.e ? this.getHandle().cC.f : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().cC.e) {
            return;
        }
        int max = this.getHandle().cC.d();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().cC.f = ticks;
    }

    public Material getSteerMaterial() {
        return Material.WARPED_FUNGUS_ON_A_STICK;
    }

    @Override
    public EntityStrider getHandle() {
        return (EntityStrider)this.entity;
    }

    @Override
    public String toString() {
        return "CraftStrider";
    }
}

