/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.component.KineticWeapon;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.KineticWeaponComponent;

@SerializableAs(value="KineticWeapon")
public final class CraftKineticWeaponComponent
implements KineticWeaponComponent {
    private KineticWeapon handle;

    public CraftKineticWeaponComponent(KineticWeapon handle) {
        this.handle = handle;
    }

    public CraftKineticWeaponComponent(CraftKineticWeaponComponent craft) {
        this.handle = craft.handle;
    }

    public CraftKineticWeaponComponent(Map<String, Object> map) {
        Integer contactCooldownTicks = SerializableMeta.getObject(Integer.class, map, "contact-cooldown-ticks", true);
        Integer delayTicks = SerializableMeta.getObject(Integer.class, map, "delay-ticks", true);
        KineticWeaponComponent.Condition dismountConditions = SerializableMeta.getObject(KineticWeaponComponent.Condition.class, map, "dismount-conditions", true);
        KineticWeaponComponent.Condition knockbackConditions = SerializableMeta.getObject(KineticWeaponComponent.Condition.class, map, "knockback-conditions", true);
        KineticWeaponComponent.Condition damageConditions = SerializableMeta.getObject(KineticWeaponComponent.Condition.class, map, "damage-conditions", true);
        Float forwardMovement = SerializableMeta.getObject(Float.class, map, "forward-movement", true);
        Float damageMultiplier = SerializableMeta.getObject(Float.class, map, "damage-multiplier", true);
        Sound sound = null;
        String snd = SerializableMeta.getString(map, "sound", true);
        if (snd != null) {
            sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)snd));
        }
        Sound hitSound = null;
        String hitSnd = SerializableMeta.getString(map, "hit-sound", true);
        if (hitSnd != null) {
            hitSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)hitSnd));
        }
        this.handle = new KineticWeapon(contactCooldownTicks != null ? contactCooldownTicks : 10, delayTicks != null ? delayTicks : 0, Optional.ofNullable(dismountConditions).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), Optional.ofNullable(knockbackConditions).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), Optional.ofNullable(damageConditions).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), forwardMovement != null ? forwardMovement.floatValue() : 0.0f, damageMultiplier != null ? damageMultiplier.floatValue() : 1.0f, Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder), Optional.ofNullable(hitSound).map(CraftSound::bukkitToMinecraftHolder));
    }

    public Map<String, Object> serialize() {
        Sound hitSound;
        KineticWeaponComponent.Condition damageConditions;
        KineticWeaponComponent.Condition knockbackConditions;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("contact-cooldown-ticks", this.getContactCooldownTicks());
        result.put("delay-ticks", this.getDelayTicks());
        KineticWeaponComponent.Condition dismountConditions = this.getDismountConditions();
        if (dismountConditions != null) {
            result.put("dismount-conditions", dismountConditions);
        }
        if ((knockbackConditions = this.getKnockbackConditions()) != null) {
            result.put("knockback-conditions", null);
        }
        if ((damageConditions = this.getDamageConditions()) != null) {
            result.put("damage-conditions", null);
        }
        result.put("forward-movement", Float.valueOf(this.getForwardMovement()));
        result.put("damage-multiplier", Float.valueOf(this.getDamageMultiplier()));
        Sound sound = this.getSound();
        if (sound != null) {
            result.put("sound", sound.getKey().toString());
        }
        if ((hitSound = this.getHitSound()) != null) {
            result.put("hit-sound", hitSound.getKey().toString());
        }
        return result;
    }

    public KineticWeapon getHandle() {
        return this.handle;
    }

    public int getContactCooldownTicks() {
        return this.handle.b();
    }

    public void setContactCooldownTicks(int ticks) {
        this.handle = new KineticWeapon(ticks, this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j());
    }

    public int getDelayTicks() {
        return this.handle.c();
    }

    public void setDelayTicks(int ticks) {
        this.handle = new KineticWeapon(this.handle.b(), ticks, this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j());
    }

    public KineticWeaponComponent.Condition getDismountConditions() {
        return this.handle.d().map(CraftKineticWeaponCondition::new).orElse(null);
    }

    public void setDismountConditions(KineticWeaponComponent.Condition condition) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), Optional.ofNullable(condition).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j());
    }

    public KineticWeaponComponent.Condition getKnockbackConditions() {
        return this.handle.e().map(CraftKineticWeaponCondition::new).orElse(null);
    }

    public void setKnockbackConditions(KineticWeaponComponent.Condition condition) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), Optional.ofNullable(condition).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j());
    }

    public KineticWeaponComponent.Condition getDamageConditions() {
        return this.handle.f().map(CraftKineticWeaponCondition::new).orElse(null);
    }

    public void setDamageConditions(KineticWeaponComponent.Condition condition) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), Optional.ofNullable(condition).map(CraftKineticWeaponCondition::new).map(CraftKineticWeaponCondition::getHandle), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j());
    }

    public float getForwardMovement() {
        return this.handle.g();
    }

    public void setForwardMovement(float movement) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), movement, this.handle.h(), this.handle.i(), this.handle.j());
    }

    public float getDamageMultiplier() {
        return this.handle.h();
    }

    public void setDamageMultipler(float multiplier) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), multiplier, this.handle.i(), this.handle.j());
    }

    public Sound getSound() {
        return this.handle.i().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setSound(Sound sound) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder), this.handle.j());
    }

    public Sound getHitSound() {
        return this.handle.j().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setHitSound(Sound sound) {
        this.handle = new KineticWeapon(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftKineticWeaponComponent other = (CraftKineticWeaponComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftKineticWeaponComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="KineticWeaponCondition")
    public static class CraftKineticWeaponCondition
    implements KineticWeaponComponent.Condition {
        private KineticWeapon.a handle;

        public CraftKineticWeaponCondition(KineticWeapon.a handle) {
            this.handle = handle;
        }

        public CraftKineticWeaponCondition(KineticWeaponComponent.Condition bukkit) {
            KineticWeapon.a toCopy = ((CraftKineticWeaponCondition)bukkit).handle;
            this.handle = new KineticWeapon.a(toCopy.a(), toCopy.b(), toCopy.c());
        }

        public CraftKineticWeaponCondition(Map<String, Object> map) {
            Integer maxDurationTicks = SerializableMeta.getObject(Integer.class, map, "max-duration-ticks", false);
            Integer minSpeed = SerializableMeta.getObject(Integer.class, map, "min-speed", true);
            Integer minRelativeSpeed = SerializableMeta.getObject(Integer.class, map, "min-relative-speed", true);
            this.handle = new KineticWeapon.a(maxDurationTicks, minSpeed != null ? (float)minSpeed.intValue() : 0.0f, minRelativeSpeed != null ? (float)minRelativeSpeed.intValue() : 0.0f);
        }

        public Map<String, Object> serialize() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("max-duration-ticks", this.getMaxDurationTicks());
            result.put("min-speed", Float.valueOf(this.getMinSpeed()));
            result.put("min-relative-speed", Float.valueOf(this.getMinRelativeSpeed()));
            return result;
        }

        public KineticWeapon.a getHandle() {
            return this.handle;
        }

        public int getMaxDurationTicks() {
            return this.handle.a();
        }

        public void setMaxDurationTicks(int ticks) {
            this.handle = new KineticWeapon.a(ticks, this.handle.b(), this.handle.c());
        }

        public float getMinSpeed() {
            return this.handle.b();
        }

        public void setMinSpeed(float speed) {
            this.handle = new KineticWeapon.a(this.handle.a(), speed, this.handle.c());
        }

        public float getMinRelativeSpeed() {
            return this.handle.c();
        }

        public void setMinRelativeSpeed(float speed) {
            this.handle = new KineticWeapon.a(this.handle.a(), this.handle.b(), speed);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftKineticWeaponCondition other = (CraftKineticWeaponCondition)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftKineticWeaponCondition{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

