/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R7.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftTileInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract IInventory getTileEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(this.getTileEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        IInventory te = this.getTileEntity();
        if (te instanceof TileEntityLootable) {
            ((TileEntityLootable)te).e = CraftChatMessage.fromStringOrNull(title);
        }
        return this.getInventory(te);
    }

    public Inventory getInventory(IInventory tileEntity) {
        return new CraftInventory(tileEntity);
    }

    public static class Crafter
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new CrafterBlockEntity(BlockPosition.c, Blocks.uP.m());
        }
    }

    public static class Smoker
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntitySmoker(BlockPosition.c, Blocks.oS.m());
        }
    }

    public static class Lectern
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityLectern((BlockPosition)BlockPosition.c, (IBlockData)Blocks.oX.m()).e;
        }
    }

    public static class BlastFurnace
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBlastFurnace(BlockPosition.c, Blocks.oT.m());
        }
    }

    public static class Hopper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityHopper(BlockPosition.c, Blocks.hT.m());
        }
    }

    public static class Dropper
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDropper(BlockPosition.c, Blocks.hZ.m());
        }
    }

    public static class Dispenser
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityDispenser(BlockPosition.c, Blocks.bb.m());
        }
    }

    public static class BrewingStand
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            return new TileEntityBrewingStand(BlockPosition.c, Blocks.gh.m());
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            if (tileEntity instanceof TileEntityBrewingStand) {
                ((TileEntityBrewingStand)tileEntity).e = (int)CraftChatMessage.fromStringOrNull(title);
            }
            return this.getInventory(tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return new CraftInventoryBrewer(tileEntity);
        }
    }

    public static class Furnace
    extends CraftTileInventoryConverter {
        @Override
        public IInventory getTileEntity() {
            TileEntityFurnaceFurnace furnace = new TileEntityFurnaceFurnace(BlockPosition.c, Blocks.da.m());
            return furnace;
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            IInventory tileEntity = this.getTileEntity();
            ((TileEntityFurnace)tileEntity).e = (int)CraftChatMessage.fromStringOrNull(title);
            return this.getInventory(tileEntity);
        }

        @Override
        public Inventory getInventory(IInventory tileEntity) {
            return new CraftInventoryFurnace((TileEntityFurnace)tileEntity);
        }
    }
}

