/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.projectiles;

import com.google.common.base.Preconditions;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final TileEntityDispenser dispenserBlock;

    public CraftBlockProjectileSource(TileEntityDispenser dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return this.dispenserBlock.j().getWorld().getBlockAt(this.dispenserBlock.aD_().u(), this.dispenserBlock.aD_().v(), this.dispenserBlock.aD_().w());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        SourceBlock sourceblock = new SourceBlock((WorldServer)this.dispenserBlock.j(), this.dispenserBlock.aD_(), this.dispenserBlock.o(), this.dispenserBlock);
        EnumDirection enumdirection = sourceblock.d().c(BlockDispenser.b);
        World world = this.dispenserBlock.j();
        Item item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = Items.so;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = Items.sD;
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            item = Items.uj;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = Items.wh;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? Items.xG : Items.xD;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            item = TippedArrow.class.isAssignableFrom(projectile) ? Items.xF : (SpectralArrow.class.isAssignableFrom(projectile) ? Items.xE : Items.pX);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            item = AbstractWindCharge.class.isAssignableFrom(projectile) ? Items.wj : Items.wi;
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = Items.wG;
        }
        Preconditions.checkArgument((boolean)(item instanceof ProjectileItem), (Object)"Projectile not supported");
        ItemStack itemstack = new ItemStack(item);
        ProjectileItem projectileItem = (ProjectileItem)((Object)item);
        ProjectileItem.a dispenseConfig = projectileItem.a();
        IPosition iposition = dispenseConfig.b().getDispensePosition(sourceblock, enumdirection);
        IProjectile launch = projectileItem.a(world, iposition, itemstack, enumdirection);
        if (Fireball.class.isAssignableFrom(projectile)) {
            EntityFireball customFireball = null;
            if (WitherSkull.class.isAssignableFrom(projectile)) {
                customFireball = EntityTypes.bT.a(world, EntitySpawnReason.k);
                launch = customFireball;
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = EntityTypes.N.a(world, EntitySpawnReason.k);
            } else if (BreezeWindCharge.class.isAssignableFrom(projectile)) {
                customFireball = EntityTypes.u.a(world, EntitySpawnReason.k);
                launch = customFireball;
            } else if (LargeFireball.class.isAssignableFrom(projectile)) {
                customFireball = EntityTypes.ac.a(world, EntitySpawnReason.k);
                launch = customFireball;
            }
            if (customFireball != null) {
                customFireball.a_(iposition.a(), iposition.b(), iposition.c());
                RandomSource randomsource = world.G_();
                double d0 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d1 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d2 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                Vec3D vec3d = new Vec3D(d0, d1, d2);
                customFireball.a(vec3d, 0.1);
            }
        }
        if (launch instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)launch;
            arrow.c = EntityArrow.PickupStatus.b;
        }
        launch.projectileSource = this;
        projectileItem.a(launch, enumdirection.j(), enumdirection.k(), enumdirection.l(), dispenseConfig.d(), dispenseConfig.c());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

