/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import org.slf4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class SystemReport {
    public static final long a = 0x100000L;
    private static final long b = 1000000000L;
    private static final Logger c = LogUtils.getLogger();
    private static final String d = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String e = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String f = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> g = Maps.newLinkedHashMap();

    public SystemReport() {
        this.a("Minecraft Version", SharedConstants.b().c());
        this.a("Minecraft Version ID", SharedConstants.b().b());
        this.a("Operating System", d);
        this.a("Java Version", e);
        this.a("Java VM Version", f);
        this.a("Memory", () -> {
            Runtime var0 = Runtime.getRuntime();
            long var1 = var0.maxMemory();
            long var3 = var0.totalMemory();
            long var5 = var0.freeMemory();
            long var7 = var1 / 0x100000L;
            long var9 = var3 / 0x100000L;
            long var11 = var5 / 0x100000L;
            return var5 + " bytes (" + var11 + " MiB) / " + var3 + " bytes (" + var9 + " MiB) up to " + var1 + " bytes (" + var7 + " MiB)";
        });
        this.a("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.a("hardware", () -> this.a(new SystemInfo()));
        this.a("JVM Flags", () -> {
            List var0 = SystemUtils.o().collect(Collectors.toList());
            return String.format(Locale.ROOT, "%d total; %s", var0.size(), String.join((CharSequence)" ", var0));
        });
    }

    public void a(String var0, String var1) {
        this.g.put(var0, var1);
    }

    public void a(String var0, Supplier<String> var1) {
        try {
            this.a(var0, var1.get());
        }
        catch (Exception var2) {
            c.warn("Failed to get system info for {}", (Object)var0, (Object)var2);
            this.a(var0, "ERR");
        }
    }

    private void a(SystemInfo var0) {
        HardwareAbstractionLayer var1 = var0.getHardware();
        this.a("processor", () -> this.a(var1.getProcessor()));
        this.a("graphics", () -> this.b(var1.getGraphicsCards()));
        this.a("memory", () -> this.a(var1.getMemory()));
        this.a("storage", this::b);
    }

    private void a(String var0, Runnable var1) {
        try {
            var1.run();
        }
        catch (Throwable var2) {
            c.warn("Failed retrieving info for group {}", (Object)var0, (Object)var2);
        }
    }

    public static float a(long var0) {
        return (float)var0 / 1048576.0f;
    }

    private void a(List<PhysicalMemory> var0) {
        int var1 = 0;
        for (PhysicalMemory var3 : var0) {
            String var4 = String.format(Locale.ROOT, "Memory slot #%d ", var1++);
            this.a(var4 + "capacity (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var3.getCapacity()))));
            this.a(var4 + "clockSpeed (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var3.getClockSpeed() / 1.0E9f)));
            this.a(var4 + "type", () -> ((PhysicalMemory)var3).getMemoryType());
        }
    }

    private void a(VirtualMemory var0) {
        this.a("Virtual memory max (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var0.getVirtualMax()))));
        this.a("Virtual memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var0.getVirtualInUse()))));
        this.a("Swap memory total (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var0.getSwapTotal()))));
        this.a("Swap memory used (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var0.getSwapUsed()))));
    }

    private void a(GlobalMemory var0) {
        this.a("physical memory", () -> this.a(var0.getPhysicalMemory()));
        this.a("virtual memory", () -> this.a(var0.getVirtualMemory()));
    }

    private void b(List<GraphicsCard> var0) {
        int var1 = 0;
        for (GraphicsCard var3 : var0) {
            String var4 = String.format(Locale.ROOT, "Graphics card #%d ", var1++);
            this.a(var4 + "name", () -> ((GraphicsCard)var3).getName());
            this.a(var4 + "vendor", () -> ((GraphicsCard)var3).getVendor());
            this.a(var4 + "VRAM (MiB)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf(SystemReport.a(var3.getVRam()))));
            this.a(var4 + "deviceId", () -> ((GraphicsCard)var3).getDeviceId());
            this.a(var4 + "versionInfo", () -> ((GraphicsCard)var3).getVersionInfo());
        }
    }

    private void a(CentralProcessor var0) {
        CentralProcessor.ProcessorIdentifier var1 = var0.getProcessorIdentifier();
        this.a("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)var1).getVendor());
        this.a("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)var1).getName());
        this.a("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)var1).getIdentifier());
        this.a("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)var1).getMicroarchitecture());
        this.a("Frequency (GHz)", () -> String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var1.getVendorFreq() / 1.0E9f)));
        this.a("Number of physical packages", () -> String.valueOf(var0.getPhysicalPackageCount()));
        this.a("Number of physical CPUs", () -> String.valueOf(var0.getPhysicalProcessorCount()));
        this.a("Number of logical CPUs", () -> String.valueOf(var0.getLogicalProcessorCount()));
    }

    private void b() {
        this.a("jna.tmpdir");
        this.a("org.lwjgl.system.SharedLibraryExtractPath");
        this.a("io.netty.native.workdir");
        this.a("java.io.tmpdir");
        this.b("workdir", () -> "");
    }

    private void a(String var0) {
        this.b(var0, () -> System.getProperty(var0));
    }

    private void b(String var0, Supplier<String> var1) {
        String var2 = "Space in storage for " + var0 + " (MiB)";
        try {
            String var3 = var1.get();
            if (var3 == null) {
                this.a(var2, "<path not set>");
                return;
            }
            FileStore var4 = Files.getFileStore(Path.of(var3, new String[0]));
            this.a(var2, String.format(Locale.ROOT, "available: %.2f, total: %.2f", Float.valueOf(SystemReport.a(var4.getUsableSpace())), Float.valueOf(SystemReport.a(var4.getTotalSpace()))));
        }
        catch (InvalidPathException var3) {
            c.warn("{} is not a path", (Object)var0, (Object)var3);
            this.a(var2, "<invalid path>");
        }
        catch (Exception var3) {
            c.warn("Failed retrieving storage space for {}", (Object)var0, (Object)var3);
            this.a(var2, "ERR");
        }
    }

    public void a(StringBuilder var0) {
        var0.append("-- ").append("System Details").append(" --\n");
        var0.append("Details:");
        this.g.forEach((var1, var2) -> {
            var0.append("\n\t");
            var0.append((String)var1);
            var0.append(": ");
            var0.append((String)var2);
        });
    }

    public String a() {
        return this.g.entrySet().stream().map(var0 -> (String)var0.getKey() + ": " + (String)var0.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

