/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float h = 0.75f;
    private static final Logger i = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (? super T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (? super T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (? super T marker) -> marker.add(b));
    public static final Supplier<NioEventLoopGroup> e = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final Supplier<EpollEventLoopGroup> f = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final Supplier<DefaultEventLoopGroup> g = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private static final ProtocolInfo<PacketHandshakingInListener> j = HandshakeProtocols.b;
    private final EnumProtocolDirection k;
    private volatile boolean l = true;
    private final Queue<Consumer<NetworkManager>> m = Queues.newConcurrentLinkedQueue();
    public Channel n;
    public SocketAddress o;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener p;
    @Nullable
    private volatile PacketListener q;
    @Nullable
    private DisconnectionDetails r;
    private boolean s;
    private boolean t;
    private int u;
    private int v;
    private float w;
    private float x;
    private int y;
    private boolean z;
    @Nullable
    private volatile DisconnectionDetails A;
    @Nullable
    BandwidthDebugMonitor B;
    public String hostname = "";

    public NetworkManager(EnumProtocolDirection enumprotocoldirection) {
        this.k = enumprotocoldirection;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.n = channelhandlercontext.channel();
        this.o = this.n.remoteAddress();
        this.preparing = false;
        if (this.A != null) {
            this.a(this.A);
        }
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(IChatBaseComponent.c("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof SkipEncodeException) {
            i.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.z;
            this.z = true;
            if (this.n.isOpen()) {
                if (throwable instanceof TimeoutException) {
                    i.debug("Timeout", throwable);
                    this.a(IChatBaseComponent.c("disconnect.timeout"));
                } else {
                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + String.valueOf(throwable)});
                    PacketListener packetlistener = this.q;
                    DisconnectionDetails disconnectiondetails = packetlistener != null ? packetlistener.a(ichatbasecomponent, throwable) : new DisconnectionDetails(ichatbasecomponent);
                    if (flag) {
                        i.debug("Failed to sent packet", throwable);
                        if (this.g() == EnumProtocolDirection.b) {
                            Packet<PacketLoginOutListener> packet = this.l ? new PacketLoginOutDisconnect(ichatbasecomponent) : new ClientboundDisconnectPacket(ichatbasecomponent);
                            this.a(packet, PacketSendListener.a(() -> this.a(disconnectiondetails)));
                        } else {
                            this.a(disconnectiondetails);
                        }
                        this.m();
                    } else {
                        i.debug("Double fault", throwable);
                        this.a(disconnectiondetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.n.isOpen()) {
            PacketListener packetlistener = this.q;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (packetlistener.a(packet)) {
                try {
                    NetworkManager.a(packet, packetlistener);
                }
                catch (CancelledPacketHandleException cancelledPacketHandleException) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    i.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_packet"));
                }
                ++this.u;
            }
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener packetlistener) {
        packet.a(packetlistener);
    }

    private void b(ProtocolInfo<?> protocolinfo, PacketListener packetlistener) {
        Validate.notNull((Object)packetlistener, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection enumprotocoldirection = packetlistener.N_();
        if (enumprotocoldirection != this.k) {
            String s2 = String.valueOf((Object)this.k);
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + s2 + ", but listener is " + String.valueOf((Object)enumprotocoldirection));
        }
        EnumProtocol enumprotocol = packetlistener.b();
        if (protocolinfo.a() != enumprotocol) {
            String s1 = String.valueOf((Object)enumprotocol);
            throw new IllegalStateException("Listener protocol (" + s1 + ") does not match requested one " + String.valueOf(protocolinfo));
        }
    }

    private static void a(ChannelFuture channelfuture) {
        try {
            channelfuture.syncUninterruptibly();
        }
        catch (Exception exception) {
            if (exception instanceof ClosedChannelException) {
                i.info("Connection closed during protocol change");
            }
            throw exception;
        }
    }

    public <T extends PacketListener> void a(ProtocolInfo<T> protocolinfo, T t0) {
        this.b(protocolinfo, t0);
        if (protocolinfo.b() != this.f()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolinfo.a()));
        }
        this.q = t0;
        this.p = null;
        UnconfiguredPipelineHandler.b unconfiguredpipelinehandler_b = UnconfiguredPipelineHandler.a(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.d();
        if (bundlerinfo != null) {
            PacketBundlePacker packetbundlepacker = new PacketBundlePacker(bundlerinfo);
            unconfiguredpipelinehandler_b = unconfiguredpipelinehandler_b.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetbundlepacker));
        }
        NetworkManager.a(this.n.writeAndFlush((Object)unconfiguredpipelinehandler_b));
    }

    public void a(ProtocolInfo<?> protocolinfo) {
        if (protocolinfo.b() != this.g()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolinfo.a()));
        }
        UnconfiguredPipelineHandler.d unconfiguredpipelinehandler_d = UnconfiguredPipelineHandler.b(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.d();
        if (bundlerinfo != null) {
            PacketBundleUnpacker packetbundleunpacker = new PacketBundleUnpacker(bundlerinfo);
            unconfiguredpipelinehandler_d = unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetbundleunpacker));
        }
        boolean flag = protocolinfo.a() == EnumProtocol.d;
        NetworkManager.a(this.n.writeAndFlush((Object)unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> {
            this.l = flag;
        })));
    }

    public void a(PacketListener packetlistener) {
        if (this.q != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.k != EnumProtocolDirection.a || packetlistener.N_() != EnumProtocolDirection.a || packetlistener.b() != j.a()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.q = packetlistener;
    }

    public void a(String s2, int i2, PacketStatusOutListener packetstatusoutlistener) {
        this.a(s2, i2, StatusProtocols.b, StatusProtocols.d, packetstatusoutlistener, ClientIntent.a);
    }

    public void a(String s2, int i2, PacketLoginOutListener packetloginoutlistener) {
        this.a(s2, i2, LoginProtocols.b, LoginProtocols.d, packetloginoutlistener, ClientIntent.b);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, boolean flag) {
        this.a(s2, i2, protocolinfo, protocolinfo1, c0, flag ? ClientIntent.c : ClientIntent.b);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, ClientIntent clientintent) {
        if (protocolinfo.a() != protocolinfo1.a()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.p = c0;
        this.a((NetworkManager networkmanager) -> {
            this.a(protocolinfo1, c0);
            networkmanager.b(new PacketHandshakingInSetProtocol(SharedConstants.b().e(), s2, i2, clientintent), null, true);
            this.a(protocolinfo);
        });
    }

    public void a(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
        this.a(packet, packetsendlistener, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        if (this.i()) {
            this.r();
            this.b(packet, packetsendlistener, flag);
        } else {
            this.m.add(networkmanager -> networkmanager.b(packet, packetsendlistener, flag));
        }
    }

    public void a(Consumer<NetworkManager> consumer) {
        if (this.i()) {
            this.r();
            consumer.accept(this);
        } else {
            this.m.add(consumer);
        }
    }

    private void b(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        ++this.v;
        if (this.n.eventLoop().inEventLoop()) {
            this.c(packet, packetsendlistener, flag);
        } else {
            this.n.eventLoop().execute(() -> this.c(packet, packetsendlistener, flag));
        }
    }

    private void c(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        ChannelFuture channelfuture;
        ChannelFuture channelFuture = channelfuture = flag ? this.n.writeAndFlush(packet) : this.n.write(packet);
        if (packetsendlistener != null) {
            channelfuture.addListener(future -> {
                if (future.isSuccess()) {
                    packetsendlistener.a();
                } else {
                    Packet<?> packet1 = packetsendlistener.b();
                    if (packet1 != null) {
                        ChannelFuture channelfuture1 = this.n.writeAndFlush(packet1);
                        channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                    }
                }
            });
        }
        channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void a() {
        if (this.i()) {
            this.q();
        } else {
            this.m.add(NetworkManager::q);
        }
    }

    private void q() {
        if (this.n.eventLoop().inEventLoop()) {
            this.n.flush();
        } else {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void r() {
        if (this.n != null && this.n.isOpen()) {
            Queue<Consumer<NetworkManager>> queue = this.m;
            synchronized (queue) {
                Consumer<NetworkManager> consumer;
                while ((consumer = this.m.poll()) != null) {
                    consumer.accept(this);
                }
            }
        }
    }

    public void b() {
        this.r();
        PacketListener packetlistener = this.q;
        if (packetlistener instanceof TickablePacketListener) {
            TickablePacketListener tickablepacketlistener = (TickablePacketListener)packetlistener;
            tickablepacketlistener.d();
        }
        if (!this.i() && !this.t) {
            this.n();
        }
        if (this.n != null) {
            this.n.flush();
        }
        if (this.y++ % 20 == 0) {
            this.c();
        }
        if (this.B != null) {
            this.B.a();
        }
    }

    protected void c() {
        this.x = MathHelper.h(0.75f, this.v, this.x);
        this.w = MathHelper.h(0.75f, this.u, this.w);
        this.v = 0;
        this.u = 0;
    }

    public SocketAddress d() {
        return this.o;
    }

    public String a(boolean flag) {
        return this.o == null ? "local" : (flag ? this.o.toString() : "IP hidden");
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.a(new DisconnectionDetails(ichatbasecomponent));
    }

    public void a(DisconnectionDetails disconnectiondetails) {
        this.preparing = false;
        if (this.n == null) {
            this.A = disconnectiondetails;
        }
        if (this.i()) {
            this.n.close();
            this.r = disconnectiondetails;
        }
    }

    public boolean e() {
        return this.n instanceof LocalChannel || this.n instanceof LocalServerChannel;
    }

    public EnumProtocolDirection f() {
        return this.k;
    }

    public EnumProtocolDirection g() {
        return this.k.a();
    }

    public static NetworkManager a(InetSocketAddress inetsocketaddress, boolean flag, @Nullable LocalSampleLogger localsamplelogger) {
        NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (localsamplelogger != null) {
            networkmanager.a(localsamplelogger);
        }
        ChannelFuture channelfuture = NetworkManager.a(inetsocketaddress, flag, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture a(InetSocketAddress inetsocketaddress, boolean flag, final NetworkManager networkmanager) {
        EventLoopGroup eventloopgroup;
        Class<NioSocketChannel> oclass;
        if (Epoll.isAvailable() && flag) {
            oclass = EpollSocketChannel.class;
            eventloopgroup = (EventLoopGroup)f.get();
        } else {
            oclass = NioSocketChannel.class;
            eventloopgroup = (EventLoopGroup)e.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b, false, networkmanager.B);
                networkmanager.a(channelpipeline);
            }
        })).channel(oclass)).connect(inetsocketaddress.getAddress(), inetsocketaddress.getPort());
    }

    private static String b(boolean flag) {
        return flag ? "encoder" : "outbound_config";
    }

    private static String c(boolean flag) {
        return flag ? "decoder" : "inbound_config";
    }

    public void a(ChannelPipeline channelpipeline) {
        channelpipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelhandlercontext, Object object, ChannelPromise channelpromise) throws Exception {
                super.write(channelhandlercontext, object, channelpromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void a(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection, boolean flag, @Nullable BandwidthDebugMonitor bandwidthdebugmonitor) {
        EnumProtocolDirection enumprotocoldirection1 = enumprotocoldirection.a();
        boolean flag1 = enumprotocoldirection == EnumProtocolDirection.a;
        boolean flag2 = enumprotocoldirection1 == EnumProtocolDirection.a;
        channelpipeline.addLast("splitter", (ChannelHandler)NetworkManager.a(bandwidthdebugmonitor, flag)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.c(flag1), flag1 ? new PacketDecoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.d(flag)).addLast(NetworkManager.b(flag2), flag2 ? new PacketEncoder<PacketHandshakingInListener>(j) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler d(boolean flag) {
        return flag ? new LocalFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler a(@Nullable BandwidthDebugMonitor bandwidthdebugmonitor, boolean flag) {
        return !flag ? new PacketSplitter(bandwidthdebugmonitor) : (bandwidthdebugmonitor != null ? new MonitoredLocalFrameDecoder(bandwidthdebugmonitor) : new LocalFrameDecoder());
    }

    public static void a(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection) {
        NetworkManager.a(channelpipeline, enumprotocoldirection, true, null);
    }

    public static NetworkManager a(SocketAddress socketaddress) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)g.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelpipeline = channel.pipeline();
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b);
                networkmanager.a(channelpipeline);
            }
        })).channel(LocalChannel.class)).connect(socketaddress).syncUninterruptibly();
        return networkmanager;
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.s = true;
        this.n.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(cipher));
        this.n.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(cipher1));
    }

    public boolean h() {
        return this.s;
    }

    public boolean i() {
        return this.n != null && this.n.isOpen();
    }

    public boolean j() {
        return this.n == null;
    }

    @Nullable
    public PacketListener k() {
        return this.q;
    }

    @Nullable
    public DisconnectionDetails l() {
        return this.r;
    }

    public void m() {
        if (this.n != null) {
            this.n.config().setAutoRead(false);
        }
    }

    public void a(int i2, boolean flag) {
        if (i2 >= 0) {
            ChannelHandler channelhandler = this.n.pipeline().get("decompress");
            if (channelhandler instanceof PacketDecompressor) {
                PacketDecompressor packetdecompressor = (PacketDecompressor)channelhandler;
                packetdecompressor.a(i2, flag);
            } else {
                this.n.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(i2, flag));
            }
            channelhandler = this.n.pipeline().get("compress");
            if (channelhandler instanceof PacketCompressor) {
                PacketCompressor packetcompressor = (PacketCompressor)channelhandler;
                packetcompressor.a(i2);
            } else {
                this.n.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(i2));
            }
        } else {
            if (this.n.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.n.pipeline().remove("decompress");
            }
            if (this.n.pipeline().get("compress") instanceof PacketCompressor) {
                this.n.pipeline().remove("compress");
            }
        }
    }

    public void n() {
        if (this.n != null && !this.n.isOpen()) {
            if (this.t) {
                i.warn("handleDisconnection() called twice");
            } else {
                PacketListener packetlistener1;
                this.t = true;
                PacketListener packetlistener = this.k();
                PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.p;
                if (packetlistener1 != null) {
                    DisconnectionDetails disconnectiondetails = Objects.requireNonNullElseGet(this.l(), () -> new DisconnectionDetails(IChatBaseComponent.c("multiplayer.disconnect.generic")));
                    packetlistener1.a(disconnectiondetails);
                }
                this.m.clear();
            }
        }
    }

    public float o() {
        return this.w;
    }

    public float p() {
        return this.x;
    }

    public void a(LocalSampleLogger localsamplelogger) {
        this.B = new BandwidthDebugMonitor(localsamplelogger);
    }
}

