/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;

public final class ChatHexColor {
    private static final String b = "#";
    public static final Codec<ChatHexColor> a = Codec.STRING.comapFlatMap(ChatHexColor::a, ChatHexColor::b);
    private static final Map<EnumChatFormat, ChatHexColor> c = (Map)Stream.of(EnumChatFormat.values()).filter(EnumChatFormat::e).collect(ImmutableMap.toImmutableMap(Function.identity(), enumchatformat -> new ChatHexColor(enumchatformat.f(), enumchatformat.g(), (EnumChatFormat)enumchatformat)));
    private static final Map<String, ChatHexColor> d = (Map)c.values().stream().collect(ImmutableMap.toImmutableMap(chathexcolor -> chathexcolor.f, Function.identity()));
    private final int e;
    @Nullable
    public final String f;
    @Nullable
    public final EnumChatFormat format;

    private ChatHexColor(int i2, String s2, EnumChatFormat format) {
        this.e = i2 & 0xFFFFFF;
        this.f = s2;
        this.format = format;
    }

    private ChatHexColor(int i2) {
        this.e = i2 & 0xFFFFFF;
        this.f = null;
        this.format = null;
    }

    public int a() {
        return this.e;
    }

    public String b() {
        return this.f != null ? this.f : this.c();
    }

    private String c() {
        return String.format(Locale.ROOT, "#%06X", this.e);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            ChatHexColor chathexcolor = (ChatHexColor)object;
            return this.e == chathexcolor.e;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.e, this.f);
    }

    public String toString() {
        return this.b();
    }

    @Nullable
    public static ChatHexColor a(EnumChatFormat enumchatformat) {
        return c.get(enumchatformat);
    }

    public static ChatHexColor a(int i2) {
        return new ChatHexColor(i2);
    }

    public static DataResult<ChatHexColor> a(String s2) {
        if (s2.startsWith(b)) {
            try {
                int i2 = Integer.parseInt(s2.substring(1), 16);
                return i2 >= 0 && i2 <= 0xFFFFFF ? DataResult.success((Object)ChatHexColor.a(i2), (Lifecycle)Lifecycle.stable()) : DataResult.error(() -> "Color value out of range: " + s2);
            }
            catch (NumberFormatException numberformatexception) {
                return DataResult.error(() -> "Invalid color value: " + s2);
            }
        }
        ChatHexColor chathexcolor = d.get(s2);
        return chathexcolor == null ? DataResult.error(() -> "Invalid color name: " + s2) : DataResult.success((Object)chathexcolor, (Lifecycle)Lifecycle.stable());
    }
}

