/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger a = LogUtils.getLogger();

    public static <T extends PacketListener> void a(Packet<T> packet, T t0, WorldServer worldserver) throws CancelledPacketHandleException {
        PlayerConnectionUtils.a(packet, t0, worldserver.p());
    }

    public static <T extends PacketListener> void a(Packet<T> packet, T t0, IAsyncTaskHandler<?> iasynctaskhandler) throws CancelledPacketHandleException {
        if (!iasynctaskhandler.bx()) {
            iasynctaskhandler.c(() -> {
                if (t0 instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)t0;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (t0.a(packet)) {
                    try {
                        packet.a(t0);
                    }
                    catch (Exception exception) {
                        ReportedException reportedexception;
                        if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                            throw PlayerConnectionUtils.a(exception, packet, t0);
                        }
                        t0.a(packet, exception);
                    }
                } else {
                    a.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                }
            });
            throw CancelledPacketHandleException.a;
        }
    }

    public static <T extends PacketListener> ReportedException a(Exception exception, Packet<T> packet, T t0) {
        if (exception instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)exception;
            PlayerConnectionUtils.a(reportedexception.a(), t0, packet);
            return reportedexception;
        }
        CrashReport crashreport = CrashReport.a(exception, "Main thread packet handler");
        PlayerConnectionUtils.a(crashreport, t0, packet);
        return new ReportedException(crashreport);
    }

    public static <T extends PacketListener> void a(CrashReport crashreport, T t0, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Incoming Packet");
            crashreportsystemdetails.a("Type", () -> packet.a().toString());
            crashreportsystemdetails.a("Is Terminal", () -> Boolean.toString(packet.d()));
            crashreportsystemdetails.a("Is Skippable", () -> Boolean.toString(packet.c()));
        }
        t0.a(crashreport);
    }
}

