/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataPlayer {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = new GsonBuilder().setPrettyPrinting().create();
    private final PlayerList c;
    private final Path d;
    private AdvancementTree e;
    private final Map<AdvancementHolder, AdvancementProgress> f = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> g = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> h = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> i = new HashSet<AdvancementNode>();
    private EntityPlayer j;
    @Nullable
    private AdvancementHolder k;
    private boolean l = true;
    private final Codec<a> m;

    public AdvancementDataPlayer(DataFixer datafixer, PlayerList playerlist, AdvancementDataWorld advancementdataworld, Path path, EntityPlayer entityplayer) {
        this.c = playerlist;
        this.d = path;
        this.j = entityplayer;
        this.e = advancementdataworld.a();
        int i2 = 1343;
        this.m = DataFixTypes.p.a(net.minecraft.server.AdvancementDataPlayer$a.a, datafixer, 1343);
        this.d(advancementdataworld);
    }

    public void a(EntityPlayer entityplayer) {
        this.j = entityplayer;
    }

    public void a() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.ak) {
            criterionTrigger.a(this);
        }
    }

    public void a(AdvancementDataWorld advancementdataworld) {
        this.a();
        this.f.clear();
        this.g.clear();
        this.i.clear();
        this.h.clear();
        this.l = true;
        this.k = null;
        this.e = advancementdataworld.a();
        this.d(advancementdataworld);
    }

    private void b(AdvancementDataWorld advancementdataworld) {
        for (AdvancementHolder advancementholder : advancementdataworld.b()) {
            this.d(advancementholder);
        }
    }

    private void c(AdvancementDataWorld advancementdataworld) {
        for (AdvancementHolder advancementholder : advancementdataworld.b()) {
            Advancement advancement = advancementholder.b();
            if (!advancement.e().isEmpty()) continue;
            this.a(advancementholder, "");
            advancement.d().a(this.j);
        }
    }

    private void d(AdvancementDataWorld advancementdataworld) {
        if (Files.isRegularFile(this.d, new LinkOption[0])) {
            try (JsonReader jsonreader = new JsonReader((Reader)Files.newBufferedReader(this.d, StandardCharsets.UTF_8));){
                jsonreader.setLenient(false);
                JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                a advancementdataplayer_a = (a)this.m.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonParseException::new);
                this.a(advancementdataworld, advancementdataplayer_a);
            }
            catch (JsonIOException | IOException ioexception) {
                a.error("Couldn't access player advancements in {}", (Object)this.d, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                a.error("Couldn't parse player advancements in {}", (Object)this.d, (Object)jsonparseexception);
            }
        }
        this.c(advancementdataworld);
        this.b(advancementdataworld);
    }

    public void b() {
        if (SpigotConfig.disableAdvancementSaving) {
            return;
        }
        JsonElement jsonelement = (JsonElement)this.m.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.c()).getOrThrow();
        try {
            FileUtils.c(this.d.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(this.d, StandardCharsets.UTF_8, new OpenOption[0]);){
                b.toJson(jsonelement, b.newJsonWriter((Writer)writer));
            }
        }
        catch (JsonIOException | IOException ioexception) {
            a.error("Couldn't save player advancements to {}", (Object)this.d, (Object)ioexception);
        }
    }

    private void a(AdvancementDataWorld advancementdataworld, a advancementdataplayer_a) {
        advancementdataplayer_a.a((MinecraftKey minecraftkey, AdvancementProgress advancementprogress) -> {
            AdvancementHolder advancementholder = advancementdataworld.a((MinecraftKey)minecraftkey);
            if (advancementholder == null) {
                if (!minecraftkey.b().equals("minecraft")) {
                    return;
                }
                a.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", minecraftkey, (Object)this.d);
            } else {
                this.a(advancementholder, (AdvancementProgress)advancementprogress);
                this.h.add(advancementholder);
                this.c(advancementholder);
            }
        });
    }

    private a c() {
        LinkedHashMap<MinecraftKey, AdvancementProgress> map = new LinkedHashMap<MinecraftKey, AdvancementProgress>();
        this.f.forEach((advancementholder, advancementprogress) -> {
            if (advancementprogress.b()) {
                map.put(advancementholder.a(), (AdvancementProgress)advancementprogress);
            }
        });
        return new a(map);
    }

    public boolean a(AdvancementHolder advancementholder, String s2) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.b(advancementholder);
        boolean flag1 = advancementprogress.a();
        if (advancementprogress.a(s2)) {
            this.e(advancementholder);
            this.h.add(advancementholder);
            flag = true;
            if (!flag1 && advancementprogress.a()) {
                this.j.dV().getCraftServer().getPluginManager().callEvent((Event)new PlayerAdvancementDoneEvent((Player)this.j.getBukkitEntity(), advancementholder.toBukkit()));
                advancementholder.b().d().a(this.j);
                advancementholder.b().c().ifPresent(advancementdisplay -> {
                    if (advancementdisplay.i() && this.j.x().O().c(GameRules.C)) {
                        this.c.a(advancementdisplay.e().a(advancementholder, this.j), false);
                    }
                });
            }
        }
        if (!flag1 && advancementprogress.a()) {
            this.c(advancementholder);
        }
        return flag;
    }

    public boolean b(AdvancementHolder advancementholder, String s2) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.b(advancementholder);
        boolean flag1 = advancementprogress.a();
        if (advancementprogress.b(s2)) {
            this.d(advancementholder);
            this.h.add(advancementholder);
            flag = true;
        }
        if (flag1 && !advancementprogress.a()) {
            this.c(advancementholder);
        }
        return flag;
    }

    private void c(AdvancementHolder advancementholder) {
        AdvancementNode advancementnode = this.e.a(advancementholder);
        if (advancementnode != null) {
            this.i.add(advancementnode.d());
        }
    }

    private void d(AdvancementHolder advancementholder) {
        AdvancementProgress advancementprogress = this.b(advancementholder);
        if (!advancementprogress.a()) {
            for (Map.Entry<String, Criterion<?>> map_entry : advancementholder.b().e().entrySet()) {
                CriterionProgress criterionprogress = advancementprogress.c(map_entry.getKey());
                if (criterionprogress == null || criterionprogress.a()) continue;
                this.a(advancementholder, map_entry.getKey(), map_entry.getValue());
            }
        }
    }

    private <T extends CriterionInstance> void a(AdvancementHolder advancementholder, String s2, Criterion<T> criterion) {
        criterion.a().a(this, new CriterionTrigger.a<T>(criterion.b(), advancementholder, s2));
    }

    private void e(AdvancementHolder advancementholder) {
        AdvancementProgress advancementprogress = this.b(advancementholder);
        for (Map.Entry<String, Criterion<?>> map_entry : advancementholder.b().e().entrySet()) {
            CriterionProgress criterionprogress = advancementprogress.c(map_entry.getKey());
            if (criterionprogress == null || !criterionprogress.a() && !advancementprogress.a()) continue;
            this.b(advancementholder, map_entry.getKey(), map_entry.getValue());
        }
    }

    private <T extends CriterionInstance> void b(AdvancementHolder advancementholder, String s2, Criterion<T> criterion) {
        criterion.a().b(this, new CriterionTrigger.a<T>(criterion.b(), advancementholder, s2));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        if (this.l || !this.i.isEmpty() || !this.h.isEmpty()) {
            HashMap<MinecraftKey, AdvancementProgress> map = new HashMap<MinecraftKey, AdvancementProgress>();
            HashSet<AdvancementHolder> set = new HashSet<AdvancementHolder>();
            HashSet<MinecraftKey> set1 = new HashSet<MinecraftKey>();
            for (AdvancementNode advancementnode : this.i) {
                this.a(advancementnode, set, set1);
            }
            this.i.clear();
            for (AdvancementHolder advancementholder : this.h) {
                if (!this.g.contains(advancementholder)) continue;
                map.put(advancementholder.a(), this.f.get(advancementholder));
            }
            this.h.clear();
            if (!(map.isEmpty() && set.isEmpty() && set1.isEmpty())) {
                entityplayer.f.b(new PacketPlayOutAdvancements(this.l, set, set1, map, flag));
            }
        }
        this.l = false;
    }

    public void a(@Nullable AdvancementHolder advancementholder) {
        AdvancementHolder advancementholder1 = this.k;
        this.k = advancementholder != null && advancementholder.b().a() && advancementholder.b().c().isPresent() ? advancementholder : null;
        if (advancementholder1 != this.k) {
            this.j.f.b(new PacketPlayOutSelectAdvancementTab(this.k == null ? null : this.k.a()));
        }
    }

    public AdvancementProgress b(AdvancementHolder advancementholder) {
        AdvancementProgress advancementprogress = this.f.get(advancementholder);
        if (advancementprogress == null) {
            advancementprogress = new AdvancementProgress();
            this.a(advancementholder, advancementprogress);
        }
        return advancementprogress;
    }

    private void a(AdvancementHolder advancementholder, AdvancementProgress advancementprogress) {
        advancementprogress.a(advancementholder.b().f());
        this.f.put(advancementholder, advancementprogress);
    }

    private void a(AdvancementNode advancementnode, Set<AdvancementHolder> set, Set<MinecraftKey> set1) {
        AdvancementVisibilityEvaluator.a(advancementnode, advancementnode1 -> this.b(advancementnode1.b()).a(), (advancementnode1, flag) -> {
            AdvancementHolder advancementholder = advancementnode1.b();
            if (flag) {
                if (this.g.add(advancementholder)) {
                    set.add(advancementholder);
                    if (this.f.containsKey(advancementholder)) {
                        this.h.add(advancementholder);
                    }
                }
            } else if (this.g.remove(advancementholder)) {
                set1.add(advancementholder.a());
            }
        });
    }

    private static final class a
    extends Record {
        private final Map<MinecraftKey, AdvancementProgress> b;
        public static final Codec<a> a = Codec.unboundedMap(MinecraftKey.a, AdvancementProgress.a).xmap(a::new, a::a);

        private a(Map<MinecraftKey, AdvancementProgress> map) {
            this.b = map;
        }

        public void a(BiConsumer<MinecraftKey, AdvancementProgress> biconsumer) {
            this.b.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> biconsumer.accept((MinecraftKey)entry.getKey(), (AdvancementProgress)entry.getValue()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "map", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "map", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "map", "b"}, this, o2);
        }

        public Map<MinecraftKey, AdvancementProgress> a() {
            return this.b;
        }
    }
}

