/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> a = (commandcontext, suggestionsbuilder) -> {
        ReloadableServerRegistries.a reloadableserverregistries_a = ((CommandListenerWrapper)commandcontext.getSource()).l().bc();
        return ICompletionProvider.a(reloadableserverregistries_a.a(Registries.br), suggestionsbuilder);
    };
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_loot_table.entity", object));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_loot_table.block", object));

    public static void a(CommandDispatcher<CommandListenerWrapper> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.a((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("loot").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2)), (ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder, b commandloot_b) -> argumentbuilder.then(net.minecraft.commands.CommandDispatcher.a("fish").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(commandbuildcontext)).suggests(a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.l, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(commandbuildcontext)).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b)))))).then(net.minecraft.commands.CommandDispatcher.a("loot").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(commandbuildcontext)).suggests(a).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("kill").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "target"), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.l, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(commandbuildcontext)).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T a(T t0, c commandloot_c) {
        return (T)t0.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.a("insert").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a)))).then(net.minecraft.commands.CommandDispatcher.a("give").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandcontext, "players"), (List<ItemStack>)list, commandloot_a)))).then(net.minecraft.commands.CommandDispatcher.a("spawn").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentVec3.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a))));
    }

    private static IInventory a(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition) throws CommandSyntaxException {
        TileEntity tileentity = commandlistenerwrapper.e().c_(blockposition);
        if (!(tileentity instanceof IInventory)) {
            throw ItemCommands.a.create((Object)blockposition.u(), (Object)blockposition.v(), (Object)blockposition.w());
        }
        return (IInventory)((Object)tileentity);
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(commandlistenerwrapper, blockposition);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            if (!CommandLoot.a(iinventory, itemstack.v())) continue;
            iinventory.e();
            list1.add(itemstack);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static boolean a(IInventory iinventory, ItemStack itemstack) {
        boolean flag = false;
        for (int i2 = 0; i2 < iinventory.b() && !itemstack.f(); ++i2) {
            ItemStack itemstack1 = iinventory.a(i2);
            if (!iinventory.b(i2, itemstack)) continue;
            if (itemstack1.f()) {
                iinventory.a(i2, itemstack);
                flag = true;
                break;
            }
            if (!CommandLoot.a(itemstack1, itemstack)) continue;
            int j2 = itemstack.k() - itemstack1.M();
            int k2 = Math.min(itemstack.M(), j2);
            itemstack.h(k2);
            itemstack1.g(k2);
            flag = true;
        }
        return flag;
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition, int i2, int j2, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(commandlistenerwrapper, blockposition);
        int k2 = iinventory.b();
        if (i2 >= 0 && i2 < k2) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
            for (int l2 = 0; l2 < j2; ++l2) {
                ItemStack itemstack;
                int i1 = i2 + l2;
                ItemStack itemStack = itemstack = l2 < list.size() ? list.get(l2) : ItemStack.l;
                if (!iinventory.b(i1, itemstack)) continue;
                iinventory.a(i1, itemstack);
                list1.add(itemstack);
            }
            commandloot_a.accept(list1);
            return list1.size();
        }
        throw ItemCommands.c.create((Object)i2);
    }

    private static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.M() <= itemstack.k() && ItemStack.c(itemstack, itemstack1);
    }

    private static int a(Collection<EntityPlayer> collection, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            for (EntityPlayer entityplayer : collection) {
                if (!entityplayer.gj().g(itemstack.v())) continue;
                list1.add(itemstack);
            }
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static void a(Entity entity, List<ItemStack> list, int i2, int j2, List<ItemStack> list1) {
        for (int k2 = 0; k2 < j2; ++k2) {
            ItemStack itemstack = k2 < list.size() ? list.get(k2) : ItemStack.l;
            SlotAccess slotaccess = entity.a_(i2 + k2);
            if (slotaccess == SlotAccess.a || !slotaccess.a(itemstack.v())) continue;
            list1.add(itemstack);
        }
    }

    private static int a(Collection<? extends Entity> collection, int i2, int j2, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (Entity entity : collection) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                CommandLoot.a(entity, list, i2, j2, list1);
                entityplayer.bR.d();
                continue;
            }
            CommandLoot.a(entity, list, i2, j2, list1);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static int a(CommandListenerWrapper commandlistenerwrapper, Vec3D vec3d, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.e();
        list.removeIf(ItemStack::f);
        list.forEach(itemstack -> {
            EntityItem entityitem = new EntityItem(worldserver, vec3d.d, vec3d.e, vec3d.f, itemstack.v());
            entityitem.i();
            worldserver.b(entityitem);
        });
        commandloot_a.accept(list);
        return list.size();
    }

    private static void a(CommandListenerWrapper commandlistenerwrapper, List<ItemStack> list) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.drop.success.single", itemstack.M(), itemstack.K()), false);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.drop.success.multiple", list.size()), false);
        }
    }

    private static void a(CommandListenerWrapper commandlistenerwrapper, List<ItemStack> list, ResourceKey<LootTable> resourcekey) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.drop.success.single_with_table", itemstack.M(), itemstack.K(), IChatBaseComponent.a(resourcekey.a())), false);
        } else {
            commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.drop.success.multiple_with_table", list.size(), IChatBaseComponent.a(resourcekey.a())), false);
        }
    }

    private static ItemStack a(CommandListenerWrapper commandlistenerwrapper, EnumItemSlot enumitemslot) throws CommandSyntaxException {
        Entity entity = commandlistenerwrapper.g();
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).a(enumitemslot);
        }
        throw b.create((Object)entity.P_());
    }

    private static int a(CommandContext<CommandListenerWrapper> commandcontext, BlockPosition blockposition, ItemStack itemstack, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        WorldServer worldserver = commandlistenerwrapper.e();
        IBlockData iblockdata = worldserver.a_(blockposition);
        TileEntity tileentity = worldserver.c_(blockposition);
        Optional<ResourceKey<LootTable>> optional = iblockdata.b().u();
        if (optional.isEmpty()) {
            throw d.create((Object)iblockdata.b().f());
        }
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.g, iblockdata).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.i, itemstack);
        List<ItemStack> list = iblockdata.a(lootparams_a);
        return commandloot_b.accept(commandcontext, list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, (ResourceKey)optional.get()));
    }

    private static int a(CommandContext<CommandListenerWrapper> commandcontext, Entity entity, b commandloot_b) throws CommandSyntaxException {
        Optional<ResourceKey<LootTable>> optional = entity.ea();
        if (optional.isEmpty()) {
            throw c.create((Object)entity.P_());
        }
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams.a lootparams_a = new LootParams.a(commandlistenerwrapper.e());
        Entity entity1 = commandlistenerwrapper.f();
        if (entity1 instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity1;
            lootparams_a.a(LootContextParameters.b, entityhuman);
        }
        lootparams_a.a(LootContextParameters.c, entity.dW().q());
        lootparams_a.b(LootContextParameters.e, entity1);
        lootparams_a.b(LootContextParameters.d, entity1);
        lootparams_a.a(LootContextParameters.a, entity);
        lootparams_a.a(LootContextParameters.f, commandlistenerwrapper.d());
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
        LootTable loottable = commandlistenerwrapper.l().bc().b(optional.get());
        ObjectArrayList<ItemStack> list = loottable.a(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, (ResourceKey)optional.get()));
    }

    private static int a(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.e()).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.f, commandlistenerwrapper.d()).a(LootContextParameterSets.c);
        return CommandLoot.a(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int a(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, BlockPosition blockposition, ItemStack itemstack, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.e()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameterSets.f);
        return CommandLoot.a(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int a(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, LootParams lootparams, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        ObjectArrayList<ItemStack> list = holder.a().a(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> CommandLoot.a(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    private static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

