/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.event.world.AsyncStructureGenerateEvent;

public class PlaceCommand {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.place.template.invalid", object));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.place.template.failed"));
    private static final SuggestionProvider<CommandListenerWrapper> f = (commandcontext, suggestionsbuilder) -> {
        StructureTemplateManager structuretemplatemanager = ((CommandListenerWrapper)commandcontext.getSource()).e().r();
        return ICompletionProvider.a(structuretemplatemanager.a(), suggestionsbuilder);
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("place").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("feature").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("feature", ResourceKeyArgument.a(Registries.aL)).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "feature"), BlockPosition.a(((CommandListenerWrapper)commandcontext.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "feature"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("jigsaw").then(net.minecraft.commands.CommandDispatcher.a("pool", ResourceKeyArgument.a(Registries.bf)).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentMinecraftKeyRegistered.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)commandcontext, "pool"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), BlockPosition.a(((CommandListenerWrapper)commandcontext.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("position", ArgumentPosition.a()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.c((CommandContext<CommandListenerWrapper>)commandcontext, "pool"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "position"))))))))).then(net.minecraft.commands.CommandDispatcher.a("structure").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("structure", ResourceKeyArgument.a(Registries.be)).executes(commandcontext -> PlaceCommand.b((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)commandcontext, "structure"), BlockPosition.a(((CommandListenerWrapper)commandcontext.getSource()).d())))).then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> PlaceCommand.b((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.b((CommandContext<CommandListenerWrapper>)commandcontext, "structure"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.a("template").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("template", ArgumentMinecraftKeyRegistered.a()).suggests(f).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), BlockPosition.a(((CommandListenerWrapper)commandcontext.getSource()).d()), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), EnumBlockRotation.a, EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotation", TemplateRotationArgument.a()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), EnumBlockMirror.a, 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("mirror", TemplateMirrorArgument.a()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), 1.0f, 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), 0, false))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("seed", IntegerArgumentType.integer()).executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seed"), false))).then(net.minecraft.commands.CommandDispatcher.a("strict").executes(commandcontext -> PlaceCommand.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seed"), true))))))))))));
    }

    public static int a(CommandListenerWrapper commandlistenerwrapper, Holder.c<WorldGenFeatureConfigured<?, ?>> holder_c, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.e();
        WorldGenFeatureConfigured<?, ?> worldgenfeatureconfigured = holder_c.a();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
        PlaceCommand.a(worldserver, new ChunkCoordIntPair(chunkcoordintpair.h - 1, chunkcoordintpair.i - 1), new ChunkCoordIntPair(chunkcoordintpair.h + 1, chunkcoordintpair.i + 1));
        if (!worldgenfeatureconfigured.a(worldserver, worldserver.m().g(), worldserver.G_(), blockposition)) {
            throw a.create();
        }
        String s2 = holder_c.h().a().toString();
        commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.place.feature.success", new Object[]{s2, blockposition.u(), blockposition.v(), blockposition.w()}), true);
        return 1;
    }

    public static int a(CommandListenerWrapper commandlistenerwrapper, Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder, MinecraftKey minecraftkey, int i2, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.e();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
        PlaceCommand.a(worldserver, chunkcoordintpair, chunkcoordintpair);
        if (!WorldGenFeatureDefinedStructureJigsawPlacement.a(worldserver, holder, minecraftkey, i2, blockposition, false)) {
            throw b.create();
        }
        commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.place.jigsaw.success", blockposition.u(), blockposition.v(), blockposition.w()), true);
        return 1;
    }

    public static int b(CommandListenerWrapper commandlistenerwrapper, Holder.c<Structure> holder_c, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.e();
        Structure structure = holder_c.a();
        ChunkGenerator chunkgenerator = worldserver.m().g();
        StructureStart structurestart = structure.a(holder_c, worldserver.aj(), commandlistenerwrapper.u(), chunkgenerator, chunkgenerator.d(), worldserver.m().i(), worldserver.r(), worldserver.E(), new ChunkCoordIntPair(blockposition), 0, worldserver, holder -> true);
        if (!structurestart.b()) {
            throw c.create();
        }
        structurestart.generationEventCause = AsyncStructureGenerateEvent.Cause.COMMAND;
        StructureBoundingBox structureboundingbox = structurestart.a();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(SectionPosition.a(structureboundingbox.h()), SectionPosition.a(structureboundingbox.j()));
        ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(SectionPosition.a(structureboundingbox.k()), SectionPosition.a(structureboundingbox.m()));
        PlaceCommand.a(worldserver, chunkcoordintpair, chunkcoordintpair1);
        ChunkCoordIntPair.a(chunkcoordintpair, chunkcoordintpair1).forEach(chunkcoordintpair2 -> structurestart.a(worldserver, worldserver.b(), chunkgenerator, worldserver.G_(), new StructureBoundingBox(chunkcoordintpair2.d(), worldserver.K_(), chunkcoordintpair2.e(), chunkcoordintpair2.f(), worldserver.ao() + 1, chunkcoordintpair2.g()), (ChunkCoordIntPair)chunkcoordintpair2));
        String s2 = holder_c.h().a().toString();
        commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.place.structure.success", new Object[]{s2, blockposition.u(), blockposition.v(), blockposition.w()}), true);
        return 1;
    }

    public static int a(CommandListenerWrapper commandlistenerwrapper, MinecraftKey minecraftkey, BlockPosition blockposition, EnumBlockRotation enumblockrotation, EnumBlockMirror enumblockmirror, float f2, int i2, boolean flag) throws CommandSyntaxException {
        boolean flag1;
        Optional<DefinedStructure> optional;
        WorldServer worldserver = commandlistenerwrapper.e();
        StructureTemplateManager structuretemplatemanager = worldserver.r();
        try {
            optional = structuretemplatemanager.b(minecraftkey);
        }
        catch (ResourceKeyInvalidException resourcekeyinvalidexception) {
            throw d.create((Object)minecraftkey);
        }
        if (optional.isEmpty()) {
            throw d.create((Object)minecraftkey);
        }
        DefinedStructure definedstructure = optional.get();
        PlaceCommand.a(worldserver, new ChunkCoordIntPair(blockposition), new ChunkCoordIntPair(blockposition.a(definedstructure.a())));
        DefinedStructureInfo definedstructureinfo = new DefinedStructureInfo().a(enumblockmirror).a(enumblockrotation).b(flag);
        if (f2 < 1.0f) {
            definedstructureinfo.b().a(new DefinedStructureProcessorRotation(f2)).a(TileEntityStructure.b(i2));
        }
        if (!(flag1 = definedstructure.a(worldserver, blockposition, blockposition, definedstructureinfo, TileEntityStructure.b(i2), 2 | (flag ? 816 : 0)))) {
            throw e.create();
        }
        commandlistenerwrapper.a(() -> IChatBaseComponent.a("commands.place.template.success", IChatBaseComponent.a(minecraftkey), blockposition.u(), blockposition.v(), blockposition.w()), true);
        return 1;
    }

    private static void a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair, ChunkCoordIntPair chunkcoordintpair1) throws CommandSyntaxException {
        if (ChunkCoordIntPair.a(chunkcoordintpair, chunkcoordintpair1).filter(chunkcoordintpair2 -> !worldserver.p(chunkcoordintpair2.l())).findAny().isPresent()) {
            throw ArgumentPosition.a.create();
        }
    }
}

