/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider {
    private static final Logger b = LogUtils.getLogger();
    private final ChunkMapDistance c;
    private final WorldServer d;
    final Thread e;
    final LightEngineThreaded f;
    private final a g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    public final TicketStorage i;
    private long j;
    public boolean k = true;
    public boolean l = true;
    private static final int m = 4;
    private final long[] n = new long[4];
    private final ChunkStatus[] o = new ChunkStatus[4];
    private final IChunkAccess[] p = new IChunkAccess[4];
    private final List<Chunk> q = new ObjectArrayList();
    private final Set<PlayerChunk> r = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d s;

    public ChunkProviderServer(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, ChunkGenerator chunkgenerator, int i2, int j2, boolean flag, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier) {
        this.d = worldserver;
        this.g = new a(worldserver);
        this.e = Thread.currentThread();
        Path path = convertable_conversionsession.a(worldserver.aj()).resolve("data");
        try {
            FileUtils.c(path);
        }
        catch (IOException ioexception) {
            b.error("Failed to create dimension data storage directory", (Throwable)ioexception);
        }
        this.h = new WorldPersistentData(new PersistentBase.a(worldserver), path, datafixer, worldserver.J_());
        this.i = this.h.a(TicketStorage.b);
        this.a = new PlayerChunkMap(worldserver, convertable_conversionsession, datafixer, structuretemplatemanager, executor, this.g, this, chunkgenerator, worldloadlistener, chunkstatusupdatelistener, supplier, this.i, i2, flag);
        this.f = this.a.d();
        this.c = this.a.j();
        this.c.b(j2);
        this.s();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long i2) {
        return this.a.b(i2);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long i2, @Nullable IChunkAccess ichunkaccess, ChunkStatus chunkstatus) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
            this.p[j2] = this.p[j2 - 1];
        }
        this.n[0] = i2;
        this.o[0] = chunkstatus;
        this.p[0] = ichunkaccess;
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        if (Thread.currentThread() != this.e) {
            return CompletableFuture.supplyAsync(() -> this.a(i2, j2, chunkstatus, flag), this.g).join();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.f("getChunk");
        long k2 = ChunkCoordIntPair.c(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            IChunkAccess ichunkaccess;
            if (k2 != this.n[l2] || chunkstatus != this.o[l2] || (ichunkaccess = this.p[l2]) == null) continue;
            return ichunkaccess;
        }
        gameprofilerfiller.f("getChunkCacheMiss");
        this.d.timings.syncChunkLoadTimer.startTiming();
        CompletableFuture<ChunkResult<IChunkAccess>> completablefuture = this.c(i2, j2, chunkstatus, flag);
        a chunkproviderserver_a = this.g;
        Objects.requireNonNull(completablefuture);
        chunkproviderserver_a.b(completablefuture::isDone);
        this.d.timings.syncChunkLoadTimer.stopTiming();
        ChunkResult<IChunkAccess> chunkresult = completablefuture.join();
        IChunkAccess ichunkaccess1 = chunkresult.b((IChunkAccess)null);
        if (ichunkaccess1 == null && flag) {
            throw SystemUtils.b(new IllegalStateException("Chunk not there when requested: " + chunkresult.b()));
        }
        this.a(k2, ichunkaccess1, chunkstatus);
        return ichunkaccess1;
    }

    @Override
    @Nullable
    public Chunk a(int i2, int j2) {
        if (Thread.currentThread() != this.e) {
            return null;
        }
        Profiler.a().f("getChunkNow");
        long k2 = ChunkCoordIntPair.c(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            if (k2 != this.n[l2] || this.o[l2] != ChunkStatus.n) continue;
            IChunkAccess ichunkaccess = this.p[l2];
            return ichunkaccess instanceof Chunk ? (Chunk)ichunkaccess : null;
        }
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        IChunkAccess ichunkaccess1 = playerchunk.b(ChunkStatus.n);
        if (ichunkaccess1 != null) {
            this.a(k2, ichunkaccess1, ChunkStatus.n);
            if (ichunkaccess1 instanceof Chunk) {
                return (Chunk)ichunkaccess1;
            }
        }
        return null;
    }

    private void s() {
        Arrays.fill(this.n, ChunkCoordIntPair.c);
        Arrays.fill(this.o, null);
        Arrays.fill(this.p, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> b(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        CompletionStage<ChunkResult<IChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.e;
        if (flag1) {
            completablefuture = this.c(i2, j2, chunkstatus, flag);
            a chunkproviderserver_a = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_a.b(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(i2, j2, chunkstatus, flag), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> c(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.a();
        int l2 = ChunkLevel.a(chunkstatus);
        PlayerChunk playerchunk = this.b(k2);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            FullChunkStatus oldChunkState = ChunkLevel.c(playerchunk.j);
            FullChunkStatus currentChunkState = ChunkLevel.c(playerchunk.j());
            boolean bl = currentlyUnloading = oldChunkState.a(FullChunkStatus.b) && !currentChunkState.a(FullChunkStatus.b);
        }
        if (flag && !currentlyUnloading) {
            this.a(new Ticket(TicketType.i, l2), chunkcoordintpair);
            if (this.a(playerchunk, l2)) {
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a("chunkLoad");
                this.t();
                playerchunk = this.b(k2);
                gameprofilerfiller.c();
                if (this.a(playerchunk, l2)) {
                    throw SystemUtils.b(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        return this.a(playerchunk, l2) ? GenerationChunkHolder.c : playerchunk.a(chunkstatus, this.a);
    }

    private boolean a(@Nullable PlayerChunk playerchunk, int i2) {
        return playerchunk == null || playerchunk.j > i2;
    }

    @Override
    public boolean b(int i2, int j2) {
        int k2;
        PlayerChunk playerchunk = this.b(new ChunkCoordIntPair(i2, j2).a());
        return !this.a(playerchunk, k2 = ChunkLevel.a(ChunkStatus.n));
    }

    @Override
    @Nullable
    public LightChunk c(int i2, int j2) {
        long k2 = ChunkCoordIntPair.c(i2, j2);
        PlayerChunk playerchunk = this.b(k2);
        return playerchunk == null ? null : playerchunk.a(ChunkStatus.k.c());
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.B();
    }

    boolean t() {
        boolean flag = this.c.a(this.a);
        boolean flag1 = this.a.f();
        this.a.g();
        if (!flag && !flag1) {
            return false;
        }
        this.s();
        return true;
    }

    public boolean a(long i2) {
        if (!this.d.a(i2)) {
            return false;
        }
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk == null ? false : playerchunk.a().getNow(PlayerChunk.a).a();
    }

    public void a(boolean flag) {
        this.t();
        this.a.a(flag);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.a(true);
        }
        this.h.close();
        this.f.close();
        this.a.close();
    }

    public void purgeUnload() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("purge");
        this.i.c();
        this.t();
        gameprofilerfiller.b("unload");
        this.a.a(() -> true);
        gameprofilerfiller.c();
        this.s();
    }

    @Override
    public void a(BooleanSupplier booleansupplier, boolean flag) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("purge");
        this.d.timings.doChunkMap.startTiming();
        if (this.d.u().i() || !flag || this.d.spigotConfig.unloadFrozenChunks) {
            this.i.c();
        }
        this.t();
        this.d.timings.doChunkMap.stopTiming();
        gameprofilerfiller.b("chunks");
        if (flag) {
            this.u();
            this.d.timings.tracker.startTiming();
            this.a.l();
            this.d.timings.tracker.stopTiming();
        }
        this.d.timings.doChunkUnload.startTiming();
        gameprofilerfiller.b("unload");
        this.a.a(booleansupplier);
        this.d.timings.doChunkUnload.stopTiming();
        gameprofilerfiller.c();
        this.s();
    }

    private void u() {
        long i2 = this.d.ae();
        long j2 = i2 - this.j;
        this.j = i2;
        if (!this.d.ak()) {
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("pollingChunks");
            if (this.d.u().i()) {
                gameprofilerfiller.a("tickingChunks");
                this.a(gameprofilerfiller, j2);
                gameprofilerfiller.c();
            }
            this.a(gameprofilerfiller);
            gameprofilerfiller.c();
        }
    }

    private void a(GameProfilerFiller gameprofilerfiller) {
        gameprofilerfiller.a("broadcast");
        for (PlayerChunk playerchunk : this.r) {
            Chunk chunk = playerchunk.d();
            if (chunk == null) continue;
            playerchunk.a(chunk);
        }
        this.r.clear();
        gameprofilerfiller.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GameProfilerFiller gameprofilerfiller, long i2) {
        List<EnumCreatureType> list;
        SpawnerCreature.d spawnercreature_d;
        gameprofilerfiller.b("naturalSpawnCount");
        int j2 = this.c.a();
        this.s = spawnercreature_d = SpawnerCreature.a(j2, this.d.C(), this::a, new LocalMobCapCalculator(this.a));
        gameprofilerfiller.b("spawnAndTick");
        boolean flag = this.d.O().c(GameRules.f) && !this.d.z().isEmpty();
        int k2 = this.d.O().d(GameRules.p);
        if (flag && (this.k || this.l)) {
            boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.C_().c() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            list = SpawnerCreature.getFilteredSpawningCategories(spawnercreature_d, this.l, this.k, flag1, this.d);
        } else {
            list = List.of();
        }
        List<Chunk> list1 = this.q;
        try {
            gameprofilerfiller.a("filteringSpawningChunks");
            this.a.a(list1);
            gameprofilerfiller.b("shuffleSpawningChunks");
            SystemUtils.c(list1, this.d.A);
            gameprofilerfiller.b("tickSpawningChunks");
            for (Chunk chunk : list1) {
                this.a(chunk, i2, list, spawnercreature_d);
            }
        }
        finally {
            list1.clear();
        }
        gameprofilerfiller.b("tickTickingChunks");
        this.a.a((Chunk chunk1) -> {
            this.d.timings.doTickTiles.startTiming();
            this.d.a((Chunk)chunk1, k2);
            this.d.timings.doTickTiles.stopTiming();
        });
        gameprofilerfiller.c();
        gameprofilerfiller.b("customSpawners");
        if (flag) {
            this.d.a(this.k, this.l);
        }
    }

    private void a(Chunk chunk, long i2, List<EnumCreatureType> list, SpawnerCreature.d spawnercreature_d) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        chunk.b(i2);
        if (this.c.c(chunkcoordintpair.a())) {
            this.d.a(chunk);
        }
        if (!list.isEmpty() && this.d.c(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
            SpawnerCreature.a(this.d, chunk, spawnercreature_d, list);
        }
    }

    private void a(long i2, Consumer<Chunk> consumer) {
        PlayerChunk playerchunk = this.b(i2);
        if (playerchunk != null) {
            playerchunk.c().getNow(PlayerChunk.a).a(consumer);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.by();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition blockposition) {
        int j2;
        int i2 = SectionPosition.a(blockposition.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.c(i2, j2 = SectionPosition.a(blockposition.w())));
        if (playerchunk != null && playerchunk.a(blockposition)) {
            this.r.add(playerchunk);
        }
    }

    @Override
    public void a(EnumSkyBlock enumskyblock, SectionPosition sectionposition) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(sectionposition.r().a());
            if (playerchunk != null && playerchunk.a(enumskyblock, sectionposition.b())) {
                this.r.add(playerchunk);
            }
        });
    }

    public void a(Ticket ticket, ChunkCoordIntPair chunkcoordintpair) {
        this.i.a(ticket, chunkcoordintpair);
    }

    public void a(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        this.i.a(tickettype, chunkcoordintpair, i2);
    }

    public void b(TicketType tickettype, ChunkCoordIntPair chunkcoordintpair, int i2) {
        this.i.b(tickettype, chunkcoordintpair, i2);
    }

    @Override
    public boolean a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        return this.i.a(chunkcoordintpair, flag);
    }

    @Override
    public LongSet k() {
        return this.i.e();
    }

    public void a(EntityPlayer entityplayer) {
        if (!entityplayer.dQ()) {
            this.a.a(entityplayer);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int i2) {
        this.a.a(i2);
    }

    public void b(int i2) {
        this.c.b(i2);
    }

    @Override
    public void b(boolean flag) {
        this.setSpawnSettings(flag, this.l);
    }

    public void setSpawnSettings(boolean flag, boolean spawnFriendlies) {
        this.k = flag;
        this.l = spawnFriendlies;
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public WorldPersistentData l() {
        return this.h;
    }

    public VillagePlace m() {
        return this.a.m();
    }

    public ChunkScanAccess n() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d o() {
        return this.s;
    }

    public void p() {
        this.i.d();
    }

    public void a(PlayerChunk playerchunk) {
        if (playerchunk.i()) {
            this.r.add(playerchunk);
        }
    }

    private final class a
    extends IAsyncTaskHandler<Runnable> {
        a(World world) {
            super("Chunk source main thread executor for " + String.valueOf(world.aj().a()));
        }

        @Override
        public void b(BooleanSupplier booleansupplier) {
            super.b(() -> MinecraftServer.z() && booleansupplier.getAsBoolean());
        }

        @Override
        public Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean ax() {
            return true;
        }

        @Override
        protected Thread ay() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable runnable) {
            Profiler.a().f("runTask");
            super.d(runnable);
        }

        @Override
        public boolean B() {
            try {
                if (ChunkProviderServer.this.t()) {
                    boolean bl = true;
                    return bl;
                }
                ChunkProviderServer.this.f.b();
                boolean bl = super.B();
                return bl;
            }
            finally {
                ChunkProviderServer.this.a.callbackExecutor.run();
            }
        }
    }
}

