/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman {
    private static final Logger cq = LogUtils.getLogger();
    private static final int cr = 32;
    private static final int cs = 10;
    private static final int ct = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    private static final AttributeModifier cu = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cv = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cw = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final boolean cx = false;
    private static final boolean cy = false;
    public PlayerConnection f;
    public final MinecraftServer g;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cz;
    private final ServerStatisticManager cA;
    private float cB = Float.MIN_VALUE;
    private int cC = Integer.MIN_VALUE;
    private int cD = Integer.MIN_VALUE;
    private int cE = Integer.MIN_VALUE;
    private int cF = Integer.MIN_VALUE;
    private int cG = Integer.MIN_VALUE;
    private float cH = -1.0E8f;
    private int cI = -99999999;
    private boolean cJ = true;
    public int cK = -99999999;
    private EnumChatVisibility cL = EnumChatVisibility.a;
    private ParticleStatus cM = ParticleStatus.a;
    private boolean cN = true;
    private long cO = SystemUtils.c();
    @Nullable
    private Entity cP;
    public boolean cQ;
    public boolean i = false;
    private final RecipeBookServer cR;
    @Nullable
    private Vec3D cS;
    private int cT;
    private boolean cU;
    private int cV = 2;
    public String cW = "en_us";
    @Nullable
    private Vec3D cX;
    @Nullable
    private Vec3D cY;
    @Nullable
    private Vec3D cZ;
    private SectionPosition da = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView db = ChunkTrackingView.a;
    @Nullable
    private RespawnConfig dc;
    private final ITextFilter dd;
    private boolean de;
    private boolean df;
    private boolean dg = false;
    private WardenSpawnTracker dh = new WardenSpawnTracker();
    @Nullable
    private BlockPosition di;
    private Vec3D dj = Vec3D.c;
    private Input dk = Input.b;
    private final Set<EntityEnderPearl> dl = new HashSet<EntityEnderPearl>();
    private final ContainerSynchronizer dm = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.dX().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> typeddatacomponent) {
                return ((HashCode)typeddatacomponent.a(this.b).getOrThrow(s2 -> {
                    String s1 = String.valueOf(typeddatacomponent);
                    return new IllegalArgumentException("Failed to hash " + s1 + ": " + s2);
                })).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> list, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowItems(container.l, container.k(), list, itemstack));
            for (int i2 = 0; i2 < aint.length; ++i2) {
                this.b(container, i2, aint[i2]);
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.f.b(new PacketPlayOutSetSlot(container.l, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.f.b(new ClientboundSetCursorItemPacket(itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.f.b(new PacketPlayOutWindowData(container.l, i2, j2));
        }

        @Override
        public RemoteSlot a() {
            LoadingCache<TypedDataComponent<?>, Integer> loadingcache = this.b;
            Objects.requireNonNull(this.b);
            return new RemoteSlot.a(arg_0 -> loadingcache.getUnchecked(arg_0));
        }
    };
    private final ICrafting dn = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gj()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gj(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    @Nullable
    private RemoteChatSession do;
    @Nullable
    public final Object j;
    private final ICommandListener dp = new ICommandListener(){

        @Override
        public boolean x_() {
            return EntityPlayer.this.x().O().c(GameRules.q);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
            EntityPlayer.this.a(ichatbasecomponent);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private int dq;
    public boolean k;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, worldserver.aa(), worldserver.ab(), gameprofile);
        this.dd = minecraftserver.a(this);
        this.h = minecraftserver.b(this);
        this.cR = new RecipeBookServer((resourcekey, consumer) -> minecraftserver.aI().a(resourcekey, consumer));
        this.g = minecraftserver;
        this.cA = minecraftserver.ag().getPlayerStats(this);
        this.cz = minecraftserver.ag().g(this);
        this.b(this.a(worldserver, worldserver.aa()).c(), 0.0f, 0.0f);
        this.a(clientinformation);
        this.j = null;
        this.displayName = this.cI();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eU();
    }

    public void resendItemInHands() {
        this.bR.b(this.gj(), this.gj().f()).ifPresent(s2 -> this.dm.a(this.bR, s2, this.fb()));
        this.dm.a((Container)this.bQ, 45, this.fc());
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.aa();
        if (worldserver.F_().g() && worldserver.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.g.a(worldserver));
            int j2 = MathHelper.a(worldserver.E_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        AxisAlignedBB axisalignedbb = this.a(EntityPose.a).a(Vec3D.c);
        BlockPosition blockposition1 = blockposition;
        if (worldserver.F_().g() && worldserver.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.g.a(worldserver));
            int j2 = MathHelper.a(worldserver.E_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                int l22 = blockposition.u() + j22 - i2;
                int i3 = blockposition.w() + k22 - i2;
                try {
                    blockposition1 = WorldProviderNormal.a(worldserver, l22, i3);
                    if (blockposition1 == null || !this.a(worldserver, axisalignedbb.c(blockposition1.c()))) continue;
                    return blockposition1;
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.a(exception, "Searching for spawn");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Spawn Lookup");
                    Objects.requireNonNull(blockposition);
                    crashreportsystemdetails.a("Origin", blockposition::toString);
                    int finalI = i2;
                    crashreportsystemdetails.a("Radius", () -> Integer.toString(finalI));
                    crashreportsystemdetails.a("Candidate", () -> "[" + l22 + "," + i3 + "]");
                    int finalL1 = l1;
                    crashreportsystemdetails.a("Progress", () -> finalL1 + " out of " + i1);
                    throw new ReportedException(crashreport);
                }
            }
            blockposition1 = blockposition;
        }
        while (!this.a(worldserver, axisalignedbb.c(blockposition1.c())) && blockposition1.v() < worldserver.ao()) {
            blockposition1 = blockposition1.d();
        }
        while (this.a(worldserver, axisalignedbb.c(blockposition1.e().c())) && blockposition1.v() > worldserver.K_() + 1) {
            blockposition1 = blockposition1.e();
        }
        return blockposition1;
    }

    private boolean a(WorldServer worldserver, AxisAlignedBB axisalignedbb) {
        return worldserver.a((Entity)this, axisalignedbb, true);
    }

    private int t(int i2) {
        return i2 <= 16 ? i2 - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.dh = nbttagcompound.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.cY = nbttagcompound.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = nbttagcompound.b("seenCredits", false);
        this.cR.a(nbttagcompound.n("recipeBook"), (ResourceKey<IRecipe<?>> resourcekey) -> this.g.aI().b((ResourceKey<IRecipe<?>>)resourcekey).isPresent());
        this.getBukkitEntity().readExtraData(nbttagcompound);
        if (this.fR()) {
            this.fS();
        }
        this.dc = nbttagcompound.a("respawn", RespawnConfig.a).orElse(null);
        String spawnWorld = nbttagcompound.b("SpawnWorld", "");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld((String)spawnWorld);
        if (oldWorld != null) {
            RespawnConfig respawnConfig = this.dc;
            this.dc = new RespawnConfig(oldWorld.getHandle().aj(), respawnConfig.b(), respawnConfig.c(), respawnConfig.d());
        }
        this.dg = nbttagcompound.b("spawn_extra_particles_on_fall", false);
        this.di = nbttagcompound.a("raid_omen_position", BlockPosition.a).orElse(null);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dh);
        this.p(nbttagcompound);
        nbttagcompound.a("seenCredits", this.i);
        nbttagcompound.b("entered_nether_pos", Vec3D.a, this.cY);
        this.m(nbttagcompound);
        nbttagcompound.a("recipeBook", this.cR.b());
        nbttagcompound.a("Dimension", this.dV().aj().a().toString());
        nbttagcompound.b("respawn", RespawnConfig.a, this.dc);
        this.getBukkitEntity().setExtraData(nbttagcompound);
        nbttagcompound.a("spawn_extra_particles_on_fall", this.dg);
        nbttagcompound.b("raid_omen_position", BlockPosition.a, this.di);
        this.n(nbttagcompound);
    }

    private void m(NBTTagCompound nbttagcompound) {
        Entity entity = this.df();
        Entity entity1 = this.dk();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dk()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.de()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            entity.g(nbttagcompound2);
            nbttagcompound1.a("Attach", UUIDUtil.a, entity1.cG());
            nbttagcompound1.a("Entity", nbttagcompound2);
            nbttagcompound.a("RootVehicle", nbttagcompound1);
        }
    }

    public void c(NBTTagCompound nbttagcompound) {
        Optional<NBTTagCompound> optional = nbttagcompound.m("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.x();
            Entity entity = EntityTypes.a(optional.get().n("Entity"), (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cG().equals(uuid)) {
                    this.a(entity, true);
                } else {
                    for (Entity entity12 : entity.dc()) {
                        if (!entity12.cG().equals(uuid)) continue;
                        this.a(entity12, true);
                        break;
                    }
                }
                if (!this.bY()) {
                    cq.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity2 : entity.dc()) {
                        entity2.discard(null);
                    }
                }
            }
        }
    }

    private void n(NBTTagCompound nbttagcompound) {
        if (!this.dl.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (EntityEnderPearl entityenderpearl : this.dl) {
                if (entityenderpearl.dQ()) {
                    cq.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                entityenderpearl.g(nbttagcompound1);
                nbttagcompound1.a(e, net.minecraft.world.level.World.h, entityenderpearl.dV().aj());
                nbttaglist.add(nbttagcompound1);
            }
            nbttagcompound.a(d, nbttaglist);
        }
    }

    public void d(NBTTagCompound nbttagcompound) {
        nbttagcompound.o(d).ifPresent(nbttaglist -> nbttaglist.j().forEach(this::o));
    }

    private void o(NBTTagCompound nbttagcompound) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = nbttagcompound.a(e, net.minecraft.world.level.World.h);
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.x().p().a(optional.get());
            if (worldserver != null) {
                Entity entity = EntityTypes.a(nbttagcompound, (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(worldserver, entity.dx());
                } else {
                    cq.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cq.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(net.minecraft.world.level.World world, boolean flag) {
        this.a(world);
        if (world == null) {
            this.dS();
            TeleportTransition teleporttransition = this.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, null);
            this.a((net.minecraft.world.level.World)teleporttransition.b());
            this.b(teleporttransition.c());
        }
        this.h.a((WorldServer)world);
    }

    public void a(int i2) {
        float f2 = this.gt();
        float f1 = (f2 - 1.0f) / f2;
        this.ch = MathHelper.a((float)i2 / f2, 0.0f, f1);
        this.cK = -1;
    }

    public void b(int i2) {
        this.cf = i2;
        this.cK = -1;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.cK = -1;
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.cK = -1;
    }

    public void a(Container container) {
        container.a(this.dn);
        container.a(this.dm);
        container.startOpen();
    }

    public void c() {
        this.a(this.bQ);
    }

    @Override
    public void f_() {
        super.f_();
        this.f.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void O_() {
        super.O_();
        this.f.b(new ClientboundPlayerCombatEndPacket(this.eS()));
    }

    @Override
    public void a(IBlockData iblockdata) {
        CriterionTriggers.e.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.gL();
        this.h.a();
        this.dh.a();
        if (this.aj > 0) {
            --this.aj;
        }
        this.bR.d();
        if (!this.bR.b(this)) {
            this.o();
            this.bR = this.bQ;
        }
        if ((entity = this.K()) != this) {
            if (entity.bJ()) {
                this.a(entity.dA(), entity.dC(), entity.dG(), entity.dL(), entity.dN());
                this.x().m().a(this);
                if (this.fZ()) {
                    this.d((Entity)this);
                }
            } else {
                this.d((Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.cS != null) {
            CriterionTriggers.v.a(this, this.cS, this.af - this.cT);
        }
        this.k();
        this.l();
        this.gT();
        this.cz.a(this, true);
    }

    private void gT() {
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.gz()) {
                attributemodifiable.a(cu);
            } else {
                attributemodifiable.e(cu);
            }
        }
        if ((attributemodifiable1 = this.g(GenericAttributes.j)) != null) {
            if (this.gz()) {
                attributemodifiable1.a(cv);
            } else {
                attributemodifiable1.e(cv);
            }
        }
    }

    public void h() {
        try {
            if (!this.ak() || !this.do()) {
                super.g();
            }
            for (int i2 = 0; i2 < this.gj().b(); ++i2) {
                ItemStack itemstack = this.gj().a(i2);
                if (itemstack.f()) continue;
                this.i(itemstack);
            }
            if (this.eG() != this.cH || this.cI != this.bS.a() || this.bS.c() == 0.0f != this.cJ) {
                this.f.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bS.a(), this.bS.c()));
                this.cH = this.eG();
                this.cI = this.bS.a();
                boolean bl = this.cJ = this.bS.c() == 0.0f;
            }
            if (this.eG() + this.fw() != this.cB) {
                this.cB = this.eG() + this.fw();
                this.a(IScoreboardCriteria.h, MathHelper.f(this.cB));
            }
            if (this.bS.a() != this.cC) {
                this.cC = this.bS.a();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cC));
            }
            if (this.cs() != this.cD) {
                this.cD = this.cs();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cD));
            }
            if (this.eR() != this.cE) {
                this.cE = this.eR();
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cE));
            }
            if (this.cg != this.cG) {
                this.cG = this.cg;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cG));
            }
            if (this.maxHealthCache != (double)this.eU()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cf != this.cF) {
                this.cF = this.cf;
                this.a(IScoreboardCriteria.m, MathHelper.f((float)this.cF));
            }
            if (this.cg != this.cK) {
                this.cK = this.cg;
                this.f.b(new PacketPlayOutExperience(this.ch, this.cg, this.cf));
            }
            if (this.af % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cf;
            }
            if (this.oldLevel != this.cf) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cf);
                this.oldLevel = this.cf;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void i(ItemStack itemstack) {
        Packet<?> packet;
        MapId mapid = itemstack.a(DataComponents.M);
        WorldMap worldmap = ItemWorldMap.a(mapid, this.dV());
        if (worldmap != null && (packet = worldmap.a(mapid, this)) != null) {
            this.f.b(packet);
        }
    }

    @Override
    protected void i() {
        if (this.dV().an() == EnumDifficulty.a && this.x().O().c(GameRules.l)) {
            if (this.af % 20 == 0) {
                float f2;
                if (this.eG() < this.eU()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f2 = this.bS.c()) < 20.0f) {
                    this.bS.b(f2 + 1.0f);
                }
            }
            if (this.af % 10 == 0 && this.bS.b()) {
                this.bS.a(this.bS.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        if (this.eG() > 0.0f && this.cX != null) {
            CriterionTriggers.X.a(this, this.cX);
        }
        this.cX = null;
        super.j();
    }

    public void k() {
        if (this.Z > 0.0 && this.cX == null) {
            this.cX = this.dt();
            if (this.cm != null && this.cm.e <= this.cX.e) {
                CriterionTriggers.ae.a(this, this.cm, this.cn);
            }
        }
    }

    public void l() {
        if (this.dk() != null && this.dk().bv()) {
            if (this.cZ == null) {
                this.cZ = this.dt();
            } else {
                CriterionTriggers.Y.a(this, this.cZ);
            }
        }
        if (!(this.cZ == null || this.dk() != null && this.dk().bv())) {
            this.cZ = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.a(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        ((Entity)this).a(GameEvent.p);
        boolean flag = this.x().O().c(GameRules.o);
        if (this.dQ()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.gj().b());
        boolean bl = keepInventory = this.x().O().c(GameRules.e) || this.ak();
        if (!keepInventory) {
            for (ItemStack item : this.gj()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.b(this.x(), damagesource, this.bb > 0);
        this.a(this.x(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.eS().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.bR != this.bQ) {
            this.o();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.eS().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.f.a(new ClientboundPlayerCombatKillPacket(this.ao(), ichatbasecomponent), PacketSendListener.a(() -> {
                int i2 = 256;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatbasecomponent2 = IChatBaseComponent.a("death.attack.even_more_magic", this.P_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable.e(ichatbasecomponent1)));
                return new ClientboundPlayerCombatKillPacket(this.ao(), ichatbasecomponent2);
            }));
            ScoreboardTeam scoreboardteambase = this.cq();
            if (scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).l() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.g.ag().a((EntityHuman)this, ichatbasecomponent);
                } else if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.g.ag().b(this, ichatbasecomponent);
                }
            } else {
                this.g.ag().a(ichatbasecomponent, false);
            }
        } else {
            this.f.b(new ClientboundPlayerCombatKillPacket(this.ao(), CommonComponents.a));
        }
        this.gy();
        if (this.x().O().c(GameRules.P)) {
            this.gU();
        }
        this.b(this.x(), damagesource.d());
        if (!event.getKeepInventory()) {
            this.gj().a();
        }
        this.d((Entity)this);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving entityliving = this.eT();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.an()));
            entityliving.a((Entity)this, damagesource);
            this.e(entityliving);
        }
        this.dV().a((Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aF();
        this.k(0);
        this.c(false);
        this.eS().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dV().aj(), this.dv())));
        this.v(false);
    }

    private void gU() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dv()).c(32.0, 10.0, 32.0);
        this.dV().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this.x(), this));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, damagesource);
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dV().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damagesource);
        }
    }

    private void a(ScoreHolder scoreholder, ScoreHolder scoreholder1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gA().e(scoreholder1.cI());
        if (scoreboardteam != null && (i2 = scoreboardteam.o().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.dV().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i2], scoreholder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        Entity entity1;
        EntityHuman entityhuman;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).p()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.gV() ? false : super.a(entityhuman);
    }

    private boolean gV() {
        return this.dV().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.a teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig entityplayer_respawnconfig = this.S();
        WorldServer worldserver = this.g.a(RespawnConfig.b(entityplayer_respawnconfig));
        if (worldserver != null && entityplayer_respawnconfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, entityplayer_respawnconfig, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.c, entityplayer_respawnposangle.b(), 0.0f, teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.a(this.g.J(), this, teleporttransition_a);
            }
        } else {
            teleportTransition = new TeleportTransition(this.g.J(), this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.f.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer worldserver, RespawnConfig entityplayer_respawnconfig, boolean flag) {
        BlockPosition blockposition = entityplayer_respawnconfig.c;
        float f2 = entityplayer_respawnconfig.d;
        boolean flag1 = entityplayer_respawnconfig.e;
        IBlockData iblockdata = worldserver.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (flag1 || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(worldserver)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bT, worldserver, blockposition);
            if (!flag1 && flag && optional.isPresent()) {
                worldserver.a(blockposition, (IBlockData)iblockdata.b(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(worldserver)) {
            return BlockBed.a(EntityTypes.bT, (ICollisionAccess)worldserver, blockposition, (EnumDirection)iblockdata.c(BlockBed.e), f2).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, true, false));
        }
        if (!flag1) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = worldserver.a_(blockposition.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.1, (double)blockposition.w() + 0.5), f2, false, false)) : Optional.empty();
    }

    public void m() {
        this.al();
        this.x().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleporttransition) {
        if (this.fR()) {
            return null;
        }
        if (this.dQ()) {
            return null;
        }
        if (teleporttransition.g()) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleporttransition.b();
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(absolutePosition.a(), (World)worldserver.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleporttransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleporttransition = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
        }
        if (!teleporttransition.h()) {
            this.aa();
        }
        if (worldserver != null && worldserver.aj() == worldserver1.aj()) {
            this.f.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
            this.f.l();
            teleporttransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.cY = this.dt();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("placing");
        this.cQ = true;
        WorldData worlddata = worldserver.C_();
        this.f.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.f.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerlist = this.g.ag();
        playerlist.e(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dS();
        this.a(worldserver);
        this.f.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        this.f.l();
        worldserver.d(this);
        gameprofilerfiller.c();
        this.g(worldserver1);
        this.fF();
        this.f.b(new PacketPlayOutAbilities(this.gk()));
        playerlist.a(this, worldserver);
        playerlist.f(this);
        playerlist.d(this);
        teleporttransition.j().onTransition(this);
        this.cK = -1;
        this.cH = -1.0f;
        this.cI = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dV().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float f2, float f1) {
        this.f.b(new ClientboundPlayerRotationPacket(f2, f1));
    }

    public void g(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.aj();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dV().aj();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dV());
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.j && maindimensionkey1 == net.minecraft.world.level.World.i && this.cY != null) {
            CriterionTriggers.D.a(this, this.cY);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.j) {
            this.cY = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.ak() ? this.K() == this : (this.ak() ? false : super.a(entityplayer));
    }

    @Override
    public void a(Entity entity, int i2) {
        super.a(entity, i2);
        this.bR.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fR() && this.bJ()) {
            if (!this.dV().F_().j() || !this.dV().F_().l()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.a));
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.c));
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.d));
            }
            this.setRespawnPosition(new RespawnConfig(this.dV().aj(), blockposition, this.dL(), false), true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.dV().V()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.b));
            }
            if (!this.gz()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dV().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a(this.x(), this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)EntityHuman.EnumBedResult.f));
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)((Object)EntityHuman.EnumBedResult.e));
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dV().a_(blockposition).c(BlockFacingHorizontal.e);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.x().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dV()).f();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dA() - vec3d.a()) <= 3.0 && Math.abs(this.dC() - vec3d.b()) <= 2.0 && Math.abs(this.dG() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.fR()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fP().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.dV().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dV().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fR()) {
            this.x().m().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.f != null) {
            this.f.teleport(this.dA(), this.dC(), this.dG(), this.dL(), this.dN(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) || this.P() && !damagesource.a(DamageTypes.m) || !this.gK();
    }

    @Override
    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        if (!this.ak()) {
            super.b(worldserver, blockposition);
        }
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.dg && flag && this.Z > 0.0) {
            Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.Z, 0.0, 200.0);
            this.x().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.dg = false;
        }
        super.a(d0, flag, iblockdata, blockposition);
    }

    @Override
    public void b_(@Nullable Entity entity) {
        super.b_(entity);
        this.cm = this.dt();
        this.cn = entity;
        this.w(entity != null && entity.an() == EntityTypes.bI);
    }

    @Override
    protected void n() {
        if (this.dV().u().i()) {
            super.n();
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.f.b(new PacketPlayOutBlockChange(this.dV(), tileentitysign.ax_()));
        this.f.b(new PacketPlayOutOpenSignEditor(tileentitysign.ax_(), flag));
    }

    public int nextContainerCounter() {
        this.dq = this.dq % 100 + 1;
        return this.dq;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.dq, this.gj(), this);
        if (container != null) {
            container.setTitle(itileinventory.P_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).c(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.ak()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bR = container;
        this.f.b(new PacketPlayOutOpenWindow(container.l, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.dq);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.f.b(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dq, this.gj(), iinventory, entityhorseabstract, entityhorseabstract.ab_());
        container.setTitle(entityhorseabstract.P_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.c(this);
            return;
        }
        if (this.bR != this.bQ) {
            this.o();
        }
        int i2 = entityhorseabstract.ab_();
        this.f.b(new PacketPlayOutOpenWindowHorse(this.dq, i2, entityhorseabstract.ao()));
        this.bR = container;
        this.a(this.bR);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.c(DataComponents.V)) {
            if (WrittenBookContent.a(itemstack, this.z(), this)) {
                this.bR.d();
            }
            this.f.b(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.f.b(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::e));
    }

    @Override
    public void o() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.f.b(new PacketPlayOutCloseWindow(this.bR.l));
        this.p();
    }

    @Override
    public void p() {
        this.bR.a(this);
        this.bQ.a(this.bR);
        this.bR = this.bQ;
    }

    @Override
    public void q() {
        double d0 = this.dA();
        double d1 = this.dC();
        double d2 = this.dG();
        super.q();
        this.q(this.dA() - d0, this.dC() - d1, this.dG() - d2);
    }

    public void a(double d0, double d1, double d2) {
        if (!this.bY() && !EntityPlayer.r(d0, d1, d2)) {
            if (this.cj()) {
                int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int j2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (j2 > 0) {
                    this.a(StatisticList.w, j2);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)j2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bi()) {
                int k2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (k2 > 0) {
                    this.a(StatisticList.s, k2);
                    this.causeFoodExhaustion(this.dV().spigotConfig.swimMultiplier * (float)k2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.k_()) {
                if (d1 > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(d1 * 100.0));
                }
            } else if (this.aH()) {
                int l2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (l2 > 0) {
                    if (this.ci()) {
                        this.a(StatisticList.r, l2);
                        this.causeFoodExhaustion(this.dV().spigotConfig.sprintMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.ch()) {
                        this.a(StatisticList.q, l2);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, l2);
                        this.causeFoodExhaustion(this.dV().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fJ()) {
                int i1 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.a(StatisticList.B, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (j1 > 25) {
                    this.a(StatisticList.v, j1);
                }
            }
        }
    }

    private void q(double d0, double d1, double d2) {
        if (this.bY() && !EntityPlayer.r(d0, d1, d2)) {
            int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.dk();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof AbstractBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    private static boolean r(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.cA.b(this, statistic, i2);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.b(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.cA.a(this, statistic, 0);
        this.dV().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> collection) {
        return this.cR.a(collection, this);
    }

    @Override
    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriterionTriggers.ac.a(this, recipeholder.a(), list);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(resourcekey -> this.g.aI().b((ResourceKey<IRecipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> collection) {
        return this.cR.b(collection, this);
    }

    @Override
    public void r() {
        super.r();
        this.a(StatisticList.E);
        if (this.ci()) {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dV().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int i2) {
        super.d(i2);
        this.cK = -1;
    }

    public void s() {
        this.cU = true;
        this.bN();
        if (this.fR()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cU;
    }

    public void u() {
        this.cH = -1.0E8f;
        this.cK = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void v() {
        if (!this.bm.f() && this.fz()) {
            this.f.b(new PacketPlayOutEntityStatus(this, 9));
            super.v();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.f.b(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.d, vec3d.e, vec3d.f));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.f.b(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.dh = entityplayer.dh;
        this.do = entityplayer.do;
        this.h.a(entityplayer.h.b(), entityplayer.h.c());
        this.w();
        if (flag) {
            this.fa().b(entityplayer.fa());
            this.d(entityplayer.eG());
            this.bS = entityplayer.bS;
            for (MobEffect mobEffect : entityplayer.eD()) {
            }
            this.gj().a(entityplayer.gj());
            this.cf = entityplayer.cf;
            this.cg = entityplayer.cg;
            this.ch = entityplayer.ch;
            this.q(entityplayer.gd());
            this.as = entityplayer.as;
        } else {
            this.fa().b(entityplayer.fa());
            if (this.x().O().c(GameRules.e) || entityplayer.ak()) {
                this.gj().a(entityplayer.gj());
                this.cf = entityplayer.cf;
                this.cg = entityplayer.cg;
                this.ch = entityplayer.ch;
                this.q(entityplayer.gd());
            }
        }
        this.ci = entityplayer.ci;
        this.bP = entityplayer.bP;
        this.ar().a(bK, (Byte)entityplayer.ar().a(bK));
        this.cK = -1;
        this.cH = -1.0f;
        this.cI = -1;
        this.i = entityplayer.i;
        this.cY = entityplayer.cY;
        this.db = entityplayer.db;
        this.k(entityplayer.gC());
        this.l(entityplayer.gD());
        ((EntityHuman)this).a(entityplayer.gJ());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        super.a(mobeffect, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ao(), mobeffect, true));
        if (mobeffect.a(MobEffects.y)) {
            this.cT = this.af;
            this.cS = this.dt();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        super.a(mobeffect, flag, entity);
        this.f.b(new PacketPlayOutEntityEffect(this.ao(), mobeffect, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> collection) {
        super.c(collection);
        for (MobEffect mobeffect : collection) {
            this.f.b(new PacketPlayOutRemoveEntityEffect(this.ao(), mobeffect.c()));
            if (!mobeffect.a(MobEffects.y)) continue;
            this.cS = null;
        }
        CriterionTriggers.B.a(this, (Entity)null);
    }

    @Override
    public void b(double d0, double d1, double d2) {
        this.f.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.f.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        if (this.fR()) {
            this.a(true, true);
        }
        if (flag) {
            this.d((Entity)this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, cause)) {
            this.r(set.contains((Object)Relative.d) ? this.cA() + f2 : f2);
        }
        return flag1;
    }

    @Override
    public void d(double d0, double d1, double d2) {
        super.d(d0, d1, d2);
        this.f.l();
    }

    @Override
    public void b(Entity entity) {
        this.x().m().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void c(Entity entity) {
        this.x().m().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void w() {
        if (this.f != null) {
            this.f.b(new PacketPlayOutAbilities(this.gk()));
            this.J();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.dV();
    }

    public boolean a(EnumGamemode enumgamemode) {
        boolean flag = this.ak();
        if (!this.h.a(enumgamemode)) {
            return false;
        }
        this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.gy();
            this.bO();
            EnchantmentManager.a(this);
        } else {
            this.d((Entity)this);
            if (flag) {
                EnchantmentManager.a(this.x(), (EntityLiving)this);
            }
        }
        this.w();
        this.fx();
        return true;
    }

    @Override
    @Nonnull
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener y() {
        return this.dp;
    }

    public CommandListenerWrapper z() {
        return new CommandListenerWrapper(this.y(), this.dt(), this.bT(), this.x(), this.F(), this.ah().getString(), this.P_(), this.g, this);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.x(flag)) {
            this.f.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    int i2 = 256;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatbasecomponent1).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.gX()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String A() {
        SocketAddress socketaddress = this.f.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.fy() != clientinformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fy() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.cW.equals(clientinformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientinformation.b());
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        this.cW = clientinformation.b();
        this.cV = clientinformation.c();
        this.cL = clientinformation.d();
        this.cN = clientinformation.e();
        this.de = clientinformation.h();
        this.df = clientinformation.i();
        this.cM = clientinformation.j();
        this.ar().a(bK, (byte)clientinformation.f());
        this.ar().a(bL, (byte)clientinformation.g().b());
    }

    public ClientInformation B() {
        byte i2 = (Byte)this.ar().a(bK);
        EnumMainHand enummainhand = EnumMainHand.d.apply(((Byte)this.ar().a(bL)).byteValue());
        return new ClientInformation(this.cW, this.cV, this.cL, this.cN, i2, enummainhand, this.de, this.df, this.cM);
    }

    public boolean C() {
        return this.cN;
    }

    public EnumChatVisibility D() {
        return this.cL;
    }

    private boolean x(boolean flag) {
        return this.cL == EnumChatVisibility.c ? flag : true;
    }

    private boolean gX() {
        return this.cL == EnumChatVisibility.a;
    }

    public int E() {
        return this.cV;
    }

    public void a(ServerPing serverping) {
        this.f.b(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a)));
    }

    @Override
    public int F() {
        return this.g.c(this.gi());
    }

    public void G() {
        this.cO = SystemUtils.c();
    }

    public ServerStatisticManager H() {
        return this.cA;
    }

    public RecipeBookServer I() {
        return this.cR;
    }

    @Override
    protected void J() {
        if (this.ak()) {
            this.eB();
            this.k(true);
        } else {
            super.J();
        }
    }

    public Entity K() {
        return this.cP == null ? this : this.cP;
    }

    public void d(@Nullable Entity entity) {
        Entity entity1 = this.K();
        Entity entity2 = this.cP = entity == null ? this : entity;
        if (entity1 != this.cP) {
            WorldServer worldserver;
            boolean result;
            net.minecraft.world.level.World world = this.cP.dV();
            if (world instanceof WorldServer && !(result = this.teleportTo(worldserver = (WorldServer)world, this.cP.dA(), this.cP.dC(), this.cP.dG(), Set.of(), this.dL(), this.dN(), false, PlayerTeleportEvent.TeleportCause.SPECTATE))) {
                this.cP = entity1;
                return;
            }
            if (entity != null) {
                this.x().m().a(this);
            }
            this.f.b(new PacketPlayOutCamera(this.cP));
            this.f.l();
        }
    }

    @Override
    protected void L() {
        if (!this.cQ) {
            super.L();
        }
    }

    @Override
    public void e(Entity entity) {
        if (this.ak()) {
            this.d(entity);
        } else {
            super.e(entity);
        }
    }

    public long M() {
        return this.cO;
    }

    @Nullable
    public IChatBaseComponent N() {
        return this.listName;
    }

    public int O() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.gF();
    }

    public boolean P() {
        return this.cQ;
    }

    public void Q() {
        this.cQ = false;
    }

    public AdvancementDataPlayer R() {
        return this.cz;
    }

    @Nullable
    public RespawnConfig S() {
        return this.dc;
    }

    public void b(EntityPlayer entityplayer) {
        this.a(entityplayer.dc, false);
    }

    public void a(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag) {
        this.setRespawnPosition(entityplayer_respawnconfig, flag, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag, PlayerSpawnChangeEvent.Cause cause) {
        Location newSpawn = null;
        boolean forced = false;
        if (entityplayer_respawnconfig != null) {
            WorldServer newWorld = this.g.a(entityplayer_respawnconfig.a());
            newSpawn = CraftLocation.toBukkit(entityplayer_respawnconfig.b(), (World)newWorld.getWorld(), entityplayer_respawnconfig.c(), 0.0f);
            forced = entityplayer_respawnconfig.d();
        }
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, forced, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        entityplayer_respawnconfig = newSpawn != null ? new RespawnConfig(((CraftWorld)newSpawn.getWorld()).getHandle().aj(), BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ()), newSpawn.getYaw(), event.isForced()) : null;
        if (flag && entityplayer_respawnconfig != null && !entityplayer_respawnconfig.a(this.dc)) {
            this.a(cw);
        }
        this.dc = entityplayer_respawnconfig;
    }

    public SectionPosition T() {
        return this.da;
    }

    public void a(SectionPosition sectionposition) {
        this.da = sectionposition;
    }

    public ChunkTrackingView U() {
        return this.db;
    }

    public void a(ChunkTrackingView chunktrackingview) {
        this.db = chunktrackingview;
    }

    @Override
    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundeffect), soundcategory, this.dA(), this.dC(), this.dG(), f2, f1, this.ae.g()));
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (flag1) {
            ItemStack itemstack1;
            ItemStack itemStack = itemstack1 = entityitem != null ? entityitem.e() : ItemStack.l;
            if (!itemstack1.f()) {
                this.a(StatisticList.f.b(itemstack1.h()), itemstack.M());
                this.a(StatisticList.F);
            }
        }
        return entityitem;
    }

    public ITextFilter V() {
        return this.dd;
    }

    public void a(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.h.a(worldserver);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbttagcompound, String s2) {
        return nbttagcompound != null ? (EnumGamemode)nbttagcompound.a(s2, EnumGamemode.g).orElse(null) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.g.bd();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.g.u());
    }

    public void e(@Nullable NBTTagCompound nbttagcompound) {
        this.h.a(this.b(EntityPlayer.a(nbttagcompound, "playerGameType")), EntityPlayer.a(nbttagcompound, "previousPlayerGameType"));
    }

    private void p(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("playerGameType", EnumGamemode.g, this.h.b());
        EnumGamemode enumgamemode = this.h.c();
        nbttagcompound.b("previousPlayerGameType", EnumGamemode.g, enumgamemode);
    }

    @Override
    public boolean W() {
        return this.de;
    }

    public boolean c(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.de || entityplayer.de;
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return super.c(worldserver, blockposition) && worldserver.a((Entity)this, blockposition);
    }

    @Override
    protected void a(ItemStack itemstack) {
        CriterionTriggers.W.a(this, itemstack);
        super.a(itemstack);
    }

    public boolean a(boolean flag) {
        PlayerInventory playerinventory = this.gj();
        ItemStack itemstack = playerinventory.a(flag);
        this.bR.b(playerinventory, playerinventory.f()).ifPresent(i2 -> this.bR.a(i2, playerinventory.g()));
        return this.a(itemstack, false, true) != null;
    }

    @Override
    public void b(ItemStack itemstack) {
        if (!this.gj().g(itemstack)) {
            this.a(itemstack, false);
        }
    }

    public boolean X() {
        return this.df;
    }

    @Override
    public Optional<WardenSpawnTracker> Y() {
        return Optional.of(this.dh);
    }

    public void b(boolean flag) {
        this.dg = flag;
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        Entity entity = entityitem.p();
        if (entity != null) {
            CriterionTriggers.S.a(this, entityitem.e(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.do = remotechatsession;
    }

    @Nullable
    public RemoteChatSession Z() {
        return this.do != null && this.do.b() ? null : this.do;
    }

    @Override
    public void a(double d0, double d1) {
        this.cl = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dL());
        this.f.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        if (super.a(entity, flag)) {
            entity.j(this);
            this.f.a(new PositionMoveRotation(this.dt(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.g.ag().a(entityliving, this.f);
            }
            this.f.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void aa() {
        Entity entity = this.dk();
        super.aa();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eD()) {
                this.f.b(new PacketPlayOutRemoveEntityEffect(entity.ao(), mobeffect.c()));
            }
        }
        if (entity != null) {
            this.f.b(new PacketPlayOutMount(entity));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.ai(), worldserver.aj(), BiomeManager.a(worldserver.E()), this.h.b(), this.h.c(), worldserver.ak(), worldserver.D(), this.gJ(), this.az(), worldserver.P());
    }

    public void c(BlockPosition blockposition) {
        this.di = blockposition;
    }

    public void ab() {
        this.di = null;
    }

    @Nullable
    public BlockPosition ac() {
        return this.di;
    }

    @Override
    public Vec3D ad() {
        Entity entity = this.dk();
        return entity != null && entity.cW() != this ? entity.ad() : this.dj;
    }

    public void a(Vec3D vec3d) {
        this.dj = vec3d;
    }

    @Override
    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return EnchantmentManager.a(this.x(), this.dZ(), entity, damagesource, f2);
    }

    @Override
    public void a(Item item, EnumItemSlot enumitemslot) {
        super.a(item, enumitemslot);
        this.b(StatisticList.d.b(item));
    }

    public Input ae() {
        return this.dk;
    }

    public void a(Input input) {
        this.dk = input;
    }

    public Vec3D af() {
        float f2;
        float f3 = this.dk.c() == this.dk.d() ? 0.0f : (f2 = this.dk.c() ? 1.0f : -1.0f);
        float f1 = this.dk.a() == this.dk.b() ? 0.0f : (this.dk.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dL());
    }

    public void a(EntityEnderPearl entityenderpearl) {
        this.dl.add(entityenderpearl);
    }

    public void b(EntityEnderPearl entityenderpearl) {
        this.dl.remove(entityenderpearl);
    }

    public Set<EntityEnderPearl> ag() {
        return this.dl;
    }

    public long c(EntityEnderPearl entityenderpearl) {
        net.minecraft.world.level.World world = entityenderpearl.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ChunkCoordIntPair chunkcoordintpair = entityenderpearl.dx();
            this.a(entityenderpearl);
            worldserver.i();
            return EntityPlayer.a(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair) {
        worldserver.m().a(TicketType.h, chunkcoordintpair, 2);
        return TicketType.h.d();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dV().af() + this.timeOffset;
        }
        return this.dV().af() - this.dV().af() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dV().C_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cI() + " at " + this.dA() + "," + this.dC() + "," + this.dG() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.f.l();
    }

    @Override
    public boolean fg() {
        return super.fg() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard gA() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.ch;
            this.newTotalExp = this.cg;
            this.newLevel = this.cf;
        }
        this.d(this.eU());
        this.fF();
        this.h(0);
        this.Z = 0.0;
        this.bS = new FoodMetaData();
        this.cf = this.newLevel;
        this.cg = this.newTotalExp;
        this.ch = 0.0f;
        this.aP = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bK = true;
        this.bR = this.bQ;
        this.ba = null;
        this.bL = null;
        this.bG = new CombatTracker(this);
        this.cK = -1;
        if (this.keepLevel) {
            this.ch = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        this.bY = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final ResourceKey<net.minecraft.world.level.World> b;
        private final BlockPosition c;
        private final float d;
        private final boolean e;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.World.h.optionalFieldOf("dimension", net.minecraft.world.level.World.i).forGetter(RespawnConfig::a), (App)BlockPosition.a.fieldOf("pos").forGetter(RespawnConfig::b), (App)Codec.FLOAT.optionalFieldOf("angle", (Object)Float.valueOf(0.0f)).forGetter(RespawnConfig::c), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::d)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(ResourceKey<net.minecraft.world.level.World> dimension, BlockPosition pos, float angle, boolean forced) {
            this.b = dimension;
            this.c = pos;
            this.d = angle;
            this.e = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null ? entityplayer_respawnconfig.a() : net.minecraft.world.level.World.i;
        }

        public boolean a(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null && this.b == entityplayer_respawnconfig.b && this.c.equals(entityplayer_respawnconfig.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "dimension;pos;angle;forced", "b", "c", "d", "e"}, this, o2);
        }

        public ResourceKey<net.minecraft.world.level.World> a() {
            return this.b;
        }

        public BlockPosition b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.b(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D vec3d, BlockPosition blockposition) {
            Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
            return (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

