/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger a = LogUtils.getLogger();
    protected WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode b = EnumGamemode.e;
    @Nullable
    private EnumGamemode e;
    private boolean f;
    private int g;
    private BlockPosition h = BlockPosition.c;
    private int i;
    private boolean j;
    private BlockPosition k = BlockPosition.c;
    private int l;
    private int m = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer entityplayer) {
        this.d = entityplayer;
        this.c = entityplayer.x();
    }

    public boolean a(EnumGamemode enumgamemode) {
        if (enumgamemode == this.b) {
            return false;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)enumgamemode.a()));
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.a(enumgamemode, this.e);
        this.d.w();
        this.d.g.ag().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.f();
        if (enumgamemode == EnumGamemode.b) {
            this.d.gQ();
        }
        return true;
    }

    protected void a(EnumGamemode enumgamemode, @Nullable EnumGamemode enumgamemode1) {
        this.e = enumgamemode1;
        this.b = enumgamemode;
        enumgamemode.a(this.d.gk());
    }

    public EnumGamemode b() {
        return this.b;
    }

    @Nullable
    public EnumGamemode c() {
        return this.e;
    }

    public boolean d() {
        return this.b.h();
    }

    public boolean e() {
        return this.b.g();
    }

    public void a() {
        this.i = MinecraftServer.currentTick;
        if (this.j) {
            IBlockData iblockdata = this.c.a_(this.k);
            if (iblockdata.l()) {
                this.j = false;
            } else {
                float f2 = this.a(iblockdata, this.k, this.l);
                if (f2 >= 1.0f) {
                    this.j = false;
                    this.a(this.k);
                }
            }
        } else if (this.f) {
            IBlockData iblockdata1 = this.c.a_(this.h);
            if (iblockdata1.l()) {
                this.c.a(this.d.ao(), this.h, -1);
                this.m = -1;
                this.f = false;
            } else {
                this.a(iblockdata1, this.h, this.g);
            }
        }
    }

    private float a(IBlockData iblockdata, BlockPosition blockposition, int i2) {
        int j2 = this.i - i2;
        float f2 = iblockdata.a(this.d, this.d.dV(), blockposition) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.m) {
            this.c.a(this.d.ao(), blockposition, k2);
            this.m = k2;
        }
        return f2;
    }

    private void a(BlockPosition blockposition, boolean flag, int i2, String s2) {
    }

    public void a(BlockPosition blockposition, PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype, EnumDirection enumdirection, int i2, int j2) {
        if (!this.d.a(blockposition, 1.0)) {
            this.a(blockposition, false, j2, "too far");
        } else if (blockposition.v() > i2) {
            this.d.f.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, j2, "too high");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((Entity)this.d, blockposition)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.gj().g(), EnumHand.a);
                this.d.f.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "may not interact");
                this.d.f.b(new ClientboundBlockChangedAckPacket(j2));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.f.b(tileentity.au_());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.d.gj().g(), EnumHand.a);
            if (event.isCancelled()) {
                this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                this.d.f.b(new ClientboundBlockChangedAckPacket(j2));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.f.b(tileentity.au_());
                }
                return;
            }
            if (this.d.gk().d) {
                this.a(blockposition, j2, "creative destroy");
                return;
            }
            if (this.d.fb().a(Items.wI) && ((ItemDebugStick)Items.wI).a(this.d, this.c.a_(blockposition), this.c, blockposition, false, this.d.fb())) {
                this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (this.d.a((World)this.c, blockposition, this.b)) {
                this.d.f.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
                this.a(blockposition, false, j2, "block action restricted");
                return;
            }
            this.g = this.i;
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(blockposition);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                IBlockData data = this.c.a_(blockposition);
                if (data.b() instanceof BlockDoor) {
                    boolean bottom = data.c(BlockDoor.c) == BlockPropertyDoubleBlockHalf.b;
                    this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                    this.d.f.b(new PacketPlayOutBlockChange(this.c, bottom ? blockposition.d() : blockposition.e()));
                } else if (data.b() instanceof BlockTrapdoor) {
                    this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                }
            } else if (!iblockdata.l()) {
                EnchantmentManager.a(this.c, this.d.fb(), this.d, this.d, EnumItemSlot.a, Vec3D.b(blockposition), iblockdata, item -> this.d.a((Item)item, EnumItemSlot.a));
                iblockdata.a((World)this.c, blockposition, this.d);
                f2 = iblockdata.a(this.d, this.d.dV(), blockposition);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, blockposition, this.d.gj().g(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.l() && f2 >= 1.0f) {
                this.a(blockposition, j2, "insta mine");
            } else {
                if (this.f) {
                    this.d.f.b(new PacketPlayOutBlockChange(this.h, this.c.a_(this.h)));
                    this.a(blockposition, false, j2, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.f = true;
                this.h = blockposition.j();
                int k2 = (int)(f2 * 10.0f);
                this.c.a(this.d.ao(), blockposition, k2);
                this.a(blockposition, true, j2, "actual start of destroying");
                this.m = k2;
            }
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (blockposition.equals(this.h)) {
                int l2 = this.i - this.g;
                IBlockData iblockdata1 = this.c.a_(blockposition);
                if (!iblockdata1.l()) {
                    float f1 = iblockdata1.a(this.d, this.d.dV(), blockposition) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.f = false;
                        this.c.a(this.d.ao(), blockposition, -1);
                        this.a(blockposition, j2, "destroyed");
                        return;
                    }
                    if (!this.j) {
                        this.f = false;
                        this.j = true;
                        this.k = blockposition;
                        this.l = this.g;
                    }
                }
            }
            this.a(blockposition, true, j2, "stopped destroying");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.f = false;
            if (!Objects.equals(this.h, blockposition)) {
                a.debug("Mismatch in destroy block pos: {} {}", (Object)this.h, (Object)blockposition);
                this.c.a(this.d.ao(), this.h, -1);
                this.a(blockposition, true, j2, "aborted mismatched destroying");
            }
            this.c.a(this.d.ao(), blockposition, -1);
            this.a(blockposition, true, j2, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, blockposition, this.d.gj().g());
        }
    }

    public void a(BlockPosition blockposition, int i2, String s2) {
        if (this.destroyBlock(blockposition, i2)) {
            this.a(blockposition, true, i2, s2);
        } else {
            this.d.f.b(new PacketPlayOutBlockChange(blockposition, this.c.a_(blockposition)));
            this.a(blockposition, false, i2, s2);
        }
    }

    public boolean a(BlockPosition blockposition) {
        return this.destroyBlock(blockposition, -1);
    }

    public boolean destroyBlock(BlockPosition blockposition, int ack) {
        IBlockData iblockdata = this.c.a_(blockposition);
        CraftBlock bblock = CraftBlock.at(this.c, blockposition);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.d.fb().a(iblockdata, (World)this.c, blockposition, (EntityHuman)this.d);
            if (this.c.c_(blockposition) == null && !isSwordNoBreak) {
                PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(blockposition, Blocks.a.m());
                this.d.f.b(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(blockposition);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.a(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.d(nmsBlock.m())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, blockposition, itemstack, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition));
                for (EnumDirection dir : EnumDirection.values()) {
                    this.d.f.b(new PacketPlayOutBlockChange(this.c, blockposition.a(dir)));
                }
                this.d.f.b(new ClientboundBlockChangedAckPacket(ack));
                TileEntity tileentity = this.c.c_(blockposition);
                if (tileentity != null) {
                    this.d.f.b(tileentity.au_());
                }
                return false;
            }
        }
        if ((iblockdata = this.c.a_(blockposition)).l()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof GameMasterBlock && !this.d.gH()) {
            this.c.a(blockposition, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a((World)this.c, blockposition, this.b)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList();
        IBlockData iblockdata1 = block.a((World)this.c, blockposition, iblockdata, this.d);
        boolean flag = this.c.a(blockposition, false);
        if (flag) {
            block.a((GeneratorAccess)this.c, blockposition, iblockdata1);
        }
        if (!this.d.gl()) {
            ItemStack itemstack = this.d.fb();
            ItemStack itemstack1 = itemstack.v();
            boolean flag1 = this.d.d(iblockdata1);
            itemstack.a(this.c, iblockdata1, blockposition, (EntityHuman)this.d);
            if (flag && flag1 && event.isDropItems()) {
                block.a(this.c, this.d, blockposition, iblockdata1, tileentity, itemstack1);
            }
        }
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, this.c.captureDrops);
        }
        this.c.captureDrops = null;
        if (flag && event != null) {
            iblockdata.b().a(this.c, blockposition, event.getExpToDrop());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand) {
        ItemStack itemstack1;
        if (this.b == EnumGamemode.d) {
            return EnumInteractionResult.e;
        }
        if (entityplayer.gG().a(itemstack)) {
            return EnumInteractionResult.e;
        }
        int i2 = itemstack.M();
        int j2 = itemstack.o();
        EnumInteractionResult enuminteractionresult = itemstack.a(world, (EntityHuman)entityplayer, enumhand);
        if (enuminteractionresult instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d enuminteractionresult_d = (EnumInteractionResult.d)enuminteractionresult;
            itemstack1 = Objects.requireNonNullElse(enuminteractionresult_d.d(), entityplayer.b(enumhand));
        } else {
            itemstack1 = entityplayer.b(enumhand);
        }
        if (itemstack1 == itemstack && itemstack1.M() == i2 && itemstack1.a(entityplayer) <= 0 && itemstack1.o() == j2) {
            return enuminteractionresult;
        }
        if (enuminteractionresult instanceof EnumInteractionResult.a && itemstack1.a(entityplayer) > 0 && !entityplayer.fz()) {
            return enuminteractionresult;
        }
        if (itemstack != itemstack1) {
            entityplayer.a(enumhand, itemstack1);
        }
        if (itemstack1.f()) {
            entityplayer.a(enumhand, ItemStack.l);
        }
        if (!entityplayer.fz()) {
            entityplayer.bQ.b();
        }
        return enuminteractionresult;
    }

    public EnumInteractionResult a(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.b();
        IBlockData iblockdata = world.a_(blockposition);
        boolean cancelledBlock = false;
        if (!iblockdata.b().a(world.K())) {
            return EnumInteractionResult.d;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (entityplayer.gG().a(itemstack)) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entityplayer, Action.RIGHT_CLICK_BLOCK, blockposition, movingobjectpositionblock.c(), itemstack, cancelledBlock, enumhand, movingobjectpositionblock.g());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.j();
        this.interactHand = enumhand;
        this.interactItemStack = itemstack.v();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.b() instanceof BlockDoor) {
                boolean bottom = iblockdata.c(BlockDoor.c) == BlockPropertyDoubleBlockHalf.b;
                entityplayer.f.b(new PacketPlayOutBlockChange(world, bottom ? blockposition.d() : blockposition.e()));
            } else if (iblockdata.b() instanceof BlockCake) {
                entityplayer.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.h() instanceof ItemBisected) {
                entityplayer.f.b(new PacketPlayOutBlockChange(world, blockposition.a(movingobjectpositionblock.c()).d()));
                entityplayer.f.b(new PacketPlayOutBlockChange(world, blockposition.d()));
            }
            entityplayer.getBukkitEntity().updateInventory();
            return event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.e;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            if (itileinventory != null) {
                entityplayer.a(itileinventory);
                return EnumInteractionResult.c;
            }
            return EnumInteractionResult.e;
        }
        boolean flag = !entityplayer.fb().f() || !entityplayer.fc().f();
        boolean flag1 = entityplayer.fY() && flag;
        ItemStack itemstack1 = itemstack.v();
        if (!flag1) {
            EnumInteractionResult enuminteractionresult1;
            EnumInteractionResult enuminteractionresult = iblockdata.a(entityplayer.b(enumhand), world, entityplayer, enumhand, movingobjectpositionblock);
            if (enuminteractionresult.a()) {
                CriterionTriggers.N.a(entityplayer, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (enuminteractionresult instanceof EnumInteractionResult.f && enumhand == EnumHand.a && (enuminteractionresult1 = iblockdata.a(world, entityplayer, movingobjectpositionblock)).a()) {
                CriterionTriggers.O.a(entityplayer, blockposition);
                return enuminteractionresult1;
            }
        }
        if (!itemstack.f() && !this.interactResult) {
            EnumInteractionResult enuminteractionresult2;
            ItemActionContext itemactioncontext = new ItemActionContext(entityplayer, enumhand, movingobjectpositionblock);
            if (entityplayer.fV()) {
                int i2 = itemstack.M();
                enuminteractionresult2 = itemstack.a(itemactioncontext);
                itemstack.e(i2);
            } else {
                enuminteractionresult2 = itemstack.a(itemactioncontext);
            }
            if (enuminteractionresult2.a()) {
                CriterionTriggers.N.a(entityplayer, blockposition, itemstack1);
            }
            return enuminteractionresult2;
        }
        return EnumInteractionResult.e;
    }

    public void a(WorldServer worldserver) {
        this.c = worldserver;
    }
}

