/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R4.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider E = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger F = LogUtils.getLogger();
    private static final int G = 300;
    private static final int H = 65536;
    final List<EntityPlayer> I = Lists.newArrayList();
    private final ChunkProviderServer J;
    private final MinecraftServer K;
    public final WorldDataServer L;
    private int M;
    final EntityTickList N = new EntityTickList();
    public final PersistentEntitySectionManager<Entity> O;
    private final GameEventDispatcher P;
    public boolean e;
    private final SleepStatus Q;
    private int R;
    private final PortalTravelAgent S;
    private final TickListServer<Block> T = new TickListServer(this::d);
    private final TickListServer<FluidType> U = new TickListServer(this::d);
    private final PathTypeCache V = new PathTypeCache();
    final Set<EntityInsentient> W = new ObjectOpenHashSet();
    volatile boolean X;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> Y = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> Z = new ArrayList<BlockActionData>(64);
    private boolean aa;
    private final List<MobSpawner> ab;
    @Nullable
    private EnderDragonBattle ac;
    final Int2ObjectMap<EntityComplexPart> ad = new Int2ObjectOpenHashMap();
    private final StructureManager ae;
    private final StructureCheck af;
    private final boolean ag;
    private final RandomSequences ah;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;

    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.J.a(x2, z2, false);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.ba(), worlddimension.a(), false, flag, i2, minecraftserver.bj(), gen, biomeProvider, env);
        this.pvpMode = minecraftserver.ac();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.ag = flag1;
        this.K = minecraftserver;
        this.ab = list;
        this.L = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.L.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.K.ba().f(Registries.aG));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aX();
        DataFixer datafixer = minecraftserver.aC();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.s), this, minecraftserver);
        this.O = new PersistentEntitySectionManager<Entity>(Entity.class, new a(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.aY();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.O;
        Objects.requireNonNull(this.O);
        this.J = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, persistententitysectionmanager::a, () -> minecraftserver.J().w());
        this.J.h().b();
        this.S = new PortalTravelAgent(this);
        this.Z();
        this.ac();
        this.E_().a(minecraftserver.aw());
        this.f = this.w().a(PersistentRaid.a(this.ai()));
        if (!minecraftserver.U()) {
            iworlddataserver.a(minecraftserver.u());
        }
        long l2 = minecraftserver.aZ().y().c();
        this.af = new StructureCheck(this.J.n(), this.J_(), minecraftserver.aY(), resourcekey, chunkgenerator, this.J.i(), this, chunkgenerator.d(), l2, datafixer);
        this.ae = new StructureManager(this, this.L.y(), this.af);
        this.ac = this.aj() == net.minecraft.world.level.World.k && this.ai().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.L.y().c(), this.L.C()) : null;
        this.Q = new SleepStatus();
        this.P = new GameEventDispatcher(this);
        this.ah = Objects.requireNonNullElseGet(randomsequences, () -> this.w().a(RandomSequences.a));
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderdragonbattle) {
        this.ac = enderdragonbattle;
    }

    public void a(int i2, int j2, boolean flag, boolean flag1) {
        this.L.a(i2);
        this.L.c(j2);
        this.L.b(j2);
        this.L.b(flag);
        this.L.a(flag1);
    }

    @Override
    public Holder<BiomeBase> a(int i2, int j2, int k2) {
        return this.m().g().d().getNoiseBiome(i2, j2, k2, this.m().i().b());
    }

    public StructureManager b() {
        return this.ae;
    }

    public void a(BooleanSupplier booleansupplier) {
        int i2;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.aa = true;
        TickRateManager tickratemanager = this.u();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.E_().s();
            gameprofilerfiller.b("weather");
            this.aw();
            gameprofilerfiller.c();
        }
        if (this.Q.a(i2 = this.O().d(GameRules.R)) && this.Q.a(i2, this.I)) {
            TimeSkipEvent event = null;
            if (this.O().c(GameRules.m)) {
                long j2 = this.B.d() + 24000L;
                event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.af());
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.af() + event.getSkipAmount());
                }
            }
            if (event == null || !event.isCancelled()) {
                this.au();
            }
            if (this.O().c(GameRules.x) && this.ah()) {
                this.h();
            }
        }
        this.Z();
        if (flag) {
            this.c();
        }
        gameprofilerfiller.a("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.ak() && flag) {
            long k2 = this.ae();
            gameprofilerfiller.a("blockTicks");
            this.T.a(k2, 65536, this::c);
            gameprofilerfiller.b("fluidTicks");
            this.U.a(k2, 65536, this::a);
            gameprofilerfiller.c();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.b("raid");
        if (flag) {
            this.f.a(this);
        }
        gameprofilerfiller.b("chunkSource");
        this.m().a(booleansupplier, true);
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.ax();
            this.timings.doSounds.stopTiming();
        }
        this.aa = false;
        gameprofilerfiller.c();
        boolean flag1 = true;
        if (flag1) {
            this.i();
        }
        if (flag1 || this.R++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.ac != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.ac.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.N.a((Entity entity) -> {
                if (!entity.dQ() && !tickratemanager.a((Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dH();
                    gameprofilerfiller.c();
                    if (entity instanceof EntityPlayer || this.J.a.j().c(entity.dx().a())) {
                        Entity entity1 = entity.dk();
                        if (entity1 != null) {
                            if (!entity1.dQ() && entity1.y((Entity)entity)) {
                                return;
                            }
                            entity.bO();
                        }
                        gameprofilerfiller.a("tick");
                        this.a(this::a, entity);
                        gameprofilerfiller.c();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.Y();
        }
        gameprofilerfiller.a("entityManagement");
        this.O.a();
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long i2) {
        return this.J.a.j().d(i2);
    }

    protected void c() {
        if (this.ag) {
            long i2 = this.B.c() + 1L;
            this.L.a(i2);
            Profiler.a().a("scheduledFunctions");
            this.L.s().a(this.K, i2);
            Profiler.a().c();
            if (this.L.o().c(GameRules.m)) {
                this.b(this.B.d() + 1L);
            }
        }
    }

    public void b(long i2) {
        this.L.b(i2);
    }

    public void a(boolean flag, boolean flag1) {
        for (MobSpawner mobspawner : this.ab) {
            mobspawner.a(this, flag, flag1);
        }
    }

    private void au() {
        this.Q.a();
        this.I.stream().filter(EntityLiving::fR).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    public void a(Chunk chunk, int i2) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("iceandsnow");
        for (int l2 = 0; l2 < i2; ++l2) {
            if (this.A.a(48) != 0) continue;
            this.a(this.a(j2, 0, k2, 15));
        }
        gameprofilerfiller.b("tickBlocks");
        if (i2 > 0) {
            ChunkSection[] achunksection = chunk.d();
            for (int i1 = 0; i1 < achunksection.length; ++i1) {
                ChunkSection chunksection = achunksection[i1];
                if (!chunksection.d()) continue;
                int j1 = chunk.h(i1);
                int k1 = SectionPosition.c(j1);
                for (int l1 = 0; l1 < i2; ++l1) {
                    Fluid fluid;
                    BlockPosition blockposition = this.a(j2, k1, k2, 15);
                    gameprofilerfiller.a("randomTick");
                    IBlockData iblockdata = chunksection.a(blockposition.u() - j2, blockposition.v() - k1, blockposition.w() - k2);
                    if (iblockdata.z()) {
                        iblockdata.b(this, blockposition, this.A);
                    }
                    if ((fluid = iblockdata.y()).f()) {
                        fluid.a(this, blockposition, this.A);
                    }
                    gameprofilerfiller.c();
                }
            }
        }
        gameprofilerfiller.c();
    }

    public void a(Chunk chunk) {
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.ah();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("thunder");
        if (flag && this.ag() && this.spigotConfig.thunderChance > 0 && this.A.a(this.spigotConfig.thunderChance) == 0 && this.r(blockposition = this.b(this.a(i2, 0, j2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.O().c(GameRules.f) && this.A.j() < (double)difficultydamagescaler.b() * 0.01 && !this.a_(blockposition.e()).a(Blocks.ta);
            if (flag1 && (entityhorseskeleton = EntityTypes.bh.a(this, EntitySpawnReason.h)) != null) {
                entityhorseskeleton.w(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.ax.a(this, EntitySpawnReason.h)) != null) {
                entitylightning.f(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        BlockPosition blockposition2 = blockposition1.e();
        BiomeBase biomebase = this.u(blockposition1).a();
        if (biomebase.a(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.ee.m(), null);
        }
        if (this.ah()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.O().d(GameRules.V);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.ed)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.ed.m(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.a(blockposition2, this.P())) != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition2);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition2, biomebase_precipitation);
            }
        }
    }

    private Optional<BlockPosition> F(BlockPosition blockposition) {
        Optional<BlockPosition> optional = this.A().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, blockposition, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, blockposition);
        Optional<BlockPosition> optional = this.F(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, blockposition1.h(this.ao() + 1)).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bJ() && this.h(entityliving.dv()));
        if (!list.isEmpty()) {
            return list.get(this.A.a(list.size())).dv();
        }
        if (blockposition1.v() == this.K_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean d() {
        return this.aa;
    }

    public boolean e() {
        return this.O().d(GameRules.R) <= 100;
    }

    private void av() {
        if (this.e() && (!this.p().U() || this.p().r())) {
            int i2 = this.O().d(GameRules.R);
            IChatMutableComponent ichatbasecomponent = this.Q.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.Q.b(), this.Q.b(i2));
            for (EntityPlayer entityplayer : this.I) {
                entityplayer.a(ichatbasecomponent, true);
            }
        }
    }

    public void f() {
        if (!this.I.isEmpty() && this.Q.a(this.I)) {
            this.av();
        }
    }

    public ScoreboardServer g() {
        return this.K.aJ();
    }

    private void aw() {
        int idx;
        boolean flag = this.ah();
        if (this.F_().g()) {
            if (this.O().c(GameRules.x)) {
                int i2 = this.L.f();
                int j2 = this.L.h();
                int k2 = this.L.j();
                boolean flag1 = this.B.g();
                boolean flag2 = this.B.i();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.A) : E.a(this.A);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.A) : b.a(this.A);
                    }
                }
                this.L.b(j2);
                this.L.c(k2);
                this.L.a(i2);
                this.L.a(flag1);
                this.L.b(flag2);
            }
            this.y = this.z;
            this.z = this.B.g() ? (this.z += 0.01f) : (this.z -= 0.01f);
            this.z = MathHelper.a(this.z, 0.0f, 1.0f);
            this.w = this.x;
            this.x = this.B.i() ? (this.x += 0.01f) : (this.x -= 0.01f);
            this.x = MathHelper.a(this.x, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.I.size(); ++idx) {
            if (this.I.get(idx).dV() != this) continue;
            this.I.get(idx).tickWeather();
        }
        if (flag != this.ah()) {
            for (idx = 0; idx < this.I.size(); ++idx) {
                if (this.I.get(idx).dV() != this) continue;
                this.I.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.I.size(); ++idx) {
            if (this.I.get(idx).dV() != this) continue;
            this.I.get(idx).updateWeather(this.w, this.x, this.y, this.z);
        }
    }

    @VisibleForTesting
    public void h() {
        this.L.b(false);
        if (!this.L.i()) {
            this.L.c(0);
        }
        this.L.a(false);
        if (!this.L.g()) {
            this.L.b(0);
        }
    }

    public void i() {
        this.R = 0;
    }

    private void a(BlockPosition blockposition, FluidType fluidtype) {
        IBlockData iblockdata = this.a_(blockposition);
        Fluid fluid = iblockdata.y();
        if (fluid.b(fluidtype)) {
            fluid.a(this, blockposition, iblockdata);
        }
    }

    private void c(BlockPosition blockposition, Block block) {
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.a(block)) {
            iblockdata.a(this, blockposition, this.A);
        }
    }

    public void a(Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.af;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.bx();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        ++entity.af;
        gameprofilerfiller.a(() -> BuiltInRegistries.f.b(entity.an()).toString());
        gameprofilerfiller.f("tickNonPassenger");
        entity.g();
        entity.postTick();
        gameprofilerfiller.c();
        for (Entity entity1 : entity.cY()) {
            this.a(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void a(Entity entity, Entity entity1) {
        if (!entity1.dQ() && entity1.dk() == entity) {
            if (entity1 instanceof EntityHuman || this.N.c(entity1)) {
                entity1.bx();
                ++entity1.af;
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a(() -> BuiltInRegistries.f.b(entity1.an()).toString());
                gameprofilerfiller.f("tickPassenger");
                entity1.q();
                entity1.postTick();
                gameprofilerfiller.c();
                for (Entity entity2 : entity1.cY()) {
                    this.a(entity1, entity2);
                }
            }
        } else {
            entity1.bO();
        }
    }

    @Override
    public boolean a(Entity entity, BlockPosition blockposition) {
        EntityHuman entityhuman;
        if (entity instanceof EntityHuman && (this.K.a(this, blockposition, entityhuman = (EntityHuman)entity) || !this.E_().a(blockposition))) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    public void a(@Nullable IProgressUpdate iprogressupdate, boolean flag, boolean flag1) {
        ChunkProviderServer chunkproviderserver = this.m();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.b(flag);
            if (iprogressupdate != null) {
                iprogressupdate.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            chunkproviderserver.a(flag);
            if (flag) {
                this.O.c();
            } else {
                this.O.b();
            }
        }
        WorldServer worldserver1 = this;
        this.L.a(worldserver1.E_().t());
        this.L.a(this.K.aM().a(this.J_()));
        this.convertable.a(this.K.ba(), this.L, this.K.ag().r());
    }

    private void b(boolean flag) {
        if (this.ac != null) {
            this.L.a(this.ac.b());
        }
        WorldPersistentData worldpersistentdata = this.m().l();
        if (flag) {
            worldpersistentdata.b();
        } else {
            worldpersistentdata.a();
        }
    }

    public <T extends Entity> List<? extends T> a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.H().a(entitytypetest, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> j() {
        return this.a(EntityTypes.Q, EntityLiving::bJ);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int i2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.I) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i2) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer k() {
        List<EntityPlayer> list = this.a(EntityLiving::bJ);
        return list.isEmpty() ? null : list.get(this.A.a(list.size()));
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.c(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    public void b(EntityPlayer entityplayer) {
        this.c(entityplayer);
    }

    private void c(EntityPlayer entityplayer) {
        Entity entity = this.b(entityplayer.cG());
        if (entity != null) {
            F.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.cG());
            entity.al();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.O.a(entityplayer);
    }

    private boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.dQ()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.O.a(entity);
    }

    public boolean e(Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.da().map(Entity::cG);
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.O;
        Objects.requireNonNull(this.O);
        if (stream.anyMatch(persistententitysectionmanager::a)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void b(Chunk chunk) {
        for (TileEntity tileentity : chunk.I().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                h2.closeInventory();
            }
        }
        chunk.J();
        chunk.c(this);
    }

    public void a(EntityPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.remove(entity_removalreason, null);
    }

    public boolean strikeLightning(Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int i2, BlockPosition blockposition, int j2) {
        EntityHuman entityhuman = null;
        Entity entity = this.a(i2);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        for (EntityPlayer entityplayer : this.K.ag().t()) {
            if (entityplayer == null || entityplayer.dV() != this || entityplayer.ao() == i2) continue;
            double d0 = (double)blockposition.u() - entityplayer.dA();
            double d1 = (double)blockposition.v() - entityplayer.dC();
            double d2 = (double)blockposition.w() - entityplayer.dG();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.f.b(new PacketPlayOutBlockBreakAnimation(i2, blockposition, j2));
        }
    }

    @Override
    public void a(@Nullable Entity entity, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.K.ag();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, d0, d1, d2, holder.a().a(f2), this.aj(), new PacketPlayOutNamedSoundEffect(holder, soundcategory, d0, d1, d2, f2, f1, i2));
    }

    @Override
    public void a(@Nullable Entity entity, Entity entity1, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.K.ag();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, entity1.dA(), entity1.dC(), entity1.dG(), holder.a().a(f2), this.aj(), new PacketPlayOutEntitySound(holder, soundcategory, entity1, f2, f1, i2));
    }

    @Override
    public void b(int i2, BlockPosition blockposition, int j2) {
        if (this.O().c(GameRules.Y)) {
            this.K.ag().t().forEach(entityplayer -> {
                Vec3D vec3d;
                if (entityplayer.dV() == this) {
                    Vec3D vec3d1 = Vec3D.b(blockposition);
                    if (entityplayer.g(vec3d1) < (double)MathHelper.h(32)) {
                        vec3d = vec3d1;
                    } else {
                        Vec3D vec3d2 = vec3d1.d(entityplayer.dt()).d();
                        vec3d = entityplayer.dt().e(vec3d2.c(32.0));
                    }
                } else {
                    vec3d = entityplayer.dt();
                }
                entityplayer.f.b(new PacketPlayOutWorldEvent(i2, BlockPosition.a(vec3d), j2, true));
            });
        } else {
            this.a((Entity)null, i2, blockposition, j2);
        }
    }

    @Override
    public void a(@Nullable Entity entity, int i2, BlockPosition blockposition, int j2) {
        EntityHuman entityhuman1;
        PlayerList playerlist = this.K.ag();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        playerlist.a(entityhuman, blockposition.u(), blockposition.v(), blockposition.w(), 64.0, this.aj(), new PacketPlayOutWorldEvent(i2, blockposition, j2, false));
    }

    public int l() {
        return this.F_().p();
    }

    @Override
    public void a(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
        this.P.a(holder, vec3d, gameevent_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, int i2) {
        if (this.X) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.m().a(blockposition);
        this.V.a(blockposition);
        VoxelShape voxelshape = iblockdata.g(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.g(this, blockposition);
        if (VoxelShapes.c(voxelshape, voxelshape1, OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.W.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(blockposition, iblockdata, iblockdata1, i2);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.N();
                if (!navigationabstract.b(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.X = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.h();
                }
            }
            finally {
                this.X = false;
            }
        }
    }

    @Override
    public void a(BlockPosition blockposition, Block block) {
        this.a(blockposition, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
        this.t.a(blockposition, block, null, orientation);
    }

    @Override
    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection, @Nullable Orientation orientation) {
        this.t.a(blockposition, block, enumdirection, orientation);
    }

    @Override
    public void b(BlockPosition blockposition, Block block, @Nullable Orientation orientation) {
        this.t.a(blockposition, block, orientation);
    }

    @Override
    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        this.t.a(iblockdata, blockposition, block, orientation, flag);
    }

    @Override
    public void a(Entity entity, byte b0) {
        this.m().a(entity, new PacketPlayOutEntityStatus(entity, b0));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        this.m().a(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    public ChunkProviderServer m() {
        return this.J;
    }

    @Override
    public void a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        this.explode0(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, particleparam, particleparam1, holder);
    }

    public ServerExplosion explode0(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        Explosion.Effect explosion_effect1 = switch (world_a) {
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.S);
            case World.a.c -> this.O().c(GameRules.d) ? this.a(GameRules.T) : Explosion.Effect.a;
            case World.a.d -> this.a(GameRules.U);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
            default -> throw new MatchException(null, null);
        };
        Vec3D vec3d = new Vec3D(d0, d1, d2);
        ServerExplosion serverexplosion = new ServerExplosion(this, entity, damagesource, explosiondamagecalculator, vec3d, f2, flag, explosion_effect1);
        serverexplosion.i();
        if (serverexplosion.wasCanceled) {
            return serverexplosion;
        }
        ParticleParam particleparam2 = serverexplosion.l() ? particleparam : particleparam1;
        for (EntityPlayer entityplayer : this.I) {
            if (!(entityplayer.g(vec3d) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverexplosion.j().get(entityplayer));
            entityplayer.f.b(new PacketPlayOutExplosion(vec3d, optional, particleparam2, holder));
        }
        return serverexplosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gamerules_gamerulekey) {
        return this.O().c(gamerules_gamerulekey) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.Y.add((Object)new BlockActionData(blockposition, block, i2, j2));
    }

    private void ax() {
        this.Z.clear();
        while (!this.Y.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.Y.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.K.ag().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.aj(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.Z.add(blockactiondata);
        }
        this.Y.addAll(this.Z);
    }

    private boolean a(BlockActionData blockactiondata) {
        IBlockData iblockdata = this.a_(blockactiondata.a());
        return iblockdata.a(blockactiondata.b()) ? iblockdata.a((net.minecraft.world.level.World)this, blockactiondata.a(), blockactiondata.c(), blockactiondata.d()) : false;
    }

    public TickListServer<Block> n() {
        return this.T;
    }

    public TickListServer<FluidType> o() {
        return this.U;
    }

    @Override
    @Nonnull
    public MinecraftServer p() {
        return this.K;
    }

    public PortalTravelAgent q() {
        return this.S;
    }

    public StructureTemplateManager r() {
        return this.K.aY();
    }

    public <T extends ParticleParam> int a(T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, false, false, d0, d1, d2, i2, d3, d4, d5, d6);
    }

    public <T extends ParticleParam> int a(T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticlesSource(null, t0, flag, flag1, d0, d1, d2, i2, d3, d4, d5, d6);
    }

    public <T extends ParticleParam> int sendParticlesSource(EntityPlayer sender, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (int k2 = 0; k2 < this.I.size(); ++k2) {
            EntityPlayer entityplayer = this.I.get(k2);
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, flag, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer entityplayer, T t0, boolean flag, boolean flag1, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(t0, flag, flag1, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        return this.a(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean a(EntityPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.dV() != this) {
            return false;
        }
        BlockPosition blockposition = entityplayer.dv();
        if (blockposition.a(new Vec3D(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.f.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity a(int i2) {
        return this.H().a(i2);
    }

    @Deprecated
    @Nullable
    public Entity b(int i2) {
        Entity entity = this.H().a(i2);
        return entity != null ? entity : (Entity)this.ad.get(i2);
    }

    @Override
    public Collection<EntityComplexPart> s() {
        return this.ad.values();
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> tagkey, BlockPosition blockposition, int i2, boolean flag) {
        if (!this.L.y().d()) {
            return null;
        }
        Optional optional = this.J_().f(Registries.be).a(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.m().g().a(this, (HolderSet)optional.get(), blockposition, i2, flag);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition blockposition, int i2, int j2, int k2) {
        return this.m().g().d().a(blockposition, i2, j2, k2, predicate, this.m().i().b(), this);
    }

    public CraftingManager t() {
        return this.K.aI();
    }

    @Override
    public TickRateManager u() {
        return this.K.aP();
    }

    @Override
    public boolean v() {
        return this.e;
    }

    public WorldPersistentData w() {
        return this.m().l();
    }

    @Override
    @Nullable
    public WorldMap a(MapId mapid) {
        WorldMap worldmap = this.p().J().w().b(WorldMap.a(mapid));
        if (worldmap != null) {
            worldmap.id = mapid;
        }
        return worldmap;
    }

    public void a(MapId mapid, WorldMap worldmap) {
        worldmap.id = mapid;
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.p().J().w().a(WorldMap.a(mapid), worldmap);
    }

    public MapId x() {
        return this.p().J().w().a(PersistentIdCounts.b).a();
    }

    public void a(BlockPosition blockposition, float f2) {
        int i2;
        BlockPosition blockposition1 = this.B.a();
        float f1 = this.B.b();
        if (!blockposition1.equals(blockposition) || f1 != f2) {
            this.B.a(blockposition, f2);
            SpawnChangeEvent event = new SpawnChangeEvent((World)this.getWorld(), CraftLocation.toBukkit(blockposition, (World)this.getWorld(), f1, 0.0f));
            this.getCraftServer().getPluginManager().callEvent((Event)event);
            this.p().ag().a(new PacketPlayOutSpawnPosition(blockposition, f2));
        }
        if (this.M > 1) {
            this.m().b(TicketType.b, new ChunkCoordIntPair(blockposition1), this.M);
        }
        if ((i2 = this.O().d(GameRules.ac) + 1) > 1) {
            this.m().a(TicketType.b, new ChunkCoordIntPair(blockposition), i2);
        }
        this.M = i2;
    }

    public LongSet y() {
        return this.J.k();
    }

    public boolean a(int i2, int j2, boolean flag) {
        boolean flag1 = this.J.a(new ChunkCoordIntPair(i2, j2), flag);
        if (flag && flag1) {
            this.d(i2, j2);
        }
        return flag1;
    }

    public List<EntityPlayer> z() {
        return this.I;
    }

    @Override
    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(iblockdata1))) {
            BlockPosition blockposition1 = blockposition.j();
            optional.ifPresent(holder -> this.p().execute(() -> {
                this.A().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.p().execute(() -> {
                this.A().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace A() {
        return this.m().m();
    }

    public boolean c(BlockPosition blockposition) {
        return this.a(blockposition, 1);
    }

    public boolean a(SectionPosition sectionposition) {
        return this.c(sectionposition.k());
    }

    public boolean a(BlockPosition blockposition, int i2) {
        return i2 > 6 ? false : this.b(SectionPosition.a(blockposition)) <= i2;
    }

    public int b(SectionPosition sectionposition) {
        return this.A().a(sectionposition);
    }

    public PersistentRaid B() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition blockposition) {
        return this.f.a(blockposition, 9216);
    }

    public boolean e(BlockPosition blockposition) {
        return this.d(blockposition) != null;
    }

    public void a(ReputationEvent reputationevent, Entity entity, ReputationHandler reputationhandler) {
        reputationhandler.a(reputationevent, entity);
    }

    public void a(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.m().a;
        try (BufferedWriter writer = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().a()));
            SpawnerCreature.d spawnercreature_d = this.m().o();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry object2intmap_entry : spawnercreature_d.b().object2IntEntrySet()) {
                    writer.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)object2intmap_entry.getKey()).a(), object2intmap_entry.getIntValue()));
                }
            }
            writer.write(String.format(Locale.ROOT, "entities: %s\n", this.O.e()));
            writer.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.s.size()));
            writer.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.n().a()));
            writer.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.o().a()));
            writer.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.m().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter writer1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            writer1.write(crashreport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter writer2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.a(writer2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter writer3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.O.a(writer3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter writer4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(writer4, this.H().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter writer5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(writer5);
        }
    }

    private static void a(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (Entity entity : iterable) {
            IChatBaseComponent ichatbasecomponent = entity.aj();
            IChatBaseComponent ichatbasecomponent1 = entity.P_();
            csvwriter.a(entity.dA(), entity.dC(), entity.dG(), entity.cG(), BuiltInRegistries.f.b(entity.an()), entity.bJ(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.s) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox structureboundingbox) {
        this.Y.removeIf(blockactiondata -> structureboundingbox.b(blockactiondata.a()));
    }

    @Override
    public float a(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<Entity> C() {
        return this.H().a();
    }

    public String toString() {
        return "ServerLevel[" + this.L.e() + "]";
    }

    public boolean D() {
        return this.L.z();
    }

    @Override
    public long E() {
        return this.L.y().c();
    }

    @Nullable
    public EnderDragonBattle F() {
        return this.ac;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String G() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.I.size(), this.O.e(), WorldServer.a(this.O.d().a(), (T entity) -> BuiltInRegistries.f.b(entity.an()).toString()), this.s.size(), WorldServer.a(this.s, TickingBlockEntity::d), this.n().a(), this.o().a(), this.J());
    }

    private static <T> String a(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s2 = function.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<Entity> H() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.O.d();
    }

    public void a(Stream<Entity> stream) {
        this.O.a(stream);
    }

    public void b(Stream<Entity> stream) {
        this.O.b(stream);
    }

    public void c(Chunk chunk) {
        chunk.d(this.C_().c());
    }

    public void a(IChunkAccess ichunkaccess) {
        this.K.execute(() -> this.af.a(ichunkaccess.f(), ichunkaccess.g()));
    }

    public PathTypeCache I() {
        return this.V;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.O.close();
    }

    @Override
    public String J() {
        String s2 = this.J.e();
        return "Chunks[S] W: " + s2 + " E: " + this.O.e();
    }

    public boolean c(long i2) {
        return this.O.a(i2);
    }

    public boolean d(long i2) {
        return this.c(i2) && this.J.a(i2);
    }

    public boolean f(BlockPosition blockposition) {
        return this.O.a(blockposition) && this.J.a.j().c(ChunkCoordIntPair.a(blockposition));
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return this.O.a(chunkcoordintpair) && this.O.a(chunkcoordintpair.a());
    }

    public boolean g(BlockPosition blockposition) {
        return this.b(new ChunkCoordIntPair(blockposition));
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair) {
        return this.J.a.b(chunkcoordintpair);
    }

    public boolean c(ChunkCoordIntPair chunkcoordintpair) {
        return this.O.b(chunkcoordintpair) && this.E_().a(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet K() {
        return this.K.aZ().K();
    }

    @Override
    public PotionBrewer L() {
        return this.K.bn();
    }

    @Override
    public FuelValues M() {
        return this.K.bo();
    }

    public RandomSource a(MinecraftKey minecraftkey) {
        return this.ah.a(minecraftkey);
    }

    public RandomSequences N() {
        return this.ah;
    }

    public GameRules O() {
        return this.L.o();
    }

    @Override
    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(crashreport);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.O.f()));
        return crashreportsystemdetails;
    }

    @Override
    public int P() {
        return this.J.g().f();
    }

    private final class a
    implements LevelCallback<Entity> {
        a() {
        }

        @Override
        public void a(Entity entity) {
        }

        @Override
        public void b(Entity entity) {
            WorldServer.this.g().a(entity);
        }

        @Override
        public void c(Entity entity) {
            WorldServer.this.N.a(entity);
        }

        @Override
        public void d(Entity entity) {
            WorldServer.this.N.b(entity);
        }

        @Override
        public void e(Entity entity) {
            AsyncCatcher.catchOp("entity register");
            WorldServer.this.m().b(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.I.add(entityplayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.X) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.W.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gq()) {
                    WorldServer.this.ad.put(entitycomplexpart.ao(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.valid = true;
        }

        @Override
        public void f(Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.p().L()).map(WorldServer::w).forEach(worldData -> {
                    for (Optional<PersistentBase> o2 : worldData.c.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)((Object)o2);
                        map.q.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.p.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dR() != Entity.RemovalReason.a)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory();
                }
            }
            WorldServer.this.m().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.I.remove(entityplayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.X) {
                    EntityComplexPart[] s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.a("onTrackingStart called during navigation iteration", (Throwable)new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.W.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gq()) {
                    WorldServer.this.ad.remove(entitycomplexpart.ao());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.I) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void g(Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

