/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Locale;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.network.LegacyProtocolUtils;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.server.ServerListPingEvent;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger a = LogUtils.getLogger();
    private final ServerInfo b;

    public LegacyPingHandler(ServerInfo serverinfo) {
        this.b = serverinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
        ByteBuf bytebuf = (ByteBuf)object;
        bytebuf.markReaderIndex();
        boolean flag = true;
        try {
            if (bytebuf.readUnsignedByte() == 254) {
                SocketAddress socketaddress = channelhandlercontext.channel().remoteAddress();
                int i2 = bytebuf.readableBytes();
                ServerListPingEvent event = CraftEventFactory.callServerListPingEvent(socketaddress, this.b.ae(), this.b.N(), this.b.O());
                if (i2 == 0) {
                    a.debug("Ping: (<1.3.x) from {}", (Object)socketaddress);
                    String s2 = LegacyPingHandler.createVersion0Response(this.b, event);
                    LegacyPingHandler.a(channelhandlercontext, LegacyPingHandler.a(channelhandlercontext.alloc(), s2));
                } else {
                    if (bytebuf.readUnsignedByte() != 1) {
                        return;
                    }
                    if (bytebuf.isReadable()) {
                        if (!LegacyPingHandler.a(bytebuf)) {
                            return;
                        }
                        a.debug("Ping: (1.6) from {}", (Object)socketaddress);
                    } else {
                        a.debug("Ping: (1.4-1.5.x) from {}", (Object)socketaddress);
                    }
                    String s1 = LegacyPingHandler.createVersion1Response(this.b, event);
                    LegacyPingHandler.a(channelhandlercontext, LegacyPingHandler.a(channelhandlercontext.alloc(), s1));
                }
                bytebuf.release();
                flag = false;
                return;
            }
        }
        catch (RuntimeException runtimeexception) {
            return;
        }
        finally {
            if (flag) {
                bytebuf.resetReaderIndex();
                channelhandlercontext.channel().pipeline().remove((ChannelHandler)this);
                channelhandlercontext.fireChannelRead(object);
            }
        }
    }

    private static boolean a(ByteBuf bytebuf) {
        short short0 = bytebuf.readUnsignedByte();
        if (short0 != 250) {
            return false;
        }
        String s2 = LegacyProtocolUtils.a(bytebuf);
        if (!"MC|PingHost".equals(s2)) {
            return false;
        }
        int i2 = bytebuf.readUnsignedShort();
        if (bytebuf.readableBytes() != i2) {
            return false;
        }
        short short1 = bytebuf.readUnsignedByte();
        if (short1 < 73) {
            return false;
        }
        String s1 = LegacyProtocolUtils.a(bytebuf);
        int j2 = bytebuf.readInt();
        return j2 <= 65535;
    }

    private static String createVersion0Response(ServerInfo serverinfo, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static String createVersion1Response(ServerInfo serverinfo, ServerListPingEvent event) {
        return String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, serverinfo.M(), event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
    }

    private static void a(ChannelHandlerContext channelhandlercontext, ByteBuf bytebuf) {
        channelhandlercontext.pipeline().firstContext().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static ByteBuf a(ByteBufAllocator bytebufallocator, String s2) {
        ByteBuf bytebuf = bytebufallocator.buffer();
        bytebuf.writeByte(255);
        LegacyProtocolUtils.a(bytebuf, s2);
        return bytebuf;
    }
}

