/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String b = "recipeBook";
    private static final Logger e = LogUtils.getLogger();
    private static final Codec<List<ResourceKey<IRecipe<?>>>> f = IRecipe.b.listOf();
    private final a g;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> c = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> d = Sets.newIdentityHashSet();

    public RecipeBookServer(a recipebookserver_a) {
        this.g = recipebookserver_a;
    }

    public void a(ResourceKey<IRecipe<?>> resourcekey) {
        this.c.add(resourcekey);
    }

    public boolean b(ResourceKey<IRecipe<?>> resourcekey) {
        return this.c.contains(resourcekey);
    }

    public void c(ResourceKey<IRecipe<?>> resourcekey) {
        this.c.remove(resourcekey);
        this.d.remove(resourcekey);
    }

    public void d(ResourceKey<IRecipe<?>> resourcekey) {
        this.d.remove(resourcekey);
    }

    private void e(ResourceKey<IRecipe<?>> resourcekey) {
        this.d.add(resourcekey);
    }

    public int a(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (this.c.contains(resourcekey) || recipeholder.b().am_() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(entityplayer, resourcekey.a())) continue;
            this.a(resourcekey);
            this.e(resourcekey);
            this.g.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, recipeholder.b().i(), true)));
            CriterionTriggers.g.a(entityplayer, recipeholder);
        }
        if (!list.isEmpty() && entityplayer.f != null) {
            entityplayer.f.b(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int b(Collection<RecipeHolder<?>> collection, EntityPlayer entityplayer) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (!this.c.contains(resourcekey)) continue;
            this.c(resourcekey);
            this.g.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(recipedisplayentry.a()));
        }
        if (!list.isEmpty() && entityplayer.f != null) {
            entityplayer.f.b(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    public NBTTagCompound b() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a().b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourcekey : this.c) {
            nbttaglist.add(NBTTagString.a(resourcekey.a().toString()));
        }
        nbttagcompound.a("recipes", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourcekey1 : this.d) {
            nbttaglist1.add(NBTTagString.a(resourcekey1.a().toString()));
        }
        nbttagcompound.a("toBeDisplayed", nbttaglist1);
        return nbttagcompound;
    }

    public void a(NBTTagCompound nbttagcompound, Predicate<ResourceKey<IRecipe<?>>> predicate) {
        this.a(RecipeBookSettings.a(nbttagcompound));
        List<ResourceKey<IRecipe<?>>> list = nbttagcompound.a("recipes", f).orElse(List.of());
        this.a(list, this::a, predicate);
        List<ResourceKey<IRecipe<?>>> list1 = nbttagcompound.a("toBeDisplayed", f).orElse(List.of());
        this.a(list1, this::e, predicate);
    }

    private void a(List<ResourceKey<IRecipe<?>>> list, Consumer<ResourceKey<IRecipe<?>>> consumer, Predicate<ResourceKey<IRecipe<?>>> predicate) {
        for (ResourceKey<IRecipe<?>> resourcekey : list) {
            if (!predicate.test(resourcekey)) {
                e.error("Tried to load unrecognized recipe: {} removed now.", resourcekey);
                continue;
            }
            consumer.accept(resourcekey);
        }
    }

    public void a(EntityPlayer entityplayer) {
        entityplayer.f.b(new ClientboundRecipeBookSettingsPacket(this.a()));
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.c.size());
        for (ResourceKey<IRecipe<?>> resourcekey : this.c) {
            this.g.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, false, this.d.contains(resourcekey))));
        }
        entityplayer.f.b(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void a(RecipeBookServer recipebookserver) {
        this.c.clear();
        this.d.clear();
        this.a.a(recipebookserver.a);
        this.c.addAll(recipebookserver.c);
        this.d.addAll(recipebookserver.d);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

