/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryID;
import net.minecraft.util.datafix.DataBitsPacked;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class ChunkConverterPalette
extends DataFix {
    private static final int a = 128;
    private static final int b = 64;
    private static final int c = 32;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 4;
    private static final int g = 2;
    private static final int h = 1;
    static final Logger i = LogUtils.getLogger();
    private static final int j = 4096;

    public ChunkConverterPalette(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public static String a(Dynamic<?> var0) {
        return var0.get("Name").asString("");
    }

    public static String a(Dynamic<?> var0, String var1) {
        return var0.get("Properties").get(var1).asString("");
    }

    public static int a(RegistryID<Dynamic<?>> var0, Dynamic<?> var1) {
        int var2 = var0.a(var1);
        if (var2 == -1) {
            var2 = var0.d(var1);
        }
        return var2;
    }

    private Dynamic<?> b(Dynamic<?> var0) {
        Optional var1 = var0.get("Level").result();
        if (var1.isPresent() && ((Dynamic)var1.get()).get("Sections").asStreamOpt().result().isPresent()) {
            return var0.set("Level", new e((Dynamic)var1.get()).a());
        }
        return var0;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(DataConverterTypes.c);
        Type var1 = this.getOutputSchema().getType(DataConverterTypes.c);
        return this.writeFixAndRead("ChunkPalettedStorageFix", var0, var1, this::b);
    }

    public static int a(boolean var0, boolean var1, boolean var2, boolean var3) {
        int var4 = 0;
        if (var2) {
            var4 = var1 ? (var4 |= 2) : (var0 ? (var4 |= 0x80) : (var4 |= 1));
        } else if (var3) {
            var4 = var0 ? (var4 |= 0x20) : (var1 ? (var4 |= 8) : (var4 |= 0x10));
        } else if (var1) {
            var4 |= 4;
        } else if (var0) {
            var4 |= 0x40;
        }
        return var4;
    }

    static final class e {
        private int a;
        private final d[] b = new d[16];
        private final Dynamic<?> c;
        private final int d;
        private final int e;
        private final Int2ObjectMap<Dynamic<?>> f = new Int2ObjectLinkedOpenHashMap(16);

        public e(Dynamic<?> var0) {
            this.c = var0;
            this.d = var0.get("xPos").asInt(0) << 4;
            this.e = var0.get("zPos").asInt(0) << 4;
            var0.get("TileEntities").asStreamOpt().ifSuccess(var02 -> var02.forEach(var0 -> {
                int var3;
                int var1 = var0.get("x").asInt(0) - this.d & 0xF;
                int var2 = var0.get("y").asInt(0);
                int var4 = var2 << 8 | (var3 = var0.get("z").asInt(0) - this.e & 0xF) << 4 | var1;
                if (this.f.put(var4, var0) != null) {
                    i.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.d, this.e, var1, var2, var3});
                }
            }));
            boolean var1 = var0.get("convertedFromAlphaFormat").asBoolean(false);
            var0.get("Sections").asStreamOpt().ifSuccess(var02 -> var02.forEach(var0 -> {
                d var1 = new d((Dynamic<?>)var0);
                this.a = var1.b(this.a);
                this.b[var1.a] = var1;
            }));
            for (d var5 : this.b) {
                if (var5 == null) continue;
                block30: for (Int2ObjectMap.Entry var7 : var5.f.int2ObjectEntrySet()) {
                    int var8 = var5.a << 12;
                    switch (var7.getIntKey()) {
                        case 2: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!"minecraft:grass_block".equals(ChunkConverterPalette.a(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.b)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.e);
                            }
                            continue block30;
                        }
                        case 3: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!"minecraft:podzol".equals(ChunkConverterPalette.a(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.b)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.d);
                            }
                            continue block30;
                        }
                        case 110: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!"minecraft:mycelium".equals(ChunkConverterPalette.a(var11)) || !"minecraft:snow".equals(var12 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.b)))) && !"minecraft:snow_layer".equals(var12)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.f);
                            }
                            continue block30;
                        }
                        case 25: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.c(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = Boolean.toString(var11.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(var11.get("note").asInt(0), 0), 24);
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.getOrDefault(var12, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.p.get("false0")));
                            }
                            continue block30;
                        }
                        case 26: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int var13;
                                var10 = (Integer)intListIterator.next();
                                var11 = this.b(var10 |= var8);
                                var12 = this.a(var10);
                                if (var11 == null || (var13 = var11.get("color").asInt(0)) == 14 || var13 < 0 || var13 >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.containsKey(var14 = ChunkConverterPalette.a(var12, "facing") + ChunkConverterPalette.a(var12, "occupied") + ChunkConverterPalette.a(var12, "part") + var13)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.r.get(var14));
                            }
                            continue block30;
                        }
                        case 176: 
                        case 177: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int var13;
                                var10 = (Integer)intListIterator.next();
                                var11 = this.b(var10 |= var8);
                                var12 = this.a(var10);
                                if (var11 == null || (var13 = var11.get("Base").asInt(0)) == 15 || var13 < 0 || var13 >= 16 || !net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.containsKey(var14 = ChunkConverterPalette.a(var12, var7.getIntKey() == 176 ? "rotation" : "facing") + "_" + var13)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.s.get(var14));
                            }
                            continue block30;
                        }
                        case 86: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!"minecraft:carved_pumpkin".equals(ChunkConverterPalette.a(var11)) || !"minecraft:grass_block".equals(var12 = ChunkConverterPalette.a(this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.a)))) && !"minecraft:dirt".equals(var12)) continue;
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.c);
                            }
                            continue block30;
                        }
                        case 140: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.c(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = var11.get("Item").asString("") + var11.get("Data").asInt(0);
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.getOrDefault(var12, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.m.get("minecraft:air0")));
                            }
                            continue block30;
                        }
                        case 144: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.b(var10 |= var8);
                                if (var11 == null) continue;
                                var12 = String.valueOf(var11.get("SkullType").asInt(0));
                                String var13 = ChunkConverterPalette.a(this.a(var10), "facing");
                                var14 = "up".equals(var13) || "down".equals(var13) ? var12 + String.valueOf(var11.get("Rot").asInt(0)) : var12 + var13;
                                var11.remove("SkullType");
                                var11.remove("facing");
                                var11.remove("Rot");
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.getOrDefault(var14, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.n.get("0north")));
                            }
                            continue block30;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            Object var14;
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!ChunkConverterPalette.a(var11).endsWith("_door") || !"lower".equals(ChunkConverterPalette.a(var12 = this.a(var10), "half"))) continue;
                                int var13 = net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.b);
                                var14 = this.a(var13);
                                String var15 = ChunkConverterPalette.a(var12);
                                if (!var15.equals(ChunkConverterPalette.a(var14))) continue;
                                String var16 = ChunkConverterPalette.a(var12, "facing");
                                String var17 = ChunkConverterPalette.a(var12, "open");
                                String var18 = var1 ? "left" : ChunkConverterPalette.a(var14, "hinge");
                                String var19 = var1 ? "false" : ChunkConverterPalette.a(var14, "powered");
                                this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(var15 + var16 + "lower" + var18 + var17 + var19));
                                this.a(var13, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.o.get(var15 + var16 + "upper" + var18 + var17 + var19));
                            }
                            continue block30;
                        }
                        case 175: {
                            Object var12;
                            Dynamic<?> var11;
                            int var10;
                            IntListIterator intListIterator = ((IntList)var7.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String var13;
                                var10 = (Integer)intListIterator.next();
                                var11 = this.a(var10 |= var8);
                                if (!"upper".equals(ChunkConverterPalette.a(var11, "half"))) continue;
                                var12 = this.a(net.minecraft.util.datafix.fixes.ChunkConverterPalette$e.a(var10, Direction.a));
                                switch (var13 = ChunkConverterPalette.a(var12)) {
                                    case "minecraft:sunflower": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.g);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.h);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.i);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.j);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.k);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.a(var10, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.l);
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> b(int var0) {
            return (Dynamic)this.f.get(var0);
        }

        @Nullable
        private Dynamic<?> c(int var0) {
            return (Dynamic)this.f.remove(var0);
        }

        public static int a(int var0, Direction var1) {
            return switch (var1.b().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int var2 = (var0 & 0xF) + var1.a().a();
                    if (var2 < 0 || var2 > 15) {
                        yield -1;
                    }
                    yield var0 & 0xFFFFFFF0 | var2;
                }
                case 1 -> {
                    int var2 = (var0 >> 8) + var1.a().a();
                    if (var2 < 0 || var2 > 255) {
                        yield -1;
                    }
                    yield var0 & 0xFF | var2 << 8;
                }
                case 2 -> {
                    int var2 = (var0 >> 4 & 0xF) + var1.a().a();
                    if (var2 < 0 || var2 > 15) {
                        yield -1;
                    }
                    yield var0 & 0xFFFFFF0F | var2 << 4;
                }
            };
        }

        private void a(int var0, Dynamic<?> var1) {
            if (var0 < 0 || var0 > 65535) {
                return;
            }
            d var2 = this.d(var0);
            if (var2 == null) {
                return;
            }
            var2.a(var0 & 0xFFF, var1);
        }

        @Nullable
        private d d(int var0) {
            int var1 = var0 >> 12;
            return var1 < this.b.length ? this.b[var1] : null;
        }

        public Dynamic<?> a(int var0) {
            if (var0 < 0 || var0 > 65535) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            d var1 = this.d(var0);
            if (var1 == null) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            return var1.a(var0 & 0xFFF);
        }

        public Dynamic<?> a() {
            Dynamic var0 = this.c;
            var0 = this.f.isEmpty() ? var0.remove("TileEntities") : var0.set("TileEntities", var0.createList(this.f.values().stream()));
            Dynamic var1 = var0.emptyMap();
            ArrayList var2 = Lists.newArrayList();
            for (d var6 : this.b) {
                if (var6 == null) continue;
                var2.add(var6.a());
                var1 = var1.set(String.valueOf(var6.a), var1.createIntList(Arrays.stream(var6.g.toIntArray())));
            }
            Dynamic var3 = var0.emptyMap();
            var3 = var3.set("Sides", var3.createByte((byte)this.a));
            var3 = var3.set("Indices", var1);
            return var0.set("UpgradeData", var3).set("Sections", var3.createList(var2.stream()));
        }
    }

    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction a = new Direction(AxisDirection.b, Axis.b);
        public static final /* enum */ Direction b = new Direction(AxisDirection.a, Axis.b);
        public static final /* enum */ Direction c = new Direction(AxisDirection.b, Axis.c);
        public static final /* enum */ Direction d = new Direction(AxisDirection.a, Axis.c);
        public static final /* enum */ Direction e = new Direction(AxisDirection.b, Axis.a);
        public static final /* enum */ Direction f = new Direction(AxisDirection.a, Axis.a);
        private final Axis g;
        private final AxisDirection h;
        private static final /* synthetic */ Direction[] i;

        public static Direction[] values() {
            return (Direction[])i.clone();
        }

        public static Direction valueOf(String var0) {
            return Enum.valueOf(Direction.class, var0);
        }

        private Direction(AxisDirection var2, Axis var3) {
            this.g = var3;
            this.h = var2;
        }

        public AxisDirection a() {
            return this.h;
        }

        public Axis b() {
            return this.g;
        }

        private static /* synthetic */ Direction[] c() {
            return new Direction[]{a, b, c, d, e, f};
        }

        static {
            i = Direction.c();
        }

        public static final class Axis
        extends Enum<Axis> {
            public static final /* enum */ Axis a = new Axis();
            public static final /* enum */ Axis b = new Axis();
            public static final /* enum */ Axis c = new Axis();
            private static final /* synthetic */ Axis[] d;

            public static Axis[] values() {
                return (Axis[])d.clone();
            }

            public static Axis valueOf(String var0) {
                return Enum.valueOf(Axis.class, var0);
            }

            private static /* synthetic */ Axis[] a() {
                return new Axis[]{a, b, c};
            }

            static {
                d = Axis.a();
            }
        }

        public static final class AxisDirection
        extends Enum<AxisDirection> {
            public static final /* enum */ AxisDirection a = new AxisDirection(1);
            public static final /* enum */ AxisDirection b = new AxisDirection(-1);
            private final int c;
            private static final /* synthetic */ AxisDirection[] d;

            public static AxisDirection[] values() {
                return (AxisDirection[])d.clone();
            }

            public static AxisDirection valueOf(String var0) {
                return Enum.valueOf(AxisDirection.class, var0);
            }

            private AxisDirection(int var2) {
                this.c = var2;
            }

            public int a() {
                return this.c;
            }

            private static /* synthetic */ AxisDirection[] b() {
                return new AxisDirection[]{a, b};
            }

            static {
                d = AxisDirection.b();
            }
        }
    }

    static class a {
        private static final int a = 2048;
        private static final int b = 4;
        private final byte[] c;

        public a() {
            this.c = new byte[2048];
        }

        public a(byte[] var0) {
            this.c = var0;
            if (var0.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + var0.length);
            }
        }

        public int a(int var0, int var1, int var2) {
            int var3 = this.b(var1 << 8 | var2 << 4 | var0);
            if (this.a(var1 << 8 | var2 << 4 | var0)) {
                return this.c[var3] & 0xF;
            }
            return this.c[var3] >> 4 & 0xF;
        }

        private boolean a(int var0) {
            return (var0 & 1) == 0;
        }

        private int b(int var0) {
            return var0 >> 1;
        }
    }

    static class d {
        private final RegistryID<Dynamic<?>> b = RegistryID.c(32);
        private final List<Dynamic<?>> c;
        private final Dynamic<?> d;
        private final boolean e;
        final Int2ObjectMap<IntList> f = new Int2ObjectLinkedOpenHashMap();
        final IntList g = new IntArrayList();
        public final int a;
        private final Set<Dynamic<?>> h = Sets.newIdentityHashSet();
        private final int[] i = new int[4096];

        public d(Dynamic<?> var0) {
            this.c = Lists.newArrayList();
            this.d = var0;
            this.a = var0.get("Y").asInt(0);
            this.e = var0.get("Blocks").result().isPresent();
        }

        public Dynamic<?> a(int var0) {
            if (var0 < 0 || var0 > 4095) {
                return net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t;
            }
            Dynamic<?> var1 = this.b.a(this.i[var0]);
            return var1 == null ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : var1;
        }

        public void a(int var0, Dynamic<?> var1) {
            if (this.h.add(var1)) {
                this.c.add("%%FILTER_ME%%".equals(ChunkConverterPalette.a(var1)) ? net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t : var1);
            }
            this.i[var0] = ChunkConverterPalette.a(this.b, var1);
        }

        public int b(int var02) {
            if (!this.e) {
                return var02;
            }
            ByteBuffer var1 = (ByteBuffer)this.d.get("Blocks").asByteBufferOpt().result().get();
            a var2 = this.d.get("Data").asByteBufferOpt().map(var0 -> new a(DataFixUtils.toArray((ByteBuffer)var0))).result().orElseGet(a::new);
            a var3 = this.d.get("Add").asByteBufferOpt().map(var0 -> new a(DataFixUtils.toArray((ByteBuffer)var0))).result().orElseGet(a::new);
            this.h.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            ChunkConverterPalette.a(this.b, net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            this.c.add(net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.t);
            for (int var4 = 0; var4 < 4096; ++var4) {
                int var5 = var4 & 0xF;
                int var6 = var4 >> 8 & 0xF;
                int var7 = var4 >> 4 & 0xF;
                int var8 = var3.a(var5, var6, var7) << 12 | (var1.get(var4) & 0xFF) << 4 | var2.a(var5, var6, var7);
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b.get(var8 >> 4)) {
                    this.a(var8 >> 4, var4);
                }
                if (net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a.get(var8 >> 4)) {
                    int var9 = ChunkConverterPalette.a(var5 == 0, var5 == 15, var7 == 0, var7 == 15);
                    if (var9 == 0) {
                        this.g.add(var4);
                    } else {
                        var02 |= var9;
                    }
                }
                this.a(var4, DataConverterFlattenData.b(var8));
            }
            return var02;
        }

        private void a(int var0, int var1) {
            IntList var2 = (IntList)this.f.get(var0);
            if (var2 == null) {
                var2 = new IntArrayList();
                this.f.put(var0, (Object)var2);
            }
            var2.add(var1);
        }

        public Dynamic<?> a() {
            Dynamic var0 = this.d;
            if (!this.e) {
                return var0;
            }
            var0 = var0.set("Palette", var0.createList(this.c.stream()));
            int var1 = Math.max(4, DataFixUtils.ceillog2((int)this.h.size()));
            DataBitsPacked var2 = new DataBitsPacked(var1, 4096);
            for (int var3 = 0; var3 < this.i.length; ++var3) {
                var2.a(var3, this.i[var3]);
            }
            var0 = var0.set("BlockStates", var0.createLongList(Arrays.stream(var2.a())));
            var0 = var0.remove("Blocks");
            var0 = var0.remove("Data");
            var0 = var0.remove("Add");
            return var0;
        }
    }

    static class c {
        static final BitSet a = new BitSet(256);
        static final BitSet b = new BitSet(256);
        static final Dynamic<?> c = ExtraDataFixUtils.a("minecraft:pumpkin");
        static final Dynamic<?> d = ExtraDataFixUtils.a("minecraft:podzol", Map.of("snowy", "true"));
        static final Dynamic<?> e = ExtraDataFixUtils.a("minecraft:grass_block", Map.of("snowy", "true"));
        static final Dynamic<?> f = ExtraDataFixUtils.a("minecraft:mycelium", Map.of("snowy", "true"));
        static final Dynamic<?> g = ExtraDataFixUtils.a("minecraft:sunflower", Map.of("half", "upper"));
        static final Dynamic<?> h = ExtraDataFixUtils.a("minecraft:lilac", Map.of("half", "upper"));
        static final Dynamic<?> i = ExtraDataFixUtils.a("minecraft:tall_grass", Map.of("half", "upper"));
        static final Dynamic<?> j = ExtraDataFixUtils.a("minecraft:large_fern", Map.of("half", "upper"));
        static final Dynamic<?> k = ExtraDataFixUtils.a("minecraft:rose_bush", Map.of("half", "upper"));
        static final Dynamic<?> l = ExtraDataFixUtils.a("minecraft:peony", Map.of("half", "upper"));
        static final Map<String, Dynamic<?>> m = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            var0.put("minecraft:air0", ExtraDataFixUtils.a("minecraft:flower_pot"));
            var0.put("minecraft:red_flower0", ExtraDataFixUtils.a("minecraft:potted_poppy"));
            var0.put("minecraft:red_flower1", ExtraDataFixUtils.a("minecraft:potted_blue_orchid"));
            var0.put("minecraft:red_flower2", ExtraDataFixUtils.a("minecraft:potted_allium"));
            var0.put("minecraft:red_flower3", ExtraDataFixUtils.a("minecraft:potted_azure_bluet"));
            var0.put("minecraft:red_flower4", ExtraDataFixUtils.a("minecraft:potted_red_tulip"));
            var0.put("minecraft:red_flower5", ExtraDataFixUtils.a("minecraft:potted_orange_tulip"));
            var0.put("minecraft:red_flower6", ExtraDataFixUtils.a("minecraft:potted_white_tulip"));
            var0.put("minecraft:red_flower7", ExtraDataFixUtils.a("minecraft:potted_pink_tulip"));
            var0.put("minecraft:red_flower8", ExtraDataFixUtils.a("minecraft:potted_oxeye_daisy"));
            var0.put("minecraft:yellow_flower0", ExtraDataFixUtils.a("minecraft:potted_dandelion"));
            var0.put("minecraft:sapling0", ExtraDataFixUtils.a("minecraft:potted_oak_sapling"));
            var0.put("minecraft:sapling1", ExtraDataFixUtils.a("minecraft:potted_spruce_sapling"));
            var0.put("minecraft:sapling2", ExtraDataFixUtils.a("minecraft:potted_birch_sapling"));
            var0.put("minecraft:sapling3", ExtraDataFixUtils.a("minecraft:potted_jungle_sapling"));
            var0.put("minecraft:sapling4", ExtraDataFixUtils.a("minecraft:potted_acacia_sapling"));
            var0.put("minecraft:sapling5", ExtraDataFixUtils.a("minecraft:potted_dark_oak_sapling"));
            var0.put("minecraft:red_mushroom0", ExtraDataFixUtils.a("minecraft:potted_red_mushroom"));
            var0.put("minecraft:brown_mushroom0", ExtraDataFixUtils.a("minecraft:potted_brown_mushroom"));
            var0.put("minecraft:deadbush0", ExtraDataFixUtils.a("minecraft:potted_dead_bush"));
            var0.put("minecraft:tallgrass2", ExtraDataFixUtils.a("minecraft:potted_fern"));
            var0.put("minecraft:cactus0", ExtraDataFixUtils.a("minecraft:potted_cactus"));
        });
        static final Map<String, Dynamic<?>> n = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 0, "skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 1, "wither_skeleton", "skull");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 2, "zombie", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 3, "player", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 4, "creeper", "head");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, 5, "dragon", "head");
        });
        static final Map<String, Dynamic<?>> o = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "oak_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "iron_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "spruce_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "birch_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "jungle_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "acacia_door");
            net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, "dark_oak_door");
        });
        static final Map<String, Dynamic<?>> p = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            for (int var1 = 0; var1 < 26; ++var1) {
                var0.put("true" + var1, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "true", "note", String.valueOf(var1))));
                var0.put("false" + var1, ExtraDataFixUtils.a("minecraft:note_block", Map.of("powered", "false", "note", String.valueOf(var1))));
            }
        });
        private static final Int2ObjectMap<String> q = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), var0 -> {
            var0.put(0, (Object)"white");
            var0.put(1, (Object)"orange");
            var0.put(2, (Object)"magenta");
            var0.put(3, (Object)"light_blue");
            var0.put(4, (Object)"yellow");
            var0.put(5, (Object)"lime");
            var0.put(6, (Object)"pink");
            var0.put(7, (Object)"gray");
            var0.put(8, (Object)"light_gray");
            var0.put(9, (Object)"cyan");
            var0.put(10, (Object)"purple");
            var0.put(11, (Object)"blue");
            var0.put(12, (Object)"brown");
            var0.put(13, (Object)"green");
            var0.put(14, (Object)"red");
            var0.put(15, (Object)"black");
        });
        static final Map<String, Dynamic<?>> r = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            for (Int2ObjectMap.Entry var2 : q.int2ObjectEntrySet()) {
                if (Objects.equals(var2.getValue(), "red")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.a(var0, var2.getIntKey(), (String)var2.getValue());
            }
        });
        static final Map<String, Dynamic<?>> s = (Map)DataFixUtils.make((Object)Maps.newHashMap(), var0 -> {
            for (Int2ObjectMap.Entry var2 : q.int2ObjectEntrySet()) {
                if (Objects.equals(var2.getValue(), "white")) continue;
                net.minecraft.util.datafix.fixes.ChunkConverterPalette$c.b(var0, 15 - var2.getIntKey(), (String)var2.getValue());
            }
        });
        static final Dynamic<?> t;

        private c() {
        }

        private static void a(Map<String, Dynamic<?>> var0, int var1, String var2, String var3) {
            var0.put(var1 + "north", ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_" + var3, Map.of("facing", "north")));
            var0.put(var1 + "east", ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_" + var3, Map.of("facing", "east")));
            var0.put(var1 + "south", ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_" + var3, Map.of("facing", "south")));
            var0.put(var1 + "west", ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_" + var3, Map.of("facing", "west")));
            for (int var4 = 0; var4 < 16; ++var4) {
                var0.put("" + var1 + var4, ExtraDataFixUtils.a("minecraft:" + var2 + "_" + var3, Map.of("rotation", String.valueOf(var4))));
            }
        }

        private static void a(Map<String, Dynamic<?>> var0, String var1) {
            String var2 = "minecraft:" + var1;
            var0.put("minecraft:" + var1 + "eastlowerleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastlowerleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastlowerlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastlowerlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastlowerrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastlowerrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastlowerrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastlowerrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastupperleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastupperleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastupperlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastupperlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastupperrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastupperrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "eastupperrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "eastupperrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "northlowerleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "northlowerleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "northlowerlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "northlowerlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "northlowerrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "northlowerrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "northlowerrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "northlowerrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "northupperleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "northupperleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "northupperlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "northupperlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "northupperrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "northupperrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "northupperrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "northupperrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "southlowerleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "southlowerleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "southlowerlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "southlowerlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "southlowerrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "southlowerrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "southlowerrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "southlowerrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "southupperleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "southupperleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "southupperlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "southupperlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "southupperrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "southupperrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "southupperrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "southupperrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "westlowerleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "westlowerleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "westlowerlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "westlowerlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "westlowerrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "westlowerrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "westlowerrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "westlowerrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "westupperleftfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "westupperleftfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "westupperlefttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "westupperlefttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            var0.put("minecraft:" + var1 + "westupperrightfalsefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            var0.put("minecraft:" + var1 + "westupperrightfalsetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            var0.put("minecraft:" + var1 + "westupperrighttruefalse", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            var0.put("minecraft:" + var1 + "westupperrighttruetrue", ExtraDataFixUtils.a(var2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
        }

        private static void a(Map<String, Dynamic<?>> var0, int var1, String var2) {
            var0.put("southfalsefoot" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "south", "occupied", "false", "part", "foot")));
            var0.put("westfalsefoot" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "west", "occupied", "false", "part", "foot")));
            var0.put("northfalsefoot" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "north", "occupied", "false", "part", "foot")));
            var0.put("eastfalsefoot" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "east", "occupied", "false", "part", "foot")));
            var0.put("southfalsehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "south", "occupied", "false", "part", "head")));
            var0.put("westfalsehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "west", "occupied", "false", "part", "head")));
            var0.put("northfalsehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "north", "occupied", "false", "part", "head")));
            var0.put("eastfalsehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "east", "occupied", "false", "part", "head")));
            var0.put("southtruehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "south", "occupied", "true", "part", "head")));
            var0.put("westtruehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "west", "occupied", "true", "part", "head")));
            var0.put("northtruehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "north", "occupied", "true", "part", "head")));
            var0.put("easttruehead" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_bed", Map.of("facing", "east", "occupied", "true", "part", "head")));
        }

        private static void b(Map<String, Dynamic<?>> var0, int var1, String var2) {
            for (int var3 = 0; var3 < 16; ++var3) {
                var0.put(var3 + "_" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_banner", Map.of("rotation", String.valueOf(var3))));
            }
            var0.put("north_" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_banner", Map.of("facing", "north")));
            var0.put("south_" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_banner", Map.of("facing", "south")));
            var0.put("west_" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_banner", Map.of("facing", "west")));
            var0.put("east_" + var1, ExtraDataFixUtils.a("minecraft:" + var2 + "_wall_banner", Map.of("facing", "east")));
        }

        static {
            b.set(2);
            b.set(3);
            b.set(110);
            b.set(140);
            b.set(144);
            b.set(25);
            b.set(86);
            b.set(26);
            b.set(176);
            b.set(177);
            b.set(175);
            b.set(64);
            b.set(71);
            b.set(193);
            b.set(194);
            b.set(195);
            b.set(196);
            b.set(197);
            a.set(54);
            a.set(146);
            a.set(25);
            a.set(26);
            a.set(51);
            a.set(53);
            a.set(67);
            a.set(108);
            a.set(109);
            a.set(114);
            a.set(128);
            a.set(134);
            a.set(135);
            a.set(136);
            a.set(156);
            a.set(163);
            a.set(164);
            a.set(180);
            a.set(203);
            a.set(55);
            a.set(85);
            a.set(113);
            a.set(188);
            a.set(189);
            a.set(190);
            a.set(191);
            a.set(192);
            a.set(93);
            a.set(94);
            a.set(101);
            a.set(102);
            a.set(160);
            a.set(106);
            a.set(107);
            a.set(183);
            a.set(184);
            a.set(185);
            a.set(186);
            a.set(187);
            a.set(132);
            a.set(139);
            a.set(199);
            t = ExtraDataFixUtils.a("minecraft:air");
        }
    }
}

