/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.TaskScheduler;
import org.slf4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
TaskScheduler<R>,
Executor {
    public static final long k = 100000L;
    private final String b;
    private static final Logger c = LogUtils.getLogger();
    private final Queue<R> d = Queues.newConcurrentLinkedQueue();
    private int e;

    protected IAsyncTaskHandler(String var0) {
        this.b = var0;
        MetricsRegistry.a.a(this);
    }

    protected abstract boolean e(R var1);

    public boolean bx() {
        return Thread.currentThread() == this.ay();
    }

    protected abstract Thread ay();

    protected boolean ax() {
        return !this.bx();
    }

    public int by() {
        return this.d.size();
    }

    @Override
    public String z_() {
        return this.b;
    }

    public <V> CompletableFuture<V> a(Supplier<V> var0) {
        if (this.ax()) {
            return CompletableFuture.supplyAsync(var0, this);
        }
        return CompletableFuture.completedFuture(var0.get());
    }

    private CompletableFuture<Void> b(Runnable var0) {
        return CompletableFuture.supplyAsync(() -> {
            var0.run();
            return null;
        }, this);
    }

    @CheckReturnValue
    public CompletableFuture<Void> g(Runnable var0) {
        if (this.ax()) {
            return this.b(var0);
        }
        var0.run();
        return CompletableFuture.completedFuture(null);
    }

    public void h(Runnable var0) {
        if (!this.bx()) {
            this.b(var0).join();
        } else {
            var0.run();
        }
    }

    @Override
    public void a_(R var0) {
        this.d.add(var0);
        LockSupport.unpark(this.ay());
    }

    @Override
    public void execute(Runnable var0) {
        if (this.ax()) {
            this.a_(this.f(var0));
        } else {
            var0.run();
        }
    }

    public void c(Runnable var0) {
        this.execute(var0);
    }

    protected void bz() {
        this.d.clear();
    }

    protected void bA() {
        while (this.B()) {
        }
    }

    public boolean B() {
        Runnable var0 = (Runnable)this.d.peek();
        if (var0 == null) {
            return false;
        }
        if (this.e == 0 && !this.e(var0)) {
            return false;
        }
        this.d((Runnable)this.d.remove());
        return true;
    }

    public void b(BooleanSupplier var0) {
        ++this.e;
        try {
            while (!var0.getAsBoolean()) {
                if (this.B()) continue;
                this.A();
            }
        }
        finally {
            --this.e;
        }
    }

    protected void A() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void d(R var0) {
        block8: {
            try (Zone var1 = TracyClient.beginZone((String)"Task", (boolean)SharedConstants.aV);){
                var0.run();
            }
            catch (Exception var12) {
                c.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.z_(), (Object)var12);
                if (!IAsyncTaskHandler.a(var12)) break block8;
                throw var12;
            }
        }
    }

    @Override
    public List<MetricSampler> bw() {
        return ImmutableList.of((Object)MetricSampler.a(this.b + "-pending-tasks", MetricCategory.b, this::by));
    }

    public static boolean a(Throwable var0) {
        if (var0 instanceof ReportedException) {
            ReportedException var1 = (ReportedException)var0;
            return IAsyncTaskHandler.a(var1.getCause());
        }
        return var0 instanceof OutOfMemoryError || var0 instanceof StackOverflowError;
    }
}

