/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Contract;
import org.spigotmc.ActivationRange;
import org.spigotmc.CustomTimingsHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ScoreHolder,
DataComponentGetter {
    private static final int CURRENT_LEVEL = 2;
    private CraftEntity bukkitEntity;
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final String b = "data";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int x = 0;
    public static final int y = 60;
    public static final int z = 300;
    public static final int A = 1024;
    private static final Codec<List<String>> d = Codec.STRING.sizeLimitedListOf(1024);
    public static final float B = 0.2f;
    public static final double C = 0.500001;
    public static final double D = 0.999999;
    public static final int E = 140;
    public static final int F = 40;
    public static final int G = 3;
    private static final ImmutableList<EnumDirection.EnumAxis> e = ImmutableList.of((Object)EnumDirection.EnumAxis.b, (Object)EnumDirection.EnumAxis.a, (Object)EnumDirection.EnumAxis.c);
    private static final ImmutableList<EnumDirection.EnumAxis> m = ImmutableList.of((Object)EnumDirection.EnumAxis.b, (Object)EnumDirection.EnumAxis.c, (Object)EnumDirection.EnumAxis.a);
    private static final AxisAlignedBB n = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double o = 0.014;
    private static final double p = 0.007;
    private static final double q = 0.0023333333333333335;
    public static final String H = "UUID";
    private static double r = 1.0;
    private final EntityTypes<?> s;
    private int t;
    public boolean I;
    public ImmutableList<Entity> u;
    protected int J;
    @Nullable
    private Entity ay;
    private net.minecraft.world.level.World az;
    public double K;
    public double L;
    public double M;
    private Vec3D aA;
    private BlockPosition aB;
    private ChunkCoordIntPair aC;
    private Vec3D aD;
    private float aE;
    private float aF;
    public float N;
    public float O;
    private AxisAlignedBB aG;
    public boolean aH;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    protected Vec3D U;
    @Nullable
    private RemovalReason aI;
    public static final float V = 0.6f;
    public static final float W = 1.8f;
    public float X;
    public float Y;
    public double Z;
    private float aJ = 1.0f;
    public double aa;
    public double ab;
    public double ac;
    public boolean ad;
    public final RandomSource ae;
    public int af;
    private int aK;
    public boolean ag;
    protected Object2DoubleMap<TagKey<FluidType>> ah;
    protected boolean ai;
    private final Set<TagKey<FluidType>> aL;
    public int aj;
    protected boolean ak = true;
    protected final DataWatcher al;
    protected static final DataWatcherObject<Byte> am = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int an = 0;
    private static final int aM = 1;
    private static final int aN = 3;
    private static final int aO = 4;
    private static final int aP = 5;
    protected static final int ao = 6;
    protected static final int ap = 7;
    private static final DataWatcherObject<Integer> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aq = DataWatcher.a(Entity.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Integer> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aW;
    private final VecDeltaCodec aX;
    public boolean ar;
    @Nullable
    public PortalProcessor as;
    public int aY;
    private boolean aZ;
    protected UUID at;
    protected String au;
    private boolean ba;
    private final Set<String> bb;
    private final double[] bc;
    private long bd;
    private EntitySize be;
    private float bf;
    public boolean av;
    public boolean aw;
    public Optional<BlockPosition> ax;
    private boolean bg = false;
    private float bh;
    private int bi;
    public boolean bj;
    @Nullable
    private IBlockData bk = null;
    private final List<List<b>> bl;
    private final List<b> bm;
    private final LongSet bn;
    private final InsideBlockEffectApplier.a bo;
    private CustomData bp;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public CustomTimingsHandler tickTimer = SpigotTimings.getEntityTimings(this);
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean x_() {
            return ((WorldServer)Entity.this.dV()).O().c(GameRules.q);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.b("Bukkit.updateLevel") && tag.b("Bukkit.updateLevel", -1) >= level;
    }

    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = CraftEntity.getEntity(this.az.getCraftServer(), this);
        }
        return this.bukkitEntity;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public float getBukkitYaw() {
        return this.aE;
    }

    public boolean isChunkLoaded() {
        return this.az.b((int)Math.floor(this.dA()) >> 4, (int)Math.floor(this.dG()) >> 4);
    }

    public Entity(EntityTypes<?> entitytypes, net.minecraft.world.level.World world) {
        this.t = c.incrementAndGet();
        this.u = ImmutableList.of();
        this.aD = Vec3D.c;
        this.aG = n;
        this.U = Vec3D.c;
        this.ae = RandomSource.a();
        this.aK = -this.dn();
        this.ah = new Object2DoubleArrayMap(2);
        this.aL = new HashSet<TagKey<FluidType>>();
        this.aW = EntityInLevelCallback.a;
        this.aX = new VecDeltaCodec();
        this.at = MathHelper.a(this.ae);
        this.au = this.at.toString();
        this.bb = Sets.newHashSet();
        this.bc = new double[]{0.0, 0.0, 0.0};
        this.ax = Optional.empty();
        this.bl = new ObjectArrayList();
        this.bm = new ObjectArrayList();
        this.bn = new LongOpenHashSet();
        this.bo = new InsideBlockEffectApplier.a();
        this.bp = CustomData.a;
        this.s = entitytypes;
        this.az = world;
        this.be = entitytypes.n();
        this.aA = Vec3D.c;
        this.aB = BlockPosition.c;
        this.aC = ChunkCoordIntPair.e;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        DataWatcher.a datawatcher_a = new DataWatcher.a(this);
        datawatcher_a.a(am, (byte)0);
        datawatcher_a.a(aQ, this.cr());
        datawatcher_a.a(aS, false);
        datawatcher_a.a(aR, Optional.empty());
        datawatcher_a.a(aT, false);
        datawatcher_a.a(aU, false);
        datawatcher_a.a(aq, EntityPose.a);
        datawatcher_a.a(aV, 0);
        this.a(datawatcher_a);
        this.al = datawatcher_a.a();
        this.a_(0.0, 0.0, 0.0);
        this.bf = this.be.c();
    }

    public boolean a(BlockPosition blockposition, IBlockData iblockdata) {
        VoxelShape voxelshape = iblockdata.b((IBlockAccess)this.dV(), blockposition, VoxelShapeCollision.a(this)).a(blockposition);
        return VoxelShapes.c(voxelshape, VoxelShapes.a(this.cR()), OperatorBoolean.i);
    }

    public int m_() {
        ScoreboardTeam scoreboardteambase = this.cq();
        return scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).o().f() != null ? ((ScoreboardTeamBase)scoreboardteambase).o().f() : 0xFFFFFF;
    }

    public boolean ak() {
        return false;
    }

    public final void al() {
        if (this.bZ()) {
            this.bN();
        }
        if (this.bY()) {
            this.bO();
        }
    }

    public void e(double d0, double d1, double d2) {
        this.aX.e(new Vec3D(d0, d1, d2));
    }

    public VecDeltaCodec am() {
        return this.aX;
    }

    public EntityTypes<?> an() {
        return this.s;
    }

    @Override
    public int ao() {
        return this.t;
    }

    public void e(int i2) {
        this.t = i2;
    }

    public Set<String> ap() {
        return this.bb;
    }

    public boolean a(String s2) {
        return this.bb.size() >= 1024 ? false : this.bb.add(s2);
    }

    public boolean b(String s2) {
        return this.bb.remove(s2);
    }

    public void c(WorldServer worldserver) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void aq() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher ar() {
        return this.al;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.ar().c();
        if (list != null) {
            to.f.b(new PacketPlayOutEntityMetadata(this.ao(), list));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).t == this.t : false;
    }

    public int hashCode() {
        return this.t;
    }

    public void a(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void as() {
    }

    public void b(RemovalReason entity_removalreason) {
    }

    public void b(EntityPose entitypose) {
        if (entitypose == this.at()) {
            return;
        }
        this.az.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[entitypose.ordinal()]));
        this.al.a(aq, entitypose);
    }

    public EntityPose at() {
        return this.al.a(aq);
    }

    public boolean c(EntityPose entitypose) {
        return this.at() == entitypose;
    }

    public boolean a(Entity entity, double d0) {
        return this.dt().a((IPosition)entity.dt(), d0);
    }

    public boolean a(Entity entity, double d0, double d1) {
        double d2 = entity.dA() - this.dA();
        double d3 = entity.dC() - this.dC();
        double d4 = entity.dG() - this.dG();
        return MathHelper.e(d2, d4) < MathHelper.k(d0) && MathHelper.k(d3) < MathHelper.k(d1);
    }

    protected void b(float f2, float f1) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.az.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        if (f1 == Float.POSITIVE_INFINITY || f1 == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.az.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            f1 = 0.0f;
        }
        this.w(f2 % 360.0f);
        this.x(f1 % 360.0f);
    }

    public final void b(Vec3D vec3d) {
        this.a_(vec3d.a(), vec3d.b(), vec3d.c());
    }

    public void a_(double d0, double d1, double d2) {
        this.o(d0, d1, d2);
        this.a(this.au());
    }

    protected final AxisAlignedBB au() {
        return this.c(this.aA);
    }

    protected AxisAlignedBB c(Vec3D vec3d) {
        return this.be.a(vec3d);
    }

    protected void av() {
        this.a_(this.aA.d, this.aA.e, this.aA.f);
    }

    public void b(double d0, double d1) {
        float f2 = (float)d1 * 0.15f;
        float f1 = (float)d0 * 0.15f;
        this.x(this.dN() + f2);
        this.w(this.dL() + f1);
        this.x(MathHelper.a(this.dN(), -90.0f, 90.0f));
        this.O += f2;
        this.N += f1;
        this.O = MathHelper.a(this.O, -90.0f, 90.0f);
        if (this.ay != null) {
            this.ay.k(this);
        }
    }

    public void g() {
        this.aw();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer)) {
            this.bV();
        }
    }

    public void aw() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("entityBaseTick");
        this.bk = null;
        if (this.bY() && this.dk().dQ()) {
            this.bO();
        }
        if (this.J > 0) {
            --this.J;
        }
        if (this instanceof EntityPlayer) {
            this.bV();
        }
        if (this.bt()) {
            this.bu();
        }
        this.aw = this.av;
        this.av = false;
        this.bo();
        this.m();
        this.bn();
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.aK > 0) {
                if (this.bh()) {
                    this.h(this.aK - 4);
                    if (this.aK < 0) {
                        this.aF();
                    }
                } else {
                    if (this.aK % 20 == 0 && !this.bv()) {
                        this.a(worldserver, this.dW().d(), 1.0f);
                    }
                    this.h(this.aK - 1);
                }
            }
        } else {
            this.aF();
        }
        if (this.bv()) {
            this.Z *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.ax();
        if (!this.dV().C) {
            this.c(this.aK > 0);
        }
        this.ak = false;
        world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)world;
            if (this instanceof Leashable) {
                Leashable.a_(worldserver1, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        gameprofilerfiller.c();
    }

    public void c(boolean flag) {
        this.b(0, flag || this.bj);
    }

    public void ax() {
        if (this.dC() < (double)(this.dV().K_() - 64)) {
            this.aG();
        }
    }

    public void ay() {
        this.aY = this.bW();
    }

    public void f(int i2) {
        this.aY = i2;
    }

    public int az() {
        return this.aY;
    }

    public boolean aA() {
        return this.aY > 0;
    }

    protected void L() {
        if (this.aA()) {
            --this.aY;
        }
    }

    public void aB() {
        if (!this.bh()) {
            if (this instanceof EntityLiving && this.aK <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.az, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.az.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void aC() {
        WorldServer worldserver;
        net.minecraft.world.level.World world;
        if (!this.bh() && (world = this.dV()) instanceof WorldServer && this.a(worldserver = (WorldServer)world, this.dW().e().directBlock(this.az, this.lastLavaContact), 4.0f) && this.aD() && !this.ba()) {
            worldserver.a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.kE, this.dm(), 0.4f, 2.0f + this.ae.i() * 0.4f);
        }
    }

    protected boolean aD() {
        return true;
    }

    public final void e(float f2) {
        this.igniteForSeconds(f2, true);
    }

    public final void igniteForSeconds(float f2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), f2);
            this.az.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            f2 = event.getDuration();
        }
        this.g(MathHelper.d(f2 * 20.0f));
    }

    public void g(int i2) {
        if (this.aK < i2) {
            this.h(i2);
        }
        this.ct();
    }

    public void h(int i2) {
        this.aK = i2;
    }

    public int aE() {
        return this.aK;
    }

    public void aF() {
        this.h(0);
    }

    protected void aG() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean f(double d0, double d1, double d2) {
        return this.b(this.cR().d(d0, d1, d2));
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        return this.dV().a(this, axisalignedbb) && !this.dV().d(axisalignedbb);
    }

    public void d(boolean flag) {
        this.aH = flag;
        this.b(flag, (Vec3D)null);
    }

    public void a(boolean flag, Vec3D vec3d) {
        this.a(flag, this.P, vec3d);
    }

    public void a(boolean flag, boolean flag1, Vec3D vec3d) {
        this.aH = flag;
        this.P = flag1;
        this.b(flag, vec3d);
    }

    public boolean d(BlockPosition blockposition) {
        return this.ax.isPresent() && this.ax.get().equals(blockposition);
    }

    protected void b(boolean flag, @Nullable Vec3D vec3d) {
        if (flag) {
            AxisAlignedBB axisalignedbb = this.cR();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.az.h(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bg) {
                if (vec3d != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-vec3d.d, 0.0, -vec3d.f);
                    optional = this.az.h(this, axisalignedbb2);
                    this.ax = optional;
                }
            } else {
                this.ax = optional;
            }
            this.bg = optional.isEmpty();
        } else {
            this.bg = false;
            if (this.ax.isPresent()) {
                this.ax = Optional.empty();
            }
        }
    }

    public boolean aH() {
        return this.aH;
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        SpigotTimings.entityMoveTimer.startTiming();
        if (this.ad) {
            this.a_(this.dA() + vec3d.d, this.dC() + vec3d.e, this.dG() + vec3d.f);
        } else {
            Vec3D vec3d1;
            double d0;
            if (enummovetype == EnumMoveType.c && (vec3d = this.e(vec3d)).equals(Vec3D.c)) {
                return;
            }
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            gameprofilerfiller.a("move");
            if (this.U.h() > 1.0E-7) {
                vec3d = vec3d.h(this.U);
                this.U = Vec3D.c;
                this.i(Vec3D.c);
            }
            if ((d0 = (vec3d1 = this.a(vec3d = this.a(vec3d, enummovetype))).h()) > 1.0E-7 || vec3d.h() - d0 < 1.0E-7) {
                MovingObjectPositionBlock movingobjectpositionblock;
                if (this.Z != 0.0 && d0 >= 1.0 && (movingobjectpositionblock = this.dV().a(new RayTrace(this.dt(), this.dt().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).d() != MovingObjectPosition.EnumMovingObjectType.a) {
                    this.j();
                }
                Vec3D vec3d2 = this.dt();
                ObjectArrayList list = new ObjectArrayList();
                for (EnumDirection.EnumAxis enumdirection_enumaxis : Entity.k(vec3d1)) {
                    double d1 = vec3d1.a(enumdirection_enumaxis);
                    if (d1 == 0.0) continue;
                    Vec3D vec3d3 = vec3d2.a(enumdirection_enumaxis.e(), d1);
                    list.add(new b(vec3d2, vec3d3));
                    vec3d2 = vec3d3;
                }
                this.bl.add((List<b>)list);
                this.b(vec3d2);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.a("rest");
            boolean flag = !MathHelper.b(vec3d.d, vec3d1.d);
            boolean flag1 = !MathHelper.b(vec3d.f, vec3d1.f);
            boolean bl = this.P = flag || flag1;
            if (Math.abs(vec3d.e) > 0.0 || this.dg()) {
                this.Q = vec3d.e != vec3d1.e;
                this.R = this.Q && vec3d.e < 0.0;
                this.a(this.R, this.P, vec3d1);
            }
            this.S = this.P ? this.d(vec3d1) : false;
            BlockPosition blockposition = this.aO();
            IBlockData iblockdata = this.dV().a_(blockposition);
            if (this.dg()) {
                this.a(vec3d1.e, this.aH(), iblockdata, blockposition);
            }
            if (this.dQ()) {
                gameprofilerfiller.c();
            } else {
                MovementEmission entity_movementemission;
                if (this.P) {
                    Vec3D vec3d4 = this.dy();
                    this.n(flag ? 0.0 : vec3d4.d, vec3d4.e, flag1 ? 0.0 : vec3d4.f);
                }
                if (this.di()) {
                    Block block = iblockdata.b();
                    if (vec3d.e != vec3d1.e) {
                        block.a(this.dV(), this);
                    }
                }
                if (this.P && this.getBukkitEntity() instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                    org.bukkit.block.Block bl2 = this.az.getWorld().getBlockAt(MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG()));
                    if (vec3d.d > vec3d1.d) {
                        bl2 = bl2.getRelative(BlockFace.EAST);
                    } else if (vec3d.d < vec3d1.d) {
                        bl2 = bl2.getRelative(BlockFace.WEST);
                    } else if (vec3d.f > vec3d1.f) {
                        bl2 = bl2.getRelative(BlockFace.SOUTH);
                    } else if (vec3d.f < vec3d1.f) {
                        bl2 = bl2.getRelative(BlockFace.NORTH);
                    }
                    if (!bl2.getType().isAir()) {
                        VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl2);
                        this.az.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                }
                if ((!this.dV().A_() || this.dg()) && (entity_movementemission = this.bf()).a() && !this.bY()) {
                    this.a(entity_movementemission, vec3d1, blockposition, iblockdata);
                }
                float f2 = this.aS();
                this.i(this.dy().d(f2, 1.0, f2));
                gameprofilerfiller.c();
            }
        }
        SpigotTimings.entityMoveTimer.stopTiming();
    }

    private void a(MovementEmission entity_movementemission, Vec3D vec3d, BlockPosition blockposition, IBlockData iblockdata) {
        float f2 = 0.6f;
        float f1 = (float)(vec3d.g() * (double)0.6f);
        float f22 = (float)(vec3d.i() * (double)0.6f);
        BlockPosition blockposition1 = this.aQ();
        IBlockData iblockdata1 = this.dV().a_(blockposition1);
        boolean flag = this.c(iblockdata1);
        this.X += flag ? f1 : f22;
        this.Y += f1;
        if (this.X > this.aJ && !iblockdata1.l()) {
            boolean flag1 = blockposition1.equals(blockposition);
            boolean flag2 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag1, vec3d);
            if (!flag1) {
                flag2 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), vec3d);
            }
            if (flag2) {
                this.aJ = this.aT();
            } else if (this.bi()) {
                this.aJ = this.aT();
                if (entity_movementemission.c()) {
                    this.aX();
                }
                if (entity_movementemission.b()) {
                    this.a(GameEvent.Q);
                }
            }
        } else if (iblockdata1.l()) {
            this.aN();
        }
    }

    protected void aI() {
        this.bm.clear();
        List<List<b>> list = this.bl;
        List<b> list1 = this.bm;
        Objects.requireNonNull(this.bm);
        list.forEach(list1::addAll);
        this.bl.clear();
        if (this.bm.isEmpty()) {
            this.bm.add(new b(this.bA(), this.dt()));
        } else if (this.bm.getLast().b.g(this.dt()) > 9.999999439624929E-11) {
            this.bm.add(new b(this.bm.getLast().b, this.dt()));
        }
        this.b(this.bm);
    }

    public void aJ() {
        if (!this.bl.isEmpty()) {
            this.bl.removeLast();
        }
    }

    public void a(Vec3D vec3d, Vec3D vec3d1) {
        this.b(List.of(new b(vec3d, vec3d1)));
    }

    private void b(List<b> list) {
        if (this.aK()) {
            if (this.aH()) {
                BlockPosition blockposition = this.aO();
                IBlockData iblockdata = this.dV().a_(blockposition);
                iblockdata.b().a(this.dV(), blockposition, iblockdata, this);
            }
            boolean flag = this.bX();
            boolean flag1 = this.dK();
            this.a(list, this.bo);
            this.bo.a(this);
            if (this.bj()) {
                this.aF();
            }
            if (flag && !this.bX() || flag1 && !this.dK()) {
                this.aL();
            }
            if (flag && !this.bX() && this.aK <= 0) {
                this.h(-this.dn());
            }
        }
    }

    protected boolean aK() {
        return !this.dQ() && !this.ad;
    }

    private boolean c(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.aS) || iblockdata.a(Blocks.rx);
    }

    private boolean a(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean flag1, Vec3D vec3d) {
        if (iblockdata.l()) {
            return false;
        }
        boolean flag2 = this.c(iblockdata);
        if ((this.aH() || flag2 || this.ch() && vec3d.e == 0.0 || this.cp()) && !this.cj()) {
            if (flag) {
                this.c(blockposition, iblockdata);
            }
            if (flag1) {
                this.dV().a(GameEvent.P, this.dt(), GameEvent.a.a(this, iblockdata));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D vec3d) {
        return false;
    }

    protected void aL() {
        if (!this.az.A_()) {
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.kJ, this.dm(), 0.7f, 1.6f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
    }

    public void aM() {
        if (this.bX()) {
            this.aL();
        }
        this.aF();
    }

    protected void aN() {
        if (this.aZ()) {
            this.aY();
            if (this.bf().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aO() {
        return this.f(0.2f);
    }

    public BlockPosition aP() {
        return this.f(0.500001f);
    }

    public BlockPosition aQ() {
        return this.f(1.0E-5f);
    }

    protected BlockPosition f(float f2) {
        if (this.ax.isPresent()) {
            BlockPosition blockposition = this.ax.get();
            if (f2 <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dV().a_(blockposition);
            return ((double)f2 > 0.5 || !iblockdata.a(TagsBlock.U)) && !iblockdata.a(TagsBlock.N) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.aA.e - (double)f2)) : blockposition;
        }
        int i2 = MathHelper.a(this.aA.d);
        int j2 = MathHelper.a(this.aA.e - (double)f2);
        int k2 = MathHelper.a(this.aA.f);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aR() {
        float f2 = this.dV().a_(this.dv()).b().j();
        float f1 = this.dV().a_(this.aP()).b().j();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aS() {
        IBlockData iblockdata = this.dV().a_(this.dv());
        float f2 = iblockdata.b().i();
        return !iblockdata.a(Blocks.J) && !iblockdata.a(Blocks.nJ) ? ((double)f2 == 1.0 ? this.dV().a_(this.aP()).b().i() : f2) : f2;
    }

    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        return vec3d;
    }

    protected Vec3D e(Vec3D vec3d) {
        if (vec3d.h() <= 1.0E-7) {
            return vec3d;
        }
        long i2 = this.dV().ae();
        if (i2 != this.bd) {
            Arrays.fill(this.bc, 0.0);
            this.bd = i2;
        }
        if (vec3d.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, vec3d.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d0, 0.0, 0.0);
        }
        if (vec3d.e != 0.0) {
            double d1 = this.a(EnumDirection.EnumAxis.b, vec3d.e);
            return Math.abs(d1) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d1, 0.0);
        }
        if (vec3d.f != 0.0) {
            double d2 = this.a(EnumDirection.EnumAxis.c, vec3d.f);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d2);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis enumdirection_enumaxis, double d0) {
        int i2 = enumdirection_enumaxis.ordinal();
        double d1 = MathHelper.a(d0 + this.bc[i2], -0.51, 0.51);
        d0 = d1 - this.bc[i2];
        this.bc[i2] = d1;
        return d0;
    }

    private Vec3D a(Vec3D vec3d) {
        boolean flag3;
        AxisAlignedBB axisalignedbb = this.cR();
        List<VoxelShape> list = this.dV().c(this, axisalignedbb.b(vec3d));
        Vec3D vec3d1 = vec3d.h() == 0.0 ? vec3d : Entity.a(this, vec3d, axisalignedbb, this.dV(), list);
        boolean flag = vec3d.d != vec3d1.d;
        boolean flag1 = vec3d.e != vec3d1.e;
        boolean flag2 = vec3d.f != vec3d1.f;
        boolean bl = flag3 = flag1 && vec3d.e < 0.0;
        if (this.dP() > 0.0f && (flag3 || this.aH()) && (flag || flag2)) {
            float[] afloat;
            AxisAlignedBB axisalignedbb1 = flag3 ? axisalignedbb.d(0.0, vec3d1.e, 0.0) : axisalignedbb;
            AxisAlignedBB axisalignedbb2 = axisalignedbb1.b(vec3d.d, this.dP(), vec3d.f);
            if (!flag3) {
                axisalignedbb2 = axisalignedbb2.b(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> list1 = Entity.a(this, this.az, list, axisalignedbb2);
            float f2 = (float)vec3d1.e;
            for (float f1 : afloat = Entity.a(axisalignedbb1, list1, this.dP(), f2)) {
                Vec3D vec3d2 = Entity.a(new Vec3D(vec3d.d, f1, vec3d.f), axisalignedbb1, list1);
                if (!(vec3d2.j() > vec3d1.j())) continue;
                double d0 = axisalignedbb.b - axisalignedbb1.b;
                return vec3d2.a(0.0, d0, 0.0);
            }
        }
        return vec3d1;
    }

    private static float[] a(AxisAlignedBB axisalignedbb, List<VoxelShape> list, float f2, float f1) {
        FloatArraySet floatset = new FloatArraySet(4);
        block0: for (VoxelShape voxelshape : list) {
            DoubleList doublelist = voxelshape.a(EnumDirection.EnumAxis.b);
            DoubleListIterator doublelistiterator = doublelist.iterator();
            while (doublelistiterator.hasNext()) {
                double d0 = doublelistiterator.next();
                float f22 = (float)(d0 - axisalignedbb.b);
                if (!(f22 >= 0.0f) || f22 == f1) continue;
                if (f22 > f2) continue block0;
                floatset.add(f22);
            }
        }
        float[] afloat = floatset.toFloatArray();
        FloatArrays.unstableSort((float[])afloat);
        return afloat;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec3d, AxisAlignedBB axisalignedbb, net.minecraft.world.level.World world, List<VoxelShape> list) {
        List<VoxelShape> list1 = Entity.a(entity, world, list, axisalignedbb.b(vec3d));
        return Entity.a(vec3d, axisalignedbb, list1);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World world, List<VoxelShape> list, AxisAlignedBB axisalignedbb) {
        boolean flag;
        ImmutableList.Builder immutablelist_builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            immutablelist_builder.addAll(list);
        }
        WorldBorder worldborder = world.E_();
        boolean bl = flag = entity != null && worldborder.a(entity, axisalignedbb);
        if (flag) {
            immutablelist_builder.add((Object)worldborder.c());
        }
        immutablelist_builder.addAll(world.e(entity, axisalignedbb));
        return immutablelist_builder.build();
    }

    private static Vec3D a(Vec3D vec3d, AxisAlignedBB axisalignedbb, List<VoxelShape> list) {
        if (list.isEmpty()) {
            return vec3d;
        }
        Vec3D vec3d1 = Vec3D.c;
        for (EnumDirection.EnumAxis enumdirection_enumaxis : Entity.k(vec3d)) {
            double d0 = vec3d.a(enumdirection_enumaxis);
            if (d0 == 0.0) continue;
            double d1 = VoxelShapes.a(enumdirection_enumaxis, axisalignedbb.c(vec3d1), list, d0);
            vec3d1 = vec3d1.a(enumdirection_enumaxis, d1);
        }
        return vec3d1;
    }

    private static Iterable<EnumDirection.EnumAxis> k(Vec3D vec3d) {
        return Math.abs(vec3d.d) < Math.abs(vec3d.f) ? m : e;
    }

    protected float aT() {
        return (int)this.X + 1;
    }

    protected SoundEffect aU() {
        return SoundEffects.kN;
    }

    protected SoundEffect aV() {
        return SoundEffects.kM;
    }

    protected SoundEffect aW() {
        return SoundEffects.kM;
    }

    public SoundEffect getSwimSound0() {
        return this.aU();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aV();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aW();
    }

    private void a(List<b> list, InsideBlockEffectApplier.a insideblockeffectapplier_a) {
        if (this.aK()) {
            LongSet longset = this.bn;
            for (b entity_b : list) {
                Vec3D vec3d = entity_b.a();
                Vec3D vec3d1 = entity_b.b();
                AxisAlignedBB axisalignedbb = this.c(vec3d1).h(1.0E-5f);
                IBlockAccess.a(vec3d, vec3d1, axisalignedbb, (BlockPosition blockposition, int i2) -> {
                    IBlockData iblockdata;
                    if (this.bJ() && !(iblockdata = this.dV().a_(blockposition)).l() && longset.add(blockposition.a())) {
                        boolean flag1;
                        boolean flag;
                        VoxelShape voxelshape = iblockdata.a((IBlockAccess)this.dV(), blockposition, this);
                        boolean bl = flag = voxelshape == VoxelShapes.b() || this.a(vec3d, vec3d1, voxelshape.a(new Vec3D(blockposition)).e());
                        if (flag) {
                            try {
                                insideblockeffectapplier_a.a(i2);
                                iblockdata.a(this.dV(), blockposition, this, insideblockeffectapplier_a);
                                this.a(iblockdata);
                            }
                            catch (Throwable throwable) {
                                CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                                CrashReportSystemDetails.a(crashreportsystemdetails, this.dV(), blockposition, iblockdata);
                                CrashReportSystemDetails crashreportsystemdetails1 = crashreport.a("Entity being checked for collision");
                                this.a(crashreportsystemdetails1);
                                throw new ReportedException(crashreport);
                            }
                        }
                        if (flag1 = this.a(iblockdata.y(), blockposition, vec3d, vec3d1)) {
                            insideblockeffectapplier_a.a(i2);
                            iblockdata.y().a(this.dV(), blockposition, this, insideblockeffectapplier_a);
                        }
                    }
                });
            }
            longset.clear();
        }
    }

    private boolean a(Fluid fluid, BlockPosition blockposition, Vec3D vec3d, Vec3D vec3d1) {
        AxisAlignedBB axisalignedbb = fluid.e(this.dV(), blockposition);
        return axisalignedbb != null && this.a(vec3d, vec3d1, List.of(axisalignedbb));
    }

    private boolean a(Vec3D vec3d, Vec3D vec3d1, List<AxisAlignedBB> list) {
        AxisAlignedBB axisalignedbb = this.c(vec3d);
        Vec3D vec3d2 = vec3d1.d(vec3d);
        return axisalignedbb.a(vec3d2, list);
    }

    protected void a(IBlockData iblockdata) {
    }

    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = worldserver.aa();
        Vec3D vec3d = blockposition1.b();
        int i2 = worldserver.m(blockposition1).a(HeightMap.Type.f, blockposition1.u(), blockposition1.w()) + 1;
        return BlockPosition.a(vec3d.d, (double)i2, vec3d.f);
    }

    public void a(Holder<GameEvent> holder, @Nullable Entity entity) {
        this.dV().a(entity, holder, this.aA);
    }

    public void a(Holder<GameEvent> holder) {
        this.a(holder, this);
    }

    private void c(BlockPosition blockposition, IBlockData iblockdata) {
        this.b(blockposition, iblockdata);
        if (this.d(iblockdata)) {
            this.l();
        }
    }

    protected void aX() {
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.dy();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.d * vec3d.d * (double)0.2f + vec3d.e * vec3d.e + vec3d.f * vec3d.f * (double)0.2f) * f2);
        this.g(f1);
    }

    protected BlockPosition e(BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.d();
        IBlockData iblockdata = this.dV().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bq) && !iblockdata.a(TagsBlock.br) ? blockposition : blockposition1;
    }

    protected void a(IBlockData iblockdata, IBlockData iblockdata1) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(iblockdata1);
    }

    protected void b(IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        SoundEffectType soundeffecttype = iblockdata.A();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData iblockdata) {
        return iblockdata.a(TagsBlock.bp) && this.af >= this.bi + 20;
    }

    private void l() {
        this.bh *= (float)Math.pow(0.997, this.af - this.bi);
        this.bh = Math.min(1.0f, this.bh + 0.07f);
        float f2 = 0.5f + this.bh * this.ae.i() * 1.2f;
        float f1 = 0.1f + this.bh * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bi = this.af;
    }

    protected void g(float f2) {
        this.a(this.aU(), f2, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    protected void aY() {
    }

    protected boolean aZ() {
        return false;
    }

    public void a(SoundEffect soundeffect, float f2, float f1) {
        if (!this.ba()) {
            this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), soundeffect, this.dm(), f2, f1);
        }
    }

    public void a(SoundEffect soundeffect) {
        if (!this.ba()) {
            this.a(soundeffect, 1.0f, 1.0f);
        }
    }

    public boolean ba() {
        return this.al.a(aT);
    }

    public void e(boolean flag) {
        this.al.a(aT, flag);
    }

    public boolean bb() {
        return this.al.a(aU);
    }

    public void f(boolean flag) {
        this.al.a(aU, flag);
    }

    protected double bc() {
        return 0.0;
    }

    public final double bd() {
        return this.bb() ? 0.0 : this.bc();
    }

    protected void be() {
        double d0 = this.bd();
        if (d0 != 0.0) {
            this.i(this.dy().b(0.0, -d0, 0.0));
        }
    }

    protected MovementEmission bf() {
        return MovementEmission.d;
    }

    public boolean bg() {
        return false;
    }

    public final void a(double d0, double d1, double d2, boolean flag) {
        if (!this.do()) {
            this.b(flag, new Vec3D(d0, d1, d2));
            BlockPosition blockposition = this.aO();
            IBlockData iblockdata = this.dV().a_(blockposition);
            this.a(d1, flag, iblockdata, blockposition);
        }
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (!this.bi() && d0 < 0.0) {
            this.Z -= (double)((float)d0);
        }
        if (flag) {
            if (this.Z > 0.0) {
                iblockdata.b().a(this.dV(), iblockdata, blockposition, this, this.Z);
                this.dV().a(GameEvent.A, this.aA, GameEvent.a.a(this, this.ax.map(blockposition1 -> this.dV().a_((BlockPosition)blockposition1)).orElse(iblockdata)));
            }
            this.j();
        }
    }

    public boolean bh() {
        return this.an().d();
    }

    public boolean a(double d0, float f2, DamageSource damagesource) {
        if (this.s.a(TagsEntity.o)) {
            return false;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    protected void b(double d0, float f2, DamageSource damagesource) {
        if (this.bZ()) {
            for (Entity entity : this.cY()) {
                entity.a(d0, f2, damagesource);
            }
        }
    }

    public boolean bi() {
        return this.ag;
    }

    boolean bj() {
        BlockPosition blockposition = this.dv();
        return this.dV().r(blockposition) || this.dV().r(BlockPosition.a((double)blockposition.u(), this.cR().e, (double)blockposition.w()));
    }

    public boolean bk() {
        return this.bi() || this.bj();
    }

    public boolean bl() {
        return this.bi() || this.bv();
    }

    public boolean bm() {
        return this.ai && this.bi();
    }

    public void bn() {
        if (this.cj()) {
            this.i(this.ci() && this.bi() && !this.bY());
        } else {
            this.i(this.ci() && this.bm() && !this.bY() && this.dV().b_(this.aB).a(TagsFluid.a));
        }
    }

    protected boolean bo() {
        this.ah.clear();
        this.bp();
        double d0 = this.dV().F_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.bi() || flag;
    }

    void bp() {
        AbstractBoat abstractboat;
        Entity entity = this.dk();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bm()) {
            this.ag = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ag && !this.ak) {
                this.bq();
            }
            this.j();
            this.ag = true;
        } else {
            this.ag = false;
        }
    }

    private void m() {
        AbstractBoat abstractboat;
        this.ai = this.a(TagsFluid.a);
        this.aL.clear();
        double d0 = this.dE();
        Entity entity = this.dk();
        if (entity instanceof AbstractBoat && !(abstractboat = (AbstractBoat)entity).bm() && abstractboat.cR().e >= d0 && abstractboat.cR().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dA(), d0, this.dG());
        Fluid fluid = this.dV().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a(this.dV(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aL;
            Objects.requireNonNull(this.aL);
            stream.forEach(set::add);
        }
    }

    protected void bq() {
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.dy();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.d * vec3d.d * (double)0.2f + vec3d.e * vec3d.e + vec3d.f * vec3d.f * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aV(), f1, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        } else {
            this.a(this.aW(), f1, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dC());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.be.a() * 20.0f) {
            double d0 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            double d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            this.dV().a(Particles.d, this.dA() + d0, (double)(f22 + 1.0f), this.dG() + d1, vec3d.d, vec3d.e - this.ae.j() * (double)0.2f, vec3d.f);
            ++i2;
        }
        int j2 = 0;
        while ((float)j2 < 1.0f + this.be.a() * 20.0f) {
            double d2 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            double d3 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            this.dV().a(Particles.ap, this.dA() + d2, (double)(f22 + 1.0f), this.dG() + d3, vec3d.d, vec3d.e, vec3d.f);
            ++j2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData br() {
        return this.dV().a_(this.aO());
    }

    public IBlockData bs() {
        return this.dV().a_(this.aQ());
    }

    public boolean bt() {
        return this.ci() && !this.bi() && !this.ak() && !this.ch() && !this.bv() && this.bJ();
    }

    protected void bu() {
        BlockPosition blockposition = this.aO();
        IBlockData iblockdata = this.dV().a_(blockposition);
        if (iblockdata.o() != EnumRenderType.a) {
            Vec3D vec3d = this.dy();
            BlockPosition blockposition1 = this.dv();
            double d0 = this.dA() + (this.ae.j() - 0.5) * (double)this.be.a();
            double d1 = this.dG() + (this.ae.j() - 0.5) * (double)this.be.a();
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dV().a(new ParticleParamBlock(Particles.b, iblockdata), d0, this.dC() + 0.1, d1, vec3d.d * -4.0, 1.5, vec3d.f * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> tagkey) {
        return this.aL.contains(tagkey);
    }

    public boolean bv() {
        return !this.ak && this.ah.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float f2, Vec3D vec3d) {
        Vec3D vec3d1 = Entity.a(vec3d, f2, this.dL());
        this.i(this.dy().e(vec3d1));
    }

    protected static Vec3D a(Vec3D vec3d, float f2, float f1) {
        double d0 = vec3d.h();
        if (d0 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? vec3d.d() : vec3d).c((double)f2);
        float f22 = MathHelper.a(f1 * ((float)Math.PI / 180));
        float f3 = MathHelper.b(f1 * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.d * (double)f3 - vec3d1.f * (double)f22, vec3d1.e, vec3d1.f * (double)f3 + vec3d1.d * (double)f22);
    }

    @Deprecated
    public float bw() {
        return this.dV().f(this.dz(), this.dF()) ? this.dV().y(BlockPosition.a(this.dA(), this.dE(), this.dG())) : 0.0f;
    }

    public void a(double d0, double d1, double d2, float f2, float f1) {
        this.g(d0, d1, d2);
        this.c(f2, f1);
    }

    public void c(float f2, float f1) {
        this.w(f2 % 360.0f);
        this.x(MathHelper.a(f1, -90.0f, 90.0f) % 360.0f);
        this.N = this.dL();
        this.O = this.dN();
    }

    public void g(double d0, double d1, double d2) {
        double d3 = MathHelper.a(d0, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(d2, -3.0E7, 3.0E7);
        this.K = d3;
        this.L = d1;
        this.M = d4;
        this.a_(d3, d1, d4);
        if (this.valid) {
            this.az.d((int)Math.floor(this.dA()) >> 4, (int)Math.floor(this.dG()) >> 4);
        }
    }

    public void f(Vec3D vec3d) {
        this.d(vec3d.d, vec3d.e, vec3d.f);
    }

    public void d(double d0, double d1, double d2) {
        this.b(d0, d1, d2, this.dL(), this.dN());
    }

    public void a(BlockPosition blockposition, float f2, float f1) {
        this.b(blockposition.c(), f2, f1);
    }

    public void b(Vec3D vec3d, float f2, float f1) {
        this.b(vec3d.d, vec3d.e, vec3d.f, f2, f1);
    }

    public void b(double d0, double d1, double d2, float f2, float f1) {
        this.o(d0, d1, d2);
        this.w(f2);
        this.x(f1);
        this.bx();
        this.av();
    }

    public final void bx() {
        this.by();
        this.bz();
    }

    public final void c(Vec3D vec3d, float f2, float f1) {
        this.l(vec3d);
        this.f(f2, f1);
    }

    protected void by() {
        this.l(this.aA);
    }

    public void bz() {
        this.f(this.dL(), this.dN());
    }

    private void l(Vec3D vec3d) {
        this.K = this.aa = vec3d.d;
        this.L = this.ab = vec3d.e;
        this.M = this.ac = vec3d.f;
    }

    private void f(float f2, float f1) {
        this.N = f2;
        this.O = f1;
    }

    public final Vec3D bA() {
        return new Vec3D(this.aa, this.ab, this.ac);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dA() - entity.dA());
        float f1 = (float)(this.dC() - entity.dC());
        float f22 = (float)(this.dG() - entity.dG());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double h(double d0, double d1, double d2) {
        double d3 = this.dA() - d0;
        double d4 = this.dC() - d1;
        double d5 = this.dG() - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double g(Entity entity) {
        return this.g(entity.dt());
    }

    public double g(Vec3D vec3d) {
        double d0 = this.dA() - vec3d.d;
        double d1 = this.dC() - vec3d.e;
        double d2 = this.dG() - vec3d.f;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void a_(EntityHuman entityhuman) {
    }

    public void h(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.z(entity) && !entity.ad && !this.ad && (d2 = MathHelper.a(d0 = entity.dA() - this.dA(), d1 = entity.dG() - this.dG())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.bZ() && this.bG()) {
                this.i(-d0, 0.0, -d1);
            }
            if (!entity.bZ() && entity.bG()) {
                entity.i(d0, 0.0, d1);
            }
        }
    }

    public void h(Vec3D vec3d) {
        this.i(vec3d.d, vec3d.e, vec3d.f);
    }

    public void i(double d0, double d1, double d2) {
        this.i(this.dy().b(d0, d1, d2));
        this.ar = true;
    }

    protected void bB() {
        this.T = true;
    }

    @Deprecated
    public final void a(DamageSource damagesource, float f2) {
        net.minecraft.world.level.World world = this.az;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, damagesource, f2);
        }
    }

    @Deprecated
    public final boolean b(DamageSource damagesource, float f2) {
        net.minecraft.world.level.World world = this.az;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return this.a(worldserver, damagesource, f2);
        }
        return this.b(damagesource);
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource damagesource) {
        return false;
    }

    public final Vec3D h(float f2) {
        return this.d(this.i(f2), this.j(f2));
    }

    public EnumDirection bC() {
        return EnumDirection.a(this.h(1.0f));
    }

    public float i(float f2) {
        return this.k(f2);
    }

    public float j(float f2) {
        return this.l(f2);
    }

    public float k(float f2) {
        return f2 == 1.0f ? this.dN() : MathHelper.h(f2, this.O, this.dN());
    }

    public float l(float f2) {
        return f2 == 1.0f ? this.dL() : MathHelper.i(f2, this.N, this.dL());
    }

    public final Vec3D d(float f2, float f1) {
        float f22 = f2 * ((float)Math.PI / 180);
        float f3 = -f1 * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f22);
        float f7 = MathHelper.a(f22);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D m(float f2) {
        return this.e(this.i(f2), this.j(f2));
    }

    protected final Vec3D e(float f2, float f1) {
        return this.d(f2 - 90.0f, f1);
    }

    public final Vec3D bD() {
        return new Vec3D(this.dA(), this.dE(), this.dG());
    }

    public final Vec3D n(float f2) {
        double d0 = MathHelper.d((double)f2, this.K, this.dA());
        double d1 = MathHelper.d((double)f2, this.L, this.dC()) + (double)this.cS();
        double d2 = MathHelper.d((double)f2, this.M, this.dG());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D o(float f2) {
        return this.n(f2);
    }

    public final Vec3D p(float f2) {
        double d0 = MathHelper.d((double)f2, this.K, this.dA());
        double d1 = MathHelper.d((double)f2, this.L, this.dC());
        double d2 = MathHelper.d((double)f2, this.M, this.dG());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double d0, float f2, boolean flag) {
        Vec3D vec3d = this.n(f2);
        Vec3D vec3d1 = this.h(f2);
        Vec3D vec3d2 = vec3d.b(vec3d1.d * d0, vec3d1.e * d0, vec3d1.f * d0);
        return this.dV().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, flag ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bE() {
        return this.bJ() && this.bF();
    }

    public boolean bF() {
        return false;
    }

    public boolean bG() {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bG();
    }

    public void a(Entity entity, DamageSource damagesource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damagesource);
        }
    }

    public boolean j(double d0, double d1, double d2) {
        double d3 = this.dA() - d0;
        double d4 = this.dC() - d1;
        double d5 = this.dG() - d2;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double d0) {
        double d1 = this.cR().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return d0 < (d1 *= 64.0 * r) * d1;
    }

    public boolean f(NBTTagCompound nbttagcompound) {
        return this.saveAsPassenger(nbttagcompound, true);
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (this.aI != null && !this.aI.b()) {
            return false;
        }
        String s2 = this.bI();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.a(v, s2);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean g(NBTTagCompound nbttagcompound) {
        return this.bY() ? false : this.f(nbttagcompound);
    }

    public NBTTagCompound h(NBTTagCompound nbttagcompound) {
        return this.saveWithoutId(nbttagcompound, true);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound, boolean includeAll) {
        try {
            int i2;
            if (includeAll) {
                if (this.ay != null) {
                    nbttagcompound.a("Pos", Vec3D.a, new Vec3D(this.ay.dA(), this.dC(), this.ay.dG()));
                } else {
                    nbttagcompound.a("Pos", Vec3D.a, this.dt());
                }
            }
            nbttagcompound.a("Motion", Vec3D.a, this.dy());
            if (Float.isNaN(this.aE)) {
                this.aE = 0.0f;
            }
            if (Float.isNaN(this.aF)) {
                this.aF = 0.0f;
            }
            nbttagcompound.a("Rotation", Vec2F.i, new Vec2F(this.dL(), this.dN()));
            nbttagcompound.a("fall_distance", this.Z);
            nbttagcompound.a("Fire", (short)this.aK);
            nbttagcompound.a("Air", (short)this.cs());
            nbttagcompound.a("OnGround", this.aH());
            nbttagcompound.a("Invulnerable", this.aZ);
            nbttagcompound.a("PortalCooldown", this.aY);
            if (includeAll) {
                nbttagcompound.a(H, UUIDUtil.a, this.cG());
                nbttagcompound.a("WorldUUIDLeast", ((WorldServer)this.az).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.a("WorldUUIDMost", ((WorldServer)this.az).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.a("Bukkit.MaxAirSupply", this.cr());
            }
            nbttagcompound.a("Spigot.ticksLived", this.af);
            IChatBaseComponent ichatbasecomponent = this.aj();
            if (ichatbasecomponent != null) {
                RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
                nbttagcompound.a("CustomName", ComponentSerialization.a, registryops, ichatbasecomponent);
            }
            if (this.cL()) {
                nbttagcompound.a("CustomNameVisible", this.cL());
            }
            if (this.ba()) {
                nbttagcompound.a("Silent", this.ba());
            }
            if (this.bb()) {
                nbttagcompound.a("NoGravity", this.bb());
            }
            if (this.ba) {
                nbttagcompound.a("Glowing", true);
            }
            if ((i2 = this.cu()) > 0) {
                nbttagcompound.a("TicksFrozen", this.cu());
            }
            if (this.bj) {
                nbttagcompound.a("HasVisualFire", this.bj);
            }
            if (!this.bb.isEmpty()) {
                nbttagcompound.a("Tags", d, List.copyOf(this.bb));
            }
            if (!this.bp.c()) {
                nbttagcompound.a(b, CustomData.b, this.bp);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.bZ()) {
                NBTTagList nbttaglist = new NBTTagList();
                for (Entity entity : this.cY()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new NBTTagCompound(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.a(w, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void i(NBTTagCompound nbttagcompound) {
        try {
            Vec3D vec3d = nbttagcompound.a("Pos", Vec3D.a).orElse(Vec3D.c);
            Vec3D vec3d1 = nbttagcompound.a("Motion", Vec3D.a).orElse(Vec3D.c);
            Vec2F vec2f = nbttagcompound.a("Rotation", Vec2F.i).orElse(Vec2F.a);
            this.n(Math.abs(vec3d1.d) > 10.0 ? 0.0 : vec3d1.d, Math.abs(vec3d1.e) > 10.0 ? 0.0 : vec3d1.e, Math.abs(vec3d1.f) > 10.0 ? 0.0 : vec3d1.f);
            this.ar = true;
            double d0 = 3.0000512E7;
            this.o(MathHelper.a(vec3d.d, -3.0000512E7, 3.0000512E7), MathHelper.a(vec3d.e, -2.0E7, 2.0E7), MathHelper.a(vec3d.f, -3.0000512E7, 3.0000512E7));
            this.w(vec2f.j);
            this.x(vec2f.k);
            this.bx();
            this.r(this.dL());
            this.s(this.dL());
            this.Z = nbttagcompound.b("fall_distance", 0.0);
            this.aK = nbttagcompound.b("Fire", (short)0);
            this.j(nbttagcompound.b("Air", this.cr()));
            this.aH = nbttagcompound.b("OnGround", false);
            this.aZ = nbttagcompound.b("Invulnerable", false);
            this.aY = nbttagcompound.b("PortalCooldown", 0);
            nbttagcompound.a(H, UUIDUtil.a).ifPresent(uuid -> {
                this.at = uuid;
                this.au = this.at.toString();
            });
            if (!Double.isFinite(this.dA()) || !Double.isFinite(this.dC()) || !Double.isFinite(this.dG())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dL()) || !Double.isFinite(this.dN())) throw new IllegalStateException("Entity has invalid rotation");
            this.av();
            this.b(this.dL(), this.dN());
            RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
            this.b((IChatBaseComponent)nbttagcompound.a("CustomName", ComponentSerialization.a, (DynamicOps<NBTBase>)registryops).orElse(null));
            this.o(nbttagcompound.b("CustomNameVisible", false));
            this.e(nbttagcompound.b("Silent", false));
            this.f(nbttagcompound.b("NoGravity", false));
            this.j(nbttagcompound.b("Glowing", false));
            this.k(nbttagcompound.b("TicksFrozen", 0));
            this.bj = nbttagcompound.b("HasVisualFire", false);
            this.bp = nbttagcompound.a(b, CustomData.b).orElse(CustomData.a);
            this.bb.clear();
            Optional<List<String>> optional = nbttagcompound.a("Tags", d);
            Set<String> set = this.bb;
            Objects.requireNonNull(this.bb);
            optional.ifPresent(set::addAll);
            this.a(nbttagcompound);
            if (this.bH()) {
                this.av();
            }
            if (this instanceof EntityLiving) {
                this.af = nbttagcompound.b("Spigot.ticksLived", this.af);
            }
            this.persist = nbttagcompound.b("Bukkit.persist", this.persist);
            this.visibleByDefault = nbttagcompound.b("Bukkit.visibleByDefault", this.visibleByDefault);
            this.maxAirTicks = nbttagcompound.b("Bukkit.MaxAirSupply", this.maxAirTicks);
            if (this instanceof EntityPlayer) {
                Server server = Bukkit.getServer();
                World bworld = null;
                String worldName = nbttagcompound.b("world", "");
                if (nbttagcompound.b("WorldUUIDMost") && nbttagcompound.b("WorldUUIDLeast")) {
                    UUID uid = new UUID(nbttagcompound.b("WorldUUIDMost", -1L), nbttagcompound.b("WorldUUIDLeast", -1L));
                    bworld = server.getWorld(uid);
                } else {
                    bworld = server.getWorld(worldName);
                }
                if (bworld == null) {
                    bworld = ((CraftServer)server).getServer().a(net.minecraft.world.level.World.i).getWorld();
                }
                ((EntityPlayer)this).a((net.minecraft.world.level.World)(bworld == null ? null : ((CraftWorld)bworld).getHandle()));
            }
            this.getBukkitEntity().readBukkitValues(nbttagcompound);
            if (!nbttagcompound.b("Bukkit.invisible")) return;
            boolean bukkitInvisible = nbttagcompound.b("Bukkit.invisible", false);
            this.k(bukkitInvisible);
            this.persistentInvisibility = bukkitInvisible;
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bH() {
        return true;
    }

    @Nullable
    public final String bI() {
        EntityTypes<?> entitytypes = this.an();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        this.b(nbttagcompound);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    @Nullable
    public EntityItem a(WorldServer worldserver, IMaterial imaterial) {
        return this.a(worldserver, imaterial, 0);
    }

    @Nullable
    public EntityItem a(WorldServer worldserver, IMaterial imaterial, int i2) {
        return this.a(worldserver, new ItemStack(imaterial), (float)i2);
    }

    @Nullable
    public EntityItem a(WorldServer worldserver, ItemStack itemstack) {
        return this.a(worldserver, itemstack, 0.0f);
    }

    @Nullable
    public EntityItem a(WorldServer worldserver, ItemStack itemstack, float f2) {
        if (itemstack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(CraftItemStack.asBukkitCopy(itemstack));
            return null;
        }
        EntityItem entityitem = new EntityItem(worldserver, this.dA(), this.dC() + (double)f2, this.dG(), itemstack);
        entityitem.i();
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        worldserver.b(entityitem);
        return entityitem;
    }

    public boolean bJ() {
        return !this.dQ();
    }

    public boolean bK() {
        if (this.ad) {
            return false;
        }
        float f2 = this.be.a() * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.bD(), f2, 1.0E-6, f2);
        return BlockPosition.b(axisalignedbb).anyMatch(blockposition -> {
            IBlockData iblockdata = this.dV().a_((BlockPosition)blockposition);
            return !iblockdata.l() && iblockdata.j(this.dV(), (BlockPosition)blockposition) && VoxelShapes.c(iblockdata.g(this.dV(), (BlockPosition)blockposition).a((BaseBlockPosition)blockposition), VoxelShapes.a(axisalignedbb), OperatorBoolean.i);
        });
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        Entity entity;
        if (this.bJ() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.B() == entityhuman) {
                if (!this.dV().A_()) {
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(this, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).f.b(new PacketPlayOutAttachEntity(this, leashable.B()));
                        return EnumInteractionResult.e;
                    }
                    if (entityhuman.fV()) {
                        leashable.y();
                    } else {
                        leashable.x();
                    }
                    this.a(GameEvent.r, (Entity)entityhuman);
                }
                return EnumInteractionResult.a.b();
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.a(Items.vV) && leashable.R_()) {
                if (!this.dV().A_()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, entityhuman, entityhuman, enumhand).isCancelled()) {
                        ((EntityPlayer)entityhuman).resendItemInHands();
                        ((EntityPlayer)entityhuman).f.b(new PacketPlayOutAttachEntity(this, leashable.B()));
                        return EnumInteractionResult.e;
                    }
                    leashable.a_(entityhuman, true);
                }
                itemstack.h(1);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean i(Entity entity) {
        return entity.bL() && !this.z(entity);
    }

    public boolean bL() {
        return false;
    }

    public void q() {
        this.i(Vec3D.c);
        this.g();
        if (this.bY()) {
            this.dk().j(this);
        }
    }

    public final void j(Entity entity) {
        if (this.y(entity)) {
            this.a(entity, Entity::a_);
        }
    }

    protected void a(Entity entity, MoveFunction entity_movefunction) {
        Vec3D vec3d = this.m(entity);
        Vec3D vec3d1 = entity.l(this);
        entity_movefunction.accept(entity, vec3d.d - vec3d1.d, vec3d.e - vec3d1.e, vec3d.f - vec3d1.f);
    }

    public void k(Entity entity) {
    }

    public Vec3D l(Entity entity) {
        return this.ds().b(EntityAttachment.b, 0, this.aE);
    }

    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.be, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return Entity.a(this, entity, entitysize.d());
    }

    protected static Vec3D a(Entity entity, Entity entity1, EntityAttachments entityattachments) {
        int i2 = entity.cY().indexOf(entity1);
        return entityattachments.c(EntityAttachment.a, i2, entity.aE);
    }

    public boolean n(Entity entity) {
        return this.a(entity, false);
    }

    public boolean bM() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean flag) {
        if (entity == this.ay) {
            return false;
        }
        if (!entity.bP()) {
            return false;
        }
        if (!(flag || this.dV().A_() || entity.s.b())) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.ay != null) {
            if (entity1.ay == this) {
                return false;
            }
            entity1 = entity1.ay;
        }
        if (flag || this.o(entity) && entity.r(this)) {
            EntityMountEvent event;
            if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.bY()) {
                this.bO();
            }
            this.b(EntityPose.a);
            this.ay = entity;
            this.ay.p(this);
            entity.C().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.U.a((EntityPlayer)entity2));
            return true;
        }
        return false;
    }

    protected boolean o(Entity entity) {
        return !this.cc() && this.J <= 0;
    }

    public void bN() {
        for (int i2 = this.u.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.u.get(i2)).bO();
        }
    }

    public void aa() {
        if (this.ay != null) {
            Entity entity = this.ay;
            this.ay = null;
            if (!entity.removePassenger(this)) {
                this.ay = entity;
            }
        }
    }

    public void bO() {
        this.aa();
    }

    protected void p(Entity entity) {
        if (entity.dk() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.u.isEmpty()) {
            this.u = ImmutableList.of((Object)entity);
        } else {
            ArrayList list = Lists.newArrayList(this.u);
            if (!this.dV().C && entity instanceof EntityHuman && !(this.cZ() instanceof EntityHuman)) {
                list.add(0, entity);
            } else {
                list.add(entity);
            }
            this.u = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, entity);
    }

    protected boolean removePassenger(Entity entity) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.dk() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.u = this.u.size() == 1 && this.u.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.u.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.J = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean r(Entity entity) {
        return this.u.isEmpty();
    }

    protected boolean bP() {
        return true;
    }

    public final boolean bQ() {
        return this.l_() != null && this.l_().d();
    }

    public final void d(Vec3D vec3d, float f2, float f1) {
        InterpolationHandler interpolationhandler = this.l_();
        if (interpolationhandler != null) {
            interpolationhandler.a(vec3d, f2, f1);
        } else {
            this.b(vec3d);
            this.b(f2, f1);
        }
    }

    @Nullable
    public InterpolationHandler l_() {
        return null;
    }

    public void a(float f2, int i2) {
        this.r(f2);
    }

    public float bR() {
        return 0.0f;
    }

    public Vec3D bS() {
        return this.d(this.dN(), this.dL());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        boolean flag = entityhuman.fc().a(item) && !entityhuman.fb().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fy().e() : entityhuman.fy();
        return this.d(0.0f, this.dL() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F bT() {
        return new Vec2F(this.dN(), this.dL());
    }

    public Vec3D bU() {
        return Vec3D.a(this.bT());
    }

    public void a(Portal portal, BlockPosition blockposition) {
        if (this.aA()) {
            this.ay();
        } else if (this.as != null && this.as.a(portal)) {
            if (!this.as.e()) {
                this.as.a(blockposition.j());
                this.as.a(true);
            }
        } else {
            this.as = new PortalProcessor(portal, blockposition.j());
        }
    }

    protected void bV() {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.L();
            if (this.as != null) {
                if (this.as.a(worldserver, this, this.n(false))) {
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a("portal");
                    this.ay();
                    TeleportTransition teleporttransition = this.as.a(worldserver, this);
                    if (teleporttransition != null) {
                        WorldServer worldserver1 = teleporttransition.b();
                        if (this instanceof EntityPlayer || worldserver1 != null && (worldserver1.aj() == worldserver.aj() || this.a((net.minecraft.world.level.World)worldserver, worldserver1))) {
                            this.b(teleporttransition);
                        }
                    }
                    gameprofilerfiller.c();
                } else if (this.as.b()) {
                    this.as = null;
                }
            }
        }
    }

    public int bW() {
        Entity entity = this.cZ();
        return entity instanceof EntityPlayer ? entity.bW() : 300;
    }

    public void k(double d0, double d1, double d2) {
        this.n(d0, d1, d2);
    }

    public void c(DamageSource damagesource) {
    }

    public void b(byte b0) {
        switch (b0) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void q(float f2) {
    }

    public boolean bX() {
        boolean flag = this.dV() != null && this.dV().C;
        return !this.bh() && (this.aK > 0 || flag && this.i(0));
    }

    public boolean bY() {
        return this.dk() != null;
    }

    public boolean bZ() {
        return !this.u.isEmpty();
    }

    public boolean ca() {
        return this.an().a(TagsEntity.p);
    }

    public boolean cb() {
        return !this.an().a(TagsEntity.q);
    }

    public void g(boolean flag) {
        this.b(1, flag);
    }

    public boolean cc() {
        return this.i(1);
    }

    public boolean cd() {
        return this.cc();
    }

    public boolean ce() {
        return this.cc();
    }

    public boolean cf() {
        return this.cc();
    }

    public boolean cg() {
        return this.cc();
    }

    public boolean ch() {
        return this.c(EntityPose.f);
    }

    public boolean ci() {
        return this.i(3);
    }

    public void h(boolean flag) {
        this.b(3, flag);
    }

    public boolean cj() {
        return this.i(4);
    }

    public boolean ck() {
        return this.c(EntityPose.d);
    }

    public boolean cl() {
        return this.ck() && !this.bi();
    }

    public void i(boolean flag) {
        if (this.valid && this.cj() != flag && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, flag).isCancelled()) {
            return;
        }
        this.b(4, flag);
    }

    public final boolean cm() {
        return this.ba;
    }

    public final void j(boolean flag) {
        this.ba = flag;
        this.b(6, this.cn());
    }

    public boolean cn() {
        return this.dV().A_() ? this.i(6) : this.ba;
    }

    public boolean co() {
        return this.i(5);
    }

    public boolean d(EntityHuman entityhuman) {
        if (entityhuman.ak()) {
            return false;
        }
        ScoreboardTeam scoreboardteambase = this.cq();
        return scoreboardteambase != null && entityhuman != null && entityhuman.cq() == scoreboardteambase && ((ScoreboardTeamBase)scoreboardteambase).j() ? false : this.co();
    }

    public boolean cp() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
    }

    @Nullable
    public ScoreboardTeam cq() {
        return this.dV().R().e(this.cI());
    }

    public final boolean s(@Nullable Entity entity) {
        return entity == null ? false : this == entity || this.t(entity) || entity.t(this);
    }

    protected boolean t(Entity entity) {
        return this.a(entity.cq());
    }

    public boolean a(@Nullable ScoreboardTeamBase scoreboardteambase) {
        return this.cq() != null ? this.cq().a(scoreboardteambase) : false;
    }

    public void k(boolean flag) {
        if (!this.persistentInvisibility) {
            this.b(5, flag);
        }
    }

    public boolean i(int i2) {
        return (this.al.a(am) & 1 << i2) != 0;
    }

    public void b(int i2, boolean flag) {
        byte b0 = this.al.a(am);
        if (flag) {
            this.al.a(am, (byte)(b0 | 1 << i2));
        } else {
            this.al.a(am, (byte)(b0 & ~(1 << i2)));
        }
    }

    public int cr() {
        return this.maxAirTicks;
    }

    public int cs() {
        return this.al.a(aQ);
    }

    public void j(int i2) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cs() != i2) {
            this.al.markDirty(aQ);
            return;
        }
        this.al.a(aQ, event.getAmount());
    }

    public void ct() {
        this.k(0);
    }

    public int cu() {
        return this.al.a(aV);
    }

    public void k(int i2) {
        this.al.a(aV, i2);
    }

    public float cv() {
        int i2 = this.cx();
        return (float)Math.min(this.cu(), i2) / (float)i2;
    }

    public boolean cw() {
        return this.cu() >= this.cx();
    }

    public int cx() {
        return 140;
    }

    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        this.h(this.aK + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = entitylightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aK == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bh()) {
            return;
        }
        if (!this.a(worldserver, this.dW().c().customEntityDamager(entitylightning), 5.0f)) {
            return;
        }
    }

    public void a(boolean flag, BlockPosition blockposition) {
        Entity.a(this, flag, blockposition);
    }

    protected static void a(Entity entity, boolean flag, BlockPosition blockposition) {
        Vec3D vec3d = entity.dy();
        double d0 = flag ? Math.max(-0.9, vec3d.e - 0.03) : Math.min(1.8, vec3d.e + 0.1);
        entity.n(vec3d.d, d0, vec3d.f);
        Entity.a(entity.az, blockposition);
    }

    protected static void a(net.minecraft.world.level.World world, BlockPosition blockposition) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            for (int i2 = 0; i2 < 2; ++i2) {
                worldserver.a(Particles.ap, (double)blockposition.u() + world.A.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + world.A.j(), 1, 0.0, 0.0, 0.0, 1.0);
                worldserver.a(Particles.d, (double)blockposition.u() + world.A.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + world.A.j(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void l(boolean flag) {
        Entity.b(this, flag);
    }

    protected static void b(Entity entity, boolean flag) {
        Vec3D vec3d = entity.dy();
        double d0 = flag ? Math.max(-0.3, vec3d.e - 0.03) : Math.min(0.7, vec3d.e + 0.06);
        entity.n(vec3d.d, d0, vec3d.f);
        entity.j();
    }

    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        return true;
    }

    public void cy() {
        if (this.dy().b() > -0.5 && this.Z > 1.0) {
            this.Z = 1.0;
        }
    }

    public void j() {
        this.Z = 0.0;
    }

    protected void l(double d0, double d1, double d2) {
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        Vec3D vec3d = new Vec3D(d0 - (double)blockposition.u(), d1 - (double)blockposition.v(), d2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.dV().a_(blockposition_mutableblockposition).m(this.dV(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d6 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.ae.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dy().c(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec3d1.e, vec3d1.f);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.n(vec3d1.d, f1 * f2, vec3d1.f);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.n(vec3d1.d, vec3d1.e, f1 * f2);
        }
    }

    public void a(IBlockData iblockdata, Vec3D vec3d) {
        this.j();
        this.U = vec3d;
    }

    private static IChatBaseComponent a(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatmutablecomponent = ichatbasecomponent.e().b(ichatbasecomponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : ichatbasecomponent.c()) {
            ichatmutablecomponent.b(Entity.a(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent ichatbasecomponent = this.aj();
        return ichatbasecomponent != null ? Entity.a(ichatbasecomponent) : this.cz();
    }

    protected IChatBaseComponent cz() {
        return this.s.h();
    }

    public boolean u(Entity entity) {
        return this == entity;
    }

    public float cA() {
        return 0.0f;
    }

    public void r(float f2) {
    }

    public void s(float f2) {
    }

    public boolean cB() {
        return true;
    }

    public boolean v(Entity entity) {
        return false;
    }

    public String toString() {
        String s2 = this.dV() == null ? "~NULL~" : this.dV().toString();
        return this.aI != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.ah().getString(), this.t, s2, this.dA(), this.dC(), this.dG(), this.aI}) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.ah().getString(), this.t, s2, this.dA(), this.dC(), this.dG());
    }

    public final boolean d(DamageSource damagesource) {
        return this.dQ() || this.aZ && !damagesource.a(DamageTypeTags.d) && !damagesource.h() || damagesource.a(DamageTypeTags.i) && this.bh() || damagesource.a(DamageTypeTags.m) && this.an().a(TagsEntity.o);
    }

    public boolean cC() {
        return this.aZ;
    }

    public void m(boolean flag) {
        this.aZ = flag;
    }

    public void w(Entity entity) {
        this.b(entity.dA(), entity.dC(), entity.dG(), entity.dL(), entity.dN());
    }

    public void x(Entity entity) {
        NBTTagCompound nbttagcompound = entity.h(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.i(nbttagcompound);
        this.aY = entity.aY;
        this.as = entity.as;
    }

    @Nullable
    public Entity b(TeleportTransition teleporttransition) {
        net.minecraft.world.level.World worldserver = this.dV();
        if (worldserver instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)worldserver;
            if (!this.dQ()) {
                boolean flag;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (World)teleporttransition.b().getWorld(), absolutePosition.c(), absolutePosition.d());
                EntityTeleportEvent teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                if (teleEvent.isCancelled()) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleporttransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), Vec3D.c, to.getYaw(), to.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
                }
                worldserver1 = teleporttransition.b();
                boolean bl = flag = worldserver.aj() != worldserver1.aj();
                if (!teleporttransition.h()) {
                    this.bO();
                }
                if (flag) {
                    return this.b(worldserver1, teleporttransition);
                }
                return this.a(worldserver1, teleporttransition);
            }
        }
        return null;
    }

    private Entity a(WorldServer worldserver, TeleportTransition teleporttransition) {
        for (Entity entity : this.cY()) {
            entity.b(this.a(teleporttransition, entity));
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        if (!teleporttransition.h()) {
            this.a(teleporttransition);
        }
        teleporttransition.j().onTransition(this);
        gameprofilerfiller.c();
        return this;
    }

    private Entity b(WorldServer worldserver, TeleportTransition teleporttransition) {
        List<Entity> list = this.cY();
        ArrayList<Entity> list1 = new ArrayList<Entity>(list.size());
        this.bN();
        for (Entity entity : list) {
            Entity entity1 = entity.b(this.a(teleporttransition, entity));
            if (entity1 == null) continue;
            list1.add(entity1);
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("teleportCrossDimension");
        Object entity2 = this.an().a(worldserver, EntitySpawnReason.s);
        if (entity2 == null) {
            gameprofilerfiller.c();
            return null;
        }
        ((Entity)entity2).x(this);
        this.cD();
        this.getBukkitEntity().setHandle((Entity)entity2);
        ((Entity)entity2).bukkitEntity = this.getBukkitEntity();
        ((Entity)entity2).a(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        if (this.inWorld) {
            worldserver.d((Entity)entity2);
        }
        for (Entity entity3 : list1) {
            entity3.a((Entity)entity2, true);
        }
        worldserver.i();
        teleporttransition.j().onTransition((Entity)entity2);
        gameprofilerfiller.c();
        return entity2;
    }

    private TeleportTransition a(TeleportTransition teleporttransition, Entity entity) {
        float f2 = teleporttransition.e() + (teleporttransition.i().contains((Object)Relative.d) ? 0.0f : entity.dL() - this.dL());
        float f1 = teleporttransition.f() + (teleporttransition.i().contains((Object)Relative.e) ? 0.0f : entity.dN() - this.dN());
        Vec3D vec3d = entity.dt().d(this.dt());
        Vec3D vec3d1 = teleporttransition.c().b(teleporttransition.i().contains((Object)Relative.a) ? 0.0 : vec3d.a(), teleporttransition.i().contains((Object)Relative.b) ? 0.0 : vec3d.b(), teleporttransition.i().contains((Object)Relative.c) ? 0.0 : vec3d.c());
        return teleporttransition.a(vec3d1).a(f2, f1).a();
    }

    private void a(TeleportTransition teleporttransition) {
        EntityLiving entity = this.cW();
        for (Entity entity1 : this.dc()) {
            if (!(entity1 instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity1;
            if (entity != null && entityplayer.ao() == entity.ao()) {
                entityplayer.f.b(PacketPlayOutEntityTeleport.a(this.ao(), PositionMoveRotation.a(teleporttransition), teleporttransition.i(), this.aH));
                continue;
            }
            entityplayer.f.b(PacketPlayOutEntityTeleport.a(this.ao(), PositionMoveRotation.a(this), Set.of(), this.aH));
        }
    }

    public void a(PositionMoveRotation positionmoverotation, Set<Relative> set) {
        PositionMoveRotation positionmoverotation1 = PositionMoveRotation.a(this);
        PositionMoveRotation positionmoverotation2 = PositionMoveRotation.a(positionmoverotation1, positionmoverotation, set);
        this.o(positionmoverotation2.a().d, positionmoverotation2.a().e, positionmoverotation2.a().f);
        this.w(positionmoverotation2.c());
        this.r(positionmoverotation2.c());
        this.x(positionmoverotation2.d());
        this.av();
        this.bx();
        this.i(positionmoverotation2.b());
        this.bl.clear();
    }

    public void a(float f2, float f1) {
        this.w(f2);
        this.r(f2);
        this.x(f1);
        this.bz();
    }

    public void f(BlockPosition blockposition) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.m().a(TicketType.g, new ChunkCoordIntPair(blockposition), 3);
        }
    }

    protected void cD() {
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            this.dV().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            leashable.y();
        }
    }

    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return BlockPortalShape.a(blockutil_rectangle, enumdirection_enumaxis, this.dt(), this.a(this.at()));
    }

    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bJ()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean n(boolean flag) {
        return (flag || !this.bY()) && this.bJ();
    }

    public boolean a(net.minecraft.world.level.World world, net.minecraft.world.level.World world1) {
        if (world.aj() == net.minecraft.world.level.World.k && world1.aj() == net.minecraft.world.level.World.i) {
            for (Entity entity : this.cY()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, Fluid fluid, float f2) {
        return f2;
    }

    public boolean a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, float f2) {
        return true;
    }

    public int cE() {
        return 3;
    }

    public boolean n_() {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Entity Type", () -> {
            String s2 = String.valueOf(EntityTypes.a(this.an()));
            return s2 + " (" + this.getClass().getCanonicalName() + ")";
        });
        crashreportsystemdetails.a("Entity ID", this.t);
        crashreportsystemdetails.a("Entity Name", () -> this.ah().getString());
        crashreportsystemdetails.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dA(), this.dC(), this.dG()));
        crashreportsystemdetails.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dV(), MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG())));
        Vec3D vec3d = this.dy();
        crashreportsystemdetails.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.d, vec3d.e, vec3d.f));
        crashreportsystemdetails.a("Entity's Passengers", () -> this.cY().toString());
        crashreportsystemdetails.a("Entity's Vehicle", () -> String.valueOf(this.dk()));
    }

    public boolean cF() {
        return this.bX() && !this.ak();
    }

    public void a_(UUID uuid) {
        this.at = uuid;
        this.au = this.at.toString();
    }

    @Override
    public UUID cG() {
        return this.at;
    }

    public String cH() {
        return this.au;
    }

    @Override
    public String cI() {
        return this.au;
    }

    public boolean cJ() {
        return true;
    }

    public static double cK() {
        return r;
    }

    public static void b(double d0) {
        r = d0;
    }

    @Override
    public IChatBaseComponent P_() {
        return ScoreboardTeam.a(this.cq(), this.ah()).a(chatmodifier -> chatmodifier.a(this.cQ()).a(this.cH()));
    }

    public void b(@Nullable IChatBaseComponent ichatbasecomponent) {
        this.al.a(aR, Optional.ofNullable(ichatbasecomponent));
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.al.a(aR).orElse(null);
    }

    @Override
    public boolean g_() {
        return this.al.a(aR).isPresent();
    }

    public void o(boolean flag) {
        this.al.a(aS, flag);
    }

    public boolean cL() {
        return this.al.a(aS);
    }

    public final boolean a(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag) {
        return this.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.b(new TeleportTransition(worldserver, new Vec3D(d0, d1, d2), Vec3D.c, f2, f1, set, TeleportTransition.a, cause));
        return entity != null;
    }

    public void m(double d0, double d1, double d2) {
        this.b(d0, d1, d2);
    }

    public void b(double d0, double d1, double d2) {
        if (this.dV() instanceof WorldServer) {
            this.b(d0, d1, d2, this.dL(), this.dN());
            this.n();
        }
    }

    private void n() {
        this.da().forEach(entity -> {
            for (Entity entity1 : entity.u) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double d0, double d1, double d2) {
        this.b(this.dA() + d0, this.dC() + d1, this.dG() + d2);
    }

    public boolean cM() {
        return this.cL();
    }

    @Override
    public void a(List<DataWatcher.c<?>> list) {
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aq.equals(datawatcherobject)) {
            this.h_();
        }
    }

    @Deprecated
    protected void cN() {
        EntitySize entitysize;
        EntityPose entitypose = this.at();
        this.be = entitysize = this.a(entitypose);
        this.bf = entitysize.c();
    }

    public void h_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.be;
        EntityPose entitypose = this.at();
        this.be = entitysize1 = this.a(entitypose);
        this.bf = entitysize1.c();
        this.av();
        boolean bl = flag = entitysize1.a() <= 4.0f && entitysize1.b() <= 4.0f;
        if (!(this.az.C || this.ak || this.ad || !flag || !(entitysize1.a() > entitysize.a()) && !(entitysize1.b() > entitysize.b()) || this instanceof EntityHuman)) {
            this.a(entitysize);
        }
    }

    public boolean a(EntitySize entitysize) {
        VoxelShape voxelshape1;
        Optional<Vec3D> optional1;
        double d1;
        double d0;
        EntitySize entitysize1 = this.a(this.at());
        Vec3D vec3d = this.dt().b(0.0, (double)entitysize.b() / 2.0, 0.0);
        VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0 = (double)Math.max(0.0f, entitysize1.a() - entitysize.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, entitysize1.b() - entitysize.b()) + 1.0E-6, d0));
        Optional<Vec3D> optional = this.az.a(this, voxelshape, vec3d, (double)entitysize1.a(), (double)entitysize1.b(), (double)entitysize1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-entitysize1.b()) / 2.0, 0.0));
            return true;
        }
        if (entitysize1.a() > entitysize.a() && entitysize1.b() > entitysize.b() && (optional1 = this.az.a(this, voxelshape1 = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, 1.0E-6, d0)), vec3d, (double)entitysize1.a(), (double)entitysize.b(), (double)entitysize1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-entitysize.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection cO() {
        return EnumDirection.a(this.dL());
    }

    public EnumDirection cP() {
        return this.cO();
    }

    protected ChatHoverable cQ() {
        return new ChatHoverable.c(new ChatHoverable.b(this.an(), this.cG(), this.ah()));
    }

    public boolean a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public final AxisAlignedBB cR() {
        return this.aG;
    }

    public final void a(AxisAlignedBB axisalignedbb) {
        double minX = axisalignedbb.a;
        double minY = axisalignedbb.b;
        double minZ = axisalignedbb.c;
        double maxX = axisalignedbb.d;
        double maxY = axisalignedbb.e;
        double maxZ = axisalignedbb.f;
        double len = axisalignedbb.d - axisalignedbb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = axisalignedbb.e - axisalignedbb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = axisalignedbb.f - axisalignedbb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aG = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float d(EntityPose entitypose) {
        return this.a(entitypose).c();
    }

    public final float cS() {
        return this.bf;
    }

    public Vec3D t(float f2) {
        return this.cT();
    }

    protected Vec3D cT() {
        return new Vec3D(0.0, this.cS(), this.dq() * 0.4f);
    }

    public SlotAccess a_(int i2) {
        return SlotAccess.a;
    }

    public net.minecraft.world.level.World cU() {
        return this.dV();
    }

    @Nullable
    public MinecraftServer cV() {
        return this.dV().p();
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer entityplayer) {
    }

    public void e(EntityPlayer entityplayer) {
    }

    public float a(EnumBlockRotation enumblockrotation) {
        float f2 = MathHelper.h(this.dL());
        switch (enumblockrotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror enumblockmirror) {
        float f2 = MathHelper.h(this.dL());
        switch (enumblockmirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public ProjectileDeflection a(IProjectile iprojectile) {
        return this.an().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @Nullable
    public EntityLiving cW() {
        return null;
    }

    public final boolean cX() {
        return this.cW() != null;
    }

    public final List<Entity> cY() {
        return this.u;
    }

    @Nullable
    public Entity cZ() {
        return this.u.isEmpty() ? null : (Entity)this.u.get(0);
    }

    public boolean y(Entity entity) {
        return this.u.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        for (Entity entity : this.u) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> C() {
        return this.u.stream().flatMap(Entity::da);
    }

    public Stream<Entity> da() {
        return Stream.concat(Stream.of(this), this.C());
    }

    public Stream<Entity> db() {
        return Stream.concat(this.u.stream().flatMap(Entity::db), Stream.of(this));
    }

    public Iterable<Entity> dc() {
        return () -> this.C().iterator();
    }

    public int dd() {
        return (int)this.C().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean de() {
        return this.dd() == 1;
    }

    public Entity df() {
        Entity entity = this;
        while (entity.bY()) {
            entity = entity.dk();
        }
        return entity;
    }

    public boolean z(Entity entity) {
        return this.df() == entity.df();
    }

    public boolean A(Entity entity) {
        if (!entity.bY()) {
            return false;
        }
        Entity entity1 = entity.dk();
        return entity1 == this ? true : this.A(entity1);
    }

    public final boolean dg() {
        return this.az.A_() ? this.dh() : !this.Z_();
    }

    protected boolean dh() {
        EntityLiving entityliving = this.cW();
        return entityliving != null && entityliving.dh();
    }

    public boolean Z_() {
        EntityLiving entityliving = this.cW();
        return entityliving != null && entityliving.Z_();
    }

    public boolean di() {
        return this.dg();
    }

    public boolean dj() {
        return this.dg();
    }

    protected static Vec3D a(double d0, double d1, float f2) {
        double d2 = (d0 + d1 + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(f2 * ((float)Math.PI / 180));
        float f22 = MathHelper.b(f2 * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f22));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f22 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving entityliving) {
        return new Vec3D(this.dA(), this.cR().e, this.dG());
    }

    @Nullable
    public Entity dk() {
        return this.ay;
    }

    @Nullable
    public Entity dl() {
        return this.ay != null && this.ay.cW() == this ? this.ay : null;
    }

    public EnumPistonReaction i_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dm() {
        return SoundCategory.g;
    }

    public int dn() {
        return 1;
    }

    public CommandListenerWrapper d(WorldServer worldserver) {
        return new CommandListenerWrapper(this.commandSource, this.dt(), this.bT(), worldserver, 0, this.ah().getString(), this.P_(), worldserver.p(), this);
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        Vec3D vec3d1 = argumentanchor_anchor.a(this);
        double d0 = vec3d.d - vec3d1.d;
        double d1 = vec3d.e - vec3d1.e;
        double d2 = vec3d.f - vec3d1.f;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.x(MathHelper.h((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.w(MathHelper.h((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.r(this.dL());
        this.O = this.dN();
        this.N = this.dL();
    }

    public float u(float f2) {
        return MathHelper.h(f2, this.N, this.aE);
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        if (this.do()) {
            return false;
        }
        AxisAlignedBB axisalignedbb = this.cR().h(0.001);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.b);
        int l2 = MathHelper.c(axisalignedbb.e);
        int i1 = MathHelper.a(axisalignedbb.c);
        int j1 = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cJ();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.c;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l1 = i2; l1 < j2; ++l1) {
            for (int i22 = k2; i22 < l2; ++i22) {
                for (int j22 = i1; j22 < j1; ++j22) {
                    double d2;
                    blockposition_mutableblockposition.d(l1, i22, j22);
                    Fluid fluid = this.dV().b_(blockposition_mutableblockposition);
                    if (!fluid.a(tagkey) || !((d2 = (double)((float)i22 + fluid.a(this.dV(), blockposition_mutableblockposition))) >= axisalignedbb.b)) continue;
                    flag1 = true;
                    d1 = Math.max(d2 - axisalignedbb.b, d1);
                    if (flag) {
                        Vec3D vec3d1 = fluid.c(this.dV(), blockposition_mutableblockposition);
                        if (d1 < 0.4) {
                            vec3d1 = vec3d1.c(d1);
                        }
                        vec3d = vec3d.e(vec3d1);
                        ++k1;
                    }
                    if (tagkey != TagsFluid.b) continue;
                    this.lastLavaContact = blockposition_mutableblockposition.j();
                }
            }
        }
        if (vec3d.g() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.c(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dy();
            vec3d = vec3d.c(d0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.d) < 0.003 && Math.abs(vec3d2.f) < 0.003 && vec3d.g() < 0.0045000000000000005) {
                vec3d = vec3d.d().c(0.0045000000000000005);
            }
            this.i(this.dy().e(vec3d));
        }
        this.ah.put(tagkey, d1);
        return flag1;
    }

    public boolean do() {
        AxisAlignedBB axisalignedbb = this.cR().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dV().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> tagkey) {
        return this.ah.getDouble(tagkey);
    }

    public double dp() {
        return (double)this.cS() < 0.4 ? 0.0 : 0.4;
    }

    public final float dq() {
        return this.be.a();
    }

    public final float dr() {
        return this.be.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity(this, entitytrackerentry);
    }

    public EntitySize a(EntityPose entitypose) {
        return this.s.n();
    }

    public final EntityAttachments ds() {
        return this.be.d();
    }

    public Vec3D dt() {
        return this.aA;
    }

    public Vec3D du() {
        return this.dt();
    }

    @Override
    public BlockPosition dv() {
        return this.aB;
    }

    public IBlockData dw() {
        if (this.bk == null) {
            this.bk = this.dV().a_(this.dv());
        }
        return this.bk;
    }

    public ChunkCoordIntPair dx() {
        return this.aC;
    }

    public Vec3D dy() {
        return this.aD;
    }

    public void i(Vec3D vec3d) {
        this.aD = vec3d;
    }

    public void j(Vec3D vec3d) {
        this.i(this.dy().e(vec3d));
    }

    public void n(double d0, double d1, double d2) {
        this.i(new Vec3D(d0, d1, d2));
    }

    public final int dz() {
        return this.aB.u();
    }

    public final double dA() {
        return this.aA.d;
    }

    public double c(double d0) {
        return this.aA.d + (double)this.dq() * d0;
    }

    public double d(double d0) {
        return this.c((2.0 * this.ae.j() - 1.0) * d0);
    }

    public final int dB() {
        return this.aB.v();
    }

    public final double dC() {
        return this.aA.e;
    }

    public double e(double d0) {
        return this.aA.e + (double)this.dr() * d0;
    }

    public double dD() {
        return this.e(this.ae.j());
    }

    public double dE() {
        return this.aA.e + (double)this.bf;
    }

    public final int dF() {
        return this.aB.w();
    }

    public final double dG() {
        return this.aA.f;
    }

    public double f(double d0) {
        return this.aA.f + (double)this.dq() * d0;
    }

    public double g(double d0) {
        return this.f((2.0 * this.ae.j() - 1.0) * d0);
    }

    public final void o(double d0, double d1, double d2) {
        if (this.aA.d != d0 || this.aA.e != d1 || this.aA.f != d2) {
            this.aA = new Vec3D(d0, d1, d2);
            int i2 = MathHelper.a(d0);
            int j2 = MathHelper.a(d1);
            int k2 = MathHelper.a(d2);
            if (i2 != this.aB.u() || j2 != this.aB.v() || k2 != this.aB.w()) {
                this.aB = new BlockPosition(i2, j2, k2);
                this.bk = null;
                if (SectionPosition.a(i2) != this.aC.h || SectionPosition.a(k2) != this.aC.i) {
                    this.aC = new ChunkCoordIntPair(this.aB);
                }
            }
            this.aW.a();
        }
    }

    public void dH() {
    }

    public Vec3D v(float f2) {
        return this.p(f2).b(0.0, (double)this.bf * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        int i2 = packetplayoutspawnentity.b();
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        this.e(d0, d1, d2);
        this.b(d0, d1, d2, packetplayoutspawnentity.n(), packetplayoutspawnentity.m());
        this.e(i2);
        this.a_(packetplayoutspawnentity.e());
        Vec3D vec3d = new Vec3D(packetplayoutspawnentity.j(), packetplayoutspawnentity.k(), packetplayoutspawnentity.l());
        this.i(vec3d);
    }

    @Nullable
    public ItemStack dI() {
        return null;
    }

    public void p(boolean flag) {
        this.av = flag;
    }

    public boolean dJ() {
        return !this.an().a(TagsEntity.k);
    }

    public boolean dK() {
        return this.cu() > 0;
    }

    public float dL() {
        return this.aE;
    }

    public float dM() {
        return this.dL();
    }

    public void w(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aE = f2;
        }
    }

    public float dN() {
        return this.aF;
    }

    public void x(float f2) {
        if (!Float.isFinite(f2)) {
            SystemUtils.b("Invalid entity rotation: " + f2 + ", discarding.");
        } else {
            this.aF = Math.clamp(f2 % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean dO() {
        return false;
    }

    public float dP() {
        return 0.0f;
    }

    public void b_(@Nullable Entity entity) {
    }

    @Override
    public final boolean dQ() {
        return this.aI != null;
    }

    @Nullable
    public RemovalReason dR() {
        return this.aI;
    }

    @Override
    public final void c(RemovalReason entity_removalreason) {
        this.setRemoved(entity_removalreason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        if (this.aI == null) {
            this.aI = entity_removalreason;
        }
        if (this.aI.a()) {
            this.bO();
        }
        this.cY().forEach(Entity::bO);
        this.aW.a(entity_removalreason);
        this.b(entity_removalreason);
    }

    public void dS() {
        this.aI = null;
    }

    @Override
    public void a(EntityInLevelCallback entityinlevelcallback) {
        this.aW = entityinlevelcallback;
    }

    @Override
    public boolean dT() {
        return this.aI != null && !this.aI.b() ? false : (this.bY() ? false : !this.bZ() || !this.de());
    }

    @Override
    public boolean dU() {
        return false;
    }

    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return true;
    }

    public net.minecraft.world.level.World dV() {
        return this.az;
    }

    protected void a(net.minecraft.world.level.World world) {
        this.az = world;
    }

    public DamageSources dW() {
        return this.dV().al();
    }

    public IRegistryCustom dX() {
        return this.dV().J_();
    }

    protected void a(int i2, double d0, double d1, double d2, double d3, double d4) {
        double d5 = 1.0 / (double)i2;
        double d6 = MathHelper.d(d5, this.dA(), d0);
        double d7 = MathHelper.d(d5, this.dC(), d1);
        double d8 = MathHelper.d(d5, this.dG(), d2);
        float f2 = (float)MathHelper.e(d5, (double)this.dL(), d3);
        float f1 = (float)MathHelper.d(d5, (double)this.dN(), d4);
        this.a_(d6, d7, d8);
        this.b(f2, f1);
    }

    public RandomSource dY() {
        return this.ae;
    }

    public Vec3D ad() {
        EntityLiving entityliving = this.cW();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            if (this.bJ()) {
                return entityhuman.ad();
            }
        }
        return this.dy();
    }

    @Nullable
    public ItemStack dZ() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> ea() {
        return this.s.j();
    }

    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.g);
        this.a(datacomponentgetter, DataComponents.b);
    }

    public final void c(ItemStack itemstack) {
        this.a(itemstack.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return (T)(datacomponenttype == DataComponents.g ? Entity.c(datacomponenttype, this.aj()) : (datacomponenttype == DataComponents.b ? Entity.c(datacomponenttype, this.bp) : null));
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T c(DataComponentType<T> datacomponenttype, @Nullable Object object) {
        return (T)object;
    }

    public <T> void d(DataComponentType<T> datacomponenttype, T t0) {
        this.b(datacomponenttype, t0);
    }

    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.g) {
            this.b(Entity.c(DataComponents.g, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.b) {
            this.bp = Entity.c(DataComponents.b, t0);
            return true;
        }
        return false;
    }

    protected <T> boolean a(DataComponentGetter datacomponentgetter, DataComponentType<T> datacomponenttype) {
        T t0 = datacomponentgetter.a(datacomponenttype);
        return t0 != null ? this.b(datacomponenttype, t0) : false;
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    private record b(Vec3D a, Vec3D b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "from;to", "a", "b"}, this, o2);
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

