/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final int j = 0;
    private static final int k = 0;
    private static final float l = 0.0f;
    private static final float m = 0.0f;
    private static final float n = 1.0f;
    private static final float o = 0.5f;
    private static final float p = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public static final int c = -1;
    public static final int d = 600;
    private static final int q = 20;
    private static final int r = 20;
    private static final ColorParticleOption s = ColorParticleOption.a(Particles.u, -1);
    public PotionContents t = PotionContents.a;
    private float u = 1.0f;
    private final Map<Entity, Integer> ay = Maps.newHashMap();
    private int az = -1;
    public int aA = 20;
    public int aB = 20;
    public int aC = 0;
    public float aD = 0.0f;
    public float aE = 0.0f;
    @Nullable
    private EntityLiving aF;
    @Nullable
    private UUID aG;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entitytypes, World world) {
        super(entitytypes, world);
        this.ad = true;
    }

    public EntityAreaEffectCloud(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.e, world);
        this.a_(d0, d1, d2);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, Float.valueOf(3.0f));
        datawatcher_a.a(g, false);
        datawatcher_a.a(h, s);
    }

    public void a(float f2) {
        if (!this.dV().C) {
            this.ar().a(f, Float.valueOf(MathHelper.a(f2, 0.0f, 32.0f)));
        }
    }

    @Override
    public void h_() {
        double d0 = this.dA();
        double d1 = this.dC();
        double d2 = this.dG();
        super.h_();
        this.a_(d0, d1, d2);
    }

    public float c() {
        return this.ar().a(f).floatValue();
    }

    public void a(PotionContents potioncontents) {
        this.t = potioncontents;
        this.r();
    }

    public void b(float f2) {
        this.u = f2;
    }

    public void r() {
        ParticleParam particleparam = this.al.a(h);
        if (particleparam instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleparam;
            int i2 = this.t.equals(PotionContents.a) ? 0 : this.t.b();
            this.al.a(h, ColorParticleOption.a(colorparticleoption.a(), ARGB.f(i2)));
        }
    }

    public void a(MobEffect mobeffect) {
        this.a(this.t.a(mobeffect));
    }

    public ParticleParam e() {
        return this.ar().a(h);
    }

    public void a(ParticleParam particleparam) {
        this.ar().a(h, particleparam);
    }

    protected void a(boolean flag) {
        this.ar().a(g, flag);
    }

    public boolean f() {
        return this.ar().a(g);
    }

    public int h() {
        return this.az;
    }

    public void a(int i2) {
        this.az = i2;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.af >= this.aA + this.az) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void g() {
        super.g();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver);
        } else {
            this.s();
        }
    }

    private void s() {
        boolean flag = this.f();
        float f2 = this.c();
        if (!flag || !this.ae.h()) {
            float f1;
            int i2;
            ParticleParam particleparam = this.e();
            if (flag) {
                i2 = 2;
                f1 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * f2 * f2);
                f1 = f2;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                float f22 = this.ae.i() * ((float)Math.PI * 2);
                float f3 = MathHelper.c(this.ae.i()) * f1;
                double d0 = this.dA() + (double)(MathHelper.b(f22) * f3);
                double d1 = this.dC();
                double d2 = this.dG() + (double)(MathHelper.a(f22) * f3);
                if (particleparam.a() == Particles.u) {
                    if (flag && this.ae.h()) {
                        this.dV().b(ColorParticleOption.a(Particles.u, -1), d0, d1, d2, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.dV().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                if (flag) {
                    this.dV().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                this.dV().b(particleparam, d0, d1, d2, (0.5 - this.ae.j()) * 0.15, 0.01f, (0.5 - this.ae.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer worldserver) {
        if (this.az != -1 && this.af >= this.aA + this.az) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag1;
            boolean flag = this.f();
            boolean bl = flag1 = this.af < this.aA;
            if (flag != flag1) {
                this.a(flag1);
            }
            if (!flag1) {
                float f2 = this.c();
                if (this.aE != 0.0f) {
                    if ((f2 += this.aE) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.af % 5 == 0) {
                    this.ay.entrySet().removeIf(entry -> this.af >= (Integer)entry.getValue());
                    if (!this.t.c()) {
                        this.ay.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        PotionContents potioncontents = this.t;
                        Objects.requireNonNull(list);
                        potioncontents.a(list::add, this.u);
                        List<EntityLiving> list1 = this.dV().a(EntityLiving.class, this.cR());
                        if (!list1.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving entityliving : list1) {
                                double d1;
                                double d0;
                                double d2;
                                if (this.ay.containsKey(entityliving) || !entityliving.fL()) continue;
                                Stream stream = list.stream();
                                Objects.requireNonNull(entityliving);
                                if (stream.noneMatch(entityliving::b) || !((d2 = (d0 = entityliving.dA() - this.dA()) * d0 + (d1 = entityliving.dG() - this.dG()) * d1) <= (double)(f2 * f2))) continue;
                                entities.add((LivingEntity)entityliving.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                                    this.ay.put(entityliving, this.af + this.aB);
                                    for (MobEffect mobeffect : list) {
                                        if (mobeffect.c().a().a()) {
                                            mobeffect.c().a().a(worldserver, this, this.n(), entityliving, mobeffect.e(), 0.5);
                                            continue;
                                        }
                                        entityliving.addEffect(new MobEffect(mobeffect), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.aD != 0.0f) {
                                        if ((f2 += this.aD) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(f2);
                                    }
                                    if (this.aC == 0 || this.az == -1) continue;
                                    this.az += this.aC;
                                    if (this.az > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.aD;
    }

    public void c(float f2) {
        this.aD = f2;
    }

    public float k() {
        return this.aE;
    }

    public void d(float f2) {
        this.aE = f2;
    }

    public int l() {
        return this.aC;
    }

    public void b(int i2) {
        this.aC = i2;
    }

    public int m() {
        return this.aA;
    }

    public void c(int i2) {
        this.aA = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.aF = entityliving;
        this.aG = entityliving == null ? null : entityliving.cG();
    }

    @Nullable
    public EntityLiving n() {
        World world;
        if (this.aF != null && !this.aF.dQ()) {
            return this.aF;
        }
        if (this.aG != null && (world = this.dV()) instanceof WorldServer) {
            EntityLiving entityliving1;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = worldserver.b(this.aG);
            EntityLiving entityliving = entity instanceof EntityLiving ? (entityliving1 = (EntityLiving)entity) : null;
            this.aF = entityliving;
        }
        return this.aF;
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound) {
        this.af = nbttagcompound.b("Age", 0);
        this.az = nbttagcompound.b("Duration", -1);
        this.aA = nbttagcompound.b("WaitTime", 20);
        this.aB = nbttagcompound.b("ReapplicationDelay", 20);
        this.aC = nbttagcompound.b("DurationOnUse", 0);
        this.aD = nbttagcompound.b("RadiusOnUse", 0.0f);
        this.aE = nbttagcompound.b("RadiusPerTick", 0.0f);
        this.a(nbttagcompound.b("Radius", 3.0f));
        this.aG = nbttagcompound.a("Owner", UUIDUtil.a).orElse(null);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.a(nbttagcompound.a("Particle", Particles.bk, (DynamicOps<NBTBase>)registryops).orElse(s));
        this.a(nbttagcompound.a("potion_contents", PotionContents.c, (DynamicOps<NBTBase>)registryops).orElse(PotionContents.a));
        this.u = nbttagcompound.b("potion_duration_scale", 1.0f);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Age", this.af);
        nbttagcompound.a("Duration", this.az);
        nbttagcompound.a("WaitTime", this.aA);
        nbttagcompound.a("ReapplicationDelay", this.aB);
        nbttagcompound.a("DurationOnUse", this.aC);
        nbttagcompound.a("RadiusOnUse", this.aD);
        nbttagcompound.a("RadiusPerTick", this.aE);
        nbttagcompound.a("Radius", this.c());
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        nbttagcompound.a("Particle", Particles.bk, registryops, this.e());
        nbttagcompound.b("Owner", UUIDUtil.a, this.aG);
        if (!this.t.equals(PotionContents.a)) {
            nbttagcompound.a("potion_contents", PotionContents.c, registryops, this.t);
        }
        if (this.u != 1.0f) {
            nbttagcompound.a("potion_duration_scale", this.u);
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (f.equals(datawatcherobject)) {
            this.h_();
        }
        super.a(datawatcherobject);
    }

    @Override
    public EnumPistonReaction i_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return false;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.R ? EntityAreaEffectCloud.c(datacomponenttype, this.t) : (datacomponenttype == DataComponents.S ? EntityAreaEffectCloud.c(datacomponenttype, Float.valueOf(this.u)) : super.a(datacomponenttype));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.R);
        this.a(datacomponentgetter, DataComponents.S);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.R) {
            this.a(EntityAreaEffectCloud.c(DataComponents.R, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.S) {
            this.b(EntityAreaEffectCloud.c(DataComponents.S, t0).floatValue());
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

