/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int j = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> bH = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float k = 0.15f;
    public static final float bu = 0.55f;
    public static final float bv = 0.5f;
    public static final float bw = 0.25f;
    public static final int bx = 2;
    private static final double bI = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean bJ = false;
    private static final boolean bK = false;
    private static final boolean bL = false;
    private static final boolean bM = false;
    protected static final MinecraftKey by = MinecraftKey.b("random_spawn_bonus");
    public int bz;
    protected int bA;
    protected ControllerLook bB;
    protected ControllerMove bC;
    protected ControllerJump bD;
    private final EntityAIBodyControl bN;
    protected NavigationAbstract bE;
    public PathfinderGoalSelector bF;
    public PathfinderGoalSelector bG;
    @Nullable
    private EntityLiving bO;
    private final EntitySenses bP;
    private DropChances bQ = DropChances.d;
    private boolean bR = false;
    private boolean bS = false;
    private final Map<PathType, Float> bT = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> bU = Optional.empty();
    public long bV;
    @Nullable
    private Leashable.a bW;
    private BlockPosition bX = BlockPosition.c;
    private float bY = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.bF = new PathfinderGoalSelector();
        this.bG = new PathfinderGoalSelector();
        this.bB = new ControllerLook(this);
        this.bC = new ControllerMove(this);
        this.bD = new ControllerJump(this);
        this.bN = this.H();
        this.bE = this.b(world);
        this.bP = new EntitySenses(this);
        if (world instanceof WorldServer) {
            this.C();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.bS = persistenceRequired;
    }

    protected void C() {
    }

    public static AttributeProvider.Builder D() {
        return EntityLiving.ee().a(GenericAttributes.m, 16.0);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean E() {
        return false;
    }

    public float a(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.dl();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).E() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.bT.get((Object)pathtype);
        return ofloat == null ? pathtype.a() : ofloat.floatValue();
    }

    public void a(PathType pathtype, float f2) {
        this.bT.put(pathtype, Float.valueOf(f2));
    }

    public void F() {
    }

    public void G() {
    }

    protected EntityAIBodyControl H() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook I() {
        return this.bB;
    }

    public ControllerMove K() {
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.K();
        }
        return this.bC;
    }

    public ControllerJump M() {
        return this.bD;
    }

    public NavigationAbstract N() {
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.N();
        }
        return this.bE;
    }

    @Override
    @Nullable
    public EntityLiving cW() {
        Entity entity = this.cZ();
        if (!this.gj() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.cb()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses O() {
        return this.bP;
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.bO;
    }

    @Nullable
    protected final EntityLiving P() {
        return this.ec().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.e() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.e() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.e().bJ() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dV().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bO = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.ae;
    }

    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return false;
    }

    public void Q() {
        ((Entity)this).a(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, (byte)0);
    }

    public int R() {
        return 80;
    }

    public void S() {
        this.b(this.s());
    }

    @Override
    public void aw() {
        super.aw();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("mobBaseTick");
        if (this.bJ() && this.ae.a(1000) < this.bz++) {
            this.m();
            this.S();
        }
        gameprofilerfiller.c();
    }

    @Override
    protected void h(DamageSource damagesource) {
        this.m();
        super.h(damagesource);
    }

    private void m() {
        this.bz = -this.R();
    }

    @Override
    protected int e(WorldServer worldserver) {
        if (this.bA > 0) {
            int i2 = this.bA;
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                ItemStack itemstack;
                if (!enumitemslot.g() || (itemstack = this.a(enumitemslot)).f() || !(this.bQ.b(enumitemslot) <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            return i2;
        }
        return this.bA;
    }

    public void T() {
        if (this.dV().C) {
            this.eY();
        } else {
            this.dV().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 20) {
            this.T();
        } else {
            super.b(b0);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.dV().C && this.af % 5 == 0) {
            this.U();
        }
    }

    protected void U() {
        boolean flag = !(this.cW() instanceof EntityInsentient);
        boolean flag1 = !(this.dk() instanceof AbstractBoat);
        this.bF.a(PathfinderGoal.Type.a, flag);
        this.bF.a(PathfinderGoal.Type.c, flag && flag1);
        this.bF.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void C(float f2) {
        this.bN.a();
    }

    @Nullable
    protected SoundEffect s() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.s();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("CanPickUpLoot", this.fN());
        nbttagcompound.a("PersistenceRequired", this.bS);
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        if (!this.bQ.equals(DropChances.d)) {
            nbttagcompound.a("drop_chances", DropChances.e, registryops, this.bQ);
        }
        this.a(nbttagcompound, this.bW);
        nbttagcompound.a("LeftHanded", this.gk());
        this.bU.ifPresent(resourcekey -> nbttagcompound.a("DeathLootTable", LootTable.a, resourcekey));
        if (this.bV != 0L) {
            nbttagcompound.a("DeathLootTableSeed", this.bV);
        }
        if (this.gj()) {
            nbttagcompound.a("NoAI", this.gj());
        }
        nbttagcompound.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        boolean data;
        super.a(nbttagcompound);
        if (nbttagcompound.b("CanPickUpLoot")) {
            data = nbttagcompound.b("CanPickUpLoot", false);
            if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
                this.a_(data);
            }
        }
        data = nbttagcompound.b("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(nbttagcompound, 1) || data) {
            this.bS = data;
        }
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        this.bQ = nbttagcompound.a("drop_chances", DropChances.e, (DynamicOps<NBTBase>)registryops).orElse(DropChances.d);
        this.c(nbttagcompound);
        this.u(nbttagcompound.b("LeftHanded", false));
        this.bU = nbttagcompound.a("DeathLootTable", LootTable.a);
        this.bV = nbttagcompound.b("DeathLootTableSeed", 0L);
        this.t(nbttagcompound.b("NoAI", false));
        this.aware = nbttagcompound.b("Bukkit.Aware", this.aware);
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.b(worldserver, damagesource, flag);
        this.bU = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> ea() {
        return this.bU.isPresent() ? this.bU : super.ea();
    }

    @Override
    public long eJ() {
        return this.bV;
    }

    public void G(float f2) {
        this.bi = f2;
    }

    public void H(float f2) {
        this.bh = f2;
    }

    public void I(float f2) {
        this.bg = f2;
    }

    @Override
    public void B(float f2) {
        super.B(f2);
        this.G(f2);
    }

    public void V() {
        this.N().m();
        this.I(0.0f);
        this.H(0.0f);
        this.B(0.0f);
    }

    @Override
    public void d_() {
        super.d_();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("looting");
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.fN() && this.bJ() && !this.bc && worldserver.O().c(GameRules.d)) {
                BaseBlockPosition baseblockposition = this.W();
                for (EntityItem entityitem : this.dV().a(EntityItem.class, this.cR().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()))) {
                    if (entityitem.dQ() || entityitem.e().f() || entityitem.n() || !this.c(worldserver, entityitem.e())) continue;
                    this.a(worldserver, entityitem);
                }
            }
        }
        gameprofilerfiller.c();
    }

    protected BaseBlockPosition W() {
        return e;
    }

    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        ItemStack itemstack1 = this.equipItemIfPossible(worldserver, itemstack.v(), entityitem);
        if (!itemstack1.f()) {
            this.a(entityitem);
            this.a((Entity)entityitem, itemstack1.M());
            itemstack.h(itemstack1.M());
            if (itemstack.f()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer worldserver, ItemStack itemstack) {
        return this.equipItemIfPossible(worldserver, itemstack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer worldserver, ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.f(itemstack);
        if (!this.a(itemstack, enumitemslot)) {
            return ItemStack.l;
        }
        ItemStack itemstack1 = this.a(enumitemslot);
        boolean flag = this.a(itemstack, itemstack1, enumitemslot);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.a(enumitemslot);
            flag = itemstack1.f();
        }
        boolean bl = canPickup = flag && this.g(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.bQ.b(enumitemslot);
            if (!itemstack1.f() && (double)Math.max(this.ae.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.a(worldserver, itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.a(itemstack);
            this.b(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.a(enumitemslot, itemstack);
        this.g(enumitemslot);
        this.bS = true;
    }

    public void g(EnumItemSlot enumitemslot) {
        this.bQ = this.bQ.a(enumitemslot);
    }

    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        return itemstack1.f() ? true : (enumitemslot.f() ? this.b(itemstack, itemstack1, enumitemslot) : (enumitemslot == EnumItemSlot.a ? this.c(itemstack, itemstack1, enumitemslot) : false));
    }

    private boolean b(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.E)) {
            return false;
        }
        double d0 = this.a(itemstack, GenericAttributes.a, enumitemslot);
        double d1 = this.a(itemstack1, GenericAttributes.a, enumitemslot);
        double d2 = this.a(itemstack, GenericAttributes.b, enumitemslot);
        double d3 = this.a(itemstack1, GenericAttributes.b, enumitemslot);
        return d0 != d1 ? d0 > d1 : (d2 != d3 ? d2 > d3 : this.b(itemstack, itemstack1));
    }

    private boolean c(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        double d1;
        double d0;
        TagKey<Item> tagkey = this.X();
        if (tagkey != null) {
            if (itemstack1.a(tagkey) && !itemstack.a(tagkey)) {
                return false;
            }
            if (!itemstack1.a(tagkey) && itemstack.a(tagkey)) {
                return true;
            }
        }
        return (d0 = this.a(itemstack, GenericAttributes.c, enumitemslot)) != (d1 = this.a(itemstack1, GenericAttributes.c, enumitemslot)) ? d0 > d1 : this.b(itemstack, itemstack1);
    }

    private double a(ItemStack itemstack, Holder<AttributeBase> holder, EnumItemSlot enumitemslot) {
        double d0 = this.fa().b(holder) ? this.i(holder) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = itemstack.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemattributemodifiers.a(d0, enumitemslot);
    }

    public boolean b(ItemStack itemstack, ItemStack itemstack1) {
        int j2;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = itemstack1.a(DataComponents.l, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = itemstack.a(DataComponents.l, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int i2 = itemstack.o();
        return i2 != (j2 = itemstack1.o()) ? i2 < j2 : itemstack.c(DataComponents.g) && !itemstack1.c(DataComponents.g);
    }

    public boolean g(ItemStack itemstack) {
        return true;
    }

    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return this.g(itemstack);
    }

    @Nullable
    public TagKey<Item> X() {
        return null;
    }

    public boolean h(double d0) {
        return true;
    }

    public boolean Y() {
        return this.bY();
    }

    protected boolean Z() {
        return false;
    }

    @Override
    public void dH() {
        if (this.dV().an() == EnumDifficulty.a && this.Z()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gd() && !this.Y()) {
            EntityHuman entity = this.dV().a((Entity)this, -1.0);
            if (entity != null) {
                int i2;
                int j2;
                double d0 = entity.g(this);
                if (d0 > (double)(j2 = (i2 = this.an().f().f()) * i2) && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.an().f().g();
                int l2 = k2 * k2;
                if (this.bd > 600 && this.ae.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.bd = 0;
                }
            }
        } else {
            this.bd = 0;
        }
    }

    @Override
    protected final void fu() {
        ++this.bd;
        if (!this.aware) {
            return;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("sensing");
        this.bP.a();
        gameprofilerfiller.c();
        int i2 = this.af + this.ao();
        if (i2 % 2 != 0 && this.af > 1) {
            gameprofilerfiller.a("targetSelector");
            this.bG.a(false);
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bF.a(false);
            gameprofilerfiller.c();
        } else {
            gameprofilerfiller.a("targetSelector");
            this.bG.a();
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.bF.a();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("navigation");
        this.bE.c();
        gameprofilerfiller.c();
        gameprofilerfiller.a("mob tick");
        this.a((WorldServer)this.dV());
        gameprofilerfiller.c();
        gameprofilerfiller.a("controls");
        gameprofilerfiller.a("move");
        this.bC.a();
        gameprofilerfiller.b("look");
        this.bB.a();
        gameprofilerfiller.b("jump");
        this.bD.b();
        gameprofilerfiller.c();
        gameprofilerfiller.c();
        this.ab();
    }

    protected void ab() {
        PacketDebug.a(this.dV(), this, this.bF);
    }

    protected void a(WorldServer worldserver) {
    }

    public int ac() {
        return 40;
    }

    public int ae() {
        return 75;
    }

    protected void af() {
        float f2 = this.ae();
        float f1 = this.cA();
        float f22 = MathHelper.h(this.aV - f1);
        float f3 = MathHelper.a(MathHelper.h(this.aV - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.r(f4);
    }

    public int ag() {
        return 10;
    }

    public void a(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.dA() - this.dA();
        double d1 = entity.dG() - this.dG();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.dE() - this.dE();
        } else {
            d2 = (entity.cR().b + entity.cR().e) / 2.0 - this.dE();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.x(this.a(this.dN(), f3, f1));
        this.w(this.a(this.dL(), f22, f2));
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.h(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.e();
        return EntitySpawnReason.a(entityspawnreason) || generatoraccess.a_(blockposition1).a((IBlockAccess)generatoraccess, blockposition1, entitytypes);
    }

    public boolean a(GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason) {
        return true;
    }

    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cR()) && iworldreader.f(this);
    }

    public int fX() {
        return 4;
    }

    public boolean q(int i2) {
        return false;
    }

    @Override
    public int cE() {
        if (this.e() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eG() - this.eU() * 0.33f);
        if ((i2 -= (3 - this.dV().an().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack fY() {
        return this.a(EnumItemSlot.g);
    }

    public boolean fZ() {
        return this.d(EnumItemSlot.h);
    }

    public boolean ga() {
        return this.d(EnumItemSlot.g);
    }

    public void h(ItemStack itemstack) {
        this.b(EnumItemSlot.g, itemstack);
    }

    public IInventory h(final EnumItemSlot enumitemslot) {
        return new ContainerSingleItem(){
            public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
            private int maxStack = 99;

            @Override
            public ItemStack f() {
                return EntityInsentient.this.a(enumitemslot);
            }

            @Override
            public void b(ItemStack itemstack) {
                EntityInsentient.this.a(enumitemslot, itemstack);
                if (!itemstack.f()) {
                    EntityInsentient.this.g(enumitemslot);
                    EntityInsentient.this.gc();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman entityhuman) {
                return entityhuman.dk() == EntityInsentient.this || entityhuman.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.f());
            }

            @Override
            public void onOpen(CraftHumanEntity who) {
                this.transaction.add(who);
            }

            @Override
            public void onClose(CraftHumanEntity who) {
                this.transaction.remove(who);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.transaction;
            }

            @Override
            public int ak_() {
                return this.maxStack;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStack = size;
            }

            @Override
            public InventoryHolder getOwner() {
                return (InventoryHolder)EntityInsentient.this.getBukkitEntity();
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            float f2 = this.bQ.b(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = this.bQ.c(enumitemslot);
            Entity entity = damagesource.d();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world = this.dV();
                if (world instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world;
                    f2 = EnchantmentManager.a(worldserver1, entityliving, damagesource, f2);
                }
            }
            if (itemstack.f() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D) || !flag && !flag1 || !(this.ae.i() < f2)) continue;
            if (!flag1 && itemstack.m()) {
                itemstack.b(itemstack.p() - this.ae.a(1 + this.ae.a(Math.max(itemstack.p() - 3, 1))));
            }
            this.a(worldserver, itemstack);
            this.a(enumitemslot, ItemStack.l);
        }
    }

    public DropChances gb() {
        return this.bQ;
    }

    public void b(WorldServer worldserver) {
        this.a(worldserver, (ItemStack itemstack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer worldserver, Predicate<ItemStack> predicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            if (!this.bQ.c(enumitemslot)) continue;
            this.a(enumitemslot, ItemStack.l);
            this.a(worldserver, itemstack);
        }
        return set;
    }

    private LootParams g(WorldServer worldserver) {
        return new LootParams.a(worldserver).a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmenttable) {
        this.a(equipmenttable.a(), equipmenttable.b());
    }

    public void a(ResourceKey<LootTable> resourcekey, Map<EnumItemSlot, Float> map) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(resourcekey, this.g(worldserver), map);
        }
    }

    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.15f * difficultydamagescaler.d()) {
            float f2;
            int i2 = randomsource.a(2);
            float f3 = f2 = this.dV().an() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : bH) {
                Item item;
                ItemStack itemstack = this.a(enumitemslot);
                if (!flag && randomsource.i() < f2) break;
                flag = false;
                if (!itemstack.f() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case f: {
                if (i2 == 0) {
                    return Items.qm;
                }
                if (i2 == 1) {
                    return Items.qC;
                }
                if (i2 == 2) {
                    return Items.qq;
                }
                if (i2 == 3) {
                    return Items.qu;
                }
                if (i2 == 4) {
                    return Items.qy;
                }
            }
            case e: {
                if (i2 == 0) {
                    return Items.qn;
                }
                if (i2 == 1) {
                    return Items.qD;
                }
                if (i2 == 2) {
                    return Items.qr;
                }
                if (i2 == 3) {
                    return Items.qv;
                }
                if (i2 == 4) {
                    return Items.qz;
                }
            }
            case d: {
                if (i2 == 0) {
                    return Items.qo;
                }
                if (i2 == 1) {
                    return Items.qE;
                }
                if (i2 == 2) {
                    return Items.qs;
                }
                if (i2 == 3) {
                    return Items.qw;
                }
                if (i2 == 4) {
                    return Items.qA;
                }
            }
            case c: {
                if (i2 == 0) {
                    return Items.qp;
                }
                if (i2 == 1) {
                    return Items.qF;
                }
                if (i2 == 2) {
                    return Items.qt;
                }
                if (i2 == 3) {
                    return Items.qx;
                }
                if (i2 != 4) break;
                return Items.qB;
            }
        }
        return null;
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.b(worldaccess, randomsource, difficultydamagescaler);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void b(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, EnumItemSlot.a, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void a(WorldAccess worldaccess, EnumItemSlot enumitemslot, RandomSource randomsource, float f2, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = this.a(enumitemslot);
        if (!itemstack.f() && randomsource.i() < f2 * difficultydamagescaler.d()) {
            EnchantmentManager.a(itemstack, worldaccess.J_(), VanillaEnchantmentProviders.a, difficultydamagescaler, randomsource);
            this.a(enumitemslot, itemstack);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.g(GenericAttributes.m));
        if (!attributemodifiable.b(by)) {
            attributemodifiable.d(new AttributeModifier(by, randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.u(randomsource.i() < 0.05f);
        return groupdataentity;
    }

    public void gc() {
        this.bS = true;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, float f2) {
        this.bQ = this.bQ.a(enumitemslot, f2);
    }

    @Override
    public boolean fN() {
        return this.bR;
    }

    public void a_(boolean flag) {
        this.bR = flag;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return this.fN();
    }

    public boolean gd() {
        return this.bS;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.bJ()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult enuminteractionresult = this.c(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.a(entityhuman, enumhand);
        if (enuminteractionresult1 != EnumInteractionResult.e) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.vW) && (enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.h() instanceof ItemMonsterEgg) {
            if (this.dV() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.h();
                Optional<EntityInsentient> optional = itemmonsteregg.a(entityhuman, this, this.an(), (WorldServer)this.dV(), this.dt(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(entityhuman, (EntityInsentient)entityinsentient));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean ge() {
        return this.a(this.dv());
    }

    public boolean a(BlockPosition blockposition) {
        return this.bY == -1.0f ? true : this.bX.j(blockposition) < (double)(this.bY * this.bY);
    }

    public void a(BlockPosition blockposition, int i2) {
        this.bX = blockposition;
        this.bY = i2;
    }

    public BlockPosition gf() {
        return this.bX;
    }

    public float gg() {
        return this.bY;
    }

    public void gh() {
        this.bY = -1.0f;
    }

    public boolean gi() {
        return this.bY != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, entityspawnreason, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dQ()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.dV(), entityspawnreason);
        if (t0 == null) {
            return null;
        }
        conversionparams.a().a(this, t0, conversionparams);
        conversionparams_a.finalizeConversion(t0);
        World world = this.dV();
        if (transformReason == null) {
            return (T)t0;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        conversionparams.a().postConvert(this, t0, conversionparams);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.addFreshEntity(t0, spawnReason);
        }
        if (conversionparams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)t0;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.convertTo(entitytypes, conversionparams, EntitySpawnReason.i, conversionparams_a, transformReason, spawnReason);
    }

    @Override
    @Nullable
    public Leashable.a S_() {
        return this.bW;
    }

    @Override
    public void a(@Nullable Leashable.a leashable_a) {
        this.bW = leashable_a;
    }

    @Override
    public void z() {
        if (this.S_() == null) {
            this.gh();
        }
    }

    @Override
    public void A() {
        Leashable.super.A();
        this.bF.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean w() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        boolean flag1 = super.a(entity, flag);
        if (flag1 && this.Q_()) {
            this.dV().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.x();
        }
        return flag1;
    }

    @Override
    public boolean di() {
        return super.di() && !this.gj();
    }

    @Override
    public boolean dj() {
        return super.dj() && !this.gj();
    }

    public void t(boolean flag) {
        byte b0 = this.al.a(a);
        this.al.a(a, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void u(boolean flag) {
        byte b0 = this.al.a(a);
        this.al.a(a, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void v(boolean flag) {
        byte b0 = this.al.a(a);
        this.al.a(a, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean gj() {
        return (this.al.a(a) & 1) != 0;
    }

    public boolean gk() {
        return (this.al.a(a) & 2) != 0;
    }

    public boolean gl() {
        return (this.al.a(a) & 4) != 0;
    }

    public void a(boolean flag) {
    }

    @Override
    public EnumMainHand fy() {
        return this.gk() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entityliving) {
        return this.gm().c(entityliving.eN());
    }

    protected AxisAlignedBB gm() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.dk();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.cR();
            AxisAlignedBB axisalignedbb2 = this.cR();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.cR();
        }
        return axisalignedbb.c(bI, 0.0, bI);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag;
        float f2 = (float)this.h(GenericAttributes.c);
        ItemStack itemstack = this.dZ();
        DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.dW().b(this));
        f2 = EnchantmentManager.a(worldserver, itemstack, entity, damagesource, f2);
        if (flag = entity.a(worldserver, damagesource, f2 += itemstack.h().a(entity, f2, damagesource))) {
            float f1 = this.b(entity, damagesource);
            if (f1 > 0.0f && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.knockback(f1 * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.i(this.dy().d(0.6, 1.0, 0.6));
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                itemstack.a(entityliving1, (EntityLiving)this);
            }
            EnchantmentManager.a(worldserver, entity, damagesource);
            this.B(entity);
            this.gn();
        }
        return flag;
    }

    protected void gn() {
    }

    protected boolean go() {
        if (this.dV().V() && !this.dV().C) {
            boolean flag;
            float f2 = this.bw();
            BlockPosition blockposition = BlockPosition.a(this.dA(), this.dE(), this.dG());
            boolean bl = flag = this.bk() || this.av || this.aw;
            if (f2 > 0.5f && this.ae.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dV().h(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        if (this.N().o()) {
            super.c(tagkey);
        } else {
            this.i(this.dy().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gp() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.ec().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.bF.a(predicate);
    }

    @Override
    protected void cD() {
        super.cD();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            itemstack.e(0);
        }
    }

    @Override
    @Nullable
    public ItemStack dI() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.an());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }

    @Override
    protected void f(Holder<AttributeBase> holder) {
        super.f(holder);
        if (holder.a(GenericAttributes.m) || holder.a(GenericAttributes.E)) {
            this.N().e();
        }
    }
}

