/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R4.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int l = 98;
    public static final int m = 100;
    public static final int n = 105;
    public static final int o = 106;
    public static final int p = 6;
    public static final int q = 100;
    private static final int bu = 40;
    public static final double r = 0.003;
    public static final double s = 0.08;
    public static final int t = 20;
    protected static final float u = 0.98f;
    private static final int bv = 10;
    private static final int bw = 2;
    public static final float ay = 0.42f;
    private static final double bx = 128.0;
    protected static final int az = 1;
    protected static final int aA = 2;
    public static final int aB = 4;
    protected static final DataWatcherObject<Byte> aC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> by = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> bz = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> bA = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bB = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bD = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int bE = 15;
    protected static final EntitySize aD = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float aE = 0.5f;
    public static final float aF = 0.5f;
    public static final String aG = "attributes";
    public static final Predicate<EntityLiving> aH = entityliving -> {
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            ItemStack itemstack = entityhuman.a(EnumItemSlot.f);
            return !itemstack.a(TagsItem.ct);
        }
        return true;
    };
    private final AttributeMapBase bF;
    public CombatTracker bG = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> bH = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> bI = SystemUtils.a(EnumItemSlot.class, (K enumitemslot) -> ItemStack.l);
    public boolean aI;
    private boolean bJ = false;
    public EnumHand aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public int aO;
    public int aP;
    public float aQ;
    public float aR;
    protected int aS;
    public final WalkAnimationState aT = new WalkAnimationState();
    public int aU = 20;
    public float aV;
    public float aW;
    public float aX;
    public float aY;
    public final ElytraAnimationState aZ = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<EntityHuman> ba;
    protected int bb;
    protected boolean bc;
    protected int bd;
    public float be;
    protected boolean bf;
    public float bg;
    public float bh;
    public float bi;
    protected InterpolationHandler bj = new InterpolationHandler(this);
    protected double bk;
    protected int bl;
    public boolean bK = true;
    @Nullable
    public EntityReference<EntityLiving> bL;
    public int bM;
    @Nullable
    private EntityLiving bN;
    private int bO;
    private float bP;
    private int bQ;
    private float bR;
    protected ItemStack bm;
    public int bn;
    protected int bo;
    private BlockPosition bS;
    private Optional<BlockPosition> bT;
    @Nullable
    private DamageSource bU;
    private long bV;
    protected int bp;
    protected float bq;
    @Nullable
    protected ItemStack br;
    private float bW;
    private float bX;
    protected BehaviorController<?> bs;
    protected boolean bY;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> bZ;
    public final EntityEquipment bt;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.cA();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bd;
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.bm = ItemStack.l;
        this.bT = Optional.empty();
        this.bZ = new EnumMap(EnumItemSlot.class);
        this.bF = new AttributeMapBase(AttributeDefaults.a(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.bF);
        this.al.a(by, Float.valueOf((float)this.g(GenericAttributes.s).g()));
        this.bt = this.eb();
        this.I = true;
        this.av();
        this.w((float)(Math.random() * 6.2831854820251465));
        this.aX = this.dL();
        DynamicOpsNBT dynamicopsnbt = DynamicOpsNBT.a;
        this.bs = this.a(new Dynamic((DynamicOps)dynamicopsnbt, (Object)((NBTBase)dynamicopsnbt.createMap((Map)ImmutableMap.of((Object)dynamicopsnbt.a("memories"), (Object)((NBTBase)dynamicopsnbt.emptyMap()))))));
    }

    @Contract(pure=true)
    protected EntityEquipment eb() {
        return new EntityEquipment();
    }

    public BehaviorController<?> ec() {
        return this.bs;
    }

    protected BehaviorController.b<?> ed() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ed().a(dynamic);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.a(worldserver, this.dW().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(aC, (byte)0);
        datawatcher_a.a(bz, List.of());
        datawatcher_a.a(bA, false);
        datawatcher_a.a(bB, 0);
        datawatcher_a.a(bC, 0);
        datawatcher_a.a(by, Float.valueOf(1.0f));
        datawatcher_a.a(bD, Optional.empty());
    }

    public static AttributeProvider.Builder ee() {
        return AttributeProvider.a().a(GenericAttributes.s).a(GenericAttributes.p).a(GenericAttributes.v).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.r).a(GenericAttributes.B).a(GenericAttributes.y).a(GenericAttributes.n).a(GenericAttributes.x).a(GenericAttributes.k).a(GenericAttributes.o).a(GenericAttributes.w).a(GenericAttributes.h).a(GenericAttributes.i).a(GenericAttributes.F).a(GenericAttributes.u).a(GenericAttributes.d);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        net.minecraft.world.level.World world;
        if (!this.bi()) {
            this.bp();
        }
        if ((world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (flag && this.Z > 0.0) {
                this.b(worldserver, blockposition);
                double d1 = Math.max(0, MathHelper.a(this.h(this.Z)));
                if (d1 > 0.0 && !iblockdata.l()) {
                    double d2 = this.dA();
                    double d3 = this.dC();
                    double d4 = this.dG();
                    BlockPosition blockposition1 = this.dv();
                    if (blockposition.u() != blockposition1.u() || blockposition.w() != blockposition1.w()) {
                        double d5 = d2 - (double)blockposition.u() - 0.5;
                        double d6 = d4 - (double)blockposition.w() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.u() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.w() + 0.5 + d6 / d7 * 0.5;
                    }
                    double d8 = Math.min((double)0.2f + d1 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        worldserver.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, iblockdata), false, false, d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        worldserver.a(new ParticleParamBlock(Particles.b, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.bT = Optional.empty();
        }
    }

    public final boolean ef() {
        return this.an().a(TagsEntity.m);
    }

    public float a(float f2) {
        return MathHelper.h(f2, this.bX, this.bW);
    }

    public boolean eg() {
        return this.dy().b() < (double)1.0E-5f && this.bl();
    }

    @Override
    public void aw() {
        EntityLiving entityliving;
        net.minecraft.world.level.World world;
        WorldServer worldserver;
        this.aQ = this.aR;
        if (this.ak) {
            this.fP().ifPresent(this::a);
        }
        if ((worldserver = (WorldServer)this.dV()) instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            EnchantmentManager.b(worldserver1, this);
        }
        super.aw();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("livingEntityBaseTick");
        if (this.bh() || this.dV().C) {
            this.aF();
        }
        if (this.bJ() && (world = this.dV()) instanceof WorldServer) {
            double d1;
            double d0;
            worldserver = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.bK()) {
                this.a(worldserver, this.dW().g(), 1.0f);
            } else if (flag && !worldserver.E_().a(this.cR()) && (d0 = worldserver.E_().a(this) + worldserver.E_().n()) < 0.0 && (d1 = worldserver.E_().o()) > 0.0) {
                this.a(worldserver, this.dW().x(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
            }
            if (((Entity)this).a(TagsFluid.a) && !worldserver.a_(BlockPosition.a(this.dA(), this.dE(), this.dG())).a(Blocks.nJ)) {
                boolean flag1;
                boolean bl = flag1 = !this.ef() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gk().a);
                if (flag1) {
                    this.j(this.l(this.cs()));
                    if (this.cs() == -20) {
                        this.j(0);
                        worldserver.a((Entity)this, (byte)67);
                        this.a(worldserver, this.dW().i(), 2.0f);
                    }
                } else if (this.cs() < this.cr()) {
                    this.j(this.m(this.cs()));
                }
                if (this.bY() && this.dk() != null && this.dk().ca()) {
                    this.bO();
                }
            } else if (this.cs() < this.cr()) {
                this.j(this.m(this.cs()));
            }
            BlockPosition blockposition = this.dv();
            if (!com.google.common.base.Objects.equal((Object)this.bS, (Object)blockposition)) {
                this.bS = blockposition;
                this.b(worldserver, blockposition);
            }
        }
        if (this.aN > 0) {
            --this.aN;
        }
        if (this.aj > 0 && !(this instanceof EntityPlayer)) {
            --this.aj;
        }
        if (this.eH() && this.dV().h(this)) {
            this.en();
        }
        if (this.bb > 0) {
            --this.bb;
        } else {
            this.ba = null;
        }
        if (this.bN != null && !this.bN.bJ()) {
            this.bN = null;
        }
        if ((entityliving = this.er()) != null) {
            if (!entityliving.bJ()) {
                this.a((EntityLiving)null);
            } else if (this.af - this.bM > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ey();
        this.aY = this.aX;
        this.aW = this.aV;
        this.N = this.dL();
        this.O = this.dN();
        gameprofilerfiller.c();
    }

    @Override
    protected float aS() {
        return MathHelper.h((float)this.h(GenericAttributes.u), super.aS(), 1.0f);
    }

    public float eh() {
        return 0.0f;
    }

    protected void ei() {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        if (attributemodifiable != null && attributemodifiable.a(c) != null) {
            attributemodifiable.c(c);
        }
    }

    protected void ej() {
        int i2;
        if (!this.br().l() && (i2 = this.cu()) > 0) {
            AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cv();
            attributemodifiable.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        EnchantmentManager.a(worldserver, this);
    }

    public boolean e_() {
        return false;
    }

    public float ek() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float el() {
        AttributeMapBase attributemapbase = this.fa();
        return attributemapbase == null ? 1.0f : this.b((float)attributemapbase.c(GenericAttributes.y));
    }

    protected float b(float f2) {
        return f2;
    }

    public boolean em() {
        return true;
    }

    protected void en() {
        ++this.aP;
        if (this.aP >= 20 && !this.dV().A_() && !this.dQ()) {
            this.dV().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eo() {
        return !this.e_();
    }

    protected boolean ep() {
        return !this.e_();
    }

    protected int l(int i2) {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.w);
        double d0 = attributemodifiable != null ? attributemodifiable.g() : 0.0;
        return d0 > 0.0 && this.ae.j() >= 1.0 / (d0 + 1.0) ? i2 : i2 - 1;
    }

    protected int m(int i2) {
        return Math.min(i2 + 4, this.cr());
    }

    public final int a(WorldServer worldserver, @Nullable Entity entity) {
        return EnchantmentManager.a(worldserver, entity, (Entity)this, this.e(worldserver));
    }

    protected int e(WorldServer worldserver) {
        return 0;
    }

    protected boolean eq() {
        return false;
    }

    @Nullable
    public EntityLiving er() {
        return EntityReference.a(this.bL, this.dV(), EntityLiving.class);
    }

    @Nullable
    public EntityHuman es() {
        return EntityReference.a(this.ba, this.dV(), EntityHuman.class);
    }

    @Override
    public EntityLiving ai() {
        return this.er();
    }

    public int et() {
        return this.bM;
    }

    public void a(EntityHuman entityhuman, int i2) {
        this.a(new EntityReference<EntityHuman>(entityhuman), i2);
    }

    public void a(UUID uuid, int i2) {
        this.a(new EntityReference<EntityHuman>(uuid), i2);
    }

    private void a(EntityReference<EntityHuman> entityreference, int i2) {
        this.ba = entityreference;
        this.bb = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.bL = entityliving != null ? new EntityReference<EntityLiving>(entityliving) : null;
        this.bM = this.af;
    }

    @Nullable
    public EntityLiving eu() {
        return this.bN;
    }

    public int ev() {
        return this.bO;
    }

    public void B(Entity entity) {
        this.bN = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.bO = this.af;
    }

    public int ew() {
        return this.bd;
    }

    public void n(int i2) {
        this.bd = i2;
    }

    public boolean ex() {
        return this.bJ;
    }

    public void q(boolean flag) {
        this.bJ = flag;
    }

    protected boolean b(EnumItemSlot enumitemslot) {
        return true;
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!(this.dV().A_() || this.ak() || ItemStack.c(itemstack, itemstack1) || this.ak)) {
            Equippable equippable = itemstack1.a(DataComponents.D);
            if (!this.ba() && equippable != null && enumitemslot == equippable.b() && !silent) {
                this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), this.a(enumitemslot, itemstack1, equippable), this.dm(), 1.0f, 1.0f, this.ae.g());
            }
            if (this.b(enumitemslot)) {
                ((Entity)this).a(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        net.minecraft.world.level.World world;
        if ((entity_removalreason == Entity.RemovalReason.a || entity_removalreason == Entity.RemovalReason.b) && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.bs.a();
    }

    protected void a(WorldServer worldserver, Entity.RemovalReason entity_removalreason) {
        for (MobEffect mobeffect : this.eD()) {
            mobeffect.a(worldserver, this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bH.clear();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", this.eG());
        nbttagcompound.a("HurtTime", (short)this.aN);
        nbttagcompound.a("HurtByTimestamp", this.bM);
        nbttagcompound.a("DeathTime", (short)this.aP);
        nbttagcompound.a("AbsorptionAmount", this.fw());
        nbttagcompound.a(aG, this.fa().d());
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        if (!this.bH.isEmpty()) {
            nbttagcompound.a(b, MobEffect.d.listOf(), registryops, List.copyOf(this.bH.values()));
        }
        nbttagcompound.a("FallFlying", this.fJ());
        this.fP().ifPresent(blockposition -> nbttagcompound.a("sleeping_pos", BlockPosition.a, blockposition));
        DataResult<NBTBase> dataresult = this.bs.a(DynamicOpsNBT.a);
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("Brain", (NBTBase)nbtbase));
        if (this.ba != null) {
            this.ba.a(nbttagcompound, "last_hurt_by_player");
            nbttagcompound.a("last_hurt_by_player_memory_time", this.bb);
        }
        if (this.bL != null) {
            this.bL.a(nbttagcompound, "last_hurt_by_mob");
            nbttagcompound.a("ticks_since_last_hurt_by_mob", this.af - this.bM);
        }
        if (!this.bt.a()) {
            nbttagcompound.a("equipment", EntityEquipment.a, registryops, this.bt);
        }
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.f()) {
            return null;
        }
        if (this.dV().C) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem entityitem = this.b(itemstack, flag, flag1);
        if (entityitem != null) {
            if (callEvent && this instanceof EntityPlayer) {
                Player player = (Player)this.getBukkitEntity();
                Item drop = (Item)entityitem.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                    if (flag1 && (cur == null || cur.getAmount() == 0)) {
                        player.getInventory().setItemInHand(drop.getItemStack());
                    } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        cur.setAmount(cur.getAmount() + 1);
                        player.getInventory().setItemInHand(cur);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.dV().b(entityitem);
        }
        return entityitem;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.F(nbttagcompound.b("AbsorptionAmount", 0.0f));
        if (this.dV() != null && !this.dV().C) {
            Optional<NBTTagList> optional = nbttagcompound.o(aG);
            AttributeMapBase attributemapbase = this.fa();
            Objects.requireNonNull(attributemapbase);
            optional.ifPresent(attributemapbase::a);
        }
        RegistryOps<NBTBase> registryops = this.dX().a(DynamicOpsNBT.a);
        List list = nbttagcompound.a(b, MobEffect.d.listOf(), (DynamicOps<NBTBase>)registryops).orElse(List.of());
        this.bH.clear();
        for (MobEffect mobeffect : list) {
            this.bH.put(mobeffect.c(), mobeffect);
        }
        if (nbttagcompound.b("Bukkit.MaxHealth")) {
            NBTBase nbtbase = nbttagcompound.a("Bukkit.MaxHealth");
            if (nbtbase.b() == 5) {
                this.g(GenericAttributes.s).a(((NBTTagFloat)nbtbase).k());
            } else if (nbtbase.b() == 3) {
                this.g(GenericAttributes.s).a(((NBTTagInt)nbtbase).k());
            }
        }
        this.d(nbttagcompound.b("Health", this.eU()));
        this.aN = nbttagcompound.b("HurtTime", (short)0);
        this.aP = nbttagcompound.b("DeathTime", (short)0);
        this.bM = nbttagcompound.b("HurtByTimestamp", 0);
        nbttagcompound.i("Team").ifPresent(s2 -> {
            boolean flag;
            Scoreboard scoreboard = this.dV().R();
            ScoreboardTeam scoreboardteam = scoreboard.b((String)s2);
            boolean bl = flag = scoreboardteam != null && scoreboard.a(this.cH(), scoreboardteam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", s2);
            }
        });
        this.b(7, nbttagcompound.b("FallFlying", false));
        nbttagcompound.a("sleeping_pos", BlockPosition.a).ifPresentOrElse(blockposition -> {
            this.g((BlockPosition)blockposition);
            this.al.a(aq, EntityPose.c);
            if (!this.ak) {
                this.a((BlockPosition)blockposition);
            }
        }, this::fQ);
        nbttagcompound.m("Brain").ifPresent(nbttagcompound1 -> {
            this.bs = this.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, nbttagcompound1));
        });
        this.ba = EntityReference.b(nbttagcompound, "last_hurt_by_player");
        this.bb = nbttagcompound.b("last_hurt_by_player_memory_time", 0);
        this.bL = EntityReference.b(nbttagcompound, "last_hurt_by_mob");
        this.bM = nbttagcompound.b("ticks_since_last_hurt_by_mob", 0) + this.af;
        this.bt.a(nbttagcompound.a("equipment", EntityEquipment.a, (DynamicOps<NBTBase>)registryops).orElseGet(EntityEquipment::new));
    }

    protected void ey() {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Iterator<Holder<MobEffectList>> iterator = this.bH.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder<MobEffectList> holder = iterator.next();
                    MobEffect mobeffect = this.bH.get(holder);
                    if (!mobeffect.a(worldserver, this, () -> this.a(mobeffect, true, (Entity)null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobeffect));
                        continue;
                    }
                    if (mobeffect.d() % 600 != 0) continue;
                    this.a(mobeffect, false, (Entity)null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect e2 : this.effectsToProcess) {
                if (e2.effect != null) {
                    this.addEffect(e2.effect, e2.cause);
                    continue;
                }
                this.removeEffect(e2.type, e2.cause);
            }
            this.effectsToProcess.clear();
            if (this.bK) {
                this.J();
                this.s();
                this.bK = false;
            }
        } else {
            for (MobEffect mobeffect1 : this.bH.values()) {
                mobeffect1.i();
            }
            List<ParticleParam> list = this.al.a(bz);
            if (!list.isEmpty()) {
                int j2;
                boolean flag = this.al.a(bA);
                int i2 = this.co() ? 15 : 4;
                int n2 = j2 = flag ? 5 : 1;
                if (this.ae.a(i2 * j2) == 0) {
                    this.dV().a(SystemUtils.a(list, this.ae), this.d(0.5), this.dD(), this.g(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void J() {
        if (this.bH.isEmpty()) {
            this.eB();
            this.k(false);
        } else {
            this.k(this.b(MobEffects.n));
            this.m();
        }
    }

    private void m() {
        List<ParticleParam> list = this.bH.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.al.a(bz, list);
        this.al.a(bA, EntityLiving.d(this.bH.values()));
    }

    private void s() {
        boolean flag = this.cn();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double C(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.cf()) {
            d0 *= 0.8;
        }
        if (this.co()) {
            float f2 = this.fd();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.an();
            if (entitytypes == EntityTypes.bg && itemstack.a(Items.vv) || entitytypes == EntityTypes.bP && itemstack.a(Items.vy) || entitytypes == EntityTypes.aS && itemstack.a(Items.vB) || entitytypes == EntityTypes.aT && itemstack.a(Items.vB) || entitytypes == EntityTypes.F && itemstack.a(Items.vz)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.dV().an() == EnumDifficulty.a ? false : entityliving.ez();
    }

    public boolean ez() {
        return !this.cC() && this.eA();
    }

    public boolean eA() {
        return !this.ak() && this.bJ();
    }

    public static boolean d(Collection<MobEffect> collection) {
        for (MobEffect mobeffect : collection) {
            if (!mobeffect.g() || mobeffect.f()) continue;
            return false;
        }
        return true;
    }

    protected void eB() {
        this.al.a(bz, List.of());
    }

    public boolean eC() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dV().C) {
            return false;
        }
        if (this.bH.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.bH.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eD() {
        return this.bH.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eE() {
        return this.bH;
    }

    public boolean b(Holder<MobEffectList> holder) {
        return this.bH.containsKey(holder);
    }

    @Nullable
    public MobEffect c(Holder<MobEffectList> holder) {
        return this.bH.get(holder);
    }

    public float a(Holder<MobEffectList> holder, float f2) {
        MobEffect mobeffect = this.c(holder);
        return mobeffect != null ? mobeffect.a(this, f2) : 0.0f;
    }

    public final boolean a(MobEffect mobeffect) {
        return this.b(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.b(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.bH.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.bH.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
            mobeffect.b(this);
        } else if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean b(MobEffect mobeffect) {
        return this.an().a(TagsEntity.G) ? !mobeffect.a(MobEffects.M) : (this.an().a(TagsEntity.F) ? !mobeffect.a(MobEffects.L) : (!this.an().a(TagsEntity.w) ? true : !mobeffect.a(MobEffects.j) && !mobeffect.a(MobEffects.s)));
    }

    public void c(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.b(mobeffect)) {
            MobEffect mobeffect1 = this.bH.put(mobeffect.c(), mobeffect);
            if (mobeffect1 == null) {
                this.a(mobeffect, entity);
            } else {
                mobeffect.d(mobeffect1);
                this.a(mobeffect, true, entity);
            }
        }
    }

    public boolean eF() {
        return this.an().a(TagsEntity.x);
    }

    @Nullable
    public final MobEffect d(Holder<MobEffectList> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public final MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.bH.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bH.remove(holder);
    }

    public boolean e(Holder<MobEffectList> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.c(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        if (!this.dV().C) {
            this.bK = true;
            mobeffect.c().a().a(this.fa(), mobeffect.e());
            this.c(mobeffect);
        }
    }

    public void c(MobEffect mobeffect) {
        for (Entity entity : this.cY()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.f.b(new PacketPlayOutEntityEffect(this.ao(), mobeffect, false));
        }
    }

    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        if (!this.dV().C) {
            this.bK = true;
            if (flag) {
                MobEffectList mobeffectlist = mobeffect.c().a();
                mobeffectlist.a(this.fa());
                mobeffectlist.a(this.fa(), mobeffect.e());
                this.C();
            }
            this.c(mobeffect);
        }
    }

    protected void c(Collection<MobEffect> collection) {
        if (!this.dV().C) {
            this.bK = true;
            for (MobEffect mobeffect : collection) {
                mobeffect.c().a().a(this.fa());
                for (Entity entity : this.cY()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.f.b(new PacketPlayOutRemoveEntityEffect(this.ao(), mobeffect.c()));
                }
            }
            this.C();
        }
    }

    private void C() {
        Set<AttributeModifiable> set = this.fa().b();
        for (AttributeModifiable attributemodifiable : set) {
            this.f(attributemodifiable.a());
        }
        set.clear();
    }

    protected void f(Holder<AttributeBase> holder) {
        if (holder.a(GenericAttributes.s)) {
            float f2 = this.eU();
            if (this.eG() > f2) {
                this.d(f2);
            }
        } else if (holder.a(GenericAttributes.r)) {
            float f1 = this.eV();
            if (this.fw() > f1) {
                this.E(f1);
            }
        } else if (holder.a(GenericAttributes.y)) {
            this.h_();
        }
    }

    public void c(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.eG();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.d((float)((double)this.eG() + event.getAmount()));
            }
        }
    }

    public float eG() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.al.a(by).floatValue();
    }

    public void d(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.al.a(by, Float.valueOf(MathHelper.a(f2, 0.0f, this.eU())));
    }

    public boolean eH() {
        return this.eG() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity1;
        boolean flag2;
        boolean flag;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.dQ() || this.bc || this.eG() <= 0.0f) {
            return false;
        }
        if (damagesource.a(DamageTypeTags.i) && this.b(MobEffects.l)) {
            return false;
        }
        if (this.fR()) {
            this.fS();
        }
        this.bd = 0;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f1 = f2;
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f2);
        f2 = 0.0f;
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        float f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
        boolean bl = flag = f22 > 0.0f;
        if (Float.isNaN(f2 -= f22) || Float.isInfinite(f2)) {
            f2 = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.aj > (float)this.aU / 2.0f && !damagesource.a(DamageTypeTags.e)) {
            if (f2 <= this.be) {
                return false;
            }
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage() - this.be, event)) {
                return false;
            }
            this.be = f2;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.be = f2;
            this.aj = this.aU;
            this.aN = this.aO = 10;
        }
        this.f(damagesource);
        this.g(damagesource);
        if (flag1) {
            BlocksAttacks blocksattacks = this.fB().a(DataComponents.I);
            if (flag && blocksattacks != null) {
                blocksattacks.a(worldserver, this);
            } else {
                worldserver.a((Entity)this, damagesource);
            }
            if (!damagesource.a(DamageTypeTags.r) && !flag) {
                this.bB();
            }
            if (!damagesource.a(DamageTypeTags.z)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity = damagesource.c();
                if (entity instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.a_(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.i() != null) {
                    d0 = damagesource.i().a() - this.dA();
                    d1 = damagesource.i().c() - this.dG();
                }
                this.knockback(0.4f, d0, d1, entity, entity == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.eH()) {
            if (!this.j(damagesource)) {
                if (flag1) {
                    this.b(this.j_());
                    this.i(damagesource);
                }
                this.a(damagesource);
            }
        } else if (flag1) {
            this.h(damagesource);
            this.i(damagesource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.bU = damagesource;
            this.bV = this.dV().ae();
            for (MobEffect mobeffect : new LinkedList<MobEffect>(this.eD())) {
                mobeffect.a(worldserver, this, damagesource, f2);
            }
        }
        if (this instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this;
            CriterionTriggers.i.a(entityplayer, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                entityplayer.a(StatisticList.K, Math.round(f22 * 10.0f));
            }
        }
        if ((entity1 = damagesource.d()) instanceof EntityPlayer) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity1;
            CriterionTriggers.h.a(entityplayer1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    public float b(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.actuallyDoItemBlocking(worldserver, damagesource, this.calculateItemBlocking(damagesource, f2));
    }

    private float calculateItemBlocking(DamageSource damagesource, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemstack = this.fH();
        if (itemstack == null) {
            return 0.0f;
        }
        BlocksAttacks blocksattacks = itemstack.a(DataComponents.I);
        if (blocksattacks != null) {
            Optional<TagKey<DamageType>> optional = blocksattacks.f();
            Objects.requireNonNull(damagesource);
            if (!optional.map(damagesource::a).orElse(false).booleanValue()) {
                double d0;
                EntityArrow entityarrow;
                Entity entity = damagesource.c();
                if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).t() > 0) {
                    return 0.0f;
                }
                Vec3D vec3d = damagesource.i();
                if (vec3d != null) {
                    Vec3D vec3d1 = this.d(0.0f, this.cA());
                    Vec3D vec3d2 = vec3d.d(this.dt());
                    vec3d2 = new Vec3D(vec3d2.d, 0.0, vec3d2.f).d();
                    d0 = Math.acos(vec3d2.b(vec3d1));
                } else {
                    d0 = 3.1415927410125732;
                }
                float f1 = blocksattacks.a(damagesource, f2, d0);
                return f1;
            }
        }
        return 0.0f;
    }

    private float actuallyDoItemBlocking(WorldServer worldserver, DamageSource damagesource, float f1) {
        BlocksAttacks blocksattacks;
        ItemStack itemstack = this.fH();
        if (itemstack != null && (blocksattacks = itemstack.a(DataComponents.I)) != null) {
            Entity entity1;
            blocksattacks.a(this.dV(), itemstack, this, this.fA(), f1);
            if (!damagesource.a(DamageTypeTags.j) && (entity1 = damagesource.c()) instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity1;
                this.b(worldserver, entityliving);
            }
            return f1;
        }
        return 0.0f;
    }

    private void i(DamageSource damagesource) {
        if (damagesource.a(DamageTypes.P)) {
            SoundCategory soundcategory = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.dV().a((Entity)null, this.dt().d, this.dt().e, this.dt().f, SoundEffects.AB, soundcategory);
        }
    }

    protected void f(DamageSource damagesource) {
        Entity entity = damagesource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (!(damagesource.a(DamageTypeTags.q) || damagesource.a(DamageTypes.I) && this.an().a(TagsEntity.E))) {
                this.a(entityliving);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damagesource) {
        EntityWolf entitywolf;
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            this.a(entityhuman, 100);
        } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).m()) {
            if (entitywolf.d() != null) {
                this.a(entitywolf.d().c(), 100);
            } else {
                this.ba = null;
                this.bb = 0;
            }
        }
        return EntityReference.a(this.ba, this.dV(), EntityHuman.class);
    }

    protected void b(WorldServer worldserver, EntityLiving entityliving) {
        entityliving.d(this);
    }

    protected void d(EntityLiving entityliving) {
        entityliving.knockback(0.5, entityliving.dA() - this.dA(), entityliving.dG() - this.dG(), null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damagesource) {
        if (damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.l;
        for (EnumHand enumhand : EnumHand.values()) {
            itemstack1 = this.b(enumhand);
            deathprotection = itemstack1.a(DataComponents.H);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.f()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(itemstack.h()));
                CriterionTriggers.C.a(entityplayer, itemstack);
                ((Entity)this).a(GameEvent.C);
            }
            this.d(1.0f);
            deathprotection.a(itemstack, this);
            this.dV().a((Entity)this, (byte)35);
        }
        return deathprotection != null;
    }

    @Nullable
    public DamageSource eI() {
        if (this.dV().ae() - this.bV > 40L) {
            this.bU = null;
        }
        return this.bU;
    }

    protected void h(DamageSource damagesource) {
        this.b(this.e(damagesource));
    }

    public void b(@Nullable SoundEffect soundeffect) {
        if (soundeffect != null) {
            this.a(soundeffect, this.fe(), this.ff());
        }
    }

    private void g(ItemStack itemstack) {
        if (!itemstack.f()) {
            Holder<SoundEffect> holder = itemstack.a(DataComponents.au);
            if (holder != null && !this.ba()) {
                this.dV().a(this.dA(), this.dC(), this.dG(), holder.a(), this.dm(), 0.8f, 0.8f + this.dV().A.i() * 0.4f, false);
            }
            this.b(itemstack, 5);
        }
    }

    public void a(DamageSource damagesource) {
        if (!this.dQ() && !this.bc) {
            Entity entity = damagesource.d();
            EntityLiving entityliving = this.eT();
            if (entityliving != null) {
                entityliving.a((Entity)this, damagesource);
            }
            if (this.fR()) {
                this.fS();
            }
            if (!this.dV().C && this.g_() && SpigotConfig.logNamedDeaths) {
                a.info("Named entity {} died: {}", (Object)this, (Object)this.eS().a().getString());
            }
            this.bc = true;
            this.eS().c();
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.a(worldserver, this)) {
                    ((Entity)this).a(GameEvent.p);
                    this.b(worldserver, damagesource);
                    this.e(entityliving);
                }
                this.dV().a((Entity)this, (byte)3);
            }
            this.b(EntityPose.h);
        }
    }

    protected void e(@Nullable EntityLiving entityliving) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (worldserver.O().c(GameRules.d)) {
                    BlockPosition blockposition = this.dv();
                    IBlockData iblockdata = Blocks.cn.m();
                    if (this.dV().a_(blockposition).l() && iblockdata.a((IWorldReader)this.dV(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.dV(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.dV().b(entityitem);
                }
            }
        }
    }

    protected void b(WorldServer worldserver, DamageSource damagesource) {
        boolean flag = this.bb > 0;
        this.f(worldserver);
        if (this.ep() && worldserver.O().c(GameRules.g)) {
            this.b(worldserver, damagesource, flag);
            this.a(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.b(worldserver, damagesource.d());
    }

    protected void f(WorldServer worldserver) {
    }

    public int getExpReward(WorldServer worldserver, @Nullable Entity entity) {
        if (!this.eL() && (this.eq() || this.bb > 0 && this.eo() && worldserver.O().c(GameRules.g))) {
            return this.a(worldserver, entity);
        }
        return 0;
    }

    protected void b(WorldServer worldserver, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.a(worldserver, this.dt(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
    }

    public long eJ() {
        return 0L;
    }

    protected float b(Entity entity, DamageSource damagesource) {
        float f2 = (float)this.h(GenericAttributes.d);
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.d(worldserver, this.dZ(), entity, damagesource, f2);
        }
        return f2;
    }

    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        Optional<ResourceKey<LootTable>> optional = this.ea();
        if (!optional.isEmpty()) {
            LootTable loottable = worldserver.p().bc().b(optional.get());
            LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dt()).a(LootContextParameters.c, damagesource).b(LootContextParameters.d, damagesource.d()).b(LootContextParameters.e, damagesource.c());
            EntityHuman entityhuman = this.es();
            if (flag && entityhuman != null) {
                lootparams_a = lootparams_a.a(LootContextParameters.b, entityhuman).a(entityhuman.eh());
            }
            LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
            loottable.a(lootparams, this.eJ(), (ItemStack itemstack) -> this.a(worldserver, (ItemStack)itemstack));
        }
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), biconsumer);
    }

    protected void a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameters.i, itemstack).a(LootContextParameterSets.s), biconsumer);
    }

    protected boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.a, LootParams> function, BiConsumer<WorldServer, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.p().bc().b(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams = function.apply(new LootParams.a(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void p(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.h(GenericAttributes.p);
        Vec3D vec3d = this.dy();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().c(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.d / 2.0 - vec3d1.d, this.aH() ? Math.min(0.4, vec3d.e / 2.0 + d0) : vec3d.e, vec3d.f / 2.0 - vec3d1.f);
        if (event.isCancelled()) {
            return;
        }
        this.ar = true;
        this.n(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void a(double d0, double d1) {
    }

    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.kK;
    }

    @Nullable
    protected SoundEffect j_() {
        return SoundEffects.kF;
    }

    private SoundEffect q(int i2) {
        return i2 > 4 ? this.eO().b() : this.eO().a();
    }

    public void eK() {
        this.bY = true;
    }

    public boolean eL() {
        return this.bY;
    }

    public float eM() {
        return 0.0f;
    }

    protected AxisAlignedBB eN() {
        AxisAlignedBB axisalignedbb = this.cR();
        Entity entity = this.dk();
        if (entity != null) {
            Vec3D vec3d = entity.m(this);
            return axisalignedbb.b(Math.max(vec3d.e, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot enumitemslot) {
        return (Map)this.bZ.computeIfAbsent(enumitemslot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public a eO() {
        return new a(SoundEffects.kL, SoundEffects.kD);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.e(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.j_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> eP() {
        return this.bT;
    }

    public boolean k_() {
        if (this.ak()) {
            return false;
        }
        BlockPosition blockposition = this.dv();
        IBlockData iblockdata = this.dw();
        if (iblockdata.a(TagsBlock.aS)) {
            this.bT = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.bT = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.dV().a_(blockposition.e());
        return iblockdata1.a(Blocks.da) && iblockdata1.c(BlockLadder.b) == iblockdata.c(BlockTrapdoor.e);
    }

    @Override
    public boolean bJ() {
        return !this.dQ() && this.eG() > 0.0f;
    }

    public boolean a(EntityLiving entityliving, double d0, boolean flag, boolean flag1, double ... adouble) {
        Vec3D vec3d = entityliving.h(1.0f).d();
        for (double d1 : adouble) {
            Vec3D vec3d1 = new Vec3D(this.dA() - entityliving.dA(), d1 - entityliving.dE(), this.dG() - entityliving.dG());
            double d2 = vec3d1.g();
            vec3d1 = vec3d1.d();
            double d3 = vec3d.b(vec3d1);
            double d4 = flag ? d2 : 1.0;
            if (!(d3 > 1.0 - d0 / d4) || !entityliving.a(this, flag1 ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cE() {
        return this.y(0.0f);
    }

    protected final int y(float f2) {
        return MathHelper.d(f2 + 3.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        int i2 = this.a(d0, f2);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.dV(), damagesource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.eQ();
            return true;
        }
        return flag;
    }

    protected int a(double d0, float f2) {
        if (this.an().a(TagsEntity.o)) {
            return 0;
        }
        double d1 = this.h(d0);
        return MathHelper.a(d1 * (double)f2 * this.h(GenericAttributes.k));
    }

    private double h(double d0) {
        return d0 + 1.0E-6 - this.h(GenericAttributes.x);
    }

    protected void eQ() {
        if (!this.ba()) {
            int i2 = MathHelper.a(this.dA());
            int j2 = MathHelper.a(this.dC() - (double)0.2f);
            int k2 = MathHelper.a(this.dG());
            IBlockData iblockdata = this.dV().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.l()) {
                SoundEffectType soundeffecttype = iblockdata.A();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float f2) {
        this.aN = this.aO = 10;
    }

    public int eR() {
        return MathHelper.a(this.h(GenericAttributes.a));
    }

    protected void c(DamageSource damagesource, float f2) {
    }

    protected void d(DamageSource damagesource, float f2) {
    }

    protected void a(DamageSource damagesource, float f2, EnumItemSlot ... aenumitemslot) {
        if (f2 > 0.0f) {
            int i2 = (int)Math.max(1.0f, f2 / 4.0f);
            for (EnumItemSlot enumitemslot : aenumitemslot) {
                ItemStack itemstack = this.a(enumitemslot);
                Equippable equippable = itemstack.a(DataComponents.D);
                if (equippable == null || !equippable.i() || !itemstack.m() || !itemstack.a(damagesource)) continue;
                itemstack.a(i2, this, enumitemslot);
            }
        }
    }

    protected float e(DamageSource damagesource, float f2) {
        if (!damagesource.a(DamageTypeTags.b)) {
            f2 = CombatMath.a(this, f2, damagesource, this.eR(), (float)this.h(GenericAttributes.b));
        }
        return f2;
    }

    protected float f(DamageSource damagesource, float f2) {
        float f4;
        if (damagesource.a(DamageTypeTags.f)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.a(DamageTypeTags.h)) {
            return f2;
        }
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.b(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f2 = CombatMath.a(f2, f4);
        }
        return f2;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2) {
        float originalDamage = f2;
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.an().a(TagsEntity.l)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f2)).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -((double)EntityLiving.this.calculateItemBlocking(damagesource, f2.floatValue()));
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.b(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.c(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fw(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.a(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.d() instanceof EntityHuman) {
                ((EntityHuman)damagesource.d()).gF();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.c(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.actuallyDoItemBlocking(worldserver, damagesource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fw() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.L, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.H, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(f2 * 10.0f));
                    }
                }
                this.eS().a(damagesource, f2);
                this.d(this.eG() - f2);
                if (!human) {
                    this.E(this.fw() - f2);
                }
                ((Entity)this).a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, f2, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker eS() {
        return this.bG;
    }

    @Nullable
    public EntityLiving eT() {
        return this.ba != null ? (EntityLiving)this.ba.a(this.dV(), EntityHuman.class) : (this.bL != null ? this.bL.a(this.dV(), EntityLiving.class) : null);
    }

    public final float eU() {
        return (float)this.h(GenericAttributes.s);
    }

    public final float eV() {
        return (float)this.h(GenericAttributes.r);
    }

    public final int eW() {
        return this.al.a(bB);
    }

    public final void o(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eW(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.al.a(bB, event.getNewAmount());
    }

    public final int eX() {
        return this.al.a(bC);
    }

    public final void p(int i2) {
        this.al.a(bC, i2);
    }

    private int D() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.b(MobEffects.d) ? 6 + (1 + this.c(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand enumhand) {
        this.a(enumhand, false);
    }

    public void a(EnumHand enumhand, boolean flag) {
        if (!this.aI || this.aK >= this.D() / 2 || this.aK < 0) {
            this.aK = -1;
            this.aI = true;
            this.aJ = enumhand;
            if (this.dV() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.dV()).m();
                if (flag) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damagesource) {
        this.aT.a(1.5f);
        this.aj = 20;
        this.aN = this.aO = 10;
        SoundEffect soundeffect = this.e(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
        }
        this.bU = damagesource;
        this.bV = this.dV().ae();
    }

    @Override
    public void b(byte b0) {
        switch (b0) {
            case 3: {
                SoundEffect soundeffect = this.j_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.d(0.0f);
                this.a(this.dW().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int j2 = 0; j2 < 128; ++j2) {
                    double d0 = (double)j2 / 127.0;
                    float f2 = (this.ae.i() - 0.5f) * 0.2f;
                    float f1 = (this.ae.i() - 0.5f) * 0.2f;
                    float f22 = (this.ae.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.K, this.dA()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    double d2 = MathHelper.d(d0, this.L, this.dC()) + this.ae.j() * (double)this.dr();
                    double d3 = MathHelper.d(d0, this.M, this.dG()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    this.dV().a(Particles.af, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.F();
                break;
            }
            case 60: {
                this.eY();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.E();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(b0);
            }
        }
    }

    public void eY() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d2 = this.ae.k() * 0.02;
            double d3 = 10.0;
            this.dV().a(Particles.ae, this.d(1.0) - d0 * 10.0, this.dD() - d1 * 10.0, this.g(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void E() {
        Vec3D vec3d = this.dy();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d0 = this.ae.a(0.0, 1.0);
            double d1 = this.ae.a(0.0, 1.0);
            double d2 = this.ae.a(0.0, 1.0);
            this.dV().a(Particles.d, this.dA() + d0, this.dC() + d1, this.dG() + d2, vec3d.d, vec3d.e, vec3d.f);
        }
    }

    private void F() {
        ItemStack itemstack = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aG() {
        this.a(this.dW().o(), 4.0f);
    }

    protected void eZ() {
        int i2 = this.D();
        if (this.aI) {
            ++this.aK;
            if (this.aK >= i2) {
                this.aK = 0;
                this.aI = false;
            }
        } else {
            this.aK = 0;
        }
        this.aR = (float)this.aK / (float)i2;
    }

    @Nullable
    public AttributeModifiable g(Holder<AttributeBase> holder) {
        return this.fa().a(holder);
    }

    public double h(Holder<AttributeBase> holder) {
        return this.fa().c(holder);
    }

    public double i(Holder<AttributeBase> holder) {
        return this.fa().d(holder);
    }

    public AttributeMapBase fa() {
        return this.bF;
    }

    public ItemStack fb() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fc() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack a(EnumMainHand enummainhand) {
        return this.fy() == enummainhand ? this.fb() : this.fc();
    }

    @Override
    @Nonnull
    public ItemStack dZ() {
        return this.fb();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fb()) || predicate.test(this.fc());
    }

    public ItemStack b(EnumHand enumhand) {
        if (enumhand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (enumhand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void a(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.a) {
            this.a(EnumItemSlot.a, itemstack);
        } else {
            if (enumhand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.a(EnumItemSlot.b, itemstack);
        }
    }

    public boolean d(EnumItemSlot enumitemslot) {
        return !this.a(enumitemslot).f();
    }

    public boolean e(EnumItemSlot enumitemslot) {
        return true;
    }

    public ItemStack a(EnumItemSlot enumitemslot) {
        return this.bt.a(enumitemslot);
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.onEquipItem(enumitemslot, this.bt.a(enumitemslot, itemstack), itemstack, silent);
    }

    public float fd() {
        int i2 = 0;
        int j2 = 0;
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemstack = this.a(enumitemslot);
            if (!itemstack.f()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void h(boolean flag) {
        super.h(flag);
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.v);
        attributemodifiable.c(e.a());
        if (flag) {
            attributemodifiable.b(e);
        }
    }

    protected float fe() {
        return 1.0f;
    }

    public float ff() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 1.5f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    protected boolean fg() {
        return this.eH();
    }

    @Override
    public void h(Entity entity) {
        if (!this.fR()) {
            super.h(entity);
        }
    }

    private void c(Entity entity) {
        Vec3D vec3d;
        if (this.dQ()) {
            vec3d = this.dt();
        } else if (!entity.dQ() && !this.dV().a_(entity.dv()).a(TagsBlock.aM)) {
            vec3d = entity.b(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.dC(), entity.dC());
            vec3d = new Vec3D(this.dA(), d0, this.dG());
            boolean bl = flag = this.dq() <= 4.0f && this.dr() <= 4.0f;
            if (flag) {
                double d1 = (double)this.dr() / 2.0;
                Vec3D vec3d1 = vec3d.b(0.0, d1, 0.0);
                VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, this.dq(), this.dr(), this.dq()));
                vec3d = this.dV().a((Entity)this, voxelshape, vec3d1, (double)this.dq(), (double)this.dr(), (double)this.dq()).map(vec3d2 -> vec3d2.b(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.m(vec3d.d, vec3d.e, vec3d.f);
    }

    @Override
    public boolean cM() {
        return this.cL();
    }

    protected float fh() {
        return this.z(1.0f);
    }

    protected float z(float f2) {
        return (float)this.h(GenericAttributes.o) * f2 * this.aR() + this.fi();
    }

    public float fi() {
        return this.b(MobEffects.h) ? 0.1f * ((float)this.c(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void r() {
        float f2 = this.fh();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.dy();
            this.n(vec3d.d, Math.max((double)f2, vec3d.e), vec3d.f);
            if (this.ci()) {
                float f1 = this.dL() * ((float)Math.PI / 180);
                this.j(new Vec3D((double)(-MathHelper.a(f1)) * 0.2, 0.0, (double)MathHelper.b(f1) * 0.2));
            }
            this.ar = true;
        }
    }

    protected void fj() {
        this.i(this.dy().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> tagkey) {
        this.i(this.dy().b(0.0, 0.04f, 0.0));
    }

    protected float fk() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    @Override
    protected double bc() {
        return this.h(GenericAttributes.n);
    }

    protected double fl() {
        boolean flag = this.dy().e <= 0.0;
        return flag && this.b(MobEffects.B) ? Math.min(this.bd(), 0.01) : this.bd();
    }

    public void a_(Vec3D vec3d) {
        Fluid fluid = this.dV().b_(this.dv());
        if ((this.bi() || this.bv()) && this.em() && !this.a(fluid)) {
            this.m(vec3d);
        } else if (this.fJ()) {
            this.n(vec3d);
        } else {
            this.l(vec3d);
        }
    }

    private void l(Vec3D vec3d) {
        BlockPosition blockposition = this.aP();
        float f2 = this.aH() ? this.dV().a_(blockposition).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3d1 = this.a(vec3d, f2);
        double d0 = vec3d1.e;
        MobEffect mobeffect = this.c(MobEffects.y);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.e) * 0.2) : (this.dV().C && !this.dV().C(blockposition) ? (this.dC() > (double)this.dV().K_() ? -0.1 : 0.0) : (d0 -= this.fl()));
        if (this.ex()) {
            this.n(vec3d1.d, d0, vec3d1.f);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.n(vec3d1.d * (double)f1, d0 * (double)f22, vec3d1.f * (double)f1);
        }
    }

    private void m(Vec3D vec3d) {
        boolean flag = this.dy().e <= 0.0;
        double d0 = this.dC();
        double d1 = this.fl();
        if (this.bi()) {
            float f2 = this.ci() ? 0.9f : this.fk();
            float f1 = 0.02f;
            float f22 = (float)this.h(GenericAttributes.F);
            if (!this.aH()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fo() - f1) * f22;
            }
            if (this.b(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dy());
            Vec3D vec3d1 = this.dy();
            if (this.P && this.k_()) {
                vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
            }
            vec3d1 = vec3d1.d(f2, 0.8f, f2);
            this.i(this.a(d1, flag, vec3d1));
        } else {
            this.a(0.02f, vec3d);
            this.a(EnumMoveType.a, this.dy());
            if (this.b(TagsFluid.b) <= this.dp()) {
                this.i(this.dy().d(0.5, 0.8f, 0.5));
                Vec3D vec3d2 = this.a(d1, flag, this.dy());
                this.i(vec3d2);
            } else {
                this.i(this.dy().c(0.5));
            }
            if (d1 != 0.0) {
                this.i(this.dy().b(0.0, -d1 / 4.0, 0.0));
            }
        }
        Vec3D vec3d3 = this.dy();
        if (this.P && this.f(vec3d3.d, vec3d3.e + (double)0.6f - this.dC() + d0, vec3d3.f)) {
            this.n(vec3d3.d, 0.3f, vec3d3.f);
        }
    }

    private void n(Vec3D vec3d) {
        if (this.k_()) {
            this.l(vec3d);
            this.fm();
        } else {
            Vec3D vec3d1 = this.dy();
            double d0 = vec3d1.i();
            this.i(this.o(vec3d1));
            this.a(EnumMoveType.a, this.dy());
            if (!this.dV().C) {
                double d1 = this.dy().i();
                this.c(d0, d1);
            }
        }
    }

    public void fm() {
        if (CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            return;
        }
        this.b(7, true);
        this.b(7, false);
    }

    private Vec3D o(Vec3D vec3d) {
        Vec3D vec3d1 = this.bS();
        float f2 = this.dN() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.d * vec3d1.d + vec3d1.f * vec3d1.f);
        double d1 = vec3d.i();
        double d2 = this.fl();
        double d3 = MathHelper.k(Math.cos(f2));
        vec3d = vec3d.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (vec3d.e < 0.0 && d0 > 0.0) {
            double d4 = vec3d.e * -0.1 * d3;
            vec3d = vec3d.b(vec3d1.d * d4 / d0, d4, vec3d1.f * d4 / d0);
        }
        if (f2 < 0.0f && d0 > 0.0) {
            double d5 = d1 * (double)(-MathHelper.a(f2)) * 0.04;
            vec3d = vec3d.b(-vec3d1.d * d5 / d0, d5 * 3.2, -vec3d1.f * d5 / d0);
        }
        if (d0 > 0.0) {
            vec3d = vec3d.b((vec3d1.d / d0 * d1 - vec3d.d) * 0.1, 0.0, (vec3d1.f / d0 * d1 - vec3d.f) * 0.1);
        }
        return vec3d.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double d0, double d1) {
        double d2;
        float f2;
        if (this.P && (f2 = (float)((d2 = d0 - d1) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.dW().n(), f2);
        }
    }

    private void c(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.b(entityhuman, vec3d);
        this.a(entityhuman, vec3d1);
        if (this.di()) {
            this.B(this.c(entityhuman));
            this.a_(vec3d1);
        } else {
            this.i(Vec3D.c);
        }
    }

    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float c(EntityHuman entityhuman) {
        return this.fo();
    }

    public void r(boolean flag) {
        float f2 = (float)MathHelper.g(this.dA() - this.K, flag ? this.dC() - this.L : 0.0, this.dG() - this.M);
        if (!this.bY() && this.bJ()) {
            this.A(f2);
        } else {
            this.aT.a();
        }
    }

    protected void A(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.aT.a(f1, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D a(Vec3D vec3d, float f2) {
        this.a(this.G(f2), vec3d);
        this.i(this.p(this.dy()));
        this.a(EnumMoveType.a, this.dy());
        Vec3D vec3d1 = this.dy();
        if ((this.P || this.bf) && (this.k_() || this.aw && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.d, 0.2, vec3d1.f);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (d0 != 0.0 && !this.ci()) {
            double d1 = flag && Math.abs(vec3d.e - 0.005) >= 0.003 && Math.abs(vec3d.e - d0 / 16.0) < 0.003 ? -0.003 : vec3d.e - d0 / 16.0;
            return new Vec3D(vec3d.d, d1, vec3d.f);
        }
        return vec3d;
    }

    private Vec3D p(Vec3D vec3d) {
        if (this.k_()) {
            this.j();
            float f2 = 0.15f;
            double d0 = MathHelper.a(vec3d.d, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(vec3d.f, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.e, (double)-0.15f);
            if (d2 < 0.0 && !this.dw().a(Blocks.oy) && this.fI() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float G(float f2) {
        return this.aH() ? this.fo() * (0.21600002f / (f2 * f2 * f2)) : this.fn();
    }

    protected float fn() {
        return this.cW() instanceof EntityHuman ? this.fo() * 0.1f : 0.02f;
    }

    public float fo() {
        return this.bP;
    }

    public void B(float f2) {
        this.bP = f2;
    }

    public boolean c(WorldServer worldserver, Entity entity) {
        this.B(entity);
        return false;
    }

    @Override
    public void g() {
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.g();
        this.I();
        this.K();
        if (!this.dV().C) {
            int j2;
            int i2 = this.eW();
            if (i2 > 0) {
                if (this.aL <= 0) {
                    this.aL = 20 * (30 - i2);
                }
                --this.aL;
                if (this.aL <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.eX()) > 0) {
                if (this.aM <= 0) {
                    this.aM = 20 * (30 - j2);
                }
                --this.aM;
                if (this.aM <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.af % 20 == 0) {
                this.eS().c();
            }
            if (this.fR() && !this.M()) {
                this.fS();
            }
        }
        if (!this.dQ()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.d_();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.dA() - this.K;
        double d1 = this.dG() - this.M;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.aV;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f3 = MathHelper.e(MathHelper.h(this.dL()) - f22);
            f1 = 95.0f < f3 && f3 < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.aR > 0.0f) {
            f1 = this.dL();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("headTurn");
        this.C(f1);
        gameprofilerfiller.c();
        gameprofilerfiller.a("rangeChecks");
        while (this.dL() - this.N < -180.0f) {
            this.N -= 360.0f;
        }
        while (this.dL() - this.N >= 180.0f) {
            this.N += 360.0f;
        }
        while (this.aV - this.aW < -180.0f) {
            this.aW -= 360.0f;
        }
        while (this.aV - this.aW >= 180.0f) {
            this.aW += 360.0f;
        }
        while (this.dN() - this.O < -180.0f) {
            this.O -= 360.0f;
        }
        while (this.dN() - this.O >= 180.0f) {
            this.O += 360.0f;
        }
        while (this.aX - this.aY < -180.0f) {
            this.aY -= 360.0f;
        }
        while (this.aX - this.aY >= 180.0f) {
            this.aY += 360.0f;
        }
        gameprofilerfiller.c();
        this.bo = this.fJ() ? ++this.bo : 0;
        if (this.fR()) {
            this.x(0.0f);
        }
        this.C();
        this.aZ.a();
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.H();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> H() {
        Map map = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemstack1;
            ItemStack itemstack = this.bI.get(enumItemSlot);
            if (!this.a(itemstack, itemstack1 = this.a(enumItemSlot))) continue;
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumItemSlot, itemstack1);
            AttributeMapBase attributemapbase = this.fa();
            if (itemstack.f()) continue;
            this.a(itemstack, enumItemSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                ItemStack itemstack2 = (ItemStack)entry.getValue();
                if (itemstack2.f() || itemstack2.q()) continue;
                itemstack2.a(enumitemslot1, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    AttributeModifiable attributemodifiable = this.bF.a((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.c(attributemodifier.a());
                        attributemodifiable.b((AttributeModifier)attributemodifier);
                    }
                });
                net.minecraft.world.level.World world = this.dV();
                if (!(world instanceof WorldServer)) continue;
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, itemstack2, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.a(itemstack1, itemstack);
    }

    private void a(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EnumItemSlot.a);
        ItemStack itemstack1 = map.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.bI.get(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.bI.get(EnumItemSlot.a))) {
            ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove(EnumItemSlot.a);
            map.remove(EnumItemSlot.b);
            this.bI.put(EnumItemSlot.a, itemstack.v());
            this.bI.put(EnumItemSlot.b, itemstack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.v();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            this.bI.put((EnumItemSlot)enumitemslot, itemstack1);
        });
        ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityEquipment(this.ao(), list));
    }

    protected void C(float f2) {
        float f1 = MathHelper.h(f2 - this.aV);
        this.aV += f1 * 0.3f;
        float f22 = MathHelper.h(this.dL() - this.aV);
        float f3 = this.fp();
        if (Math.abs(f22) > f3) {
            this.aV += f22 - (float)MathHelper.j((double)f22) * f3;
        }
    }

    protected float fp() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.bQ > 0) {
            --this.bQ;
        }
        if (this.bQ()) {
            this.l_().e();
        } else if (!this.di()) {
            this.i(this.dy().c(0.98));
        }
        if (this.bl > 0) {
            this.a(this.bl, this.bk);
            --this.bl;
        }
        this.bt.a((Entity)this);
        vec3d = this.dy();
        d0 = vec3d.d;
        d1 = vec3d.e;
        d2 = vec3d.f;
        if (this.an().equals(EntityTypes.bT)) {
            if (vec3d.j() < 9.0E-6) {
                d0 = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(vec3d.d) < 0.003) {
                d0 = 0.0;
            }
            if (Math.abs(vec3d.f) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(vec3d.e) < 0.003) {
            d1 = 0.0;
        }
        this.n(d0, d1, d2);
        gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("ai");
        SpigotTimings.timerEntityAI.startTiming();
        this.fq();
        if (this.fg()) {
            this.bf = false;
            this.bg = 0.0f;
            this.bi = 0.0f;
        } else if (this.dj() && !this.dV().C) {
            gameprofilerfiller.a("newAi");
            this.fu();
            gameprofilerfiller.c();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        gameprofilerfiller.c();
        gameprofilerfiller.a("jump");
        if (this.bf && this.em()) {
            d3 = this.bv() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bi() != false && d3 > 0.0;
            d4 = this.dp();
            if (!flag || this.aH() && d3 <= d4) {
                if (!this.bv() || this.aH() && d3 <= d4) {
                    if ((this.aH() || flag && d3 <= d4) && this.bQ == 0) {
                        this.r();
                        this.bQ = 10;
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.bQ = 0;
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("travel");
        if (this.fJ()) {
            this.fs();
        }
        axisalignedbb = this.cR();
        vec3d1 = new Vec3D(this.bg, this.bh, this.bi);
        if (this.b(MobEffects.B) || this.b(MobEffects.y)) {
            this.j();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.cW();
        if (!(entityliving instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bJ()) {
            this.c(entityhuman, vec3d1);
        } else if (this.di()) {
            this.a_(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        if (!this.dV().A_() || this.dg()) {
            this.aI();
        }
        if (this.dV().A_()) {
            this.r(this instanceof EntityBird);
        }
        gameprofilerfiller.c();
        world = this.dV();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            gameprofilerfiller.a("freezing");
            if (!this.av || !this.dJ()) {
                this.k(Math.max(0, this.cu() - 2));
            }
            this.ei();
            this.ej();
            if (this.af % 40 == 0 && this.cw() && this.dJ()) {
                this.a(worldserver, this.dW().v(), 1.0f);
            }
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("push");
        if (this.bp > 0) {
            --this.bp;
            this.a(axisalignedbb, this.cR());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.n();
        SpigotTimings.timerEntityAICollision.stopTiming();
        gameprofilerfiller.c();
        world = this.dV();
        if (world instanceof WorldServer) {
            worldserver1 = (WorldServer)world;
            if (this.fr() && this.bk()) {
                this.a(worldserver1, this.dW().i(), 1.0f);
            }
        }
    }

    protected void fq() {
        this.bg *= 0.98f;
        this.bi *= 0.98f;
    }

    public boolean fr() {
        return false;
    }

    protected void fs() {
        this.cy();
        if (!this.dV().C) {
            if (!this.ft()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bo + 1;
            if (i2 % 10 == 0) {
                int j2 = i2 / 10;
                if (j2 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(enumitemslot -> EntityLiving.b(this.a((EnumItemSlot)enumitemslot), enumitemslot)).toList();
                    EnumItemSlot enumitemslot2 = SystemUtils.a(list, this.ae);
                    this.a(enumitemslot2).a(1, this, enumitemslot2);
                }
                ((Entity)this).a(GameEvent.n);
            }
        }
    }

    protected boolean ft() {
        if (!(this.aH() || this.bY() || this.b(MobEffects.y))) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(enumitemslot), enumitemslot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fu() {
    }

    protected void n() {
        List<Entity> list = this.dV().i(this, this.cR());
        if (!list.isEmpty()) {
            WorldServer worldserver;
            int i2;
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer && (i2 = (worldserver = (WorldServer)world).O().d(GameRules.w)) > 0 && list.size() > i2 - 1 && this.ae.a(4) == 0) {
                int j2 = 0;
                for (Entity entity : list) {
                    if (entity.bY()) continue;
                    ++j2;
                }
                if (j2 > i2 - 1) {
                    this.a(worldserver, this.dW().h(), 6.0f);
                }
            }
            for (Entity entity1 : list) {
                this.D(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.b(axisalignedbb1);
        List<Entity> list = this.dV().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.f((EntityLiving)entity);
                this.bp = 0;
                this.i(this.dy().c(-0.2));
                break;
            }
        } else if (this.P) {
            this.bp = 0;
        }
        if (!this.dV().C && this.bp <= 0) {
            this.c(4, false);
            this.bq = 0.0f;
            this.br = null;
        }
    }

    protected void D(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving entityliving) {
    }

    public boolean fv() {
        return (this.al.a(aC) & 4) != 0;
    }

    @Override
    public void bO() {
        Entity entity = this.dk();
        super.bO();
        if (entity != null && entity != this.dk() && !this.dV().C) {
            this.c(entity);
        }
    }

    @Override
    public void q() {
        super.q();
        this.j();
    }

    @Override
    public InterpolationHandler l_() {
        return this.bj;
    }

    @Override
    public void a(float f2, int i2) {
        this.bk = f2;
        this.bl = i2;
    }

    public void s(boolean flag) {
        this.bf = flag;
    }

    public void a(EntityItem entityitem) {
        Entity entity = entityitem.p();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)entity, entityitem.e(), this);
        }
    }

    public void a(Entity entity, int i2) {
        if (!entity.dQ() && !this.dV().C && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dV()).m().b(entity, new PacketPlayOutCollect(entity.ao(), this.ao(), i2));
        }
    }

    public boolean E(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dE());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption raytrace_blockcollisionoption, RayTrace.FluidCollisionOption raytrace_fluidcollisionoption, double d0) {
        if (entity.dV() != this.dV()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dA(), this.dE(), this.dG());
        Vec3D vec3d1 = new Vec3D(entity.dA(), d0, entity.dG());
        return vec3d1.f(vec3d) > 128.0 ? false : this.dV().a(new RayTrace(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float f2) {
        return f2 == 1.0f ? this.aX : MathHelper.i(f2, this.aY, this.aX);
    }

    public float D(float f2) {
        float f1 = this.aR - this.aQ;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.aQ + f1 * f2;
    }

    @Override
    public boolean bF() {
        return !this.dQ() && this.collides;
    }

    @Override
    public boolean bG() {
        return this.bJ() && !this.ak() && !this.k_() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bG() && this.collides != this.collidableExemptions.contains(entity.cG());
    }

    @Override
    public float cA() {
        return this.aX;
    }

    @Override
    public void r(float f2) {
        this.aX = f2;
    }

    @Override
    public void s(float f2) {
        this.aV = f2;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.k(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D k(Vec3D vec3d) {
        return new Vec3D(vec3d.d, vec3d.e, 0.0);
    }

    public float fw() {
        return this.bR;
    }

    public final void E(float f2) {
        this.F(MathHelper.a(f2, 0.0f, this.eV()));
    }

    protected void F(float f2) {
        this.bR = f2;
    }

    public void f_() {
    }

    public void O_() {
    }

    protected void fx() {
        this.bK = true;
    }

    public abstract EnumMainHand fy();

    public boolean fz() {
        return (this.al.a(aC) & 1) > 0;
    }

    public EnumHand fA() {
        return (this.al.a(aC) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void I() {
        if (this.fz()) {
            if (ItemStack.b(this.b(this.fA()), this.bm)) {
                this.bm = this.b(this.fA());
                this.a(this.bm);
            } else {
                this.fF();
            }
        }
    }

    @Nullable
    private EntityItem b(ItemStack itemstack, boolean flag, boolean flag1) {
        if (itemstack.f()) {
            return null;
        }
        double d0 = this.dE() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.dV(), this.dA(), d0, this.dG(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.ae.i() * 0.5f;
            float f1 = this.ae.i() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f2 = 0.3f;
            float f3 = MathHelper.a(this.dN() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dN() * ((float)Math.PI / 180));
            float f5 = MathHelper.a(this.dL() * ((float)Math.PI / 180));
            float f6 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
            float f7 = this.ae.i() * ((float)Math.PI * 2);
            float f8 = 0.02f * this.ae.i();
            entityitem.n((double)(-f5 * f4 * 0.3f) + Math.cos(f7) * (double)f8, -f3 * 0.3f + 0.1f + (this.ae.i() - this.ae.i()) * 0.1f, (double)(f6 * f4 * 0.3f) + Math.sin(f7) * (double)f8);
        }
        return entityitem;
    }

    protected void a(ItemStack itemstack) {
        itemstack.b(this.dV(), this, this.fC());
        if (--this.bn == 0 && !this.dV().C && !itemstack.x()) {
            this.v();
        }
    }

    private void K() {
        this.bX = this.bW;
        this.bW = this.ck() ? Math.min(1.0f, this.bW + 0.09f) : Math.max(0.0f, this.bW - 0.09f);
    }

    public void c(int i2, boolean flag) {
        int j2 = this.al.a(aC).byteValue();
        j2 = flag ? (j2 |= i2) : (j2 &= ~i2);
        this.al.a(aC, (byte)j2);
    }

    public void c(EnumHand enumhand) {
        ItemStack itemstack = this.b(enumhand);
        if (!itemstack.f() && !this.fz()) {
            this.bm = itemstack;
            this.bn = itemstack.a(this);
            if (!this.dV().C) {
                this.c(1, true);
                this.c(2, enumhand == EnumHand.b);
                ((Entity)this).a(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (bD.equals(datawatcherobject)) {
            if (this.dV().C) {
                this.fP().ifPresent(this::a);
            }
        } else if (aC.equals(datawatcherobject) && this.dV().C) {
            if (this.fz() && this.bm.f()) {
                this.bm = this.b(this.fA());
                if (!this.bm.f()) {
                    this.bn = this.bm.a(this);
                }
            } else if (!this.fz() && !this.bm.f()) {
                this.bm = ItemStack.l;
                this.bn = 0;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.aY = this.aX;
        this.aW = this.aV = this.aX;
    }

    @Override
    public float u(float f2) {
        return MathHelper.h(f2, this.aW, this.aV);
    }

    public void b(ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dN() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dL() * ((float)Math.PI / 180));
            double d0 = (double)(-this.ae.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.ae.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dN() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dL() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dA(), this.dE(), this.dG());
            this.dV().a(new ParticleParamItem(Particles.U, itemstack), vec3d1.d, vec3d1.e, vec3d1.f, vec3d.d, vec3d.e + 0.05, vec3d.f);
        }
    }

    protected void v() {
        if (!this.dV().C || this.fz()) {
            EnumHand enumhand = this.fA();
            if (!this.bm.equals(this.b(enumhand))) {
                this.fE();
            } else if (!this.bm.f() && this.fz()) {
                ItemStack itemstack;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bm);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bm.a(DataComponents.w);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.bm);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bm.a(this.dV(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dV(), this);
                } else {
                    itemstack = this.bm.a(this.dV(), this);
                }
                if (itemstack != this.bm) {
                    this.a(enumhand, itemstack);
                }
                this.fF();
            }
        }
    }

    public void b(ItemStack itemstack) {
    }

    public ItemStack fB() {
        return this.bm;
    }

    public int fC() {
        return this.bn;
    }

    public int fD() {
        return this.fz() ? this.bm.a(this) - this.fC() : 0;
    }

    public void fE() {
        ItemStack itemstack = this.b(this.fA());
        if (!this.bm.f() && ItemStack.b(itemstack, this.bm)) {
            this.bm = itemstack;
            this.bm.a(this.dV(), this, this.fC());
            if (this.bm.x()) {
                this.I();
            }
        }
        this.fF();
    }

    public void fF() {
        if (!this.dV().C) {
            boolean flag = this.fz();
            this.c(1, false);
            if (flag) {
                ((Entity)this).a(GameEvent.C);
            }
        }
        this.bm = ItemStack.l;
        this.bn = 0;
    }

    public boolean fG() {
        return this.fH() != null;
    }

    @Nullable
    public ItemStack fH() {
        int i2;
        if (!this.fz()) {
            return null;
        }
        BlocksAttacks blocksattacks = this.bm.a(DataComponents.I);
        if (blocksattacks != null && (i2 = this.bm.h().a(this.bm, this) - this.bn) >= blocksattacks.a()) {
            return this.bm;
        }
        return null;
    }

    public boolean fI() {
        return this.cc();
    }

    public boolean fJ() {
        return this.i(7);
    }

    @Override
    public boolean ck() {
        return super.ck() || !this.fJ() && this.c(EntityPose.b);
    }

    public int fK() {
        return this.bo;
    }

    public boolean b(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dA();
        double d4 = this.dC();
        double d5 = this.dG();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.dV();
        if (world.C(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.K_()) {
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.cR())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dV().getWorld(), d3, d4, d5), new Location((World)this.dV().getWorld(), d0, d6, d2));
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).f.teleport(d0, d6, d2, this.dL(), this.dN(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.N().m();
        return Optional.of(true);
    }

    public boolean fL() {
        return !this.eH();
    }

    public boolean fM() {
        return true;
    }

    public void a(BlockPosition blockposition, boolean flag) {
    }

    public boolean fN() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.c ? aD : this.e(entitypose).a(this.el());
    }

    protected EntitySize e(EntityPose entitypose) {
        return this.an().n().a(this.ek());
    }

    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        return new AxisAlignedBB(-entitysize.a() / 2.0f, 0.0, -entitysize.a() / 2.0f, entitysize.a() / 2.0f, entitysize.b(), entitysize.a() / 2.0f);
    }

    protected boolean g(EntityPose entitypose) {
        AxisAlignedBB axisalignedbb = this.a(entitypose).a(this.dt());
        return this.dV().b(this, axisalignedbb);
    }

    @Override
    public boolean n(boolean flag) {
        return super.n(flag) && !this.fR();
    }

    public Optional<BlockPosition> fP() {
        return this.al.a(bD);
    }

    public void g(BlockPosition blockposition) {
        this.al.a(bD, Optional.of(blockposition));
    }

    public void fQ() {
        this.al.a(bD, Optional.empty());
    }

    public boolean fR() {
        return this.fP().isPresent();
    }

    public void b(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.bY()) {
            this.bO();
        }
        if ((iblockdata = this.dV().a_(blockposition)).b() instanceof BlockBed) {
            this.dV().a(blockposition, (IBlockData)iblockdata.b(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(blockposition);
        this.g(blockposition);
        this.i(Vec3D.c);
        this.ar = true;
    }

    private void a(BlockPosition blockposition) {
        this.a_((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.6875, (double)blockposition.w() + 0.5);
    }

    private boolean M() {
        return this.fP().map(blockposition -> this.dV().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void fS() {
        Optional<BlockPosition> optional = this.fP();
        net.minecraft.world.level.World world = this.dV();
        Objects.requireNonNull(world);
        optional.filter(world::C).ifPresent(blockposition -> {
            IBlockData iblockdata = this.dV().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = (EnumDirection)iblockdata.c(BlockBed.e);
                this.dV().a((BlockPosition)blockposition, (IBlockData)iblockdata.b(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.an(), (ICollisionAccess)this.dV(), blockposition, enumdirection, this.dL()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.d();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
                this.a_(vec3d.d, vec3d.e, vec3d.f);
                this.w(f2);
                this.x(0.0f);
            }
        });
        Vec3D vec3d = this.dt();
        this.b(EntityPose.a);
        this.a_(vec3d.d, vec3d.e, vec3d.f);
        this.fQ();
    }

    @Nullable
    public EnumDirection fT() {
        BlockPosition blockposition = this.fP().orElse(null);
        return blockposition != null ? BlockBed.a(this.dV(), blockposition) : null;
    }

    @Override
    public boolean bK() {
        return !this.fR() && super.bK();
    }

    public ItemStack d(ItemStack itemstack) {
        return ItemStack.l;
    }

    private static byte g(EnumItemSlot enumitemslot) {
        return switch (enumitemslot) {
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
            default -> throw new MatchException(null, null);
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot enumitemslot) {
        this.dV().a((Entity)this, EntityLiving.g(enumitemslot));
        this.a(this.a(enumitemslot), enumitemslot, this.bF);
    }

    private void a(ItemStack itemstack, EnumItemSlot enumitemslot, AttributeMapBase attributemapbase) {
        itemstack.a(enumitemslot, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
            AttributeModifiable attributemodifiable = attributemapbase.a((Holder<AttributeBase>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.e((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentManager.a(itemstack, this, enumitemslot);
    }

    public static EnumItemSlot d(EnumHand enumhand) {
        return enumhand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b;
    }

    public final boolean e(ItemStack itemstack) {
        if (this.bJ() && !this.ak()) {
            Equippable equippable = itemstack.a(DataComponents.D);
            if (equippable != null && equippable.g()) {
                EnumItemSlot enumitemslot = equippable.b();
                return this.e(enumitemslot) && equippable.a(this.an()) ? this.a(enumitemslot).f() && this.f(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot enumitemslot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack itemstack) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack itemstack, EnumItemSlot enumitemslot) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable == null ? enumitemslot == EnumItemSlot.a && this.e(EnumItemSlot.a) : enumitemslot == equippable.b() && this.e(equippable.b()) && equippable.a(this.an());
    }

    private static SlotAccess a(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.f && enumitemslot != EnumItemSlot.a && enumitemslot != EnumItemSlot.b ? SlotAccess.a(entityliving, enumitemslot, (ItemStack itemstack) -> itemstack.f() || entityliving.f((ItemStack)itemstack) == enumitemslot) : SlotAccess.a(entityliving, enumitemslot);
    }

    @Nullable
    private static EnumItemSlot r(int i2) {
        return i2 == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (i2 == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (i2 == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (i2 == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (i2 == 98 ? EnumItemSlot.a : (i2 == 99 ? EnumItemSlot.b : (i2 == 105 ? EnumItemSlot.g : (i2 == 106 ? EnumItemSlot.h : null)))))));
    }

    @Override
    public SlotAccess a_(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.r(i2);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(i2);
    }

    @Override
    public boolean dJ() {
        if (this.ak()) {
            return false;
        }
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (!this.a(enumitemslot).a(TagsItem.bs)) continue;
            return false;
        }
        return super.dJ();
    }

    @Override
    public boolean cn() {
        return !this.dV().A_() && this.b(MobEffects.x) || super.cn();
    }

    @Override
    public float dM() {
        return this.aV;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        float f2 = packetplayoutspawnentity.n();
        float f1 = packetplayoutspawnentity.m();
        this.e(d0, d1, d2);
        this.aV = packetplayoutspawnentity.o();
        this.aX = packetplayoutspawnentity.o();
        this.aW = this.aV;
        this.aY = this.aX;
        this.e(packetplayoutspawnentity.b());
        this.a_(packetplayoutspawnentity.e());
        this.a(d0, d1, d2, f2, f1);
        this.n(packetplayoutspawnentity.j(), packetplayoutspawnentity.k(), packetplayoutspawnentity.l());
    }

    public float fU() {
        Weapon weapon = this.dZ().a(DataComponents.B);
        return weapon != null ? weapon.b() : 0.0f;
    }

    @Override
    public float dP() {
        float f2 = (float)this.h(GenericAttributes.B);
        return this.cW() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.a(this.at()), this.el() * this.ek()));
    }

    protected void a(int i2, double d0) {
        this.aX = (float)MathHelper.e(1.0 / (double)i2, (double)this.aX, d0);
    }

    @Override
    public void g(int i2) {
        super.g(MathHelper.c((double)i2 * this.h(GenericAttributes.h)));
    }

    public boolean fV() {
        return false;
    }

    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.d(damagesource) || EnchantmentManager.a(worldserver, this, damagesource);
    }

    public static boolean b(ItemStack itemstack, EnumItemSlot enumitemslot) {
        if (!itemstack.c(DataComponents.F)) {
            return false;
        }
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && enumitemslot == equippable.b() && !itemstack.r();
    }

    @VisibleForTesting
    public int fW() {
        return this.bb;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

