/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ChestRaft;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class EntityTypes<T extends Entity>
implements FeatureElement,
EntityTypeTest<Entity, T> {
    private static final Logger bW = LogUtils.getLogger();
    private final Holder.c<EntityTypes<?>> bX = BuiltInRegistries.f.f(this);
    public static final Codec<EntityTypes<?>> a = BuiltInRegistries.f.q();
    private static final float bY = 1.3964844f;
    private static final int bZ = 10;
    public static final EntityTypes<EntityBoat> b = EntityTypes.a("acacia_boat", Builder.a(EntityTypes.a(() -> Items.oM), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> c = EntityTypes.a("acacia_chest_boat", Builder.a(EntityTypes.b(() -> Items.oN), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Allay> d = EntityTypes.a("allay", Builder.a(Allay::new, EnumCreatureType.b).a(0.35f, 0.6f).b(0.36f).c(0.04f).a(8).b(2));
    public static final EntityTypes<EntityAreaEffectCloud> e = EntityTypes.a("area_effect_cloud", Builder.a(EntityAreaEffectCloud::new, EnumCreatureType.h).e().c().a(6.0f, 0.5f).a(10).b(10));
    public static final EntityTypes<Armadillo> f = EntityTypes.a("armadillo", Builder.a(Armadillo::new, EnumCreatureType.b).a(0.7f, 0.65f).b(0.26f).a(10));
    public static final EntityTypes<EntityArmorStand> g = EntityTypes.a("armor_stand", Builder.a(EntityArmorStand::new, EnumCreatureType.h).a(0.5f, 1.975f).b(1.7775f).a(10));
    public static final EntityTypes<EntityTippedArrow> h = EntityTypes.a("arrow", Builder.a(EntityTippedArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<Axolotl> i = EntityTypes.a("axolotl", Builder.a(Axolotl::new, EnumCreatureType.d).a(0.75f, 0.42f).b(0.2751f).a(10));
    public static final EntityTypes<ChestRaft> j = EntityTypes.a("bamboo_chest_raft", Builder.a(EntityTypes.d(() -> Items.oX), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Raft> k = EntityTypes.a("bamboo_raft", Builder.a(EntityTypes.c(() -> Items.oW), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBat> l = EntityTypes.a("bat", Builder.a(EntityBat::new, EnumCreatureType.c).a(0.5f, 0.9f).b(0.45f).a(5));
    public static final EntityTypes<EntityBee> m = EntityTypes.a("bee", Builder.a(EntityBee::new, EnumCreatureType.b).a(0.7f, 0.6f).b(0.3f).a(8));
    public static final EntityTypes<EntityBoat> n = EntityTypes.a("birch_boat", Builder.a(EntityTypes.a(() -> Items.oI), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> o = EntityTypes.a("birch_chest_boat", Builder.a(EntityTypes.b(() -> Items.oJ), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityBlaze> p = EntityTypes.a("blaze", Builder.a(EntityBlaze::new, EnumCreatureType.a).c().a(0.6f, 1.8f).a(8));
    public static final EntityTypes<Display.BlockDisplay> q = EntityTypes.a("block_display", Builder.a(Display.BlockDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<Bogged> r = EntityTypes.a("bogged", Builder.a(Bogged::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<Breeze> s = EntityTypes.a("breeze", Builder.a(Breeze::new, EnumCreatureType.a).a(0.6f, 1.77f).b(1.3452f).a(10));
    public static final EntityTypes<BreezeWindCharge> t = EntityTypes.a("breeze_wind_charge", Builder.a(BreezeWindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<Camel> u = EntityTypes.a("camel", Builder.a(Camel::new, EnumCreatureType.b).a(1.7f, 2.375f).b(2.275f).a(10));
    public static final EntityTypes<EntityCat> v = EntityTypes.a("cat", Builder.a(EntityCat::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.35f).a(new float[]{0.5125f}).a(8));
    public static final EntityTypes<EntityCaveSpider> w = EntityTypes.a("cave_spider", Builder.a(EntityCaveSpider::new, EnumCreatureType.a).a(0.7f, 0.5f).b(0.45f).a(8));
    public static final EntityTypes<EntityBoat> x = EntityTypes.a("cherry_boat", Builder.a(EntityTypes.a(() -> Items.oO), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> y = EntityTypes.a("cherry_chest_boat", Builder.a(EntityTypes.b(() -> Items.oP), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityMinecartChest> z = EntityTypes.a("chest_minecart", Builder.a(EntityMinecartChest::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityChicken> A = EntityTypes.a("chicken", Builder.a(EntityChicken::new, EnumCreatureType.b).a(0.4f, 0.7f).b(0.644f).a(new Vec3D[]{new Vec3D(0.0, 0.7, -0.1)}).a(10));
    public static final EntityTypes<EntityCod> B = EntityTypes.a("cod", Builder.a(EntityCod::new, EnumCreatureType.g).a(0.5f, 0.3f).b(0.195f).a(4));
    public static final EntityTypes<EntityMinecartCommandBlock> C = EntityTypes.a("command_block_minecart", Builder.a(EntityMinecartCommandBlock::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityCow> D = EntityTypes.a("cow", Builder.a(EntityCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<Creaking> E = EntityTypes.a("creaking", Builder.a(Creaking::new, EnumCreatureType.a).a(0.9f, 2.7f).b(2.3f).a(8));
    public static final EntityTypes<EntityCreeper> F = EntityTypes.a("creeper", Builder.a(EntityCreeper::new, EnumCreatureType.a).a(0.6f, 1.7f).a(8));
    public static final EntityTypes<EntityBoat> G = EntityTypes.a("dark_oak_boat", Builder.a(EntityTypes.a(() -> Items.oQ), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> H = EntityTypes.a("dark_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oR), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityDolphin> I = EntityTypes.a("dolphin", Builder.a(EntityDolphin::new, EnumCreatureType.f).a(0.9f, 0.6f).b(0.3f));
    public static final EntityTypes<EntityHorseDonkey> J = EntityTypes.a("donkey", Builder.a(EntityHorseDonkey::new, EnumCreatureType.b).a(1.3964844f, 1.5f).b(1.425f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityDragonFireball> K = EntityTypes.a("dragon_fireball", Builder.a(EntityDragonFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityDrowned> L = EntityTypes.a("drowned", Builder.a(EntityDrowned::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityEgg> M = EntityTypes.a("egg", Builder.a(EntityEgg::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityGuardianElder> N = EntityTypes.a("elder_guardian", Builder.a(EntityGuardianElder::new, EnumCreatureType.a).a(1.9975f, 1.9975f).b(0.99875f).a(new float[]{2.350625f}).a(10));
    public static final EntityTypes<EntityEnderman> O = EntityTypes.a("enderman", Builder.a(EntityEnderman::new, EnumCreatureType.a).a(0.6f, 2.9f).b(2.55f).a(new float[]{2.80625f}).a(8));
    public static final EntityTypes<EntityEndermite> P = EntityTypes.a("endermite", Builder.a(EntityEndermite::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntityEnderDragon> Q = EntityTypes.a("ender_dragon", Builder.a(EntityEnderDragon::new, EnumCreatureType.a).c().a(16.0f, 8.0f).a(new float[]{3.0f}).a(10));
    public static final EntityTypes<EntityEnderPearl> R = EntityTypes.a("ender_pearl", Builder.a(EntityEnderPearl::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityEnderCrystal> S = EntityTypes.a("end_crystal", Builder.a(EntityEnderCrystal::new, EnumCreatureType.h).e().c().a(2.0f, 2.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityEvoker> T = EntityTypes.a("evoker", Builder.a(EntityEvoker::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityEvokerFangs> U = EntityTypes.a("evoker_fangs", Builder.a(EntityEvokerFangs::new, EnumCreatureType.h).e().a(0.5f, 0.8f).a(6).b(2));
    public static final EntityTypes<EntityThrownExpBottle> V = EntityTypes.a("experience_bottle", Builder.a(EntityThrownExpBottle::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityExperienceOrb> W = EntityTypes.a("experience_orb", Builder.a(EntityExperienceOrb::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(6).b(20));
    public static final EntityTypes<EntityEnderSignal> X = EntityTypes.a("eye_of_ender", Builder.a(EntityEnderSignal::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(4));
    public static final EntityTypes<EntityFallingBlock> Y = EntityTypes.a("falling_block", Builder.a(EntityFallingBlock::new, EnumCreatureType.h).e().a(0.98f, 0.98f).a(10).b(20));
    public static final EntityTypes<EntityLargeFireball> Z = EntityTypes.a("fireball", Builder.a(EntityLargeFireball::new, EnumCreatureType.h).e().a(1.0f, 1.0f).a(4).b(10));
    public static final EntityTypes<EntityFireworks> aa = EntityTypes.a("firework_rocket", Builder.a(EntityFireworks::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityFox> ab = EntityTypes.a("fox", Builder.a(EntityFox::new, EnumCreatureType.b).a(0.6f, 0.7f).b(0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.6375, -0.25)}).a(8).a(Blocks.oO));
    public static final EntityTypes<Frog> ac = EntityTypes.a("frog", Builder.a(Frog::new, EnumCreatureType.b).a(0.5f, 0.5f).a(new Vec3D[]{new Vec3D(0.0, 0.375, -0.25)}).a(10));
    public static final EntityTypes<EntityMinecartFurnace> ad = EntityTypes.a("furnace_minecart", Builder.a(EntityMinecartFurnace::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityGhast> ae = EntityTypes.a("ghast", Builder.a(EntityGhast::new, EnumCreatureType.a).c().a(4.0f, 4.0f).b(2.6f).a(new float[]{4.0625f}).c(0.5f).a(10));
    public static final EntityTypes<EntityGiantZombie> af = EntityTypes.a("giant", Builder.a(EntityGiantZombie::new, EnumCreatureType.a).a(3.6f, 12.0f).b(10.44f).c(-3.75f).a(10));
    public static final EntityTypes<GlowItemFrame> ag = EntityTypes.a("glow_item_frame", Builder.a(GlowItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<GlowSquid> ah = EntityTypes.a("glow_squid", Builder.a(GlowSquid::new, EnumCreatureType.e).a(0.8f, 0.8f).b(0.4f).a(10));
    public static final EntityTypes<Goat> ai = EntityTypes.a("goat", Builder.a(Goat::new, EnumCreatureType.b).a(0.9f, 1.3f).a(new float[]{1.1125f}).a(10));
    public static final EntityTypes<EntityGuardian> aj = EntityTypes.a("guardian", Builder.a(EntityGuardian::new, EnumCreatureType.a).a(0.85f, 0.85f).b(0.425f).a(new float[]{0.975f}).a(8));
    public static final EntityTypes<EntityHoglin> ak = EntityTypes.a("hoglin", Builder.a(EntityHoglin::new, EnumCreatureType.a).a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityMinecartHopper> al = EntityTypes.a("hopper_minecart", Builder.a(EntityMinecartHopper::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityHorse> am = EntityTypes.a("horse", Builder.a(EntityHorse::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.44375f}).a(10));
    public static final EntityTypes<EntityZombieHusk> an = EntityTypes.a("husk", Builder.a(EntityZombieHusk::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.075f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityIllagerIllusioner> ao = EntityTypes.a("illusioner", Builder.a(EntityIllagerIllusioner::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<Interaction> ap = EntityTypes.a("interaction", Builder.a(Interaction::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10));
    public static final EntityTypes<EntityIronGolem> aq = EntityTypes.a("iron_golem", Builder.a(EntityIronGolem::new, EnumCreatureType.h).a(1.4f, 2.7f).a(10));
    public static final EntityTypes<EntityItem> ar = EntityTypes.a("item", Builder.a(EntityItem::new, EnumCreatureType.h).e().a(0.25f, 0.25f).b(0.2125f).a(6).b(20));
    public static final EntityTypes<Display.ItemDisplay> as = EntityTypes.a("item_display", Builder.a(Display.ItemDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityItemFrame> at = EntityTypes.a("item_frame", Builder.a(EntityItemFrame::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.0f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> au = EntityTypes.a("jungle_boat", Builder.a(EntityTypes.a(() -> Items.oK), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> av = EntityTypes.a("jungle_chest_boat", Builder.a(EntityTypes.b(() -> Items.oL), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityLeash> aw = EntityTypes.a("leash_knot", Builder.a(EntityLeash::new, EnumCreatureType.h).e().b().a(0.375f, 0.5f).b(0.0625f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLightning> ax = EntityTypes.a("lightning_bolt", Builder.a(EntityLightning::new, EnumCreatureType.h).e().b().a(0.0f, 0.0f).a(16).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityLlama> ay = EntityTypes.a("llama", Builder.a(EntityLlama::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityLlamaSpit> az = EntityTypes.a("llama_spit", Builder.a(EntityLlamaSpit::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityMagmaCube> aA = EntityTypes.a("magma_cube", Builder.a(EntityMagmaCube::new, EnumCreatureType.a).c().a(0.52f, 0.52f).b(0.325f).a(4.0f).a(8));
    public static final EntityTypes<EntityBoat> aB = EntityTypes.a("mangrove_boat", Builder.a(EntityTypes.a(() -> Items.oU), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aC = EntityTypes.a("mangrove_chest_boat", Builder.a(EntityTypes.b(() -> Items.oV), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<Marker> aD = EntityTypes.a("marker", Builder.a(Marker::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(0));
    public static final EntityTypes<EntityMinecartRideable> aE = EntityTypes.a("minecart", Builder.a(EntityMinecartRideable::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityMushroomCow> aF = EntityTypes.a("mooshroom", Builder.a(EntityMushroomCow::new, EnumCreatureType.b).a(0.9f, 1.4f).b(1.3f).a(new float[]{1.36875f}).a(10));
    public static final EntityTypes<EntityHorseMule> aG = EntityTypes.a("mule", Builder.a(EntityHorseMule::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.2125f}).a(8));
    public static final EntityTypes<EntityBoat> aH = EntityTypes.a("oak_boat", Builder.a(EntityTypes.a(() -> Items.oE), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aI = EntityTypes.a("oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oF), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityOcelot> aJ = EntityTypes.a("ocelot", Builder.a(EntityOcelot::new, EnumCreatureType.b).a(0.6f, 0.7f).a(new float[]{0.6375f}).a(10));
    public static final EntityTypes<OminousItemSpawner> aK = EntityTypes.a("ominous_item_spawner", Builder.a(OminousItemSpawner::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(8));
    public static final EntityTypes<EntityPainting> aL = EntityTypes.a("painting", Builder.a(EntityPainting::new, EnumCreatureType.h).e().a(0.5f, 0.5f).a(10).b(Integer.MAX_VALUE));
    public static final EntityTypes<EntityBoat> aM = EntityTypes.a("pale_oak_boat", Builder.a(EntityTypes.a(() -> Items.oS), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> aN = EntityTypes.a("pale_oak_chest_boat", Builder.a(EntityTypes.b(() -> Items.oT), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntityPanda> aO = EntityTypes.a("panda", Builder.a(EntityPanda::new, EnumCreatureType.b).a(1.3f, 1.25f).a(10));
    public static final EntityTypes<EntityParrot> aP = EntityTypes.a("parrot", Builder.a(EntityParrot::new, EnumCreatureType.b).a(0.5f, 0.9f).b(0.54f).a(new float[]{0.4625f}).a(8));
    public static final EntityTypes<EntityPhantom> aQ = EntityTypes.a("phantom", Builder.a(EntityPhantom::new, EnumCreatureType.a).a(0.9f, 0.5f).b(0.175f).a(new float[]{0.3375f}).c(-0.125f).a(8));
    public static final EntityTypes<EntityPig> aR = EntityTypes.a("pig", Builder.a(EntityPig::new, EnumCreatureType.b).a(0.9f, 0.9f).a(new float[]{0.86875f}).a(10));
    public static final EntityTypes<EntityPiglin> aS = EntityTypes.a("piglin", Builder.a(EntityPiglin::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPiglinBrute> aT = EntityTypes.a("piglin_brute", Builder.a(EntityPiglinBrute::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityPillager> aU = EntityTypes.a("pillager", Builder.a(EntityPillager::new, EnumCreatureType.a).d().a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityPolarBear> aV = EntityTypes.a("polar_bear", Builder.a(EntityPolarBear::new, EnumCreatureType.b).a(Blocks.rx).a(1.4f, 1.4f).a(10));
    public static final EntityTypes<ThrownSplashPotion> aW = EntityTypes.a("splash_potion", Builder.a(ThrownSplashPotion::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<ThrownLingeringPotion> aX = EntityTypes.a("lingering_potion", Builder.a(ThrownLingeringPotion::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntityPufferFish> aY = EntityTypes.a("pufferfish", Builder.a(EntityPufferFish::new, EnumCreatureType.g).a(0.7f, 0.7f).b(0.455f).a(4));
    public static final EntityTypes<EntityRabbit> aZ = EntityTypes.a("rabbit", Builder.a(EntityRabbit::new, EnumCreatureType.b).a(0.4f, 0.5f).a(8));
    public static final EntityTypes<EntityRavager> ba = EntityTypes.a("ravager", Builder.a(EntityRavager::new, EnumCreatureType.a).a(1.95f, 2.2f).a(new Vec3D[]{new Vec3D(0.0, 2.2625, -0.0625)}).a(10));
    public static final EntityTypes<EntitySalmon> bb = EntityTypes.a("salmon", Builder.a(EntitySalmon::new, EnumCreatureType.g).a(0.7f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntitySheep> bc = EntityTypes.a("sheep", Builder.a(EntitySheep::new, EnumCreatureType.b).a(0.9f, 1.3f).b(1.235f).a(new float[]{1.2375f}).a(10));
    public static final EntityTypes<EntityShulker> bd = EntityTypes.a("shulker", Builder.a(EntityShulker::new, EnumCreatureType.a).c().d().a(1.0f, 1.0f).b(0.5f).a(10));
    public static final EntityTypes<EntityShulkerBullet> be = EntityTypes.a("shulker_bullet", Builder.a(EntityShulkerBullet::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(8));
    public static final EntityTypes<EntitySilverfish> bf = EntityTypes.a("silverfish", Builder.a(EntitySilverfish::new, EnumCreatureType.a).a(0.4f, 0.3f).b(0.13f).a(new float[]{0.2375f}).a(8));
    public static final EntityTypes<EntitySkeleton> bg = EntityTypes.a("skeleton", Builder.a(EntitySkeleton::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseSkeleton> bh = EntityTypes.a("skeleton_horse", Builder.a(EntityHorseSkeleton::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntitySlime> bi = EntityTypes.a("slime", Builder.a(EntitySlime::new, EnumCreatureType.a).a(0.52f, 0.52f).b(0.325f).a(4.0f).a(10));
    public static final EntityTypes<EntitySmallFireball> bj = EntityTypes.a("small_fireball", Builder.a(EntitySmallFireball::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<Sniffer> bk = EntityTypes.a("sniffer", Builder.a(Sniffer::new, EnumCreatureType.b).a(1.9f, 1.75f).b(1.05f).a(new float[]{2.09375f}).d(2.05f).a(10));
    public static final EntityTypes<EntitySnowball> bl = EntityTypes.a("snowball", Builder.a(EntitySnowball::new, EnumCreatureType.h).e().a(0.25f, 0.25f).a(4).b(10));
    public static final EntityTypes<EntitySnowman> bm = EntityTypes.a("snow_golem", Builder.a(EntitySnowman::new, EnumCreatureType.h).a(Blocks.rx).a(0.7f, 1.9f).b(1.7f).a(8));
    public static final EntityTypes<EntityMinecartMobSpawner> bn = EntityTypes.a("spawner_minecart", Builder.a(EntityMinecartMobSpawner::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntitySpectralArrow> bo = EntityTypes.a("spectral_arrow", Builder.a(EntitySpectralArrow::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntitySpider> bp = EntityTypes.a("spider", Builder.a(EntitySpider::new, EnumCreatureType.a).a(1.4f, 0.9f).b(0.65f).a(new float[]{0.765f}).a(8));
    public static final EntityTypes<EntityBoat> bq = EntityTypes.a("spruce_boat", Builder.a(EntityTypes.a(() -> Items.oG), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<ChestBoat> br = EntityTypes.a("spruce_chest_boat", Builder.a(EntityTypes.b(() -> Items.oH), EnumCreatureType.h).e().a(1.375f, 0.5625f).b(0.5625f).a(10));
    public static final EntityTypes<EntitySquid> bs = EntityTypes.a("squid", Builder.a(EntitySquid::new, EnumCreatureType.f).a(0.8f, 0.8f).b(0.4f).a(8));
    public static final EntityTypes<EntitySkeletonStray> bt = EntityTypes.a("stray", Builder.a(EntitySkeletonStray::new, EnumCreatureType.a).a(0.6f, 1.99f).b(1.74f).c(-0.7f).a(Blocks.rx).a(8));
    public static final EntityTypes<EntityStrider> bu = EntityTypes.a("strider", Builder.a(EntityStrider::new, EnumCreatureType.b).c().a(0.9f, 1.7f).a(10));
    public static final EntityTypes<Tadpole> bv = EntityTypes.a("tadpole", Builder.a(Tadpole::new, EnumCreatureType.b).a(0.4f, 0.3f).b(0.19500001f).a(10));
    public static final EntityTypes<Display.TextDisplay> bw = EntityTypes.a("text_display", Builder.a(Display.TextDisplay::new, EnumCreatureType.h).e().a(0.0f, 0.0f).a(10).b(1));
    public static final EntityTypes<EntityTNTPrimed> bx = EntityTypes.a("tnt", Builder.a(EntityTNTPrimed::new, EnumCreatureType.h).e().c().a(0.98f, 0.98f).b(0.15f).a(10).b(10));
    public static final EntityTypes<EntityMinecartTNT> by = EntityTypes.a("tnt_minecart", Builder.a(EntityMinecartTNT::new, EnumCreatureType.h).e().a(0.98f, 0.7f).a(new float[]{0.1875f}).a(8));
    public static final EntityTypes<EntityLlamaTrader> bz = EntityTypes.a("trader_llama", Builder.a(EntityLlamaTrader::new, EnumCreatureType.b).a(0.9f, 1.87f).b(1.7765f).a(new Vec3D[]{new Vec3D(0.0, 1.37, -0.3)}).a(10));
    public static final EntityTypes<EntityThrownTrident> bA = EntityTypes.a("trident", Builder.a(EntityThrownTrident::new, EnumCreatureType.h).e().a(0.5f, 0.5f).b(0.13f).a(4).b(20));
    public static final EntityTypes<EntityTropicalFish> bB = EntityTypes.a("tropical_fish", Builder.a(EntityTropicalFish::new, EnumCreatureType.g).a(0.5f, 0.4f).b(0.26f).a(4));
    public static final EntityTypes<EntityTurtle> bC = EntityTypes.a("turtle", Builder.a(EntityTurtle::new, EnumCreatureType.b).a(1.2f, 0.4f).a(new Vec3D[]{new Vec3D(0.0, 0.55625, -0.25)}).a(10));
    public static final EntityTypes<EntityVex> bD = EntityTypes.a("vex", Builder.a(EntityVex::new, EnumCreatureType.a).c().a(0.4f, 0.8f).b(0.51875f).a(new float[]{0.7375f}).c(0.04f).a(8));
    public static final EntityTypes<EntityVillager> bE = EntityTypes.a("villager", Builder.a(EntityVillager::new, EnumCreatureType.h).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<EntityVindicator> bF = EntityTypes.a("vindicator", Builder.a(EntityVindicator::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.0f}).c(-0.6f).a(8));
    public static final EntityTypes<EntityVillagerTrader> bG = EntityTypes.a("wandering_trader", Builder.a(EntityVillagerTrader::new, EnumCreatureType.b).a(0.6f, 1.95f).b(1.62f).a(10));
    public static final EntityTypes<Warden> bH = EntityTypes.a("warden", Builder.a(Warden::new, EnumCreatureType.a).a(0.9f, 2.9f).a(new float[]{3.15f}).a(EntityAttachment.d, 0.0f, 1.6f, 0.0f).a(16).c());
    public static final EntityTypes<WindCharge> bI = EntityTypes.a("wind_charge", Builder.a(WindCharge::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).b(0.0f).a(4).b(10));
    public static final EntityTypes<EntityWitch> bJ = EntityTypes.a("witch", Builder.a(EntityWitch::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.62f).a(new float[]{2.2625f}).a(8));
    public static final EntityTypes<EntityWither> bK = EntityTypes.a("wither", Builder.a(EntityWither::new, EnumCreatureType.a).c().a(Blocks.cn).a(0.9f, 3.5f).a(10));
    public static final EntityTypes<EntitySkeletonWither> bL = EntityTypes.a("wither_skeleton", Builder.a(EntitySkeletonWither::new, EnumCreatureType.a).c().a(Blocks.cn).a(0.7f, 2.4f).b(2.1f).c(-0.875f).a(8));
    public static final EntityTypes<EntityWitherSkull> bM = EntityTypes.a("wither_skull", Builder.a(EntityWitherSkull::new, EnumCreatureType.h).e().a(0.3125f, 0.3125f).a(4).b(10));
    public static final EntityTypes<EntityWolf> bN = EntityTypes.a("wolf", Builder.a(EntityWolf::new, EnumCreatureType.b).a(0.6f, 0.85f).b(0.68f).a(new Vec3D[]{new Vec3D(0.0, 0.81875, -0.0625)}).a(10));
    public static final EntityTypes<EntityZoglin> bO = EntityTypes.a("zoglin", Builder.a(EntityZoglin::new, EnumCreatureType.a).c().a(1.3964844f, 1.4f).a(new float[]{1.49375f}).a(8));
    public static final EntityTypes<EntityZombie> bP = EntityTypes.a("zombie", Builder.a(EntityZombie::new, EnumCreatureType.a).a(0.6f, 1.95f).b(1.74f).a(new float[]{2.0125f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHorseZombie> bQ = EntityTypes.a("zombie_horse", Builder.a(EntityHorseZombie::new, EnumCreatureType.b).a(1.3964844f, 1.6f).b(1.52f).a(new float[]{1.31875f}).a(10));
    public static final EntityTypes<EntityZombieVillager> bR = EntityTypes.a("zombie_villager", Builder.a(EntityZombieVillager::new, EnumCreatureType.a).a(0.6f, 1.95f).a(new float[]{2.125f}).c(-0.7f).b(1.74f).a(8));
    public static final EntityTypes<EntityPigZombie> bS = EntityTypes.a("zombified_piglin", Builder.a(EntityPigZombie::new, EnumCreatureType.a).c().a(0.6f, 1.95f).b(1.79f).a(new float[]{2.0f}).c(-0.7f).a(8));
    public static final EntityTypes<EntityHuman> bT = EntityTypes.a("player", Builder.a(EnumCreatureType.h).b().a().a(0.6f, 1.8f).b(1.62f).a(EntityHuman.bI).a(32).b(2));
    public static final EntityTypes<EntityFishingHook> bU = EntityTypes.a("fishing_bobber", Builder.a(EntityFishingHook::new, EnumCreatureType.h).e().b().a().a(0.25f, 0.25f).a(4).b(5));
    private static final Set<EntityTypes<?>> ca = Set.of(Y, C, bn);
    private final b<T> cb;
    private final EnumCreatureType cc;
    private final ImmutableSet<Block> cd;
    private final boolean ce;
    private final boolean cf;
    private final boolean cg;
    private final boolean ch;
    private final int ci;
    private final int cj;
    private final String ck;
    @Nullable
    private IChatBaseComponent cl;
    private final Optional<ResourceKey<LootTable>> cm;
    private final EntitySize cn;
    private final float co;
    private final FeatureFlagSet cp;

    private static <T extends Entity> EntityTypes<T> a(ResourceKey<EntityTypes<?>> resourcekey, Builder<T> entitytypes_builder) {
        return IRegistry.a(BuiltInRegistries.f, resourcekey, entitytypes_builder.a(resourcekey));
    }

    private static ResourceKey<EntityTypes<?>> b(String s2) {
        return ResourceKey.a(Registries.B, MinecraftKey.b(s2));
    }

    private static <T extends Entity> EntityTypes<T> a(String s2, Builder entitytypes_builder) {
        return EntityTypes.a(EntityTypes.b(s2), entitytypes_builder);
    }

    public static MinecraftKey a(EntityTypes<?> entitytypes) {
        return BuiltInRegistries.f.b(entitytypes);
    }

    public static Optional<EntityTypes<?>> a(String s2) {
        return BuiltInRegistries.f.b(MinecraftKey.c(s2));
    }

    public EntityTypes(b<T> entitytypes_b, EnumCreatureType enumcreaturetype, boolean flag, boolean flag1, boolean flag2, boolean flag3, ImmutableSet<Block> immutableset, EntitySize entitysize, float f2, int i2, int j2, String s2, Optional<ResourceKey<LootTable>> optional, FeatureFlagSet featureflagset) {
        this.cb = entitytypes_b;
        this.cc = enumcreaturetype;
        this.ch = flag3;
        this.ce = flag;
        this.cf = flag1;
        this.cg = flag2;
        this.cd = immutableset;
        this.cn = entitysize;
        this.co = f2;
        this.ci = i2;
        this.cj = j2;
        this.ck = s2;
        this.cm = optional;
        this.cp = featureflagset;
    }

    @Nullable
    public T a(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityLiving entityliving, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1) {
        return this.spawn(worldserver, itemstack, entityliving, blockposition, entityspawnreason, flag, flag1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable ItemStack itemstack, @Nullable EntityLiving entityliving, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        Consumer<Entity> consumer = itemstack != null ? EntityTypes.a(worldserver, itemstack, entityliving) : entity -> {};
        return (T)this.spawn(worldserver, consumer, blockposition, entityspawnreason, flag, flag1, spawnReason);
    }

    public static <T extends Entity> Consumer<T> a(World world, ItemStack itemstack, @Nullable EntityLiving entityliving) {
        return EntityTypes.a((T entity) -> {}, world, itemstack, entityliving);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, World world, ItemStack itemstack, @Nullable EntityLiving entityliving) {
        return EntityTypes.b(EntityTypes.a(consumer, itemstack), world, itemstack, entityliving);
    }

    public static <T extends Entity> Consumer<T> a(Consumer<T> consumer, ItemStack itemstack) {
        return consumer.andThen(entity -> entity.c(itemstack));
    }

    public static <T extends Entity> Consumer<T> b(Consumer<T> consumer, World world, ItemStack itemstack, @Nullable EntityLiving entityliving) {
        CustomData customdata = itemstack.a(DataComponents.Y, CustomData.a);
        return !customdata.c() ? consumer.andThen(entity -> {
            try {
                EntityTypes.a(world, entityliving, entity, customdata);
            }
            catch (Throwable t2) {
                bW.warn("Error loading spawn egg NBT", t2);
            }
        }) : consumer;
    }

    @Nullable
    public T a(WorldServer worldserver, BlockPosition blockposition, EntitySpawnReason entityspawnreason) {
        return this.spawn(worldserver, blockposition, entityspawnreason, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, BlockPosition blockposition, EntitySpawnReason entityspawnreason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.spawn(worldserver, null, blockposition, entityspawnreason, false, false, spawnReason);
    }

    @Nullable
    public T a(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1) {
        return this.spawn(worldserver, consumer, blockposition, entityspawnreason, flag, flag1, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public T spawn(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1, CreatureSpawnEvent.SpawnReason spawnReason) {
        T t0 = this.b(worldserver, consumer, blockposition, entityspawnreason, flag, flag1);
        if (t0 != null) {
            worldserver.addFreshEntityWithPassengers((Entity)t0, spawnReason);
            if (((Entity)t0).dQ()) {
                return null;
            }
            if (t0 instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)t0;
                entityinsentient.S();
            }
        }
        return t0;
    }

    @Nullable
    public T b(WorldServer worldserver, @Nullable Consumer<T> consumer, BlockPosition blockposition, EntitySpawnReason entityspawnreason, boolean flag, boolean flag1) {
        double d0;
        T t0 = this.a(worldserver, entityspawnreason);
        if (t0 == null) {
            return null;
        }
        if (flag) {
            ((Entity)t0).a_((double)blockposition.u() + 0.5, blockposition.v() + 1, (double)blockposition.w() + 0.5);
            d0 = EntityTypes.a((IWorldReader)worldserver, blockposition, flag1, ((Entity)t0).cR());
        } else {
            d0 = 0.0;
        }
        ((Entity)t0).b((double)blockposition.u() + 0.5, (double)blockposition.v() + d0, (double)blockposition.w() + 0.5, MathHelper.h(worldserver.A.i() * 360.0f), 0.0f);
        if (t0 instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)t0;
            entityinsentient.aX = entityinsentient.dL();
            entityinsentient.aV = entityinsentient.dL();
            entityinsentient.a((WorldAccess)worldserver, worldserver.d_(entityinsentient.dv()), entityspawnreason, (GroupDataEntity)null);
        }
        if (consumer != null) {
            consumer.accept(t0);
        }
        return t0;
    }

    protected static double a(IWorldReader iworldreader, BlockPosition blockposition, boolean flag, AxisAlignedBB axisalignedbb) {
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(blockposition);
        if (flag) {
            axisalignedbb1 = axisalignedbb1.b(0.0, -1.0, 0.0);
        }
        Iterable<VoxelShape> iterable = iworldreader.d(null, axisalignedbb1);
        return 1.0 + VoxelShapes.a(EnumDirection.EnumAxis.b, axisalignedbb, iterable, flag ? -2.0 : -1.0);
    }

    public static void a(World world, @Nullable EntityLiving entityliving, @Nullable Entity entity, CustomData customdata) {
        MinecraftServer minecraftserver = world.p();
        if (minecraftserver != null && entity != null) {
            EntityTypes<?> entitytypes = customdata.a(minecraftserver.ba(), Registries.B);
            if (entity.an() == entitytypes) {
                if (!world.C && entity.an().s()) {
                    if (!(entityliving instanceof EntityHuman)) {
                        return;
                    }
                    EntityHuman entityhuman = (EntityHuman)entityliving;
                    if (!minecraftserver.ag().f(entityhuman.gi())) {
                        return;
                    }
                }
                customdata.a(entity);
            }
        }
    }

    public boolean b() {
        return this.ce;
    }

    public boolean c() {
        return this.cf;
    }

    public boolean d() {
        return this.cg;
    }

    public boolean e() {
        return this.ch;
    }

    public EnumCreatureType f() {
        return this.cc;
    }

    public String g() {
        return this.ck;
    }

    public IChatBaseComponent h() {
        if (this.cl == null) {
            this.cl = IChatBaseComponent.c(this.g());
        }
        return this.cl;
    }

    public String toString() {
        return this.g();
    }

    public String i() {
        int i2 = this.g().lastIndexOf(46);
        return i2 == -1 ? this.g() : this.g().substring(i2 + 1);
    }

    public Optional<ResourceKey<LootTable>> j() {
        return this.cm;
    }

    public float l() {
        return this.cn.a();
    }

    public float m() {
        return this.cn.b();
    }

    @Override
    public FeatureFlagSet k() {
        return this.cp;
    }

    @Nullable
    public T a(World world, EntitySpawnReason entityspawnreason) {
        return !this.a(world.K()) ? null : (T)this.cb.create(this, world);
    }

    public static Optional<Entity> a(NBTTagCompound nbttagcompound, World world, EntitySpawnReason entityspawnreason) {
        return SystemUtils.a(EntityTypes.a(nbttagcompound).map(entitytypes -> entitytypes.a(world, entityspawnreason)), (T entity) -> entity.i(nbttagcompound), () -> bW.warn("Skipping Entity with id {}", (Object)nbttagcompound.b("id", "[invalid]")));
    }

    public AxisAlignedBB a(double d0, double d1, double d2) {
        float f2 = this.co * this.l() / 2.0f;
        float f1 = this.co * this.m();
        return new AxisAlignedBB(d0 - (double)f2, d1, d2 - (double)f2, d0 + (double)f2, d1 + (double)f1, d2 + (double)f2);
    }

    @Override
    public boolean a(IBlockData iblockdata) {
        return this.cd.contains((Object)iblockdata.b()) ? false : (!this.cg && PathfinderAbstract.a(iblockdata) ? true : iblockdata.a(Blocks.cn) || iblockdata.a(Blocks.oO) || iblockdata.a(Blocks.eg) || iblockdata.a(Blocks.rx));
    }

    public EntitySize n() {
        return this.cn;
    }

    public static Optional<EntityTypes<?>> a(NBTTagCompound nbttagcompound) {
        return nbttagcompound.a("id", a);
    }

    @Nullable
    public static Entity a(NBTTagCompound nbttagcompound, World world, EntitySpawnReason entityspawnreason, Function<Entity, Entity> function) {
        return EntityTypes.b(nbttagcompound, world, entityspawnreason).map(function).map(entity -> {
            NBTTagList nbttaglist = nbttagcompound.p("Passengers");
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                Entity entity1 = EntityTypes.a(nbttaglist.b(i2), world, entityspawnreason, function);
                if (entity1 == null) continue;
                entity1.a((Entity)entity, true);
            }
            return entity;
        }).orElse(null);
    }

    public static Stream<Entity> a(List<? extends NBTBase> list, World world, EntitySpawnReason entityspawnreason) {
        return list.stream().flatMap(nbtbase -> nbtbase.s_().stream()).mapMulti((nbttagcompound, consumer) -> EntityTypes.a(nbttagcompound, world, entityspawnreason, (Entity entity) -> {
            consumer.accept(entity);
            return entity;
        }));
    }

    private static Optional<Entity> b(NBTTagCompound nbttagcompound, World world, EntitySpawnReason entityspawnreason) {
        try {
            return EntityTypes.a(nbttagcompound, world, entityspawnreason);
        }
        catch (RuntimeException runtimeexception) {
            bW.warn("Exception loading entity: ", (Throwable)runtimeexception);
            return Optional.empty();
        }
    }

    public int o() {
        return this.ci;
    }

    public int p() {
        return this.cj;
    }

    public boolean q() {
        return this != bT && this != az && this != bK && this != l && this != at && this != ag && this != aw && this != aL && this != S && this != U;
    }

    @Override
    public boolean a(TagKey<EntityTypes<?>> tagkey) {
        return this.bX.a(tagkey);
    }

    @Override
    public boolean a(HolderSet<EntityTypes<?>> holderset) {
        return holderset.a(this.bX);
    }

    @Override
    @Nullable
    public T a(Entity entity) {
        return (T)(entity.an() == this ? entity : null);
    }

    @Override
    public Class<? extends Entity> a() {
        return Entity.class;
    }

    @Deprecated
    public Holder.c<EntityTypes<?>> r() {
        return this.bX;
    }

    private static b<EntityBoat> a(Supplier<Item> supplier) {
        return (entitytypes, world) -> new EntityBoat(entitytypes, world, supplier);
    }

    private static b<ChestBoat> b(Supplier<Item> supplier) {
        return (entitytypes, world) -> new ChestBoat(entitytypes, world, supplier);
    }

    private static b<Raft> c(Supplier<Item> supplier) {
        return (entitytypes, world) -> new Raft(entitytypes, world, supplier);
    }

    private static b<ChestRaft> d(Supplier<Item> supplier) {
        return (entitytypes, world) -> new ChestRaft(entitytypes, world, supplier);
    }

    public boolean s() {
        return ca.contains(this);
    }

    public static class Builder<T extends Entity> {
        private final b<T> a;
        private final EnumCreatureType b;
        private ImmutableSet<Block> c = ImmutableSet.of();
        private boolean d = true;
        private boolean e = true;
        private boolean f;
        private boolean g;
        private int h = 5;
        private int i = 3;
        private EntitySize j = EntitySize.b(0.6f, 1.8f);
        private float k = 1.0f;
        private EntityAttachments.a l = EntityAttachments.a();
        private FeatureFlagSet m = FeatureFlags.g;
        private DependantName<EntityTypes<?>, Optional<ResourceKey<LootTable>>> n = resourcekey -> Optional.of(ResourceKey.a(Registries.br, resourcekey.a().f("entities/")));
        private final DependantName<EntityTypes<?>, String> o = resourcekey -> SystemUtils.a("entity", resourcekey.a());

        private Builder(b<T> entitytypes_b, EnumCreatureType enumcreaturetype) {
            this.a = entitytypes_b;
            this.b = enumcreaturetype;
            this.g = enumcreaturetype == EnumCreatureType.b || enumcreaturetype == EnumCreatureType.h;
        }

        public static <T extends Entity> Builder<T> a(b entitytypes_b, EnumCreatureType enumcreaturetype) {
            return new Builder<T>(entitytypes_b, enumcreaturetype);
        }

        public static <T extends Entity> Builder<T> a(EnumCreatureType enumcreaturetype) {
            return new Builder<Entity>((entitytypes, world) -> null, enumcreaturetype);
        }

        public Builder<T> a(float f2, float f1) {
            this.j = EntitySize.b(f2, f1);
            return this;
        }

        public Builder<T> a(float f2) {
            this.k = f2;
            return this;
        }

        public Builder<T> b(float f2) {
            this.j = this.j.b(f2);
            return this;
        }

        public Builder<T> a(float ... afloat) {
            for (float f2 : afloat) {
                this.l = this.l.a(EntityAttachment.a, 0.0f, f2, 0.0f);
            }
            return this;
        }

        public Builder<T> a(Vec3D ... avec3d) {
            for (Vec3D vec3d : avec3d) {
                this.l = this.l.a(EntityAttachment.a, vec3d);
            }
            return this;
        }

        public Builder<T> a(Vec3D vec3d) {
            return this.a(EntityAttachment.b, vec3d);
        }

        public Builder<T> c(float f2) {
            return this.a(EntityAttachment.b, 0.0f, -f2, 0.0f);
        }

        public Builder<T> d(float f2) {
            return this.a(EntityAttachment.c, 0.0f, f2, 0.0f);
        }

        public Builder<T> a(EntityAttachment entityattachment, float f2, float f1, float f22) {
            this.l = this.l.a(entityattachment, f2, f1, f22);
            return this;
        }

        public Builder<T> a(EntityAttachment entityattachment, Vec3D vec3d) {
            this.l = this.l.a(entityattachment, vec3d);
            return this;
        }

        public Builder<T> a() {
            this.e = false;
            return this;
        }

        public Builder<T> b() {
            this.d = false;
            return this;
        }

        public Builder<T> c() {
            this.f = true;
            return this;
        }

        public Builder<T> a(Block ... ablock) {
            this.c = ImmutableSet.copyOf((Object[])ablock);
            return this;
        }

        public Builder<T> d() {
            this.g = true;
            return this;
        }

        public Builder<T> a(int i2) {
            this.h = i2;
            return this;
        }

        public Builder<T> b(int i2) {
            this.i = i2;
            return this;
        }

        public Builder<T> a(FeatureFlag ... afeatureflag) {
            this.m = FeatureFlags.e.a(afeatureflag);
            return this;
        }

        public Builder<T> e() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public EntityTypes<T> a(ResourceKey<EntityTypes<?>> resourcekey) {
            if (this.d) {
                SystemUtils.a(DataConverterTypes.C, resourcekey.a().toString());
            }
            return new EntityTypes<T>(this.a, this.b, this.d, this.e, this.f, this.g, this.c, this.j.a(this.l), this.k, this.h, this.i, this.o.get(resourcekey), this.n.get(resourcekey), this.m);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        @Nullable
        public T create(EntityTypes<T> var1, World var2);
    }
}

