/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int bL = 6000;
    private static final int bI = 0;
    public int bJ = 0;
    @Nullable
    public UUID bK;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gz() {
        return EntityInsentient.D().a(GenericAttributes.E, 10.0);
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.Y_() != 0) {
            this.bJ = 0;
        }
        super.a(worldserver);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.Y_() != 0) {
            this.bJ = 0;
        }
        if (this.bJ > 0) {
            --this.bJ;
            if (this.bJ % 10 == 0) {
                double d0 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d2 = this.ae.k() * 0.02;
                this.dV().a(Particles.S, this.d(1.0), this.dD() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gF();
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.i) ? 10.0f : iworldreader.x(blockposition);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("InLove", this.bJ);
        nbttagcompound.b("LoveCause", UUIDUtil.a, this.bK);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.bJ = nbttagcompound.b("InLove", 0);
        this.bK = nbttagcompound.a("LoveCause", UUIDUtil.a).orElse(null);
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = EntitySpawnReason.b(entityspawnreason) || EntityAnimal.a(generatoraccess, blockposition);
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.ca) && flag;
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int R() {
        return 120;
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    protected int e(WorldServer worldserver) {
        return 1 + this.ae.a(3);
    }

    public abstract boolean i(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.i(itemstack)) {
            int i2 = this.Y_();
            if (!this.dV().C && i2 == 0 && this.gB()) {
                this.a(entityhuman, enumhand, itemstack);
                this.e(entityhuman);
                this.gA();
                return EnumInteractionResult.b;
            }
            if (this.e_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                this.gA();
                return EnumInteractionResult.a;
            }
            if (this.dV().C) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void gA() {
    }

    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        int i2 = itemstack.M();
        UseRemainder useremainder = itemstack.a(DataComponents.x);
        itemstack.a(1, (EntityLiving)entityhuman);
        if (useremainder != null) {
            boolean flag = entityhuman.fV();
            Objects.requireNonNull(entityhuman);
            ItemStack itemstack1 = useremainder.a(itemstack, i2, flag, entityhuman::b);
            entityhuman.a(enumhand, itemstack1);
        }
    }

    public boolean gB() {
        return this.bJ <= 0;
    }

    public void e(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.bJ = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman != null) {
            this.bK = entityhuman.cG();
        }
        this.breedItem = entityhuman.gj().g();
        this.dV().a((Entity)this, (byte)18);
    }

    public void r(int i2) {
        this.bJ = i2;
    }

    public int gC() {
        return this.bJ;
    }

    @Nullable
    public EntityPlayer gD() {
        if (this.bK == null) {
            return null;
        }
        EntityHuman entityhuman = this.dV().a(this.bK);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gE() {
        return this.bJ > 0;
    }

    public void gF() {
        this.bJ = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.gE() && entityanimal.gE());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dA(), this.dC(), this.dG(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gD()).or(() -> Optional.ofNullable(entityanimal.gD())).orElse(null);
            int experience = this.dY().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.dY().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.gD()).or(() -> Optional.ofNullable(entityanimal.gD())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.p.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.c_(6000);
        entityanimal.c_(6000);
        this.gF();
        entityanimal.gF();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.O().c(GameRules.g) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dA(), this.dC(), this.dG(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ae.k() * 0.02;
                double d1 = this.ae.k() * 0.02;
                double d2 = this.ae.k() * 0.02;
                this.dV().a(Particles.S, this.d(1.0), this.dD() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(b0);
        }
    }
}

