/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize bQ = EntityTypes.A.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> bR = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.y);
    private static final boolean bS = false;
    public float bI;
    public float bJ;
    public float bK;
    public float bM;
    public float bN = 1.0f;
    private float bT = 1.0f;
    public int bO = this.ae.a(6000) + 6000;
    public boolean bP = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 1.4));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.a(TagsItem.ap), false));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.e_() ? bQ : super.e(entitypose);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 4.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.bM = this.bI;
        this.bK = this.bJ;
        this.bJ += (this.aH() ? -1.0f : 4.0f) * 0.3f;
        this.bJ = MathHelper.a(this.bJ, 0.0f, 1.0f);
        if (!this.aH() && this.bN < 1.0f) {
            this.bN = 1.0f;
        }
        this.bN *= 0.9f;
        Vec3D vec3d = this.dy();
        if (!this.aH() && vec3d.e < 0.0) {
            this.i(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bI += this.bN * 2.0f;
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.bJ() && !this.e_() && !this.u() && --this.bO <= 0) {
                this.forceDrops = true;
                if (this.a(worldserver, LootTables.aI, this::a)) {
                    this.a(SoundEffects.eX, 1.0f, (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                    ((Entity)this).a(GameEvent.t);
                }
                this.forceDrops = false;
                this.bO = this.ae.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean aZ() {
        return this.Y > this.bT;
    }

    @Override
    protected void aY() {
        this.bT = this.Y + this.bJ / 2.0f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.eV;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.eY;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.eW;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.eZ, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityChicken entitychicken = EntityTypes.A.a(worldserver, EntitySpawnReason.e);
        if (entitychicken != null && entityageable instanceof EntityChicken) {
            EntityChicken entitychicken1 = (EntityChicken)entityageable;
            entitychicken.j(this.ae.h() ? this.p() : entitychicken1.p());
        }
        return entitychicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        ChickenVariants.a(this.ae, this.dX(), SpawnContext.a(worldaccess, this.dv())).ifPresent(this::j);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ap);
    }

    @Override
    protected int e(WorldServer worldserver) {
        return this.u() ? 10 : super.e(worldserver);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bR, VariantUtils.a(this.dX(), ChickenVariants.a));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.bP = nbttagcompound.b("IsChickenJockey", false);
        nbttagcompound.e("EggLayTime").ifPresent(integer -> {
            this.bO = integer;
        });
        VariantUtils.a(nbttagcompound, this.dX(), Registries.aJ).ifPresent(this::j);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsChickenJockey", this.bP);
        nbttagcompound.a("EggLayTime", this.bO);
        VariantUtils.a(nbttagcompound, this.p());
    }

    public void j(Holder<ChickenVariant> holder) {
        this.al.a(bR, holder);
    }

    public Holder<ChickenVariant> p() {
        return this.al.a(bR);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aJ ? EntityChicken.c(datacomponenttype, new EitherHolder<ChickenVariant>(this.p())) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aJ);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aJ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aJ, t0).a(this.dX());
            if (optional.isPresent()) {
                this.j(optional.get());
                return true;
            }
            return false;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    public boolean h(double d0) {
        return this.u();
    }

    @Override
    protected void a(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.a(entity, entity_movefunction);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).aV = this.aV;
        }
    }

    public boolean u() {
        return this.bP;
    }

    public void w(boolean flag) {
        this.bP = flag;
    }
}

