/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> bQ = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> bR = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && bS.containsKey(entityinsentient.an());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> bS = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.p, SoundEffects.tx);
        hashmap.put(EntityTypes.r, SoundEffects.ty);
        hashmap.put(EntityTypes.s, SoundEffects.tz);
        hashmap.put(EntityTypes.w, SoundEffects.tW);
        hashmap.put(EntityTypes.E, SoundEffects.tA);
        hashmap.put(EntityTypes.F, SoundEffects.tB);
        hashmap.put(EntityTypes.L, SoundEffects.tC);
        hashmap.put(EntityTypes.N, SoundEffects.tD);
        hashmap.put(EntityTypes.Q, SoundEffects.tE);
        hashmap.put(EntityTypes.P, SoundEffects.tF);
        hashmap.put(EntityTypes.T, SoundEffects.tG);
        hashmap.put(EntityTypes.ae, SoundEffects.tH);
        hashmap.put(EntityTypes.aj, SoundEffects.tI);
        hashmap.put(EntityTypes.ak, SoundEffects.tJ);
        hashmap.put(EntityTypes.an, SoundEffects.tK);
        hashmap.put(EntityTypes.ao, SoundEffects.tL);
        hashmap.put(EntityTypes.aA, SoundEffects.tM);
        hashmap.put(EntityTypes.aQ, SoundEffects.tN);
        hashmap.put(EntityTypes.aS, SoundEffects.tO);
        hashmap.put(EntityTypes.aT, SoundEffects.tP);
        hashmap.put(EntityTypes.aU, SoundEffects.tQ);
        hashmap.put(EntityTypes.ba, SoundEffects.tR);
        hashmap.put(EntityTypes.bd, SoundEffects.tS);
        hashmap.put(EntityTypes.bf, SoundEffects.tT);
        hashmap.put(EntityTypes.bg, SoundEffects.tU);
        hashmap.put(EntityTypes.bi, SoundEffects.tV);
        hashmap.put(EntityTypes.bp, SoundEffects.tW);
        hashmap.put(EntityTypes.bt, SoundEffects.tX);
        hashmap.put(EntityTypes.bD, SoundEffects.tY);
        hashmap.put(EntityTypes.bF, SoundEffects.tZ);
        hashmap.put(EntityTypes.bH, SoundEffects.ua);
        hashmap.put(EntityTypes.bJ, SoundEffects.ub);
        hashmap.put(EntityTypes.bK, SoundEffects.uc);
        hashmap.put(EntityTypes.bL, SoundEffects.ud);
        hashmap.put(EntityTypes.bO, SoundEffects.ue);
        hashmap.put(EntityTypes.bP, SoundEffects.uf);
        hashmap.put(EntityTypes.bR, SoundEffects.ug);
    });
    public float bM;
    public float bN;
    public float bO;
    public float bP;
    private float bT = 1.0f;
    private float bU = 1.0f;
    private boolean bV;
    @Nullable
    private BlockPosition bW;

    public EntityParrot(EntityTypes<? extends EntityParrot> entitytypes, World world) {
        super((EntityTypes<? extends EntityPerchable>)entitytypes, world);
        this.bC = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(SystemUtils.a(Variant.values(), worldaccess.G_()));
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void C() {
        this.bF.a(0, new EntityTameableAnimal.a(1.25));
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bF.a(2, new PathfinderGoalSit(this));
        this.bF.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.bF.a(2, new a(this, 1.0));
        this.bF.a(3, new PathfinderGoalPerch(this));
        this.bF.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gG() {
        return EntityAnimal.gz().a(GenericAttributes.s, 6.0).a(GenericAttributes.l, 0.4f).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    public void d_() {
        if (this.bW == null || !this.bW.a(this.dt(), 3.46) || !this.dV().a_(this.bW).a(Blocks.ek)) {
            this.bV = false;
            this.bW = null;
        }
        if (this.dV().A.a(400) == 0) {
            EntityParrot.a(this.dV(), this);
        }
        super.d_();
        this.gL();
    }

    @Override
    public void a(BlockPosition blockposition, boolean flag) {
        this.bW = blockposition;
        this.bV = flag;
    }

    public boolean gH() {
        return this.bV;
    }

    private void gL() {
        this.bP = this.bM;
        this.bO = this.bN;
        this.bN += (float)(!this.aH() && !this.bY() ? 4 : -1) * 0.3f;
        this.bN = MathHelper.a(this.bN, 0.0f, 1.0f);
        if (!this.aH() && this.bT < 1.0f) {
            this.bT = 1.0f;
        }
        this.bT *= 0.9f;
        Vec3D vec3d = this.dy();
        if (!this.aH() && vec3d.e < 0.0) {
            this.i(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bM += this.bT * 2.0f;
    }

    public static boolean a(World world, Entity entity) {
        if (entity.bJ() && !entity.ba() && world.A.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, entity.cR().g(20.0), bR);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.A.a(list.size()))).ba()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.an());
                world.a((Entity)null, entity.dA(), entity.dC(), entity.dG(), soundeffect, entity.dm(), 0.7f, EntityParrot.a(world.A));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!this.m() && itemstack.a(TagsItem.aC)) {
            this.a(entityhuman, enumhand, itemstack);
            if (!this.ba()) {
                this.dV().a((Entity)null, this.dA(), this.dC(), this.dG(), SoundEffects.tu, this.dm(), 1.0f, 1.0f + (this.ae.i() - this.ae.i()) * 0.2f);
            }
            if (!this.dV().C) {
                if (this.ae.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
                    this.a(entityhuman);
                    this.dV().a((Entity)this, (byte)7);
                } else {
                    this.dV().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemstack.a(TagsItem.aD)) {
            if (!this.gJ() && this.m() && this.j(entityhuman)) {
                if (!this.dV().C) {
                    this.y(!this.gu());
                }
                return EnumInteractionResult.a;
            }
            return super.b(entityhuman, enumhand);
        }
        this.a(entityhuman, enumhand, itemstack);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (entityhuman.gz() || !this.cC()) {
            this.a(this.dW().a(entityhuman), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cf) && EntityParrot.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect s() {
        return EntityParrot.a(this.dV(), this.dV().A);
    }

    public static SoundEffect a(World world, RandomSource randomsource) {
        if (world.an() != EnumDifficulty.a && randomsource.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(bS.keySet());
            return EntityParrot.b((EntityTypes)list.get(randomsource.a(list.size())));
        }
        return SoundEffects.ts;
    }

    private static SoundEffect b(EntityTypes<?> entitytypes) {
        return bS.getOrDefault(entitytypes, SoundEffects.ts);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.tw;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.tt;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.uh, 0.15f, 1.0f);
    }

    @Override
    protected boolean aZ() {
        return this.Y > this.bU;
    }

    @Override
    protected void aY() {
        this.a(SoundEffects.tv, 0.15f, 1.0f);
        this.bU = this.Y + this.bN / 2.0f;
    }

    @Override
    public float ff() {
        return EntityParrot.a(this.ae);
    }

    public static float a(RandomSource randomsource) {
        return (randomsource.i() - randomsource.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.g;
    }

    @Override
    public boolean bG() {
        return super.bG();
    }

    @Override
    protected void D(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.D(entity);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.y(false);
        return result;
    }

    public Variant gI() {
        return Variant.a(this.al.a(bQ));
    }

    public void a(Variant entityparrot_variant) {
        this.al.a(bQ, entityparrot_variant.k);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aB ? EntityParrot.c(datacomponenttype, this.gI()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aB);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aB) {
            this.a(EntityParrot.c(DataComponents.aB, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bQ, Variant.f.k);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Variant", Variant.h, this.gI());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean gJ() {
        return !this.aH();
    }

    @Override
    protected boolean gy() {
        return true;
    }

    @Override
    public Vec3D cT() {
        return new Vec3D(0.0, 0.5f * this.cS(), this.dq() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;

        private Variant(int i2, String s2) {
            this.k = i2;
            this.l = s2;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        @Override
        public String c() {
            return this.l;
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            h = primitivecodec.xmap(intfunction::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature entitycreature, double d0) {
            super(entitycreature, d0);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.bi()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.dY().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dv();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockposition1 : BlockPosition.b(MathHelper.a(this.b.dA() - 3.0), MathHelper.a(this.b.dC() - 6.0), MathHelper.a(this.b.dG() - 3.0), MathHelper.a(this.b.dA() + 3.0), MathHelper.a(this.b.dC() + 6.0), MathHelper.a(this.b.dG() + 3.0))) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.dV().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.u)) || !this.b.dV().v(blockposition1) || !this.b.dV().v(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

