/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int bI = 200;
    private static final int bT = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bJ = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.p, SensorType.q);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.L, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.O, MemoryModuleType.C, MemoryModuleType.P, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.V, MemoryModuleType.aa});
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double bM = 20.0;
    public static final int bN = 1200;
    private static final int bX = 6000;
    public static final String bO = "Variant";
    private static final int bY = 1800;
    private static final int bZ = 2400;
    private static final boolean ca = false;
    public final BinaryAnimator bP = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bQ = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bR = new BinaryAnimator(10, MathHelper::m);
    public final BinaryAnimator bS = new BinaryAnimator(10, MathHelper::m);
    private static final int cb = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.a(PathType.j, 0.0f);
        this.bC = new d(this);
        this.bB = new c(this, 20);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bU, 0);
        datawatcher_a.a(bV, false);
        datawatcher_a.a(bW, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a(bO, Variant.i, this.gu());
        nbttagcompound.a("FromBucket", this.p());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.a(bO, Variant.i).orElse(Variant.f));
        this.w(nbttagcompound.b("FromBucket", false));
    }

    @Override
    public void S() {
        if (!this.gv()) {
            super.S();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        boolean flag = false;
        if (entityspawnreason == EntitySpawnReason.l) {
            return groupdataentity;
        }
        RandomSource randomsource = worldaccess.G_();
        if (groupdataentity instanceof b) {
            if (((b)groupdataentity).a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new b(Variant.a(randomsource), Variant.a(randomsource));
        }
        this.a(((b)groupdataentity).a(randomsource));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public void aw() {
        World world;
        int i2 = this.cs();
        super.aw();
        if (!this.gj() && (world = this.dV()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, i2);
        }
        if (this.dV().A_()) {
            this.gx();
        }
    }

    private void gx() {
        a axolotl_a = this.gv() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.bi() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aH() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.bP.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.bQ.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.bR.a(axolotl_a == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.aT.d() || this.dN() != this.O || this.dL() != this.N;
        this.bS.a(flag);
    }

    protected void a(WorldServer worldserver, int i2) {
        if (this.bJ() && !this.bk()) {
            this.j(i2 - 1);
            if (this.cs() == -20) {
                this.j(0);
                this.a(worldserver, this.dW().t(), 2.0f);
            }
        } else {
            this.j(this.cr());
        }
    }

    public void m() {
        int i2 = this.cs() + 1800;
        this.j(Math.min(i2, this.cr()));
    }

    @Override
    public int cr() {
        return this.maxAirTicks;
    }

    public Variant gu() {
        return Variant.a(this.al.a(bU));
    }

    public void a(Variant axolotl_variant) {
        this.al.a(bU, axolotl_variant.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aO ? Axolotl.c(datacomponenttype, this.gu()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aO);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aO) {
            this.a(Axolotl.c(DataComponents.aO, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    private static boolean a(RandomSource randomsource) {
        return randomsource.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    public boolean cJ() {
        return false;
    }

    public void x(boolean flag) {
        this.al.a(bV, flag);
    }

    public boolean gv() {
        return this.al.a(bV);
    }

    @Override
    public boolean p() {
        return this.al.a(bW);
    }

    @Override
    public void w(boolean flag) {
        this.al.a(bW, flag);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        Axolotl axolotl = EntityTypes.i.a(worldserver, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.ae) ? Variant.b(this.ae) : (this.ae.h() ? this.gu() : ((Axolotl)entityageable).gu());
            axolotl.a(axolotl_variant);
            axolotl.gc();
        }
        return axolotl;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.aE);
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("axolotlBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        gameprofilerfiller.c();
        if (!this.gj()) {
            Optional<Integer> optional = this.ec().c(MemoryModuleType.O);
            this.x(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder gw() {
        return EntityAnimal.gz().a(GenericAttributes.s, 14.0).a(GenericAttributes.v, 1.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.B, 1.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new AmphibiousPathNavigation(this, world);
    }

    @Override
    public void gn() {
        this.a(SoundEffects.aK, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        float f1 = this.eG();
        if (!this.gj() && this.dV().A.a(3) == 0 && ((float)this.dV().A.a(3) < f2 || f1 / this.eU() < 0.5f) && f2 < f1 && this.bi() && (damagesource.d() != null || damagesource.c() != null) && !this.gv()) {
            this.bs.a(MemoryModuleType.O, Integer.valueOf(200));
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public int ac() {
        return 1;
    }

    @Override
    public int ae() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return Bucketable.a(entityhuman, enumhand, this).orElse(super.b(entityhuman, enumhand));
    }

    @Override
    public void a_(ItemStack itemstack) {
        Bucketable.a((EntityInsentient)this, itemstack);
        itemstack.a(DataComponents.aO, (DataComponentGetter)this);
        CustomData.a(DataComponents.Z, itemstack, (NBTTagCompound nbttagcompound) -> {
            nbttagcompound.a("Age", this.Y_());
            BehaviorController<Axolotl> behaviorcontroller = this.ec();
            if (behaviorcontroller.a(MemoryModuleType.V)) {
                nbttagcompound.a("HuntingCooldown", behaviorcontroller.e(MemoryModuleType.V));
            }
        });
    }

    @Override
    public void d(NBTTagCompound nbttagcompound) {
        Bucketable.a((EntityInsentient)this, nbttagcompound);
        this.c_(nbttagcompound.b("Age", 0));
        nbttagcompound.f("HuntingCooldown").ifPresentOrElse(olong -> this.ec().a(MemoryModuleType.V, true, nbttagcompound.b("HuntingCooldown", 0L)), () -> this.ec().a(MemoryModuleType.V, Optional.empty()));
    }

    @Override
    public ItemStack a() {
        return new ItemStack(Items.rz);
    }

    @Override
    public SoundEffect u() {
        return SoundEffects.dk;
    }

    @Override
    public boolean ez() {
        return !this.gv() && super.ez();
    }

    public static void a(WorldServer worldserver, Axolotl axolotl, EntityLiving entityliving) {
        Entity entity;
        DamageSource damagesource;
        if (entityliving.eH() && (damagesource = entityliving.eI()) != null && (entity = damagesource.d()) != null && entity.an() == EntityTypes.bT) {
            EntityHuman entityhuman = (EntityHuman)entity;
            List<EntityHuman> list = worldserver.a(EntityHuman.class, axolotl.cR().g(20.0));
            if (list.contains(entityhuman)) {
                axolotl.a(entityhuman);
            }
        }
    }

    public void a(EntityHuman entityhuman) {
        MobEffect mobeffect = entityhuman.c(MobEffects.j);
        if (mobeffect == null || mobeffect.a(2399)) {
            int i2 = mobeffect != null ? mobeffect.d() : 0;
            int j2 = Math.min(2400, 100 + i2);
            entityhuman.addEffect(new MobEffect(MobEffects.j, j2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        entityhuman.e(MobEffects.d);
    }

    @Override
    public boolean Y() {
        return super.Y() || this.p();
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.aM;
    }

    @Override
    @Nullable
    protected SoundEffect j_() {
        return SoundEffects.aL;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.bi() ? SoundEffects.aO : SoundEffects.aN;
    }

    @Override
    protected SoundEffect aV() {
        return SoundEffects.aP;
    }

    @Override
    protected SoundEffect aU() {
        return SoundEffects.aQ;
    }

    protected BehaviorController.b<Axolotl> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ed().a(dynamic));
    }

    public BehaviorController<Axolotl> ec() {
        return super.ec();
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public void a_(Vec3D vec3d) {
        if (this.bi()) {
            this.a(this.fo(), vec3d);
            this.a(EnumMoveType.a, this.dy());
            this.i(this.dy().c(0.9));
        } else {
            super.a_(vec3d);
        }
    }

    @Override
    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        if (itemstack.a(Items.ry)) {
            entityhuman.a(enumhand, ItemLiquidUtil.a(itemstack, entityhuman, new ItemStack(Items.rp)));
        } else {
            super.a(entityhuman, enumhand, itemstack);
        }
    }

    @Override
    public boolean h(double d0) {
        return !this.p() && !this.g_();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.P();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entitytypes, WorldAccess worldaccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return worldaccess.a_(blockposition.e()).a(TagsBlock.cc);
    }

    private static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gv()) {
                super.a();
            }
        }
    }

    private class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl axolotl2, int i2) {
            super(axolotl2, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gv()) {
                super.a();
            }
        }
    }

    public static enum Variant implements INamable
    {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> g;
        public static final Codec<Variant> h;
        @Deprecated
        public static final Codec<Variant> i;
        private final int k;
        private final String l;
        private final boolean m;

        private Variant(int i2, String s2, boolean flag) {
            this.k = i2;
            this.l = s2;
            this.m = flag;
        }

        public int a() {
            return this.k;
        }

        public String b() {
            return this.l;
        }

        @Override
        public String c() {
            return this.l;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        public static Variant a(RandomSource randomsource) {
            return Variant.a(randomsource, true);
        }

        public static Variant b(RandomSource randomsource) {
            return Variant.a(randomsource, false);
        }

        private static Variant a(RandomSource randomsource, boolean flag) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(Variant.values()).filter(axolotl_variant -> axolotl_variant.m == flag).toArray(Variant[]::new);
            return SystemUtils.a(aaxolotl_variant, randomsource);
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            g = ByteBufCodecs.a(j, Variant::a);
            h = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            i = primitivecodec.xmap(intfunction::apply, Variant::a);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... aaxolotl_variant) {
            super(false);
            this.a = aaxolotl_variant;
        }

        public Variant a(RandomSource randomsource) {
            return this.a[randomsource.a(this.a.length)];
        }
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

