/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bI = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int bP = 2;
    private static final int bQ = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bJ = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> bK = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.aw, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int bM = 10;
    public static final double bN = 0.02;
    public static final double bO = (double)0.1f;
    private static final DataWatcherObject<Boolean> bR = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> bS = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> bT = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean bU = false;
    private static final boolean bV = true;
    private static final boolean bW = true;
    private boolean bX;
    private int bY;

    public Goat(EntityTypes<? extends Goat> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.N().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack m() {
        RandomSource randomsource = RandomSource.a(this.cG().hashCode());
        TagKey<Instrument> tagkey = this.gG() ? InstrumentTags.b : InstrumentTags.a;
        return this.dV().J_().f(Registries.aU).a(tagkey, randomsource).map(holder -> InstrumentItem.a(Items.xt, holder)).orElseGet(() -> new ItemStack(Items.xt));
    }

    protected BehaviorController.b<Goat> ed() {
        return BehaviorController.a(bK, bJ);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ed().a(dynamic));
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.g(GenericAttributes.c).a(1.0);
            this.gy();
        } else {
            this.g(GenericAttributes.c).a(2.0);
            this.gx();
        }
    }

    @Override
    protected int a(double d0, float f2) {
        return super.a(d0, f2) - 10;
    }

    @Override
    protected SoundEffect s() {
        return this.gG() ? SoundEffects.lx : SoundEffects.lo;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gG() ? SoundEffects.lA : SoundEffects.lr;
    }

    @Override
    protected SoundEffect j_() {
        return this.gG() ? SoundEffects.ly : SoundEffects.lp;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.lF, 0.15f, 1.0f);
    }

    protected SoundEffect u() {
        return this.gG() ? SoundEffects.lC : SoundEffects.lt;
    }

    @Nullable
    public Goat b(WorldServer worldserver, EntityAgeable entityageable) {
        Goat goat = EntityTypes.ai.a(worldserver, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, worldserver.G_());
            EntityAgeable entityageable1 = worldserver.G_().h() ? this : entityageable;
            boolean flag = entityageable1 instanceof Goat && ((Goat)(goat1 = entityageable1)).gG() || !(worldserver.G_().j() >= 0.02);
            boolean flag1 = flag;
            goat.w(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> ec() {
        return super.ec();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("goatBrain");
        this.ec().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("goatActivityUpdate");
        GoatAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    public int ae() {
        return 15;
    }

    @Override
    public void r(float f2) {
        int i2 = this.ae();
        float f1 = MathHelper.c(this.aV, f2);
        float f22 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.r(this.aV + f22);
    }

    @Override
    protected void gA() {
        this.dV().a((Entity)null, this, this.gG() ? SoundEffects.lz : SoundEffects.lq, SoundCategory.g, 1.0f, MathHelper.b(this.dV().A, 0.8f, 1.2f));
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ag);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.ro) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.dV(), entityhuman, this.dv(), this.dv(), null, itemstack, Items.ru, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(this.u(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && this.i(itemstack)) {
            this.gA();
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        GoatAi.a(this, randomsource);
        this.w(randomsource.j() < 0.02);
        this.h();
        if (!this.e_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? bS : bT;
            this.al.a(datawatcherobject, false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected void ab() {
        super.ab();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return entitypose == EntityPose.g ? bI.a(this.ek()) : super.e(entitypose);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsScreamingGoat", this.gG());
        nbttagcompound.a("HasLeftHorn", this.gu());
        nbttagcompound.a("HasRightHorn", this.gv());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w(nbttagcompound.b("IsScreamingGoat", false));
        this.al.a(bS, nbttagcompound.b("HasLeftHorn", true));
        this.al.a(bT, nbttagcompound.b("HasRightHorn", true));
    }

    @Override
    public void b(byte b0) {
        if (b0 == 58) {
            this.bX = true;
        } else if (b0 == 59) {
            this.bX = false;
        } else {
            super.b(b0);
        }
    }

    @Override
    public void d_() {
        this.bY = this.bX ? ++this.bY : (this.bY -= 2);
        this.bY = MathHelper.a(this.bY, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bR, false);
        datawatcher_a.a(bS, true);
        datawatcher_a.a(bT, true);
    }

    public boolean gu() {
        return this.al.a(bS);
    }

    public boolean gv() {
        return this.al.a(bT);
    }

    public boolean gw() {
        boolean flag = this.gu();
        boolean flag1 = this.gv();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? bT : (!flag1 ? bS : (this.ae.h() ? bS : bT));
        this.al.a(datawatcherobject, false);
        Vec3D vec3d = this.dt();
        ItemStack itemstack = this.m();
        double d0 = MathHelper.b(this.ae, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ae, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.ae, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.dV(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        this.dV().b(entityitem);
        return true;
    }

    public void gx() {
        this.al.a(bS, true);
        this.al.a(bT, true);
    }

    public void gy() {
        this.al.a(bS, false);
        this.al.a(bT, false);
    }

    public boolean gG() {
        return this.al.a(bR);
    }

    public void w(boolean flag) {
        this.al.a(bR, flag);
    }

    public float gH() {
        return (float)this.bY / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cd) && Goat.a(generatoraccess, blockposition);
    }
}

