/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap bI = new PathfinderGoalHorseTrap(this);
    private static final int bJ = 18000;
    private static final boolean bK = false;
    private static final int bM = 0;
    private static final EntitySize bN = EntityTypes.bh.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bh.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean bO = false;
    public int bP = 0;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> entitytypes, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)entitytypes, world);
    }

    public static AttributeProvider.Builder m() {
        return EntityHorseSkeleton.gV().a(GenericAttributes.s, 15.0).a(GenericAttributes.v, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return !EntitySpawnReason.a(entityspawnreason) ? EntityAnimal.b(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource) : EntitySpawnReason.b(entityspawnreason) || EntityHorseSkeleton.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(RandomSource randomsource) {
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.o);
        Objects.requireNonNull(randomsource);
        attributemodifiable.a(EntityHorseSkeleton.a(randomsource::j));
    }

    @Override
    protected void gM() {
    }

    @Override
    protected SoundEffect s() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.xY : SoundEffects.xU;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.xV;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.xW;
    }

    @Override
    protected SoundEffect aU() {
        if (this.aH()) {
            if (!this.bZ()) {
                return SoundEffects.yb;
            }
            ++this.cf;
            if (this.cf > 5 && this.cf % 3 == 0) {
                return SoundEffects.xZ;
            }
            if (this.cf <= 5) {
                return SoundEffects.yb;
            }
        }
        return SoundEffects.xX;
    }

    @Override
    protected void g(float f2) {
        if (this.aH()) {
            super.g(0.3f);
        } else {
            super.g(Math.min(0.1f, f2 * 25.0f));
        }
    }

    @Override
    protected void hb() {
        if (this.bi()) {
            this.a(SoundEffects.ya, 0.4f, 1.0f);
        } else {
            super.hb();
        }
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return this.e_() ? bN : super.e(entitypose);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.p() && this.bP++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("SkeletonTrap", this.p());
        nbttagcompound.a("SkeletonTrapTime", this.bP);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w(nbttagcompound.b("SkeletonTrap", false));
        this.bP = nbttagcompound.b("SkeletonTrapTime", 0);
    }

    @Override
    protected float fk() {
        return 0.96f;
    }

    public boolean p() {
        return this.bO;
    }

    public void w(boolean flag) {
        if (flag != this.bO) {
            this.bO = flag;
            if (flag) {
                this.bF.a(1, this.bI);
            } else {
                this.bF.a(this.bI);
            }
        }
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bh.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return !this.gL() ? EnumInteractionResult.e : super.b(entityhuman, enumhand);
    }
}

