/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sheep.SheepColorSpawnRules;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepRegrowWoolEvent;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bI = 40;
    private static final DataWatcherObject<Byte> bJ = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, Integer> bK = SystemUtils.a(EnumColor.class, EntitySheep::c);
    private static final EnumColor bM = EnumColor.a;
    private static final boolean bN = false;
    private int bO;
    private PathfinderGoalEatTile bP;

    private static int c(EnumColor enumcolor) {
        if (enumcolor == EnumColor.a) {
            return -1644826;
        }
        int i2 = enumcolor.d();
        float f2 = 0.75f;
        return ARGB.a(255, MathHelper.d((float)ARGB.b(i2) * 0.75f), MathHelper.d((float)ARGB.c(i2) * 0.75f), MathHelper.d((float)ARGB.d(i2) * 0.75f));
    }

    public static int a(EnumColor enumcolor) {
        return bK.get(enumcolor);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
    }

    @Override
    protected void C() {
        this.bP = new PathfinderGoalEatTile(this);
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.1, itemstack -> itemstack.a(TagsItem.ah), false));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bF.a(5, this.bP);
        this.bF.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ah);
    }

    @Override
    protected void a(WorldServer worldserver) {
        this.bO = this.bP.h();
        super.a(worldserver);
    }

    @Override
    public void d_() {
        if (this.dV().C) {
            this.bO = Math.max(0, this.bO - 1);
        }
        super.d_();
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 8.0).a(GenericAttributes.v, 0.23f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(bJ, (byte)0);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 10) {
            this.bO = 40;
        } else {
            super.b(b0);
        }
    }

    public float J(float f2) {
        return this.bO <= 0 ? 0.0f : (this.bO >= 4 && this.bO <= 36 ? 1.0f : (this.bO < 4 ? ((float)this.bO - f2) / 4.0f : -((float)(this.bO - 40) - f2) / 4.0f));
    }

    public float K(float f2) {
        if (this.bO > 4 && this.bO <= 36) {
            float f1 = ((float)(this.bO - 4) - f2) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f1 * 28.7f);
        }
        return this.bO > 0 ? 0.62831855f : this.k(f2) * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.td)) {
            World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.a()) {
                    if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                        return EnumInteractionResult.e;
                    }
                    this.a(worldserver, SoundCategory.h, itemstack);
                    this.a(GameEvent.M, (Entity)entityhuman);
                    itemstack.a(1, (EntityLiving)entityhuman, EntitySheep.d(enumhand));
                    return EnumInteractionResult.b;
                }
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public void a(WorldServer worldserver, SoundCategory soundcategory, ItemStack itemstack) {
        worldserver.a((Entity)null, this, SoundEffects.xr, soundcategory, 1.0f, 1.0f);
        this.a(worldserver, LootTables.aV, itemstack, (WorldServer worldserver1, ItemStack itemstack1) -> {
            for (int i2 = 0; i2 < itemstack1.M(); ++i2) {
                this.forceDrops = true;
                EntityItem entityitem = this.a((WorldServer)worldserver1, itemstack1.c(1), 1.0f);
                this.forceDrops = false;
                if (entityitem == null) continue;
                entityitem.i(entityitem.dy().b((this.ae.i() - this.ae.i()) * 0.1f, this.ae.i() * 0.05f, (this.ae.i() - this.ae.i()) * 0.1f));
            }
        });
        this.w(true);
    }

    @Override
    public boolean a() {
        return this.bJ() && !this.u() && !this.e_();
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Sheared", this.u());
        nbttagcompound.a("Color", EnumColor.s, this.p());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w(nbttagcompound.b("Sheared", false));
        this.b(nbttagcompound.a("Color", EnumColor.s).orElse(bM));
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.xo;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.xq;
    }

    @Override
    protected SoundEffect j_() {
        return SoundEffects.xp;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.xs, 0.15f, 1.0f);
    }

    public EnumColor p() {
        return EnumColor.a(this.al.a(bJ) & 0xF);
    }

    public void b(EnumColor enumcolor) {
        byte b0 = this.al.a(bJ);
        this.al.a(bJ, (byte)(b0 & 0xF0 | enumcolor.a() & 0xF));
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aR ? EntitySheep.c(datacomponenttype, this.p()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aR);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aR) {
            this.b(EntitySheep.c(DataComponents.aR, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public boolean u() {
        return (this.al.a(bJ) & 0x10) != 0;
    }

    public void w(boolean flag) {
        byte b0 = this.al.a(bJ);
        if (flag) {
            this.al.a(bJ, (byte)(b0 | 0x10));
        } else {
            this.al.a(bJ, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(WorldAccess worldaccess, BlockPosition blockposition) {
        Holder<BiomeBase> holder = worldaccess.u(blockposition);
        return SheepColorSpawnRules.a(holder, worldaccess.G_());
    }

    @Nullable
    public EntitySheep b(WorldServer worldserver, EntityAgeable entityageable) {
        EntitySheep entitysheep = EntityTypes.bc.a(worldserver, EntitySpawnReason.e);
        if (entitysheep != null) {
            EnumColor enumcolor = this.p();
            EnumColor enumcolor1 = ((EntitySheep)entityageable).p();
            entitysheep.b(EnumColor.a(worldserver, enumcolor, enumcolor1));
        }
        return entitysheep;
    }

    @Override
    public void Q() {
        SheepRegrowWoolEvent event = new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity());
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        super.Q();
        this.w(false);
        if (this.e_()) {
            this.b_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.b(EntitySheep.a(worldaccess, this.dv()));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }
}

